/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAllowGroupDelayInhibit is the corresponding interface of BACnetConstructedDataAllowGroupDelayInhibit
type BACnetConstructedDataAllowGroupDelayInhibit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetAllowGroupDelayInhibit returns AllowGroupDelayInhibit (property field)
	GetAllowGroupDelayInhibit() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
}

// BACnetConstructedDataAllowGroupDelayInhibitExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataAllowGroupDelayInhibit.
// This is useful for switch cases.
type BACnetConstructedDataAllowGroupDelayInhibitExactly interface {
	BACnetConstructedDataAllowGroupDelayInhibit
	isBACnetConstructedDataAllowGroupDelayInhibit() bool
}

// _BACnetConstructedDataAllowGroupDelayInhibit is the data-structure of this message
type _BACnetConstructedDataAllowGroupDelayInhibit struct {
	*_BACnetConstructedData
	AllowGroupDelayInhibit BACnetApplicationTagBoolean
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetAllowGroupDelayInhibit() BACnetApplicationTagBoolean {
	return m.AllowGroupDelayInhibit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetAllowGroupDelayInhibit())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataAllowGroupDelayInhibit factory function for _BACnetConstructedDataAllowGroupDelayInhibit
func NewBACnetConstructedDataAllowGroupDelayInhibit(allowGroupDelayInhibit BACnetApplicationTagBoolean, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAllowGroupDelayInhibit {
	_result := &_BACnetConstructedDataAllowGroupDelayInhibit{
		AllowGroupDelayInhibit: allowGroupDelayInhibit,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAllowGroupDelayInhibit(structType any) BACnetConstructedDataAllowGroupDelayInhibit {
	if casted, ok := structType.(BACnetConstructedDataAllowGroupDelayInhibit); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAllowGroupDelayInhibit); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetTypeName() string {
	return "BACnetConstructedDataAllowGroupDelayInhibit"
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (allowGroupDelayInhibit)
	lengthInBits += m.AllowGroupDelayInhibit.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataAllowGroupDelayInhibitParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataAllowGroupDelayInhibit, error) {
	return BACnetConstructedDataAllowGroupDelayInhibitParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataAllowGroupDelayInhibitParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataAllowGroupDelayInhibit, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAllowGroupDelayInhibit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAllowGroupDelayInhibit")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (allowGroupDelayInhibit)
	if pullErr := readBuffer.PullContext("allowGroupDelayInhibit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for allowGroupDelayInhibit")
	}
	_allowGroupDelayInhibit, _allowGroupDelayInhibitErr := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
	if _allowGroupDelayInhibitErr != nil {
		return nil, errors.Wrap(_allowGroupDelayInhibitErr, "Error parsing 'allowGroupDelayInhibit' field of BACnetConstructedDataAllowGroupDelayInhibit")
	}
	allowGroupDelayInhibit := _allowGroupDelayInhibit.(BACnetApplicationTagBoolean)
	if closeErr := readBuffer.CloseContext("allowGroupDelayInhibit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for allowGroupDelayInhibit")
	}

	// Virtual field
	_actualValue := allowGroupDelayInhibit
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAllowGroupDelayInhibit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAllowGroupDelayInhibit")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataAllowGroupDelayInhibit{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		AllowGroupDelayInhibit: allowGroupDelayInhibit,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAllowGroupDelayInhibit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAllowGroupDelayInhibit")
		}

		// Simple Field (allowGroupDelayInhibit)
		if pushErr := writeBuffer.PushContext("allowGroupDelayInhibit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for allowGroupDelayInhibit")
		}
		_allowGroupDelayInhibitErr := writeBuffer.WriteSerializable(ctx, m.GetAllowGroupDelayInhibit())
		if popErr := writeBuffer.PopContext("allowGroupDelayInhibit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for allowGroupDelayInhibit")
		}
		if _allowGroupDelayInhibitErr != nil {
			return errors.Wrap(_allowGroupDelayInhibitErr, "Error serializing 'allowGroupDelayInhibit' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAllowGroupDelayInhibit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAllowGroupDelayInhibit")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) isBACnetConstructedDataAllowGroupDelayInhibit() bool {
	return true
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
