/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedData is the corresponding interface of BACnetConstructedData
type BACnetConstructedData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetObjectTypeArgument returns ObjectTypeArgument (discriminator field)
	GetObjectTypeArgument() BACnetObjectType
	// GetPropertyIdentifierArgument returns PropertyIdentifierArgument (discriminator field)
	GetPropertyIdentifierArgument() BACnetPropertyIdentifier
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
}

// BACnetConstructedDataExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedData.
// This is useful for switch cases.
type BACnetConstructedDataExactly interface {
	BACnetConstructedData
	isBACnetConstructedData() bool
}

// _BACnetConstructedData is the data-structure of this message
type _BACnetConstructedData struct {
	_BACnetConstructedDataChildRequirements
	OpeningTag      BACnetOpeningTag
	PeekedTagHeader BACnetTagHeader
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber          uint8
	ArrayIndexArgument BACnetTagPayloadUnsignedInteger
}

type _BACnetConstructedDataChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetObjectTypeArgument() BACnetObjectType
	GetPropertyIdentifierArgument() BACnetPropertyIdentifier
	GetPeekedTagNumber() uint8
}

type BACnetConstructedDataParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetConstructedData, serializeChildFunction func() error) error
	GetTypeName() string
}

type BACnetConstructedDataChild interface {
	utils.Serializable
	InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag)
	GetParent() *BACnetConstructedData

	GetTypeName() string
	BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedData) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetConstructedData) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetConstructedData) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedData) GetPeekedTagNumber() uint8 {
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedData factory function for _BACnetConstructedData
func NewBACnetConstructedData(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedData {
	return &_BACnetConstructedData{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, ClosingTag: closingTag, TagNumber: tagNumber, ArrayIndexArgument: arrayIndexArgument}
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedData(structType any) BACnetConstructedData {
	if casted, ok := structType.(BACnetConstructedData); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedData); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedData) GetTypeName() string {
	return "BACnetConstructedData"
}

func (m *_BACnetConstructedData) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetConstructedData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedData, error) {
	return BACnetConstructedDataParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedData, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (openingTag)
	if pullErr := readBuffer.PullContext("openingTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for openingTag")
	}
	_openingTag, _openingTagErr := BACnetOpeningTagParseWithBuffer(ctx, readBuffer, uint8(tagNumber))
	if _openingTagErr != nil {
		return nil, errors.Wrap(_openingTagErr, "Error parsing 'openingTag' field of BACnetConstructedData")
	}
	openingTag := _openingTag.(BACnetOpeningTag)
	if closeErr := readBuffer.CloseContext("openingTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for openingTag")
	}

	// Peek Field (peekedTagHeader)
	currentPos = positionAware.GetPos()
	if pullErr := readBuffer.PullContext("peekedTagHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for peekedTagHeader")
	}
	peekedTagHeader, _ := BACnetTagHeaderParseWithBuffer(ctx, readBuffer)
	readBuffer.Reset(currentPos)

	// Virtual field
	_peekedTagNumber := peekedTagHeader.GetActualTagNumber()
	peekedTagNumber := uint8(_peekedTagNumber)
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type BACnetConstructedDataChildSerializeRequirement interface {
		BACnetConstructedData
		InitializeParent(BACnetConstructedData, BACnetOpeningTag, BACnetTagHeader, BACnetClosingTag)
		GetParent() BACnetConstructedData
	}
	var _childTemp any
	var _child BACnetConstructedDataChildSerializeRequirement
	var typeSwitchError error
	switch {
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ABSENTEE_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAbsenteeLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAbsenteeLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCEPTED_MODES: // BACnetConstructedDataAcceptedModes
		_childTemp, typeSwitchError = BACnetConstructedDataAcceptedModesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessAlarmEvents
		_childTemp, typeSwitchError = BACnetConstructedDataAccessAlarmEventsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_DOORS: // BACnetConstructedDataAccessDoors
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessEvent
		_childTemp, typeSwitchError = BACnetConstructedDataAccessEventParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR: // BACnetConstructedDataAccessEventAuthenticationFactor
		_childTemp, typeSwitchError = BACnetConstructedDataAccessEventAuthenticationFactorParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL: // BACnetConstructedDataAccessEventCredential
		_childTemp, typeSwitchError = BACnetConstructedDataAccessEventCredentialParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_TAG && peekedTagNumber == uint8(2): // BACnetConstructedDataAccessEventTag
		_childTemp, typeSwitchError = BACnetConstructedDataAccessEventTagParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_TIME: // BACnetConstructedDataAccessEventTime
		_childTemp, typeSwitchError = BACnetConstructedDataAccessEventTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessTransactionEvents
		_childTemp, typeSwitchError = BACnetConstructedDataAccessTransactionEventsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCOMPANIMENT: // BACnetConstructedDataAccompaniment
		_childTemp, typeSwitchError = BACnetConstructedDataAccompanimentParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCOMPANIMENT_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataAccompanimentTime
		_childTemp, typeSwitchError = BACnetConstructedDataAccompanimentTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACK_REQUIRED && peekedTagNumber == uint8(9): // BACnetConstructedDataAckRequired
		_childTemp, typeSwitchError = BACnetConstructedDataAckRequiredParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACKED_TRANSITIONS && peekedTagNumber == uint8(9): // BACnetConstructedDataAckedTransitions
		_childTemp, typeSwitchError = BACnetConstructedDataAckedTransitionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION && peekedTagNumber == uint8(9): // BACnetConstructedDataLoopAction
		_childTemp, typeSwitchError = BACnetConstructedDataLoopActionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_COMMAND && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION: // BACnetConstructedDataCommandAction
		_childTemp, typeSwitchError = BACnetConstructedDataCommandActionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION: // BACnetConstructedDataAction
		_childTemp, typeSwitchError = BACnetConstructedDataActionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataActionText
		_childTemp, typeSwitchError = BACnetConstructedDataActionTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVATION_TIME: // BACnetConstructedDataActivationTime
		_childTemp, typeSwitchError = BACnetConstructedDataActivationTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY && peekedTagNumber == uint8(2): // BACnetConstructedDataActiveAuthenticationPolicy
		_childTemp, typeSwitchError = BACnetConstructedDataActiveAuthenticationPolicyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS: // BACnetConstructedDataActiveCOVMultipleSubscriptions
		_childTemp, typeSwitchError = BACnetConstructedDataActiveCOVMultipleSubscriptionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS: // BACnetConstructedDataActiveCOVSubscriptions
		_childTemp, typeSwitchError = BACnetConstructedDataActiveCOVSubscriptionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataActiveText
		_childTemp, typeSwitchError = BACnetConstructedDataActiveTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS: // BACnetConstructedDataActiveVTSessions
		_childTemp, typeSwitchError = BACnetConstructedDataActiveVTSessionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL: // BACnetConstructedDataActualShedLevel
		_childTemp, typeSwitchError = BACnetConstructedDataActualShedLevelParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataAccessZoneAdjustValue
		_childTemp, typeSwitchError = BACnetConstructedDataAccessZoneAdjustValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataPulseConverterAdjustValue
		_childTemp, typeSwitchError = BACnetConstructedDataPulseConverterAdjustValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataAdjustValue
		_childTemp, typeSwitchError = BACnetConstructedDataAdjustValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataAlarmValue
		_childTemp, typeSwitchError = BACnetConstructedDataAlarmValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAccessDoorAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAccessZoneAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataAccessZoneAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValueAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataBitStringValueAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataCharacterStringValueAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataCharacterStringValueAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataLifeSafetyPointAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyPointAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataLifeSafetyZoneAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyZoneAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateInputAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateInputAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateValueAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataTimerAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataTimerAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALIGN_INTERVALS && peekedTagNumber == uint8(1): // BACnetConstructedDataAlignIntervals
		_childTemp, typeSwitchError = BACnetConstructedDataAlignIntervalsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_CREDENTIAL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessCredentialAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessCredentialAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessDoorAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessPointAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessPointAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_RIGHTS && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessRightsAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessRightsAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_USER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessUserAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessUserAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessZoneAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccessZoneAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccumulatorAll
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ALERT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAlertEnrollmentAll
		_childTemp, typeSwitchError = BACnetConstructedDataAlertEnrollmentAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogInputAll
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogOutputAll
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogOutputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_AVERAGING && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAveragingAll
		_childTemp, typeSwitchError = BACnetConstructedDataAveragingAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryInputAll
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryInputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryLightingOutputAll
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryLightingOutputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryOutputAll
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryOutputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBitstringValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataBitstringValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CALENDAR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCalendarAll
		_childTemp, typeSwitchError = BACnetConstructedDataCalendarAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataChannelAll
		_childTemp, typeSwitchError = BACnetConstructedDataChannelAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCharacterstringValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataCharacterstringValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_COMMAND && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCommandAll
		_childTemp, typeSwitchError = BACnetConstructedDataCommandAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCredentialDataInputAll
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialDataInputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatepatternValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataDatepatternValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDateValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataDateValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatetimepatternValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataDatetimepatternValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatetimeValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataDatetimeValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDeviceAll
		_childTemp, typeSwitchError = BACnetConstructedDataDeviceAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ELEVATOR_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataElevatorGroupAll
		_childTemp, typeSwitchError = BACnetConstructedDataElevatorGroupAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ESCALATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEscalatorAll
		_childTemp, typeSwitchError = BACnetConstructedDataEscalatorAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_EVENT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEventEnrollmentAll
		_childTemp, typeSwitchError = BACnetConstructedDataEventEnrollmentAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_EVENT_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEventLogAll
		_childTemp, typeSwitchError = BACnetConstructedDataEventLogAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_FILE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataFileAll
		_childTemp, typeSwitchError = BACnetConstructedDataFileAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataGlobalGroupAll
		_childTemp, typeSwitchError = BACnetConstructedDataGlobalGroupAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataGroupAll
		_childTemp, typeSwitchError = BACnetConstructedDataGroupAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataIntegerValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLargeAnalogValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLifeSafetyPointAll
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyPointAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLifeSafetyZoneAll
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyZoneAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLiftAll
		_childTemp, typeSwitchError = BACnetConstructedDataLiftAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLightingOutputAll
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LOAD_CONTROL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLoadControlAll
		_childTemp, typeSwitchError = BACnetConstructedDataLoadControlAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLoopAll
		_childTemp, typeSwitchError = BACnetConstructedDataLoopAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateInputAll
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateInputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateOutputAll
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateOutputAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNetworkPortAll
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkPortAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NETWORK_SECURITY && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNetworkSecurityAll
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkSecurityAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NOTIFICATION_CLASS && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNotificationClassAll
		_childTemp, typeSwitchError = BACnetConstructedDataNotificationClassAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NOTIFICATION_FORWARDER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNotificationForwarderAll
		_childTemp, typeSwitchError = BACnetConstructedDataNotificationForwarderAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataOctetstringValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataOctetstringValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataPositiveIntegerValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_PROGRAM && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataProgramAll
		_childTemp, typeSwitchError = BACnetConstructedDataProgramAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataPulseConverterAll
		_childTemp, typeSwitchError = BACnetConstructedDataPulseConverterAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_SCHEDULE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataScheduleAll
		_childTemp, typeSwitchError = BACnetConstructedDataScheduleAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_STRUCTURED_VIEW && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataStructuredViewAll
		_childTemp, typeSwitchError = BACnetConstructedDataStructuredViewAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimepatternValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataTimepatternValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimeValueAll
		_childTemp, typeSwitchError = BACnetConstructedDataTimeValueAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimerAll
		_childTemp, typeSwitchError = BACnetConstructedDataTimerAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTrendLogAll
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTrendLogMultipleAll
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogMultipleAllParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL && peekedTagNumber == uint8(1): // BACnetConstructedDataAllWritesSuccessful
		_childTemp, typeSwitchError = BACnetConstructedDataAllWritesSuccessfulParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataAllowGroupDelayInhibit
		_childTemp, typeSwitchError = BACnetConstructedDataAllowGroupDelayInhibitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_LENGTH && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDULength
		_childTemp, typeSwitchError = BACnetConstructedDataAPDULengthParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDUSegmentTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataAPDUSegmentTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDUTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataAPDUTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION && peekedTagNumber == uint8(7): // BACnetConstructedDataApplicationSoftwareVersion
		_childTemp, typeSwitchError = BACnetConstructedDataApplicationSoftwareVersionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ARCHIVE && peekedTagNumber == uint8(1): // BACnetConstructedDataArchive
		_childTemp, typeSwitchError = BACnetConstructedDataArchiveParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS: // BACnetConstructedDataAssignedAccessRights
		_childTemp, typeSwitchError = BACnetConstructedDataAssignedAccessRightsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS: // BACnetConstructedDataAssignedLandingCalls
		_childTemp, typeSwitchError = BACnetConstructedDataAssignedLandingCallsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ATTEMPTED_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataAttemptedSamples
		_childTemp, typeSwitchError = BACnetConstructedDataAttemptedSamplesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_FACTORS: // BACnetConstructedDataAuthenticationFactors
		_childTemp, typeSwitchError = BACnetConstructedDataAuthenticationFactorsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST: // BACnetConstructedDataAuthenticationPolicyList
		_childTemp, typeSwitchError = BACnetConstructedDataAuthenticationPolicyListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES && peekedTagNumber == uint8(7): // BACnetConstructedDataAuthenticationPolicyNames
		_childTemp, typeSwitchError = BACnetConstructedDataAuthenticationPolicyNamesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthenticationStatus
		_childTemp, typeSwitchError = BACnetConstructedDataAuthenticationStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthorizationExemptions
		_childTemp, typeSwitchError = BACnetConstructedDataAuthorizationExemptionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHORIZATION_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthorizationMode
		_childTemp, typeSwitchError = BACnetConstructedDataAuthorizationModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY && peekedTagNumber == uint8(1): // BACnetConstructedDataAutoSlaveDiscovery
		_childTemp, typeSwitchError = BACnetConstructedDataAutoSlaveDiscoveryParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AVERAGE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAverageValue
		_childTemp, typeSwitchError = BACnetConstructedDataAverageValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataBackupAndRestoreState
		_childTemp, typeSwitchError = BACnetConstructedDataBackupAndRestoreStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataBackupFailureTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataBackupFailureTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataBackupPreparationTime
		_childTemp, typeSwitchError = BACnetConstructedDataBackupPreparationTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS: // BACnetConstructedDataBACnetIPGlobalAddress
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPGlobalAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataBACnetIPMode
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataBACnetIPMulticastAddress
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPMulticastAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL && peekedTagNumber == uint8(1): // BACnetConstructedDataBACnetIPNATTraversal
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPNATTraversalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_UDP_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataBACnetIPUDPPort
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPUDPPortParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataBACnetIPv6Mode
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPv6ModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataBACnetIPv6UDPPort
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPv6UDPPortParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataBACnetIPv6MulticastAddress
		_childTemp, typeSwitchError = BACnetConstructedDataBACnetIPv6MulticastAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY && peekedTagNumber == uint8(9): // BACnetConstructedDataBaseDeviceSecurityPolicy
		_childTemp, typeSwitchError = BACnetConstructedDataBaseDeviceSecurityPolicyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS && peekedTagNumber == uint8(1): // BACnetConstructedDataBBMDAcceptFDRegistrations
		_childTemp, typeSwitchError = BACnetConstructedDataBBMDAcceptFDRegistrationsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE: // BACnetConstructedDataBBMDBroadcastDistributionTable
		_childTemp, typeSwitchError = BACnetConstructedDataBBMDBroadcastDistributionTableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE: // BACnetConstructedDataBBMDForeignDeviceTable
		_childTemp, typeSwitchError = BACnetConstructedDataBBMDForeignDeviceTableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BELONGS_TO: // BACnetConstructedDataBelongsTo
		_childTemp, typeSwitchError = BACnetConstructedDataBelongsToParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIAS && peekedTagNumber == uint8(4): // BACnetConstructedDataBias
		_childTemp, typeSwitchError = BACnetConstructedDataBiasParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIT_MASK && peekedTagNumber == uint8(8): // BACnetConstructedDataBitMask
		_childTemp, typeSwitchError = BACnetConstructedDataBitMaskParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIT_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataBitText
		_childTemp, typeSwitchError = BACnetConstructedDataBitTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BLINK_WARN_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataBlinkWarnEnable
		_childTemp, typeSwitchError = BACnetConstructedDataBlinkWarnEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BUFFER_SIZE && peekedTagNumber == uint8(2): // BACnetConstructedDataBufferSize
		_childTemp, typeSwitchError = BACnetConstructedDataBufferSizeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataCarAssignedDirection
		_childTemp, typeSwitchError = BACnetConstructedDataCarAssignedDirectionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_COMMAND && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDoorCommand
		_childTemp, typeSwitchError = BACnetConstructedDataCarDoorCommandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDoorStatus
		_childTemp, typeSwitchError = BACnetConstructedDataCarDoorStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataCarDoorText
		_childTemp, typeSwitchError = BACnetConstructedDataCarDoorTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_ZONE && peekedTagNumber == uint8(1): // BACnetConstructedDataCarDoorZone
		_childTemp, typeSwitchError = BACnetConstructedDataCarDoorZoneParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DRIVE_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDriveStatus
		_childTemp, typeSwitchError = BACnetConstructedDataCarDriveStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_LOAD && peekedTagNumber == uint8(4): // BACnetConstructedDataCarLoad
		_childTemp, typeSwitchError = BACnetConstructedDataCarLoadParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_LOAD_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarLoadUnits
		_childTemp, typeSwitchError = BACnetConstructedDataCarLoadUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataCarMode
		_childTemp, typeSwitchError = BACnetConstructedDataCarModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_MOVING_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataCarMovingDirection
		_childTemp, typeSwitchError = BACnetConstructedDataCarMovingDirectionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_POSITION && peekedTagNumber == uint8(2): // BACnetConstructedDataCarPosition
		_childTemp, typeSwitchError = BACnetConstructedDataCarPositionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataChangeOfStateCount
		_childTemp, typeSwitchError = BACnetConstructedDataChangeOfStateCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME: // BACnetConstructedDataChangeOfStateTime
		_childTemp, typeSwitchError = BACnetConstructedDataChangeOfStateTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGES_PENDING && peekedTagNumber == uint8(1): // BACnetConstructedDataChangesPending
		_childTemp, typeSwitchError = BACnetConstructedDataChangesPendingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANNEL_NUMBER && peekedTagNumber == uint8(2): // BACnetConstructedDataChannelNumber
		_childTemp, typeSwitchError = BACnetConstructedDataChannelNumberParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CLIENT_COV_INCREMENT: // BACnetConstructedDataClientCOVIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataClientCOVIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COMMAND && peekedTagNumber == uint8(9): // BACnetConstructedDataCommand
		_childTemp, typeSwitchError = BACnetConstructedDataCommandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COMMAND_TIME_ARRAY: // BACnetConstructedDataCommandTimeArray
		_childTemp, typeSwitchError = BACnetConstructedDataCommandTimeArrayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONFIGURATION_FILES && peekedTagNumber == uint8(12): // BACnetConstructedDataConfigurationFiles
		_childTemp, typeSwitchError = BACnetConstructedDataConfigurationFilesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROL_GROUPS && peekedTagNumber == uint8(2): // BACnetConstructedDataControlGroups
		_childTemp, typeSwitchError = BACnetConstructedDataControlGroupsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE: // BACnetConstructedDataControlledVariableReference
		_childTemp, typeSwitchError = BACnetConstructedDataControlledVariableReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataControlledVariableUnits
		_childTemp, typeSwitchError = BACnetConstructedDataControlledVariableUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataControlledVariableValue
		_childTemp, typeSwitchError = BACnetConstructedDataControlledVariableValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataCount
		_childTemp, typeSwitchError = BACnetConstructedDataCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE && peekedTagNumber == uint8(2): // BACnetConstructedDataCountBeforeChange
		_childTemp, typeSwitchError = BACnetConstructedDataCountBeforeChangeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT_CHANGE_TIME: // BACnetConstructedDataCountChangeTime
		_childTemp, typeSwitchError = BACnetConstructedDataCountChangeTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(2): // BACnetConstructedDataIntegerValueCOVIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueCOVIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueCOVIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueCOVIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueCOVIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueCOVIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(4): // BACnetConstructedDataCOVIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataCOVIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_PERIOD && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVPeriod
		_childTemp, typeSwitchError = BACnetConstructedDataCOVPeriodParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVResubscriptionInterval
		_childTemp, typeSwitchError = BACnetConstructedDataCOVResubscriptionIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COVU_PERIOD && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVUPeriod
		_childTemp, typeSwitchError = BACnetConstructedDataCOVUPeriodParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COVU_RECIPIENTS: // BACnetConstructedDataCOVURecipients
		_childTemp, typeSwitchError = BACnetConstructedDataCOVURecipientsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIAL_DISABLE && peekedTagNumber == uint8(9): // BACnetConstructedDataCredentialDisable
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialDisableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIAL_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCredentialStatus
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIALS: // BACnetConstructedDataCredentials
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE: // BACnetConstructedDataCredentialsInZone
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialsInZoneParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY: // BACnetConstructedDataCurrentCommandPriority
		_childTemp, typeSwitchError = BACnetConstructedDataCurrentCommandPriorityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DATABASE_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataDatabaseRevision
		_childTemp, typeSwitchError = BACnetConstructedDataDatabaseRevisionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DATE_LIST: // BACnetConstructedDataDateList
		_childTemp, typeSwitchError = BACnetConstructedDataDateListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS && peekedTagNumber == uint8(1): // BACnetConstructedDataDaylightSavingsStatus
		_childTemp, typeSwitchError = BACnetConstructedDataDaylightSavingsStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DAYS_REMAINING && peekedTagNumber == uint8(3): // BACnetConstructedDataDaysRemaining
		_childTemp, typeSwitchError = BACnetConstructedDataDaysRemainingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(2): // BACnetConstructedDataIntegerValueDeadband
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueDeadbandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueDeadband
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueDeadbandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueDeadband
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueDeadbandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(4): // BACnetConstructedDataDeadband
		_childTemp, typeSwitchError = BACnetConstructedDataDeadbandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_FADE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDefaultFadeTime
		_childTemp, typeSwitchError = BACnetConstructedDataDefaultFadeTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_RAMP_RATE && peekedTagNumber == uint8(4): // BACnetConstructedDataDefaultRampRate
		_childTemp, typeSwitchError = BACnetConstructedDataDefaultRampRateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT && peekedTagNumber == uint8(4): // BACnetConstructedDataDefaultStepIncrement
		_childTemp, typeSwitchError = BACnetConstructedDataDefaultStepIncrementParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP && peekedTagNumber == uint8(9): // BACnetConstructedDataDefaultSubordinateRelationship
		_childTemp, typeSwitchError = BACnetConstructedDataDefaultSubordinateRelationshipParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataDefaultTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataDefaultTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataDeployedProfileLocation
		_childTemp, typeSwitchError = BACnetConstructedDataDeployedProfileLocationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DERIVATIVE_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataDerivativeConstant
		_childTemp, typeSwitchError = BACnetConstructedDataDerivativeConstantParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataDerivativeConstantUnits
		_childTemp, typeSwitchError = BACnetConstructedDataDerivativeConstantUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DESCRIPTION && peekedTagNumber == uint8(7): // BACnetConstructedDataDescription
		_childTemp, typeSwitchError = BACnetConstructedDataDescriptionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DESCRIPTION_OF_HALT && peekedTagNumber == uint8(7): // BACnetConstructedDataDescriptionOfHalt
		_childTemp, typeSwitchError = BACnetConstructedDataDescriptionOfHaltParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING: // BACnetConstructedDataDeviceAddressBinding
		_childTemp, typeSwitchError = BACnetConstructedDataDeviceAddressBindingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEVICE_TYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataDeviceType
		_childTemp, typeSwitchError = BACnetConstructedDataDeviceTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DIRECT_READING && peekedTagNumber == uint8(4): // BACnetConstructedDataDirectReading
		_childTemp, typeSwitchError = BACnetConstructedDataDirectReadingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataDistributionKeyRevision
		_childTemp, typeSwitchError = BACnetConstructedDataDistributionKeyRevisionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DO_NOT_HIDE && peekedTagNumber == uint8(1): // BACnetConstructedDataDoNotHide
		_childTemp, typeSwitchError = BACnetConstructedDataDoNotHideParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_ALARM_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataDoorAlarmState
		_childTemp, typeSwitchError = BACnetConstructedDataDoorAlarmStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorExtendedPulseTime
		_childTemp, typeSwitchError = BACnetConstructedDataDoorExtendedPulseTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_MEMBERS: // BACnetConstructedDataDoorMembers
		_childTemp, typeSwitchError = BACnetConstructedDataDoorMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorOpenTooLongTime
		_childTemp, typeSwitchError = BACnetConstructedDataDoorOpenTooLongTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_PULSE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorPulseTime
		_childTemp, typeSwitchError = BACnetConstructedDataDoorPulseTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataDoorStatus
		_childTemp, typeSwitchError = BACnetConstructedDataDoorStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorUnlockDelayTime
		_childTemp, typeSwitchError = BACnetConstructedDataDoorUnlockDelayTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DUTY_WINDOW && peekedTagNumber == uint8(2): // BACnetConstructedDataDutyWindow
		_childTemp, typeSwitchError = BACnetConstructedDataDutyWindowParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EFFECTIVE_PERIOD: // BACnetConstructedDataEffectivePeriod
		_childTemp, typeSwitchError = BACnetConstructedDataEffectivePeriodParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EGRESS_ACTIVE && peekedTagNumber == uint8(1): // BACnetConstructedDataEgressActive
		_childTemp, typeSwitchError = BACnetConstructedDataEgressActiveParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EGRESS_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataEgressTime
		_childTemp, typeSwitchError = BACnetConstructedDataEgressTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataElapsedActiveTime
		_childTemp, typeSwitchError = BACnetConstructedDataElapsedActiveTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ELEVATOR_GROUP && peekedTagNumber == uint8(12): // BACnetConstructedDataElevatorGroup
		_childTemp, typeSwitchError = BACnetConstructedDataElevatorGroupParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataEnable
		_childTemp, typeSwitchError = BACnetConstructedDataEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENERGY_METER && peekedTagNumber == uint8(4): // BACnetConstructedDataEnergyMeter
		_childTemp, typeSwitchError = BACnetConstructedDataEnergyMeterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENERGY_METER_REF: // BACnetConstructedDataEnergyMeterRef
		_childTemp, typeSwitchError = BACnetConstructedDataEnergyMeterRefParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENTRY_POINTS: // BACnetConstructedDataEntryPoints
		_childTemp, typeSwitchError = BACnetConstructedDataEntryPointsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ERROR_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataErrorLimit
		_childTemp, typeSwitchError = BACnetConstructedDataErrorLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ESCALATOR_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataEscalatorMode
		_childTemp, typeSwitchError = BACnetConstructedDataEscalatorModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataEventAlgorithmInhibit
		_childTemp, typeSwitchError = BACnetConstructedDataEventAlgorithmInhibitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF: // BACnetConstructedDataEventAlgorithmInhibitRef
		_childTemp, typeSwitchError = BACnetConstructedDataEventAlgorithmInhibitRefParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataEventDetectionEnable
		_childTemp, typeSwitchError = BACnetConstructedDataEventDetectionEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ENABLE && peekedTagNumber == uint8(8): // BACnetConstructedDataEventEnable
		_childTemp, typeSwitchError = BACnetConstructedDataEventEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS: // BACnetConstructedDataEventMessageTexts
		_childTemp, typeSwitchError = BACnetConstructedDataEventMessageTextsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG: // BACnetConstructedDataEventMessageTextsConfig
		_childTemp, typeSwitchError = BACnetConstructedDataEventMessageTextsConfigParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_PARAMETERS: // BACnetConstructedDataEventParameters
		_childTemp, typeSwitchError = BACnetConstructedDataEventParametersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataEventState
		_childTemp, typeSwitchError = BACnetConstructedDataEventStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_TIME_STAMPS: // BACnetConstructedDataEventTimeStamps
		_childTemp, typeSwitchError = BACnetConstructedDataEventTimeStampsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataEventType
		_childTemp, typeSwitchError = BACnetConstructedDataEventTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXCEPTION_SCHEDULE: // BACnetConstructedDataExceptionSchedule
		_childTemp, typeSwitchError = BACnetConstructedDataExceptionScheduleParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXECUTION_DELAY && peekedTagNumber == uint8(2): // BACnetConstructedDataExecutionDelay
		_childTemp, typeSwitchError = BACnetConstructedDataExecutionDelayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXIT_POINTS: // BACnetConstructedDataExitPoints
		_childTemp, typeSwitchError = BACnetConstructedDataExitPointsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL: // BACnetConstructedDataExpectedShedLevel
		_childTemp, typeSwitchError = BACnetConstructedDataExpectedShedLevelParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXPIRATION_TIME: // BACnetConstructedDataExpirationTime
		_childTemp, typeSwitchError = BACnetConstructedDataExpirationTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataExtendedTimeEnable
		_childTemp, typeSwitchError = BACnetConstructedDataExtendedTimeEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS: // BACnetConstructedDataFailedAttemptEvents
		_childTemp, typeSwitchError = BACnetConstructedDataFailedAttemptEventsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPTS && peekedTagNumber == uint8(2): // BACnetConstructedDataFailedAttempts
		_childTemp, typeSwitchError = BACnetConstructedDataFailedAttemptsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataFailedAttemptsTime
		_childTemp, typeSwitchError = BACnetConstructedDataFailedAttemptsTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValueFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataFaultHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataFaultHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValueFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataFaultLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataFaultLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_PARAMETERS: // BACnetConstructedDataFaultParameters
		_childTemp, typeSwitchError = BACnetConstructedDataFaultParametersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ESCALATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataEscalatorFaultSignals
		_childTemp, typeSwitchError = BACnetConstructedDataEscalatorFaultSignalsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataLiftFaultSignals
		_childTemp, typeSwitchError = BACnetConstructedDataLiftFaultSignalsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataFaultSignals
		_childTemp, typeSwitchError = BACnetConstructedDataFaultSignalsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataFaultType
		_childTemp, typeSwitchError = BACnetConstructedDataFaultTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataAccessDoorFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataCharacterStringValueFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataCharacterStringValueFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataLifeSafetyPointFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyPointFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataLifeSafetyZoneFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyZoneFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateInputFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateInputFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateValueFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataFaultValues
		_childTemp, typeSwitchError = BACnetConstructedDataFaultValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FD_BBMD_ADDRESS: // BACnetConstructedDataFDBBMDAddress
		_childTemp, typeSwitchError = BACnetConstructedDataFDBBMDAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME && peekedTagNumber == uint8(2): // BACnetConstructedDataFDSubscriptionLifetime
		_childTemp, typeSwitchError = BACnetConstructedDataFDSubscriptionLifetimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputFeedbackValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryLightingOutputFeedbackValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputFeedbackValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryOutputFeedbackValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputFeedbackValue
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputFeedbackValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateOutputFeedbackValue
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateOutputFeedbackValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_ACCESS_METHOD && peekedTagNumber == uint8(9): // BACnetConstructedDataFileAccessMethod
		_childTemp, typeSwitchError = BACnetConstructedDataFileAccessMethodParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_SIZE && peekedTagNumber == uint8(2): // BACnetConstructedDataFileSize
		_childTemp, typeSwitchError = BACnetConstructedDataFileSizeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_TYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataFileType
		_childTemp, typeSwitchError = BACnetConstructedDataFileTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FIRMWARE_REVISION && peekedTagNumber == uint8(7): // BACnetConstructedDataFirmwareRevision
		_childTemp, typeSwitchError = BACnetConstructedDataFirmwareRevisionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FLOOR_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataFloorText
		_childTemp, typeSwitchError = BACnetConstructedDataFloorTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FULL_DUTY_BASELINE && peekedTagNumber == uint8(4): // BACnetConstructedDataFullDutyBaseline
		_childTemp, typeSwitchError = BACnetConstructedDataFullDutyBaselineParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GLOBAL_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataGlobalIdentifier
		_childTemp, typeSwitchError = BACnetConstructedDataGlobalIdentifierParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_ID && peekedTagNumber == uint8(2): // BACnetConstructedDataGroupID
		_childTemp, typeSwitchError = BACnetConstructedDataGroupIDParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBER_NAMES && peekedTagNumber == uint8(7): // BACnetConstructedDataGroupMemberNames
		_childTemp, typeSwitchError = BACnetConstructedDataGroupMemberNamesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS: // BACnetConstructedDataGlobalGroupGroupMembers
		_childTemp, typeSwitchError = BACnetConstructedDataGlobalGroupGroupMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ELEVATOR_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS && peekedTagNumber == uint8(12): // BACnetConstructedDataElevatorGroupGroupMembers
		_childTemp, typeSwitchError = BACnetConstructedDataElevatorGroupGroupMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS && peekedTagNumber == uint8(12): // BACnetConstructedDataGroupMembers
		_childTemp, typeSwitchError = BACnetConstructedDataGroupMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataGroupMode
		_childTemp, typeSwitchError = BACnetConstructedDataGroupModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataHighLimit
		_childTemp, typeSwitchError = BACnetConstructedDataHighLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGHER_DECK && peekedTagNumber == uint8(12): // BACnetConstructedDataHigherDeck
		_childTemp, typeSwitchError = BACnetConstructedDataHigherDeckParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IN_PROCESS && peekedTagNumber == uint8(1): // BACnetConstructedDataInProcess
		_childTemp, typeSwitchError = BACnetConstructedDataInProcessParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IN_PROGRESS && peekedTagNumber == uint8(9): // BACnetConstructedDataInProgress
		_childTemp, typeSwitchError = BACnetConstructedDataInProgressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INACTIVE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataInactiveText
		_childTemp, typeSwitchError = BACnetConstructedDataInactiveTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INITIAL_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataInitialTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataInitialTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INPUT_REFERENCE: // BACnetConstructedDataInputReference
		_childTemp, typeSwitchError = BACnetConstructedDataInputReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTALLATION_ID && peekedTagNumber == uint8(2): // BACnetConstructedDataInstallationID
		_childTemp, typeSwitchError = BACnetConstructedDataInstallationIDParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTANCE_OF && peekedTagNumber == uint8(7): // BACnetConstructedDataInstanceOf
		_childTemp, typeSwitchError = BACnetConstructedDataInstanceOfParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTANTANEOUS_POWER && peekedTagNumber == uint8(4): // BACnetConstructedDataInstantaneousPower
		_childTemp, typeSwitchError = BACnetConstructedDataInstantaneousPowerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTEGRAL_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataIntegralConstant
		_childTemp, typeSwitchError = BACnetConstructedDataIntegralConstantParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataIntegralConstantUnits
		_childTemp, typeSwitchError = BACnetConstructedDataIntegralConstantUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataAnalogInputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataAnalogOutputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogOutputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataBinaryInputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryInputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataBinaryOutputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryOutputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataMultiStateInputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateInputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataMultiStateOutputInterfaceValue
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateOutputInterfaceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERVAL_OFFSET && peekedTagNumber == uint8(2): // BACnetConstructedDataIntervalOffset
		_childTemp, typeSwitchError = BACnetConstructedDataIntervalOffsetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataIPAddress
		_childTemp, typeSwitchError = BACnetConstructedDataIPAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDefaultGateway
		_childTemp, typeSwitchError = BACnetConstructedDataIPDefaultGatewayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataIPDHCPEnable
		_childTemp, typeSwitchError = BACnetConstructedDataIPDHCPEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataIPDHCPLeaseTime
		_childTemp, typeSwitchError = BACnetConstructedDataIPDHCPLeaseTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING && peekedTagNumber == uint8(2): // BACnetConstructedDataIPDHCPLeaseTimeRemaining
		_childTemp, typeSwitchError = BACnetConstructedDataIPDHCPLeaseTimeRemainingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDHCPServer
		_childTemp, typeSwitchError = BACnetConstructedDataIPDHCPServerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DNS_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDNSServer
		_childTemp, typeSwitchError = BACnetConstructedDataIPDNSServerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_SUBNET_MASK && peekedTagNumber == uint8(6): // BACnetConstructedDataIPSubnetMask
		_childTemp, typeSwitchError = BACnetConstructedDataIPSubnetMaskParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6Address
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6AddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataIPv6AutoAddressingEnable
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6AutoAddressingEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DefaultGateway
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6DefaultGatewayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6DHCPLeaseTime
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6DHCPLeaseTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6DHCPLeaseTimeRemaining
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6DHCPLeaseTimeRemainingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DHCPServer
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6DHCPServerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DNS_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DNSServer
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6DNSServerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6PrefixLength
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6PrefixLengthParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_ZONE_INDEX && peekedTagNumber == uint8(7): // BACnetConstructedDataIPv6ZoneIndex
		_childTemp, typeSwitchError = BACnetConstructedDataIPv6ZoneIndexParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IS_UTC && peekedTagNumber == uint8(1): // BACnetConstructedDataIsUTC
		_childTemp, typeSwitchError = BACnetConstructedDataIsUTCParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_KEY_SETS: // BACnetConstructedDataKeySets
		_childTemp, typeSwitchError = BACnetConstructedDataKeySetsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_CALL_CONTROL: // BACnetConstructedDataLandingCallControl
		_childTemp, typeSwitchError = BACnetConstructedDataLandingCallControlParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_CALLS: // BACnetConstructedDataLandingCalls
		_childTemp, typeSwitchError = BACnetConstructedDataLandingCallsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_DOOR_STATUS: // BACnetConstructedDataLandingDoorStatus
		_childTemp, typeSwitchError = BACnetConstructedDataLandingDoorStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_ACCESS_EVENT && peekedTagNumber == uint8(9): // BACnetConstructedDataLastAccessEvent
		_childTemp, typeSwitchError = BACnetConstructedDataLastAccessEventParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_ACCESS_POINT: // BACnetConstructedDataLastAccessPoint
		_childTemp, typeSwitchError = BACnetConstructedDataLastAccessPointParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_COMMAND_TIME: // BACnetConstructedDataLastCommandTime
		_childTemp, typeSwitchError = BACnetConstructedDataLastCommandTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED: // BACnetConstructedDataLastCredentialAdded
		_childTemp, typeSwitchError = BACnetConstructedDataLastCredentialAddedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME: // BACnetConstructedDataLastCredentialAddedTime
		_childTemp, typeSwitchError = BACnetConstructedDataLastCredentialAddedTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED: // BACnetConstructedDataLastCredentialRemoved
		_childTemp, typeSwitchError = BACnetConstructedDataLastCredentialRemovedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME: // BACnetConstructedDataLastCredentialRemovedTime
		_childTemp, typeSwitchError = BACnetConstructedDataLastCredentialRemovedTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_KEY_SERVER: // BACnetConstructedDataLastKeyServer
		_childTemp, typeSwitchError = BACnetConstructedDataLastKeyServerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_NOTIFY_RECORD && peekedTagNumber == uint8(2): // BACnetConstructedDataLastNotifyRecord
		_childTemp, typeSwitchError = BACnetConstructedDataLastNotifyRecordParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_PRIORITY && peekedTagNumber == uint8(2): // BACnetConstructedDataLastPriority
		_childTemp, typeSwitchError = BACnetConstructedDataLastPriorityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_RESTART_REASON && peekedTagNumber == uint8(9): // BACnetConstructedDataLastRestartReason
		_childTemp, typeSwitchError = BACnetConstructedDataLastRestartReasonParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_RESTORE_TIME: // BACnetConstructedDataLastRestoreTime
		_childTemp, typeSwitchError = BACnetConstructedDataLastRestoreTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_STATE_CHANGE && peekedTagNumber == uint8(9): // BACnetConstructedDataLastStateChange
		_childTemp, typeSwitchError = BACnetConstructedDataLastStateChangeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_USE_TIME: // BACnetConstructedDataLastUseTime
		_childTemp, typeSwitchError = BACnetConstructedDataLastUseTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIGHTING_COMMAND: // BACnetConstructedDataLightingCommand
		_childTemp, typeSwitchError = BACnetConstructedDataLightingCommandParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY && peekedTagNumber == uint8(2): // BACnetConstructedDataLightingCommandDefaultPriority
		_childTemp, typeSwitchError = BACnetConstructedDataLightingCommandDefaultPriorityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIMIT_ENABLE && peekedTagNumber == uint8(8): // BACnetConstructedDataLimitEnable
		_childTemp, typeSwitchError = BACnetConstructedDataLimitEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataLimitMonitoringInterval
		_childTemp, typeSwitchError = BACnetConstructedDataLimitMonitoringIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEED && peekedTagNumber == uint8(4): // BACnetConstructedDataLinkSpeed
		_childTemp, typeSwitchError = BACnetConstructedDataLinkSpeedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE && peekedTagNumber == uint8(1): // BACnetConstructedDataLinkSpeedAutonegotiate
		_childTemp, typeSwitchError = BACnetConstructedDataLinkSpeedAutonegotiateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEEDS && peekedTagNumber == uint8(4): // BACnetConstructedDataLinkSpeeds
		_childTemp, typeSwitchError = BACnetConstructedDataLinkSpeedsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS: // BACnetConstructedDataListOfGroupMembers
		_childTemp, typeSwitchError = BACnetConstructedDataListOfGroupMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES: // BACnetConstructedDataChannelListOfObjectPropertyReferences
		_childTemp, typeSwitchError = BACnetConstructedDataChannelListOfObjectPropertyReferencesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES: // BACnetConstructedDataListOfObjectPropertyReferences
		_childTemp, typeSwitchError = BACnetConstructedDataListOfObjectPropertyReferencesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_DATE && peekedTagNumber == uint8(10): // BACnetConstructedDataLocalDate
		_childTemp, typeSwitchError = BACnetConstructedDataLocalDateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY && peekedTagNumber == uint8(1): // BACnetConstructedDataLocalForwardingOnly
		_childTemp, typeSwitchError = BACnetConstructedDataLocalForwardingOnlyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_TIME && peekedTagNumber == uint8(11): // BACnetConstructedDataLocalTime
		_childTemp, typeSwitchError = BACnetConstructedDataLocalTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataLocation
		_childTemp, typeSwitchError = BACnetConstructedDataLocationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCK_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataLockStatus
		_childTemp, typeSwitchError = BACnetConstructedDataLockStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCKOUT && peekedTagNumber == uint8(1): // BACnetConstructedDataLockout
		_childTemp, typeSwitchError = BACnetConstructedDataLockoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataLockoutRelinquishTime
		_childTemp, typeSwitchError = BACnetConstructedDataLockoutRelinquishTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_EVENT_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataEventLogLogBuffer
		_childTemp, typeSwitchError = BACnetConstructedDataEventLogLogBufferParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataTrendLogLogBuffer
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogLogBufferParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataTrendLogMultipleLogBuffer
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogMultipleLogBufferParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataLogBuffer
		_childTemp, typeSwitchError = BACnetConstructedDataLogBufferParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataTrendLogLogDeviceObjectProperty
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogLogDeviceObjectPropertyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty
		_childTemp, typeSwitchError = BACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataLogDeviceObjectProperty
		_childTemp, typeSwitchError = BACnetConstructedDataLogDeviceObjectPropertyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataLogInterval
		_childTemp, typeSwitchError = BACnetConstructedDataLogIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_OBJECT && peekedTagNumber == uint8(12): // BACnetConstructedDataLoggingObject
		_childTemp, typeSwitchError = BACnetConstructedDataLoggingObjectParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_RECORD: // BACnetConstructedDataLoggingRecord
		_childTemp, typeSwitchError = BACnetConstructedDataLoggingRecordParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataLoggingType
		_childTemp, typeSwitchError = BACnetConstructedDataLoggingTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_DIFF_LIMIT: // BACnetConstructedDataLowDiffLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLowDiffLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataLowLimit
		_childTemp, typeSwitchError = BACnetConstructedDataLowLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOWER_DECK && peekedTagNumber == uint8(12): // BACnetConstructedDataLowerDeck
		_childTemp, typeSwitchError = BACnetConstructedDataLowerDeckParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAC_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataMACAddress
		_childTemp, typeSwitchError = BACnetConstructedDataMACAddressParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MACHINE_ROOM_ID && peekedTagNumber == uint8(12): // BACnetConstructedDataMachineRoomID
		_childTemp, typeSwitchError = BACnetConstructedDataMachineRoomIDParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAINTENANCE_REQUIRED && peekedTagNumber == uint8(1): // BACnetConstructedDataLifeSafetyZoneMaintenanceRequired
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyZoneMaintenanceRequiredParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAINTENANCE_REQUIRED && peekedTagNumber == uint8(9): // BACnetConstructedDataMaintenanceRequired
		_childTemp, typeSwitchError = BACnetConstructedDataMaintenanceRequiredParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAKING_CAR_CALL: // BACnetConstructedDataMakingCarCall
		_childTemp, typeSwitchError = BACnetConstructedDataMakingCarCallParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE: // BACnetConstructedDataManipulatedVariableReference
		_childTemp, typeSwitchError = BACnetConstructedDataManipulatedVariableReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING: // BACnetConstructedDataManualSlaveAddressBinding
		_childTemp, typeSwitchError = BACnetConstructedDataManualSlaveAddressBindingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MASKED_ALARM_VALUES && peekedTagNumber == uint8(9): // BACnetConstructedDataMaskedAlarmValues
		_childTemp, typeSwitchError = BACnetConstructedDataMaskedAlarmValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_ACTUAL_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaxActualValue
		_childTemp, typeSwitchError = BACnetConstructedDataMaxActualValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxAPDULengthAccepted
		_childTemp, typeSwitchError = BACnetConstructedDataMaxAPDULengthAcceptedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxFailedAttempts
		_childTemp, typeSwitchError = BACnetConstructedDataMaxFailedAttemptsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataDeviceMaxInfoFrames
		_childTemp, typeSwitchError = BACnetConstructedDataDeviceMaxInfoFramesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkPortMaxInfoFrames
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkPortMaxInfoFramesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxInfoFrames
		_childTemp, typeSwitchError = BACnetConstructedDataMaxInfoFramesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataDeviceMaxMaster
		_childTemp, typeSwitchError = BACnetConstructedDataDeviceMaxMasterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkPortMaxMaster
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkPortMaxMasterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxMaster
		_childTemp, typeSwitchError = BACnetConstructedDataMaxMasterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogOutputMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValueMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataTimerMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaxPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataMaxPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxSegmentsAccepted
		_childTemp, typeSwitchError = BACnetConstructedDataMaxSegmentsAcceptedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_OUTPUT && peekedTagNumber == uint8(4): // BACnetConstructedDataMaximumOutput
		_childTemp, typeSwitchError = BACnetConstructedDataMaximumOutputParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaximumValue
		_childTemp, typeSwitchError = BACnetConstructedDataMaximumValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP: // BACnetConstructedDataMaximumValueTimestamp
		_childTemp, typeSwitchError = BACnetConstructedDataMaximumValueTimestampParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBER_OF: // BACnetConstructedDataMemberOf
		_childTemp, typeSwitchError = BACnetConstructedDataMemberOfParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS && peekedTagNumber == uint8(8): // BACnetConstructedDataMemberStatusFlags
		_childTemp, typeSwitchError = BACnetConstructedDataMemberStatusFlagsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBERS: // BACnetConstructedDataMembers
		_childTemp, typeSwitchError = BACnetConstructedDataMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_ACTUAL_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinActualValue
		_childTemp, typeSwitchError = BACnetConstructedDataMinActualValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataAccumulatorMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataTimerMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinPresValue
		_childTemp, typeSwitchError = BACnetConstructedDataMinPresValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_OFF_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataMinimumOffTime
		_childTemp, typeSwitchError = BACnetConstructedDataMinimumOffTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_ON_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataMinimumOnTime
		_childTemp, typeSwitchError = BACnetConstructedDataMinimumOnTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_OUTPUT && peekedTagNumber == uint8(4): // BACnetConstructedDataMinimumOutput
		_childTemp, typeSwitchError = BACnetConstructedDataMinimumOutputParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinimumValue
		_childTemp, typeSwitchError = BACnetConstructedDataMinimumValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP: // BACnetConstructedDataMinimumValueTimestamp
		_childTemp, typeSwitchError = BACnetConstructedDataMinimumValueTimestampParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataMode
		_childTemp, typeSwitchError = BACnetConstructedDataModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODEL_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataModelName
		_childTemp, typeSwitchError = BACnetConstructedDataModelNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODIFICATION_DATE: // BACnetConstructedDataModificationDate
		_childTemp, typeSwitchError = BACnetConstructedDataModificationDateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MUSTER_POINT && peekedTagNumber == uint8(1): // BACnetConstructedDataMusterPoint
		_childTemp, typeSwitchError = BACnetConstructedDataMusterPointParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES: // BACnetConstructedDataNegativeAccessRules
		_childTemp, typeSwitchError = BACnetConstructedDataNegativeAccessRulesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES: // BACnetConstructedDataNetworkAccessSecurityPolicies
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkAccessSecurityPoliciesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataNetworkInterfaceName
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkInterfaceNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_NUMBER && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkNumber
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkNumberParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY && peekedTagNumber == uint8(9): // BACnetConstructedDataNetworkNumberQuality
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkNumberQualityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNetworkType
		_childTemp, typeSwitchError = BACnetConstructedDataNetworkTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR && peekedTagNumber == uint8(2): // BACnetConstructedDataNextStoppingFloor
		_childTemp, typeSwitchError = BACnetConstructedDataNextStoppingFloorParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NODE_SUBTYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataNodeSubtype
		_childTemp, typeSwitchError = BACnetConstructedDataNodeSubtypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NODE_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNodeType
		_childTemp, typeSwitchError = BACnetConstructedDataNodeTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFICATION_CLASS && peekedTagNumber == uint8(2): // BACnetConstructedDataNotificationClass
		_childTemp, typeSwitchError = BACnetConstructedDataNotificationClassParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD && peekedTagNumber == uint8(2): // BACnetConstructedDataNotificationThreshold
		_childTemp, typeSwitchError = BACnetConstructedDataNotificationThresholdParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFY_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNotifyType
		_childTemp, typeSwitchError = BACnetConstructedDataNotifyTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfAPDURetries
		_childTemp, typeSwitchError = BACnetConstructedDataNumberOfAPDURetriesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfAuthenticationPolicies
		_childTemp, typeSwitchError = BACnetConstructedDataNumberOfAuthenticationPoliciesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_STATES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfStates
		_childTemp, typeSwitchError = BACnetConstructedDataNumberOfStatesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_IDENTIFIER && peekedTagNumber == uint8(12): // BACnetConstructedDataObjectIdentifier
		_childTemp, typeSwitchError = BACnetConstructedDataObjectIdentifierParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_LIST: // BACnetConstructedDataObjectList
		_childTemp, typeSwitchError = BACnetConstructedDataObjectListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataObjectName
		_childTemp, typeSwitchError = BACnetConstructedDataObjectNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE: // BACnetConstructedDataObjectPropertyReference
		_childTemp, typeSwitchError = BACnetConstructedDataObjectPropertyReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataObjectType
		_childTemp, typeSwitchError = BACnetConstructedDataObjectTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyCount
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyCountAdjust
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyCountAdjustParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyCountEnable
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyCountEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyLowerLimit
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyLowerLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyLowerLimitEnforced
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyLowerLimitEnforcedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataOccupancyState
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyUpperLimit
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyUpperLimitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyUpperLimitEnforced
		_childTemp, typeSwitchError = BACnetConstructedDataOccupancyUpperLimitEnforcedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPERATION_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataOperationDirection
		_childTemp, typeSwitchError = BACnetConstructedDataOperationDirectionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPERATION_EXPECTED && peekedTagNumber == uint8(9): // BACnetConstructedDataOperationExpected
		_childTemp, typeSwitchError = BACnetConstructedDataOperationExpectedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPTIONAL: // BACnetConstructedDataOptional
		_childTemp, typeSwitchError = BACnetConstructedDataOptionalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OUT_OF_SERVICE && peekedTagNumber == uint8(1): // BACnetConstructedDataOutOfService
		_childTemp, typeSwitchError = BACnetConstructedDataOutOfServiceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OUTPUT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataOutputUnits
		_childTemp, typeSwitchError = BACnetConstructedDataOutputUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PACKET_REORDER_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataPacketReorderTime
		_childTemp, typeSwitchError = BACnetConstructedDataPacketReorderTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSBACK_MODE: // BACnetConstructedDataPassbackMode
		_childTemp, typeSwitchError = BACnetConstructedDataPassbackModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSBACK_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataPassbackTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataPassbackTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSENGER_ALARM && peekedTagNumber == uint8(1): // BACnetConstructedDataPassengerAlarm
		_childTemp, typeSwitchError = BACnetConstructedDataPassengerAlarmParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POLARITY && peekedTagNumber == uint8(9): // BACnetConstructedDataPolarity
		_childTemp, typeSwitchError = BACnetConstructedDataPolarityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PORT_FILTER: // BACnetConstructedDataPortFilter
		_childTemp, typeSwitchError = BACnetConstructedDataPortFilterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES: // BACnetConstructedDataPositiveAccessRules
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveAccessRulesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POWER && peekedTagNumber == uint8(4): // BACnetConstructedDataPower
		_childTemp, typeSwitchError = BACnetConstructedDataPowerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POWER_MODE && peekedTagNumber == uint8(1): // BACnetConstructedDataPowerMode
		_childTemp, typeSwitchError = BACnetConstructedDataPowerModeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESCALE: // BACnetConstructedDataPrescale
		_childTemp, typeSwitchError = BACnetConstructedDataPrescaleParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessDoorPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ALERT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(12): // BACnetConstructedDataAlertEnrollmentPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataAlertEnrollmentPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogInputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogOutputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryInputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryInputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryOutputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryLightingOutputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataBitStringValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CALENDAR && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(1): // BACnetConstructedDataCalendarPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataCalendarPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataChannelPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataChannelPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(7): // BACnetConstructedDataCharacterStringValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataCharacterStringValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataCredentialDataInputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialDataInputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(10): // BACnetConstructedDataDateValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataDateValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(10): // BACnetConstructedDataDatePatternValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataDatePatternValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataDateTimeValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataDateTimeValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataDateTimePatternValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataDateTimePatternValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyPointPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyPointPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyZonePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLifeSafetyZonePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LOAD_CONTROL && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLoadControlPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLoadControlPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLoopPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataLoopPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataPulseConverterPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataPulseConverterPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataGroupPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataGroupPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataGlobalGroupPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataGlobalGroupPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(6): // BACnetConstructedDataOctetStringValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataOctetStringValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_SCHEDULE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataSchedulePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataSchedulePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataTimeValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataTimeValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataTimePatternValuePresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataTimePatternValuePresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPresentValue
		_childTemp, typeSwitchError = BACnetConstructedDataPresentValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY: // BACnetConstructedDataPriority
		_childTemp, typeSwitchError = BACnetConstructedDataPriorityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY_ARRAY: // BACnetConstructedDataPriorityArray
		_childTemp, typeSwitchError = BACnetConstructedDataPriorityArrayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY_FOR_WRITING && peekedTagNumber == uint8(2): // BACnetConstructedDataPriorityForWriting
		_childTemp, typeSwitchError = BACnetConstructedDataPriorityForWritingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROCESS_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataProcessIdentifier
		_childTemp, typeSwitchError = BACnetConstructedDataProcessIdentifierParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER: // BACnetConstructedDataProcessIdentifierFilter
		_childTemp, typeSwitchError = BACnetConstructedDataProcessIdentifierFilterParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROFILE_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataProfileLocation
		_childTemp, typeSwitchError = BACnetConstructedDataProfileLocationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROFILE_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataProfileName
		_childTemp, typeSwitchError = BACnetConstructedDataProfileNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_CHANGE && peekedTagNumber == uint8(9): // BACnetConstructedDataProgramChange
		_childTemp, typeSwitchError = BACnetConstructedDataProgramChangeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataProgramLocation
		_childTemp, typeSwitchError = BACnetConstructedDataProgramLocationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataProgramState
		_childTemp, typeSwitchError = BACnetConstructedDataProgramStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPERTY_LIST && peekedTagNumber == uint8(9): // BACnetConstructedDataPropertyList
		_childTemp, typeSwitchError = BACnetConstructedDataPropertyListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataProportionalConstant
		_childTemp, typeSwitchError = BACnetConstructedDataProportionalConstantParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataProportionalConstantUnits
		_childTemp, typeSwitchError = BACnetConstructedDataProportionalConstantUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_LEVEL && peekedTagNumber == uint8(9): // BACnetConstructedDataProtocolLevel
		_childTemp, typeSwitchError = BACnetConstructedDataProtocolLevelParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED && peekedTagNumber == uint8(8): // BACnetConstructedDataProtocolObjectTypesSupported
		_childTemp, typeSwitchError = BACnetConstructedDataProtocolObjectTypesSupportedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataProtocolRevision
		_childTemp, typeSwitchError = BACnetConstructedDataProtocolRevisionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED && peekedTagNumber == uint8(8): // BACnetConstructedDataProtocolServicesSupported
		_childTemp, typeSwitchError = BACnetConstructedDataProtocolServicesSupportedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_VERSION && peekedTagNumber == uint8(2): // BACnetConstructedDataProtocolVersion
		_childTemp, typeSwitchError = BACnetConstructedDataProtocolVersionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PULSE_RATE && peekedTagNumber == uint8(2): // BACnetConstructedDataPulseRate
		_childTemp, typeSwitchError = BACnetConstructedDataPulseRateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_READ_ONLY && peekedTagNumber == uint8(1): // BACnetConstructedDataReadOnly
		_childTemp, typeSwitchError = BACnetConstructedDataReadOnlyParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REASON_FOR_DISABLE && peekedTagNumber == uint8(9): // BACnetConstructedDataReasonForDisable
		_childTemp, typeSwitchError = BACnetConstructedDataReasonForDisableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REASON_FOR_HALT && peekedTagNumber == uint8(9): // BACnetConstructedDataReasonForHalt
		_childTemp, typeSwitchError = BACnetConstructedDataReasonForHaltParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECIPIENT_LIST: // BACnetConstructedDataRecipientList
		_childTemp, typeSwitchError = BACnetConstructedDataRecipientListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_FILE && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataFileRecordCount
		_childTemp, typeSwitchError = BACnetConstructedDataFileRecordCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataRecordCount
		_childTemp, typeSwitchError = BACnetConstructedDataRecordCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION && peekedTagNumber == uint8(2): // BACnetConstructedDataRecordsSinceNotification
		_childTemp, typeSwitchError = BACnetConstructedDataRecordsSinceNotificationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REFERENCE_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataReferencePort
		_childTemp, typeSwitchError = BACnetConstructedDataReferencePortParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REGISTERED_CAR_CALL: // BACnetConstructedDataRegisteredCarCall
		_childTemp, typeSwitchError = BACnetConstructedDataRegisteredCarCallParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELIABILITY && peekedTagNumber == uint8(9): // BACnetConstructedDataReliability
		_childTemp, typeSwitchError = BACnetConstructedDataReliabilityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataReliabilityEvaluationInhibit
		_childTemp, typeSwitchError = BACnetConstructedDataReliabilityEvaluationInhibitParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessDoorRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataAccessDoorRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogOutputRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataAnalogValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryOutputRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataBinaryLightingOutputRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataBitStringValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(7): // BACnetConstructedDataCharacterStringValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataCharacterStringValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(10): // BACnetConstructedDataDateValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataDateValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(10): // BACnetConstructedDataDatePatternValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataDatePatternValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT: // BACnetConstructedDataDateTimeValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataDateTimeValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT: // BACnetConstructedDataDateTimePatternValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataDateTimePatternValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(11): // BACnetConstructedDataTimePatternValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataTimePatternValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(11): // BACnetConstructedDataTimeValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataTimeValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(6): // BACnetConstructedDataOctetStringValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataOctetStringValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateOutputRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateOutputRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataMultiStateValueRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataRelinquishDefault
		_childTemp, typeSwitchError = BACnetConstructedDataRelinquishDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REPRESENTS: // BACnetConstructedDataRepresents
		_childTemp, typeSwitchError = BACnetConstructedDataRepresentsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL: // BACnetConstructedDataRequestedShedLevel
		_childTemp, typeSwitchError = BACnetConstructedDataRequestedShedLevelParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataRequestedUpdateInterval
		_childTemp, typeSwitchError = BACnetConstructedDataRequestedUpdateIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUIRED: // BACnetConstructedDataRequired
		_childTemp, typeSwitchError = BACnetConstructedDataRequiredParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueResolution
		_childTemp, typeSwitchError = BACnetConstructedDataLargeAnalogValueResolutionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueResolution
		_childTemp, typeSwitchError = BACnetConstructedDataIntegerValueResolutionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueResolution
		_childTemp, typeSwitchError = BACnetConstructedDataPositiveIntegerValueResolutionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerResolution
		_childTemp, typeSwitchError = BACnetConstructedDataTimerResolutionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(4): // BACnetConstructedDataResolution
		_childTemp, typeSwitchError = BACnetConstructedDataResolutionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS: // BACnetConstructedDataRestartNotificationRecipients
		_childTemp, typeSwitchError = BACnetConstructedDataRestartNotificationRecipientsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataRestoreCompletionTime
		_childTemp, typeSwitchError = BACnetConstructedDataRestoreCompletionTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataRestorePreparationTime
		_childTemp, typeSwitchError = BACnetConstructedDataRestorePreparationTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ROUTING_TABLE: // BACnetConstructedDataRoutingTable
		_childTemp, typeSwitchError = BACnetConstructedDataRoutingTableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCALE: // BACnetConstructedDataScale
		_childTemp, typeSwitchError = BACnetConstructedDataScaleParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCALE_FACTOR && peekedTagNumber == uint8(4): // BACnetConstructedDataScaleFactor
		_childTemp, typeSwitchError = BACnetConstructedDataScaleFactorParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCHEDULE_DEFAULT: // BACnetConstructedDataScheduleDefault
		_childTemp, typeSwitchError = BACnetConstructedDataScheduleDefaultParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURED_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataSecuredStatus
		_childTemp, typeSwitchError = BACnetConstructedDataSecuredStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataSecurityPDUTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataSecurityPDUTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURITY_TIME_WINDOW && peekedTagNumber == uint8(2): // BACnetConstructedDataSecurityTimeWindow
		_childTemp, typeSwitchError = BACnetConstructedDataSecurityTimeWindowParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED && peekedTagNumber == uint8(9): // BACnetConstructedDataSegmentationSupported
		_childTemp, typeSwitchError = BACnetConstructedDataSegmentationSupportedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SERIAL_NUMBER && peekedTagNumber == uint8(7): // BACnetConstructedDataSerialNumber
		_childTemp, typeSwitchError = BACnetConstructedDataSerialNumberParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETPOINT && peekedTagNumber == uint8(4): // BACnetConstructedDataSetpoint
		_childTemp, typeSwitchError = BACnetConstructedDataSetpointParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETPOINT_REFERENCE: // BACnetConstructedDataSetpointReference
		_childTemp, typeSwitchError = BACnetConstructedDataSetpointReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETTING && peekedTagNumber == uint8(2): // BACnetConstructedDataSetting
		_childTemp, typeSwitchError = BACnetConstructedDataSettingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_DURATION && peekedTagNumber == uint8(2): // BACnetConstructedDataShedDuration
		_childTemp, typeSwitchError = BACnetConstructedDataShedDurationParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS && peekedTagNumber == uint8(7): // BACnetConstructedDataShedLevelDescriptions
		_childTemp, typeSwitchError = BACnetConstructedDataShedLevelDescriptionsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_LEVELS && peekedTagNumber == uint8(2): // BACnetConstructedDataShedLevels
		_childTemp, typeSwitchError = BACnetConstructedDataShedLevelsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SILENCED && peekedTagNumber == uint8(9): // BACnetConstructedDataSilenced
		_childTemp, typeSwitchError = BACnetConstructedDataSilencedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING: // BACnetConstructedDataSlaveAddressBinding
		_childTemp, typeSwitchError = BACnetConstructedDataSlaveAddressBindingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataSlaveProxyEnable
		_childTemp, typeSwitchError = BACnetConstructedDataSlaveProxyEnableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_START_TIME: // BACnetConstructedDataStartTime
		_childTemp, typeSwitchError = BACnetConstructedDataStartTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_CHANGE_VALUES: // BACnetConstructedDataStateChangeValues
		_childTemp, typeSwitchError = BACnetConstructedDataStateChangeValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_DESCRIPTION && peekedTagNumber == uint8(7): // BACnetConstructedDataStateDescription
		_childTemp, typeSwitchError = BACnetConstructedDataStateDescriptionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataStateText
		_childTemp, typeSwitchError = BACnetConstructedDataStateTextParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATUS_FLAGS && peekedTagNumber == uint8(8): // BACnetConstructedDataStatusFlags
		_childTemp, typeSwitchError = BACnetConstructedDataStatusFlagsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STOP_TIME: // BACnetConstructedDataStopTime
		_childTemp, typeSwitchError = BACnetConstructedDataStopTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STOP_WHEN_FULL && peekedTagNumber == uint8(1): // BACnetConstructedDataStopWhenFull
		_childTemp, typeSwitchError = BACnetConstructedDataStopWhenFullParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STRIKE_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataStrikeCount
		_childTemp, typeSwitchError = BACnetConstructedDataStrikeCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST: // BACnetConstructedDataStructuredObjectList
		_childTemp, typeSwitchError = BACnetConstructedDataStructuredObjectListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS: // BACnetConstructedDataSubordinateAnnotations
		_childTemp, typeSwitchError = BACnetConstructedDataSubordinateAnnotationsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_LIST: // BACnetConstructedDataSubordinateList
		_childTemp, typeSwitchError = BACnetConstructedDataSubordinateListParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES && peekedTagNumber == uint8(9): // BACnetConstructedDataSubordinateNodeTypes
		_childTemp, typeSwitchError = BACnetConstructedDataSubordinateNodeTypesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS && peekedTagNumber == uint8(9): // BACnetConstructedDataSubordinateRelationships
		_childTemp, typeSwitchError = BACnetConstructedDataSubordinateRelationshipsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_TAGS: // BACnetConstructedDataSubordinateTags
		_childTemp, typeSwitchError = BACnetConstructedDataSubordinateTagsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS: // BACnetConstructedDataSubscribedRecipients
		_childTemp, typeSwitchError = BACnetConstructedDataSubscribedRecipientsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES: // BACnetConstructedDataSupportedFormatClasses
		_childTemp, typeSwitchError = BACnetConstructedDataSupportedFormatClassesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_FORMATS: // BACnetConstructedDataSupportedFormats
		_childTemp, typeSwitchError = BACnetConstructedDataSupportedFormatsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS: // BACnetConstructedDataSupportedSecurityAlgorithms
		_childTemp, typeSwitchError = BACnetConstructedDataSupportedSecurityAlgorithmsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SYSTEM_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataSystemStatus
		_childTemp, typeSwitchError = BACnetConstructedDataSystemStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TAGS: // BACnetConstructedDataTags
		_childTemp, typeSwitchError = BACnetConstructedDataTagsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_THREAT_AUTHORITY: // BACnetConstructedDataThreatAuthority
		_childTemp, typeSwitchError = BACnetConstructedDataThreatAuthorityParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_THREAT_LEVEL: // BACnetConstructedDataThreatLevel
		_childTemp, typeSwitchError = BACnetConstructedDataThreatLevelParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_DELAY && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeDelay
		_childTemp, typeSwitchError = BACnetConstructedDataTimeDelayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_DELAY_NORMAL && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeDelayNormal
		_childTemp, typeSwitchError = BACnetConstructedDataTimeDelayNormalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET: // BACnetConstructedDataTimeOfActiveTimeReset
		_childTemp, typeSwitchError = BACnetConstructedDataTimeOfActiveTimeResetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART: // BACnetConstructedDataTimeOfDeviceRestart
		_childTemp, typeSwitchError = BACnetConstructedDataTimeOfDeviceRestartParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET: // BACnetConstructedDataTimeOfStateCountReset
		_childTemp, typeSwitchError = BACnetConstructedDataTimeOfStateCountResetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET: // BACnetConstructedDataTimeOfStrikeCountReset
		_childTemp, typeSwitchError = BACnetConstructedDataTimeOfStrikeCountResetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeSynchronizationInterval
		_childTemp, typeSwitchError = BACnetConstructedDataTimeSynchronizationIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS: // BACnetConstructedDataTimeSynchronizationRecipients
		_childTemp, typeSwitchError = BACnetConstructedDataTimeSynchronizationRecipientsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIMER_RUNNING && peekedTagNumber == uint8(1): // BACnetConstructedDataTimerRunning
		_childTemp, typeSwitchError = BACnetConstructedDataTimerRunningParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIMER_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataTimerState
		_childTemp, typeSwitchError = BACnetConstructedDataTimerStateParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TOTAL_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataTotalRecordCount
		_childTemp, typeSwitchError = BACnetConstructedDataTotalRecordCountParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACE_FLAG && peekedTagNumber == uint8(1): // BACnetConstructedDataTraceFlag
		_childTemp, typeSwitchError = BACnetConstructedDataTraceFlagParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACKING_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputTrackingValue
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputTrackingValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACKING_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputTrackingValue
		_childTemp, typeSwitchError = BACnetConstructedDataLightingOutputTrackingValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACKING_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataTrackingValue
		_childTemp, typeSwitchError = BACnetConstructedDataTrackingValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS && peekedTagNumber == uint8(2): // BACnetConstructedDataTransactionNotificationClass
		_childTemp, typeSwitchError = BACnetConstructedDataTransactionNotificationClassParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRANSITION && peekedTagNumber == uint8(9): // BACnetConstructedDataTransition
		_childTemp, typeSwitchError = BACnetConstructedDataTransitionParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRIGGER && peekedTagNumber == uint8(1): // BACnetConstructedDataTrigger
		_childTemp, typeSwitchError = BACnetConstructedDataTriggerParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataUnits
		_childTemp, typeSwitchError = BACnetConstructedDataUnitsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataUpdateInterval
		_childTemp, typeSwitchError = BACnetConstructedDataUpdateIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataUpdateKeySetTimeout
		_childTemp, typeSwitchError = BACnetConstructedDataUpdateKeySetTimeoutParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_TIME: // BACnetConstructedDataCredentialDataInputUpdateTime
		_childTemp, typeSwitchError = BACnetConstructedDataCredentialDataInputUpdateTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_TIME: // BACnetConstructedDataUpdateTime
		_childTemp, typeSwitchError = BACnetConstructedDataUpdateTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER && peekedTagNumber == uint8(7): // BACnetConstructedDataUserExternalIdentifier
		_childTemp, typeSwitchError = BACnetConstructedDataUserExternalIdentifierParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE && peekedTagNumber == uint8(7): // BACnetConstructedDataUserInformationReference
		_childTemp, typeSwitchError = BACnetConstructedDataUserInformationReferenceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataUserName
		_childTemp, typeSwitchError = BACnetConstructedDataUserNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataUserType
		_childTemp, typeSwitchError = BACnetConstructedDataUserTypeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USES_REMAINING && peekedTagNumber == uint8(3): // BACnetConstructedDataUsesRemaining
		_childTemp, typeSwitchError = BACnetConstructedDataUsesRemainingParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UTC_OFFSET && peekedTagNumber == uint8(3): // BACnetConstructedDataUTCOffset
		_childTemp, typeSwitchError = BACnetConstructedDataUTCOffsetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS: // BACnetConstructedDataUTCTimeSynchronizationRecipients
		_childTemp, typeSwitchError = BACnetConstructedDataUTCTimeSynchronizationRecipientsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALID_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataValidSamples
		_childTemp, typeSwitchError = BACnetConstructedDataValidSamplesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE && peekedTagNumber == uint8(2): // BACnetConstructedDataValueBeforeChange
		_childTemp, typeSwitchError = BACnetConstructedDataValueBeforeChangeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_CHANGE_TIME: // BACnetConstructedDataValueChangeTime
		_childTemp, typeSwitchError = BACnetConstructedDataValueChangeTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SET && peekedTagNumber == uint8(2): // BACnetConstructedDataValueSet
		_childTemp, typeSwitchError = BACnetConstructedDataValueSetParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SOURCE: // BACnetConstructedDataValueSource
		_childTemp, typeSwitchError = BACnetConstructedDataValueSourceParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY: // BACnetConstructedDataValueSourceArray
		_childTemp, typeSwitchError = BACnetConstructedDataValueSourceArrayParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VARIANCE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataVarianceValue
		_childTemp, typeSwitchError = BACnetConstructedDataVarianceValueParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VENDOR_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataVendorIdentifier
		_childTemp, typeSwitchError = BACnetConstructedDataVendorIdentifierParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VENDOR_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataVendorName
		_childTemp, typeSwitchError = BACnetConstructedDataVendorNameParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VERIFICATION_TIME && peekedTagNumber == uint8(3): // BACnetConstructedDataVerificationTime
		_childTemp, typeSwitchError = BACnetConstructedDataVerificationTimeParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE: // BACnetConstructedDataVirtualMACAddressTable
		_childTemp, typeSwitchError = BACnetConstructedDataVirtualMACAddressTableParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED && peekedTagNumber == uint8(9): // BACnetConstructedDataVTClassesSupported
		_childTemp, typeSwitchError = BACnetConstructedDataVTClassesSupportedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WEEKLY_SCHEDULE: // BACnetConstructedDataWeeklySchedule
		_childTemp, typeSwitchError = BACnetConstructedDataWeeklyScheduleParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WINDOW_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataWindowInterval
		_childTemp, typeSwitchError = BACnetConstructedDataWindowIntervalParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WINDOW_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataWindowSamples
		_childTemp, typeSwitchError = BACnetConstructedDataWindowSamplesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WRITE_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataWriteStatus
		_childTemp, typeSwitchError = BACnetConstructedDataWriteStatusParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_FROM: // BACnetConstructedDataZoneFrom
		_childTemp, typeSwitchError = BACnetConstructedDataZoneFromParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_MEMBERS: // BACnetConstructedDataZoneMembers
		_childTemp, typeSwitchError = BACnetConstructedDataZoneMembersParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_TO: // BACnetConstructedDataZoneTo
		_childTemp, typeSwitchError = BACnetConstructedDataZoneToParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case 0 == 0: // BACnetConstructedDataUnspecified
		_childTemp, typeSwitchError = BACnetConstructedDataUnspecifiedParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [objectTypeArgument=%v, propertyIdentifierArgument=%v, peekedTagNumber=%v]", objectTypeArgument, propertyIdentifierArgument, peekedTagNumber)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of BACnetConstructedData")
	}
	_child = _childTemp.(BACnetConstructedDataChildSerializeRequirement)

	// Simple Field (closingTag)
	if pullErr := readBuffer.PullContext("closingTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for closingTag")
	}
	_closingTag, _closingTagErr := BACnetClosingTagParseWithBuffer(ctx, readBuffer, uint8(tagNumber))
	if _closingTagErr != nil {
		return nil, errors.Wrap(_closingTagErr, "Error parsing 'closingTag' field of BACnetConstructedData")
	}
	closingTag := _closingTag.(BACnetClosingTag)
	if closeErr := readBuffer.CloseContext("closingTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for closingTag")
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedData")
	}

	// Finish initializing
	_child.InitializeParent(_child, openingTag, peekedTagHeader, closingTag)
	return _child, nil
}

func (pm *_BACnetConstructedData) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetConstructedData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetConstructedData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetConstructedData")
	}

	// Simple Field (openingTag)
	if pushErr := writeBuffer.PushContext("openingTag"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for openingTag")
	}
	_openingTagErr := writeBuffer.WriteSerializable(ctx, m.GetOpeningTag())
	if popErr := writeBuffer.PopContext("openingTag"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for openingTag")
	}
	if _openingTagErr != nil {
		return errors.Wrap(_openingTagErr, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	// Simple Field (closingTag)
	if pushErr := writeBuffer.PushContext("closingTag"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for closingTag")
	}
	_closingTagErr := writeBuffer.WriteSerializable(ctx, m.GetClosingTag())
	if popErr := writeBuffer.PopContext("closingTag"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for closingTag")
	}
	if _closingTagErr != nil {
		return errors.Wrap(_closingTagErr, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetConstructedData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetConstructedData")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetConstructedData) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetConstructedData) GetArrayIndexArgument() BACnetTagPayloadUnsignedInteger {
	return m.ArrayIndexArgument
}

//
////

func (m *_BACnetConstructedData) isBACnetConstructedData() bool {
	return true
}

func (m *_BACnetConstructedData) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
