/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/apache/plc4x/plc4go/spi/utils"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAccessCredentialDisableReason is an enum
type BACnetAccessCredentialDisableReason uint16

type IBACnetAccessCredentialDisableReason interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	BACnetAccessCredentialDisableReason_DISABLED                    BACnetAccessCredentialDisableReason = 0
	BACnetAccessCredentialDisableReason_DISABLED_NEEDS_PROVISIONING BACnetAccessCredentialDisableReason = 1
	BACnetAccessCredentialDisableReason_DISABLED_UNASSIGNED         BACnetAccessCredentialDisableReason = 2
	BACnetAccessCredentialDisableReason_DISABLED_NOT_YET_ACTIVE     BACnetAccessCredentialDisableReason = 3
	BACnetAccessCredentialDisableReason_DISABLED_EXPIRED            BACnetAccessCredentialDisableReason = 4
	BACnetAccessCredentialDisableReason_DISABLED_LOCKOUT            BACnetAccessCredentialDisableReason = 5
	BACnetAccessCredentialDisableReason_DISABLED_MAX_DAYS           BACnetAccessCredentialDisableReason = 6
	BACnetAccessCredentialDisableReason_DISABLED_MAX_USES           BACnetAccessCredentialDisableReason = 7
	BACnetAccessCredentialDisableReason_DISABLED_INACTIVITY         BACnetAccessCredentialDisableReason = 8
	BACnetAccessCredentialDisableReason_DISABLED_MANUAL             BACnetAccessCredentialDisableReason = 9
	BACnetAccessCredentialDisableReason_VENDOR_PROPRIETARY_VALUE    BACnetAccessCredentialDisableReason = 0xFFFF
)

var BACnetAccessCredentialDisableReasonValues []BACnetAccessCredentialDisableReason

func init() {
	_ = errors.New
	BACnetAccessCredentialDisableReasonValues = []BACnetAccessCredentialDisableReason{
		BACnetAccessCredentialDisableReason_DISABLED,
		BACnetAccessCredentialDisableReason_DISABLED_NEEDS_PROVISIONING,
		BACnetAccessCredentialDisableReason_DISABLED_UNASSIGNED,
		BACnetAccessCredentialDisableReason_DISABLED_NOT_YET_ACTIVE,
		BACnetAccessCredentialDisableReason_DISABLED_EXPIRED,
		BACnetAccessCredentialDisableReason_DISABLED_LOCKOUT,
		BACnetAccessCredentialDisableReason_DISABLED_MAX_DAYS,
		BACnetAccessCredentialDisableReason_DISABLED_MAX_USES,
		BACnetAccessCredentialDisableReason_DISABLED_INACTIVITY,
		BACnetAccessCredentialDisableReason_DISABLED_MANUAL,
		BACnetAccessCredentialDisableReason_VENDOR_PROPRIETARY_VALUE,
	}
}

func BACnetAccessCredentialDisableReasonByValue(value uint16) (enum BACnetAccessCredentialDisableReason, ok bool) {
	switch value {
	case 0:
		return BACnetAccessCredentialDisableReason_DISABLED, true
	case 0xFFFF:
		return BACnetAccessCredentialDisableReason_VENDOR_PROPRIETARY_VALUE, true
	case 1:
		return BACnetAccessCredentialDisableReason_DISABLED_NEEDS_PROVISIONING, true
	case 2:
		return BACnetAccessCredentialDisableReason_DISABLED_UNASSIGNED, true
	case 3:
		return BACnetAccessCredentialDisableReason_DISABLED_NOT_YET_ACTIVE, true
	case 4:
		return BACnetAccessCredentialDisableReason_DISABLED_EXPIRED, true
	case 5:
		return BACnetAccessCredentialDisableReason_DISABLED_LOCKOUT, true
	case 6:
		return BACnetAccessCredentialDisableReason_DISABLED_MAX_DAYS, true
	case 7:
		return BACnetAccessCredentialDisableReason_DISABLED_MAX_USES, true
	case 8:
		return BACnetAccessCredentialDisableReason_DISABLED_INACTIVITY, true
	case 9:
		return BACnetAccessCredentialDisableReason_DISABLED_MANUAL, true
	}
	return 0, false
}

func BACnetAccessCredentialDisableReasonByName(value string) (enum BACnetAccessCredentialDisableReason, ok bool) {
	switch value {
	case "DISABLED":
		return BACnetAccessCredentialDisableReason_DISABLED, true
	case "VENDOR_PROPRIETARY_VALUE":
		return BACnetAccessCredentialDisableReason_VENDOR_PROPRIETARY_VALUE, true
	case "DISABLED_NEEDS_PROVISIONING":
		return BACnetAccessCredentialDisableReason_DISABLED_NEEDS_PROVISIONING, true
	case "DISABLED_UNASSIGNED":
		return BACnetAccessCredentialDisableReason_DISABLED_UNASSIGNED, true
	case "DISABLED_NOT_YET_ACTIVE":
		return BACnetAccessCredentialDisableReason_DISABLED_NOT_YET_ACTIVE, true
	case "DISABLED_EXPIRED":
		return BACnetAccessCredentialDisableReason_DISABLED_EXPIRED, true
	case "DISABLED_LOCKOUT":
		return BACnetAccessCredentialDisableReason_DISABLED_LOCKOUT, true
	case "DISABLED_MAX_DAYS":
		return BACnetAccessCredentialDisableReason_DISABLED_MAX_DAYS, true
	case "DISABLED_MAX_USES":
		return BACnetAccessCredentialDisableReason_DISABLED_MAX_USES, true
	case "DISABLED_INACTIVITY":
		return BACnetAccessCredentialDisableReason_DISABLED_INACTIVITY, true
	case "DISABLED_MANUAL":
		return BACnetAccessCredentialDisableReason_DISABLED_MANUAL, true
	}
	return 0, false
}

func BACnetAccessCredentialDisableReasonKnows(value uint16) bool {
	for _, typeValue := range BACnetAccessCredentialDisableReasonValues {
		if uint16(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetAccessCredentialDisableReason(structType any) BACnetAccessCredentialDisableReason {
	castFunc := func(typ any) BACnetAccessCredentialDisableReason {
		if sBACnetAccessCredentialDisableReason, ok := typ.(BACnetAccessCredentialDisableReason); ok {
			return sBACnetAccessCredentialDisableReason
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetAccessCredentialDisableReason) GetLengthInBits(ctx context.Context) uint16 {
	return 16
}

func (m BACnetAccessCredentialDisableReason) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAccessCredentialDisableReasonParse(ctx context.Context, theBytes []byte) (BACnetAccessCredentialDisableReason, error) {
	return BACnetAccessCredentialDisableReasonParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAccessCredentialDisableReasonParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAccessCredentialDisableReason, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := readBuffer.ReadUint16("BACnetAccessCredentialDisableReason", 16)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetAccessCredentialDisableReason")
	}
	if enum, ok := BACnetAccessCredentialDisableReasonByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for BACnetAccessCredentialDisableReason")
		return BACnetAccessCredentialDisableReason(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetAccessCredentialDisableReason) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e BACnetAccessCredentialDisableReason) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return writeBuffer.WriteUint16("BACnetAccessCredentialDisableReason", 16, uint16(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetAccessCredentialDisableReason) PLC4XEnumName() string {
	switch e {
	case BACnetAccessCredentialDisableReason_DISABLED:
		return "DISABLED"
	case BACnetAccessCredentialDisableReason_VENDOR_PROPRIETARY_VALUE:
		return "VENDOR_PROPRIETARY_VALUE"
	case BACnetAccessCredentialDisableReason_DISABLED_NEEDS_PROVISIONING:
		return "DISABLED_NEEDS_PROVISIONING"
	case BACnetAccessCredentialDisableReason_DISABLED_UNASSIGNED:
		return "DISABLED_UNASSIGNED"
	case BACnetAccessCredentialDisableReason_DISABLED_NOT_YET_ACTIVE:
		return "DISABLED_NOT_YET_ACTIVE"
	case BACnetAccessCredentialDisableReason_DISABLED_EXPIRED:
		return "DISABLED_EXPIRED"
	case BACnetAccessCredentialDisableReason_DISABLED_LOCKOUT:
		return "DISABLED_LOCKOUT"
	case BACnetAccessCredentialDisableReason_DISABLED_MAX_DAYS:
		return "DISABLED_MAX_DAYS"
	case BACnetAccessCredentialDisableReason_DISABLED_MAX_USES:
		return "DISABLED_MAX_USES"
	case BACnetAccessCredentialDisableReason_DISABLED_INACTIVITY:
		return "DISABLED_INACTIVITY"
	case BACnetAccessCredentialDisableReason_DISABLED_MANUAL:
		return "DISABLED_MANUAL"
	}
	return fmt.Sprintf("Unknown(%v)", uint16(e))
}

func (e BACnetAccessCredentialDisableReason) String() string {
	return e.PLC4XEnumName()
}
