/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/apache/plc4x/plc4go/protocols/bacnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type BacnetipParserHelper struct {
}

func (m BacnetipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "BACnetAuthenticationStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthenticationStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftGroupModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftGroupModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetValueSource":
		return model.BACnetValueSourceParseWithBuffer(context.Background(), io)
	case "NLMUpdateKeyUpdateKeyEntry":
		return model.NLMUpdateKeyUpdateKeyEntryParseWithBuffer(context.Background(), io)
	case "BACnetOpeningTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetOpeningTagParseWithBuffer(context.Background(), io, tagNumberArgument)
	case "BACnetPriorityArray":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		tagNumber, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetPriorityArrayParseWithBuffer(context.Background(), io, objectTypeArgument, tagNumber, arrayIndexArgument)
	case "BACnetNameValue":
		return model.BACnetNameValueParseWithBuffer(context.Background(), io)
	case "SecurityResponseCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.SecurityResponseCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSpecialEvent":
		return model.BACnetSpecialEventParseWithBuffer(context.Background(), io)
	case "BACnetRouterEntry":
		return model.BACnetRouterEntryParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadReal":
		return model.BACnetTagPayloadRealParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetNotificationParametersExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLoggingTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLoggingTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimeValue":
		return model.BACnetTimeValueParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadOctetString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadOctetStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEscalatorOperationDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorOperationDirectionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "NPDUControl":
		return model.NPDUControlParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultStateListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultStateListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimeStampEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTimeStampEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimerStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetTimerStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDateRangeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDateRangeEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventParameterChangeOfTimerAlarmValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfTimerAlarmValueParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetUnconfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetUnconfirmedServiceRequestParseWithBuffer(context.Background(), io, serviceRequestLength)
	case "BACnetAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAddressEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetObjectTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetObjectTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDaysOfWeekTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDaysOfWeekTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetReadAccessResultListOfResults":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetReadAccessResultListOfResultsParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetRouterEntryStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRouterEntryStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessRuleTimeRangeSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessRuleTimeRangeSpecifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetObjectTypesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetObjectTypesSupportedTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BVLCBroadcastDistributionTableEntry":
		return model.BVLCBroadcastDistributionTableEntryParseWithBuffer(context.Background(), io)
	case "BACnetBackupStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBackupStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDestination":
		return model.BACnetDestinationParseWithBuffer(context.Background(), io)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDeviceStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDeviceStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPrescale":
		return model.BACnetPrescaleParseWithBuffer(context.Background(), io)
	case "ErrorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ErrorEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationPolicyListEntry":
		return model.BACnetAuthenticationPolicyListEntryParseWithBuffer(context.Background(), io)
	case "APDU":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.APDUParseWithBuffer(context.Background(), io, apduLength)
	case "BACnetEventNotificationSubscription":
		return model.BACnetEventNotificationSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetSegmentationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSegmentationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSecurityKeySet":
		return model.BACnetSecurityKeySetParseWithBuffer(context.Background(), io)
	case "BACnetNetworkSecurityPolicy":
		return model.BACnetNetworkSecurityPolicyParseWithBuffer(context.Background(), io)
	case "BACnetHostNPortEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetHostNPortEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPropertyIdentifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetPropertyIdentifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRecipientEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRecipientEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestParseWithBuffer(context.Background(), io, serviceRequestLength)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadUnsignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadUnsignedIntegerParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetAccessUserTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessUserTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRestartReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRestartReasonTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadBitString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadBitStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetClientCOV":
		return model.BACnetClientCOVParseWithBuffer(context.Background(), io)
	case "BACnetSetpointReference":
		return model.BACnetSetpointReferenceParseWithBuffer(context.Background(), io)
	case "BACnetObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEscalatorFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorFaultTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagHeader":
		return model.BACnetTagHeaderParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadBoolean":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadBooleanParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetFaultTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetFaultTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "VTCloseErrorListOfVTSessionIdentifiers":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecifications":
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsParseWithBuffer(context.Background(), io)
	case "BACnetIPModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetIPModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccumulatorRecord":
		return model.BACnetAccumulatorRecordParseWithBuffer(context.Background(), io)
	case "BACnetDailySchedule":
		return model.BACnetDailyScheduleParseWithBuffer(context.Background(), io)
	case "BACnetLogDataLogDataEntry":
		return model.BACnetLogDataLogDataEntryParseWithBuffer(context.Background(), io)
	case "BACnetOptionalBinaryPV":
		return model.BACnetOptionalBinaryPVParseWithBuffer(context.Background(), io)
	case "BACnetBDTEntry":
		return model.BACnetBDTEntryParseWithBuffer(context.Background(), io)
	case "BACnetEngineeringUnitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEngineeringUnitsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "ListOfCovNotifications":
		return model.ListOfCovNotificationsParseWithBuffer(context.Background(), io)
	case "BACnetAssignedAccessRights":
		return model.BACnetAssignedAccessRightsParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestCreateObjectObjectSpecifier":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestCreateObjectObjectSpecifierParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationPolicy":
		return model.BACnetAuthenticationPolicyParseWithBuffer(context.Background(), io)
	case "BACnetPropertyAccessResult":
		return model.BACnetPropertyAccessResultParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsListParseWithBuffer(context.Background(), io, tagNumber)
	case "NPDU":
		npduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.NPDUParseWithBuffer(context.Background(), io, npduLength)
	case "BACnetProgramStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorSecuredStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorSecuredStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "ErrorClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.ErrorClassTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSpecialEventListOfTimeValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetSpecialEventListOfTimeValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetFaultParameterFaultOutOfRangeMaxNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultOutOfRangeMaxNormalValueParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAccessRuleLocationSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessRuleLocationSpecifierTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntry":
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntryParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationFactorFormat":
		return model.BACnetAuthenticationFactorFormatParseWithBuffer(context.Background(), io)
	case "BACnetMaintenanceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetMaintenanceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetNotificationParametersChangeOfDiscreteValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersChangeOfDiscreteValueNewValueParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetReadAccessPropertyReadResult":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetReadAccessPropertyReadResultParseWithBuffer(context.Background(), io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetActionCommand":
		return model.BACnetActionCommandParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultExtendedParametersEntry":
		return model.BACnetFaultParameterFaultExtendedParametersEntryParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadDate":
		return model.BACnetTagPayloadDateParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventParameterExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterExtendedParametersParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventParameterAccessEventListOfAccessEvents":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterAccessEventListOfAccessEventsParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetReadAccessProperty":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetReadAccessPropertyParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetLifeSafetyOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyOperationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetWeekNDayTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetWeekNDayTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventTransitionBitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventTransitionBitsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLogDataParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetFaultParameterFaultCharacterStringListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLockStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLockStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPropertyStates":
		return model.BACnetPropertyStatesParseWithBuffer(context.Background(), io)
	case "BACnetReadAccessResult":
		return model.BACnetReadAccessResultParseWithBuffer(context.Background(), io)
	case "BACnetResultFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetResultFlagsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessCredentialDisableReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessCredentialDisableReasonTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLightingInProgressTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingInProgressTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLifeSafetyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetVTSession":
		return model.BACnetVTSessionParseWithBuffer(context.Background(), io)
	case "BACnetEventTimestampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventTimestampsEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSecurityLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSecurityLevelTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLogRecordLogDatumParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDateTimeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDateTimeEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTimerTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetTimerTransitionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogMultipleRecord":
		return model.BACnetLogMultipleRecordParseWithBuffer(context.Background(), io)
	case "BACnetProgramRequestTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramRequestTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDateRange":
		return model.BACnetDateRangeParseWithBuffer(context.Background(), io)
	case "BACnetEventParameter":
		return model.BACnetEventParameterParseWithBuffer(context.Background(), io)
	case "BACnetLiftFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftFaultTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyStatesEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetPropertyStatesEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetGroupChannelValueList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetGroupChannelValueListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetFileAccessMethodTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetFileAccessMethodTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadCharacterString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadCharacterStringParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEventLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventLogRecordLogDatumParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetStatusFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetStatusFlagsTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetNodeTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNodeTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetOptionalCharacterString":
		return model.BACnetOptionalCharacterStringParseWithBuffer(context.Background(), io)
	case "BACnetAddress":
		return model.BACnetAddressParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfLifeSavetyListOfAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReference":
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReferenceParseWithBuffer(context.Background(), io)
	case "BACnetApplicationTag":
		return model.BACnetApplicationTagParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfBitstringListOfBitstringValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetShedLevel":
		return model.BACnetShedLevelParseWithBuffer(context.Background(), io)
	case "BACnetActionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetActionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCredentialAuthenticationFactor":
		return model.BACnetCredentialAuthenticationFactorParseWithBuffer(context.Background(), io)
	case "BACnetAssignedLandingCallsLandingCallsListEntry":
		return model.BACnetAssignedLandingCallsLandingCallsListEntryParseWithBuffer(context.Background(), io)
	case "BACnetPropertyValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPropertyValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetCOVSubscription":
		return model.BACnetCOVSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetFaultParameterFaultLifeSafetyListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultLifeSafetyListOfFaultValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetRelationshipTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRelationshipTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "NLMInitalizeRoutingTablePortMapping":
		return model.NLMInitalizeRoutingTablePortMappingParseWithBuffer(context.Background(), io)
	case "BACnetRecipientProcessEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRecipientProcessEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAccessRule":
		return model.BACnetAccessRuleParseWithBuffer(context.Background(), io)
	case "BACnetHostNPort":
		return model.BACnetHostNPortParseWithBuffer(context.Background(), io)
	case "BACnetShedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetShedStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessEventTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessEventTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServiceAck":
		serviceAckLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetServiceAckParseWithBuffer(context.Background(), io, serviceAckLength)
	case "BACnetAccessCredentialDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessCredentialDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftCarCallList":
		return model.BACnetLiftCarCallListParseWithBuffer(context.Background(), io)
	case "BACnetLightingTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingTransitionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "NLMUpdateKeyUpdateControlFlags":
		return model.NLMUpdateKeyUpdateControlFlagsParseWithBuffer(context.Background(), io)
	case "BACnetAssignedLandingCalls":
		return model.BACnetAssignedLandingCallsParseWithBuffer(context.Background(), io)
	case "BACnetNotifyTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNotifyTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthorizationExemptionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthorizationExemptionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLandingDoorStatusLandingDoorsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthenticationFactorTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthenticationFactorTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAccessAuthenticationFactorDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessAuthenticationFactorDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAuthorizationModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthorizationModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetVendorIdTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetVendorIdTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventTimestamps":
		return model.BACnetEventTimestampsParseWithBuffer(context.Background(), io)
	case "BACnetNameValueCollection":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNameValueCollectionParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadEnumerated":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadEnumeratedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetLimitEnableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLimitEnableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorAlarmStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorAlarmStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServicesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetServicesSupportedTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetWriteStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetWriteStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetRecipientProcess":
		return model.BACnetRecipientProcessParseWithBuffer(context.Background(), io)
	case "BACnetReadAccessSpecification":
		return model.BACnetReadAccessSpecificationParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationPolicyList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAuthenticationPolicyListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLandingDoorStatus":
		return model.BACnetLandingDoorStatusParseWithBuffer(context.Background(), io)
	case "BACnetLiftCarCallListFloorList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLiftCarCallListFloorListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAccessThreatLevel":
		return model.BACnetAccessThreatLevelParseWithBuffer(context.Background(), io)
	case "BACnetCalendarEntryEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCalendarEntryEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetRecipient":
		return model.BACnetRecipientParseWithBuffer(context.Background(), io)
	case "BACnetLiftCarDriveStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDriveStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetUnconfirmedServiceRequestWhoHasObject":
		return model.BACnetUnconfirmedServiceRequestWhoHasObjectParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadSignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadSignedIntegerParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetSecurityPolicyTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSecurityPolicyTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord":
		return model.BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordParseWithBuffer(context.Background(), io)
	case "BVLC":
		return model.BVLCParseWithBuffer(context.Background(), io)
	case "ConfirmedEventNotificationRequest":
		return model.ConfirmedEventNotificationRequestParseWithBuffer(context.Background(), io)
	case "BACnetLandingDoorStatusLandingDoorsListEntry":
		return model.BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(context.Background(), io)
	case "BACnetLiftCarDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDirectionTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestConfirmedTextMessageMessageClassParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAddressBinding":
		return model.BACnetAddressBindingParseWithBuffer(context.Background(), io)
	case "BACnetLandingCallStatusCommand":
		return model.BACnetLandingCallStatusCommandParseWithBuffer(context.Background(), io)
	case "ListOfCovNotificationsValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.ListOfCovNotificationsValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetLandingCallStatus":
		return model.BACnetLandingCallStatusParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfStateListOfValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfStateListOfValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPortPermission":
		return model.BACnetPortPermissionParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestReadRangeRange":
		return model.BACnetConfirmedServiceRequestReadRangeRangeParseWithBuffer(context.Background(), io)
	case "BACnetError":
		errorChoice, _ := model.BACnetConfirmedServiceChoiceByName(arguments[0])
		return model.BACnetErrorParseWithBuffer(context.Background(), io, errorChoice)
	case "BACnetDeviceObjectReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDeviceObjectReferenceEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetOptionalUnsigned":
		return model.BACnetOptionalUnsignedParseWithBuffer(context.Background(), io)
	case "BACnetHostAddress":
		return model.BACnetHostAddressParseWithBuffer(context.Background(), io)
	case "ListOfCovNotificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ListOfCovNotificationsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventSummariesList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventSummariesListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetVTClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetVTClassTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReference":
		return model.BACnetDeviceObjectPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetProcessIdSelection":
		return model.BACnetProcessIdSelectionParseWithBuffer(context.Background(), io)
	case "BACnetAssignedLandingCallsLandingCallsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAssignedLandingCallsLandingCallsListParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetTagPayloadDouble":
		return model.BACnetTagPayloadDoubleParseWithBuffer(context.Background(), io)
	case "BACnetAccumulatorRecordAccumulatorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccumulatorRecordAccumulatorStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTimerStateChangeValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetTimerStateChangeValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetSpecialEventPeriod":
		return model.BACnetSpecialEventPeriodParseWithBuffer(context.Background(), io)
	case "BACnetKeyIdentifier":
		return model.BACnetKeyIdentifierParseWithBuffer(context.Background(), io)
	case "BACnetNetworkNumberQualityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkNumberQualityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLogStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLogStatusTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetAbortReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAbortReasonTaggedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetProgramErrorTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramErrorTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "Error":
		return model.ErrorParseWithBuffer(context.Background(), io)
	case "BACnetPropertyReference":
		return model.BACnetPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetContextTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		dataType, _ := model.BACnetDataTypeByName(arguments[1])
		return model.BACnetContextTagParseWithBuffer(context.Background(), io, tagNumberArgument, dataType)
	case "BACnetUnconfirmedServiceChoiceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BVLCResultCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BVLCResultCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetFaultParameter":
		return model.BACnetFaultParameterParseWithBuffer(context.Background(), io)
	case "BACnetEventParameterChangeOfValueCivCriteria":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetPriorityValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPriorityValueParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetLogRecord":
		return model.BACnetLogRecordParseWithBuffer(context.Background(), io)
	case "BACnetCalendarEntry":
		return model.BACnetCalendarEntryParseWithBuffer(context.Background(), io)
	case "BACnetAccessPassbackModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessPassbackModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDeviceObjectReference":
		return model.BACnetDeviceObjectReferenceParseWithBuffer(context.Background(), io)
	case "BVLCForeignDeviceTableEntry":
		return model.BVLCForeignDeviceTableEntryParseWithBuffer(context.Background(), io)
	case "NLM":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.NLMParseWithBuffer(context.Background(), io, apduLength)
	case "BACnetWeekNDay":
		return model.BACnetWeekNDayParseWithBuffer(context.Background(), io)
	case "NPDUNetworkPriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.NPDUNetworkPriorityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetReliabilityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetReliabilityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetDoorValueTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorValueTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetScale":
		return model.BACnetScaleParseWithBuffer(context.Background(), io)
	case "BACnetNotificationParametersChangeOfValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersChangeOfValueNewValueParseWithBuffer(context.Background(), io, tagNumber)
	case "ErrorCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.ErrorCodeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BacnetConstants":
		return model.BacnetConstantsParseWithBuffer(context.Background(), io)
	case "BACnetPolarityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetPolarityTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetServiceAckAtomicReadFileStreamOrRecord":
		return model.BACnetServiceAckAtomicReadFileStreamOrRecordParseWithBuffer(context.Background(), io)
	case "BACnetChannelValue":
		return model.BACnetChannelValueParseWithBuffer(context.Background(), io)
	case "BACnetConstructedData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[2])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetConstructedDataParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetEventTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetObjectPropertyReference":
		return model.BACnetObjectPropertyReferenceParseWithBuffer(context.Background(), io)
	case "BACnetBinaryLightingPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBinaryLightingPVTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetOptionalREAL":
		return model.BACnetOptionalREALParseWithBuffer(context.Background(), io)
	case "BACnetTagPayloadTime":
		return model.BACnetTagPayloadTimeParseWithBuffer(context.Background(), io)
	case "BACnetAuthenticationFactorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAuthenticationFactorEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventSummary":
		return model.BACnetEventSummaryParseWithBuffer(context.Background(), io)
	case "BACnetAccessZoneOccupancyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessZoneOccupancyStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetPropertyAccessResultAccessResult":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var propertyArrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetPropertyAccessResultAccessResultParseWithBuffer(context.Background(), io, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
	case "BACnetNetworkPortCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkPortCommandTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetGroupChannelValue":
		return model.BACnetGroupChannelValueParseWithBuffer(context.Background(), io)
	case "BACnetRejectReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRejectReasonTaggedParseWithBuffer(context.Background(), io, actualLength)
	case "BACnetEscalatorModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetTagPayloadObjectIdentifier":
		return model.BACnetTagPayloadObjectIdentifierParseWithBuffer(context.Background(), io)
	case "BACnetPropertyWriteDefinition":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPropertyWriteDefinitionParseWithBuffer(context.Background(), io, objectTypeArgument)
	case "BACnetEventLogRecord":
		return model.BACnetEventLogRecordParseWithBuffer(context.Background(), io)
	case "BACnetBinaryPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBinaryPVTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetEventPriorities":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventPrioritiesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetDateTime":
		return model.BACnetDateTimeParseWithBuffer(context.Background(), io)
	case "BACnetLightingOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingOperationTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetFaultParameterFaultOutOfRangeMinNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultOutOfRangeMinNormalValueParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetEventParameterChangeOfCharacterStringListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfCharacterStringListOfAlarmValuesParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetSecurityKeySetKeyIds":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetSecurityKeySetKeyIdsParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetVMACEntry":
		return model.BACnetVMACEntryParseWithBuffer(context.Background(), io)
	case "BACnetTimeStamp":
		return model.BACnetTimeStampParseWithBuffer(context.Background(), io)
	case "BACnetNotificationParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetNotificationParametersParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetClosingTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetClosingTagParseWithBuffer(context.Background(), io, tagNumberArgument)
	case "BACnetTimeStampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTimeStampsEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry":
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryParseWithBuffer(context.Background(), io)
	case "BACnetHostAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetHostAddressEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetNetworkTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkTypeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetConstructedDataElement":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetConstructedDataElementParseWithBuffer(context.Background(), io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetPropertyValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetPropertyValuesParseWithBuffer(context.Background(), io, tagNumber, objectTypeArgument)
	case "BACnetProtocolLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProtocolLevelTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscription":
		return model.BACnetCOVMultipleSubscriptionParseWithBuffer(context.Background(), io)
	case "BACnetActionList":
		return model.BACnetActionListParseWithBuffer(context.Background(), io)
	case "BACnetLightingCommand":
		return model.BACnetLightingCommandParseWithBuffer(context.Background(), io)
	case "SubscribeCOVPropertyMultipleErrorFirstFailedSubscription":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.SubscribeCOVPropertyMultipleErrorFirstFailedSubscriptionParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetAuthenticationFactor":
		return model.BACnetAuthenticationFactorParseWithBuffer(context.Background(), io)
	case "BACnetWriteAccessSpecification":
		return model.BACnetWriteAccessSpecificationParseWithBuffer(context.Background(), io)
	case "BACnetLightingCommandEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLightingCommandEnclosedParseWithBuffer(context.Background(), io, tagNumber)
	case "BACnetLiftCarDoorCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDoorCommandTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLiftCarModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetSilencedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSilencedStateTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	case "BACnetLifeSafetyModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyModeTaggedParseWithBuffer(context.Background(), io, tagNumber, tagClass)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
