/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by mockery v2.32.4. DO NOT EDIT.

package values

import (
	time "time"

	mock "github.com/stretchr/testify/mock"
)

// MockRawPlcValue is an autogenerated mock type for the RawPlcValue type
type MockRawPlcValue struct {
	mock.Mock
}

type MockRawPlcValue_Expecter struct {
	mock *mock.Mock
}

func (_m *MockRawPlcValue) EXPECT() *MockRawPlcValue_Expecter {
	return &MockRawPlcValue_Expecter{mock: &_m.Mock}
}

// GetBool provides a mock function with given fields:
func (_m *MockRawPlcValue) GetBool() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_GetBool_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBool'
type MockRawPlcValue_GetBool_Call struct {
	*mock.Call
}

// GetBool is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetBool() *MockRawPlcValue_GetBool_Call {
	return &MockRawPlcValue_GetBool_Call{Call: _e.mock.On("GetBool")}
}

func (_c *MockRawPlcValue_GetBool_Call) Run(run func()) *MockRawPlcValue_GetBool_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetBool_Call) Return(_a0 bool) *MockRawPlcValue_GetBool_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetBool_Call) RunAndReturn(run func() bool) *MockRawPlcValue_GetBool_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolArray provides a mock function with given fields:
func (_m *MockRawPlcValue) GetBoolArray() []bool {
	ret := _m.Called()

	var r0 []bool
	if rf, ok := ret.Get(0).(func() []bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]bool)
		}
	}

	return r0
}

// MockRawPlcValue_GetBoolArray_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolArray'
type MockRawPlcValue_GetBoolArray_Call struct {
	*mock.Call
}

// GetBoolArray is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetBoolArray() *MockRawPlcValue_GetBoolArray_Call {
	return &MockRawPlcValue_GetBoolArray_Call{Call: _e.mock.On("GetBoolArray")}
}

func (_c *MockRawPlcValue_GetBoolArray_Call) Run(run func()) *MockRawPlcValue_GetBoolArray_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetBoolArray_Call) Return(_a0 []bool) *MockRawPlcValue_GetBoolArray_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetBoolArray_Call) RunAndReturn(run func() []bool) *MockRawPlcValue_GetBoolArray_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolAt provides a mock function with given fields: index
func (_m *MockRawPlcValue) GetBoolAt(index uint32) bool {
	ret := _m.Called(index)

	var r0 bool
	if rf, ok := ret.Get(0).(func(uint32) bool); ok {
		r0 = rf(index)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_GetBoolAt_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolAt'
type MockRawPlcValue_GetBoolAt_Call struct {
	*mock.Call
}

// GetBoolAt is a helper method to define mock.On call
//   - index uint32
func (_e *MockRawPlcValue_Expecter) GetBoolAt(index interface{}) *MockRawPlcValue_GetBoolAt_Call {
	return &MockRawPlcValue_GetBoolAt_Call{Call: _e.mock.On("GetBoolAt", index)}
}

func (_c *MockRawPlcValue_GetBoolAt_Call) Run(run func(index uint32)) *MockRawPlcValue_GetBoolAt_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint32))
	})
	return _c
}

func (_c *MockRawPlcValue_GetBoolAt_Call) Return(_a0 bool) *MockRawPlcValue_GetBoolAt_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetBoolAt_Call) RunAndReturn(run func(uint32) bool) *MockRawPlcValue_GetBoolAt_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolLength provides a mock function with given fields:
func (_m *MockRawPlcValue) GetBoolLength() uint32 {
	ret := _m.Called()

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockRawPlcValue_GetBoolLength_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolLength'
type MockRawPlcValue_GetBoolLength_Call struct {
	*mock.Call
}

// GetBoolLength is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetBoolLength() *MockRawPlcValue_GetBoolLength_Call {
	return &MockRawPlcValue_GetBoolLength_Call{Call: _e.mock.On("GetBoolLength")}
}

func (_c *MockRawPlcValue_GetBoolLength_Call) Run(run func()) *MockRawPlcValue_GetBoolLength_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetBoolLength_Call) Return(_a0 uint32) *MockRawPlcValue_GetBoolLength_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetBoolLength_Call) RunAndReturn(run func() uint32) *MockRawPlcValue_GetBoolLength_Call {
	_c.Call.Return(run)
	return _c
}

// GetByte provides a mock function with given fields:
func (_m *MockRawPlcValue) GetByte() byte {
	ret := _m.Called()

	var r0 byte
	if rf, ok := ret.Get(0).(func() byte); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(byte)
	}

	return r0
}

// MockRawPlcValue_GetByte_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetByte'
type MockRawPlcValue_GetByte_Call struct {
	*mock.Call
}

// GetByte is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetByte() *MockRawPlcValue_GetByte_Call {
	return &MockRawPlcValue_GetByte_Call{Call: _e.mock.On("GetByte")}
}

func (_c *MockRawPlcValue_GetByte_Call) Run(run func()) *MockRawPlcValue_GetByte_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetByte_Call) Return(_a0 byte) *MockRawPlcValue_GetByte_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetByte_Call) RunAndReturn(run func() byte) *MockRawPlcValue_GetByte_Call {
	_c.Call.Return(run)
	return _c
}

// GetDate provides a mock function with given fields:
func (_m *MockRawPlcValue) GetDate() time.Time {
	ret := _m.Called()

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockRawPlcValue_GetDate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDate'
type MockRawPlcValue_GetDate_Call struct {
	*mock.Call
}

// GetDate is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetDate() *MockRawPlcValue_GetDate_Call {
	return &MockRawPlcValue_GetDate_Call{Call: _e.mock.On("GetDate")}
}

func (_c *MockRawPlcValue_GetDate_Call) Run(run func()) *MockRawPlcValue_GetDate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetDate_Call) Return(_a0 time.Time) *MockRawPlcValue_GetDate_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetDate_Call) RunAndReturn(run func() time.Time) *MockRawPlcValue_GetDate_Call {
	_c.Call.Return(run)
	return _c
}

// GetDateTime provides a mock function with given fields:
func (_m *MockRawPlcValue) GetDateTime() time.Time {
	ret := _m.Called()

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockRawPlcValue_GetDateTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDateTime'
type MockRawPlcValue_GetDateTime_Call struct {
	*mock.Call
}

// GetDateTime is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetDateTime() *MockRawPlcValue_GetDateTime_Call {
	return &MockRawPlcValue_GetDateTime_Call{Call: _e.mock.On("GetDateTime")}
}

func (_c *MockRawPlcValue_GetDateTime_Call) Run(run func()) *MockRawPlcValue_GetDateTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetDateTime_Call) Return(_a0 time.Time) *MockRawPlcValue_GetDateTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetDateTime_Call) RunAndReturn(run func() time.Time) *MockRawPlcValue_GetDateTime_Call {
	_c.Call.Return(run)
	return _c
}

// GetDuration provides a mock function with given fields:
func (_m *MockRawPlcValue) GetDuration() time.Duration {
	ret := _m.Called()

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func() time.Duration); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Duration)
	}

	return r0
}

// MockRawPlcValue_GetDuration_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDuration'
type MockRawPlcValue_GetDuration_Call struct {
	*mock.Call
}

// GetDuration is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetDuration() *MockRawPlcValue_GetDuration_Call {
	return &MockRawPlcValue_GetDuration_Call{Call: _e.mock.On("GetDuration")}
}

func (_c *MockRawPlcValue_GetDuration_Call) Run(run func()) *MockRawPlcValue_GetDuration_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetDuration_Call) Return(_a0 time.Duration) *MockRawPlcValue_GetDuration_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetDuration_Call) RunAndReturn(run func() time.Duration) *MockRawPlcValue_GetDuration_Call {
	_c.Call.Return(run)
	return _c
}

// GetFloat32 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetFloat32() float32 {
	ret := _m.Called()

	var r0 float32
	if rf, ok := ret.Get(0).(func() float32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(float32)
	}

	return r0
}

// MockRawPlcValue_GetFloat32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetFloat32'
type MockRawPlcValue_GetFloat32_Call struct {
	*mock.Call
}

// GetFloat32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetFloat32() *MockRawPlcValue_GetFloat32_Call {
	return &MockRawPlcValue_GetFloat32_Call{Call: _e.mock.On("GetFloat32")}
}

func (_c *MockRawPlcValue_GetFloat32_Call) Run(run func()) *MockRawPlcValue_GetFloat32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetFloat32_Call) Return(_a0 float32) *MockRawPlcValue_GetFloat32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetFloat32_Call) RunAndReturn(run func() float32) *MockRawPlcValue_GetFloat32_Call {
	_c.Call.Return(run)
	return _c
}

// GetFloat64 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetFloat64() float64 {
	ret := _m.Called()

	var r0 float64
	if rf, ok := ret.Get(0).(func() float64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(float64)
	}

	return r0
}

// MockRawPlcValue_GetFloat64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetFloat64'
type MockRawPlcValue_GetFloat64_Call struct {
	*mock.Call
}

// GetFloat64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetFloat64() *MockRawPlcValue_GetFloat64_Call {
	return &MockRawPlcValue_GetFloat64_Call{Call: _e.mock.On("GetFloat64")}
}

func (_c *MockRawPlcValue_GetFloat64_Call) Run(run func()) *MockRawPlcValue_GetFloat64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetFloat64_Call) Return(_a0 float64) *MockRawPlcValue_GetFloat64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetFloat64_Call) RunAndReturn(run func() float64) *MockRawPlcValue_GetFloat64_Call {
	_c.Call.Return(run)
	return _c
}

// GetIndex provides a mock function with given fields: i
func (_m *MockRawPlcValue) GetIndex(i uint32) PlcValue {
	ret := _m.Called(i)

	var r0 PlcValue
	if rf, ok := ret.Get(0).(func(uint32) PlcValue); ok {
		r0 = rf(i)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(PlcValue)
		}
	}

	return r0
}

// MockRawPlcValue_GetIndex_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetIndex'
type MockRawPlcValue_GetIndex_Call struct {
	*mock.Call
}

// GetIndex is a helper method to define mock.On call
//   - i uint32
func (_e *MockRawPlcValue_Expecter) GetIndex(i interface{}) *MockRawPlcValue_GetIndex_Call {
	return &MockRawPlcValue_GetIndex_Call{Call: _e.mock.On("GetIndex", i)}
}

func (_c *MockRawPlcValue_GetIndex_Call) Run(run func(i uint32)) *MockRawPlcValue_GetIndex_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint32))
	})
	return _c
}

func (_c *MockRawPlcValue_GetIndex_Call) Return(_a0 PlcValue) *MockRawPlcValue_GetIndex_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetIndex_Call) RunAndReturn(run func(uint32) PlcValue) *MockRawPlcValue_GetIndex_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt16 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetInt16() int16 {
	ret := _m.Called()

	var r0 int16
	if rf, ok := ret.Get(0).(func() int16); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int16)
	}

	return r0
}

// MockRawPlcValue_GetInt16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt16'
type MockRawPlcValue_GetInt16_Call struct {
	*mock.Call
}

// GetInt16 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetInt16() *MockRawPlcValue_GetInt16_Call {
	return &MockRawPlcValue_GetInt16_Call{Call: _e.mock.On("GetInt16")}
}

func (_c *MockRawPlcValue_GetInt16_Call) Run(run func()) *MockRawPlcValue_GetInt16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetInt16_Call) Return(_a0 int16) *MockRawPlcValue_GetInt16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetInt16_Call) RunAndReturn(run func() int16) *MockRawPlcValue_GetInt16_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt32 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetInt32() int32 {
	ret := _m.Called()

	var r0 int32
	if rf, ok := ret.Get(0).(func() int32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int32)
	}

	return r0
}

// MockRawPlcValue_GetInt32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt32'
type MockRawPlcValue_GetInt32_Call struct {
	*mock.Call
}

// GetInt32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetInt32() *MockRawPlcValue_GetInt32_Call {
	return &MockRawPlcValue_GetInt32_Call{Call: _e.mock.On("GetInt32")}
}

func (_c *MockRawPlcValue_GetInt32_Call) Run(run func()) *MockRawPlcValue_GetInt32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetInt32_Call) Return(_a0 int32) *MockRawPlcValue_GetInt32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetInt32_Call) RunAndReturn(run func() int32) *MockRawPlcValue_GetInt32_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt64 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetInt64() int64 {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// MockRawPlcValue_GetInt64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt64'
type MockRawPlcValue_GetInt64_Call struct {
	*mock.Call
}

// GetInt64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetInt64() *MockRawPlcValue_GetInt64_Call {
	return &MockRawPlcValue_GetInt64_Call{Call: _e.mock.On("GetInt64")}
}

func (_c *MockRawPlcValue_GetInt64_Call) Run(run func()) *MockRawPlcValue_GetInt64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetInt64_Call) Return(_a0 int64) *MockRawPlcValue_GetInt64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetInt64_Call) RunAndReturn(run func() int64) *MockRawPlcValue_GetInt64_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt8 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetInt8() int8 {
	ret := _m.Called()

	var r0 int8
	if rf, ok := ret.Get(0).(func() int8); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int8)
	}

	return r0
}

// MockRawPlcValue_GetInt8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt8'
type MockRawPlcValue_GetInt8_Call struct {
	*mock.Call
}

// GetInt8 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetInt8() *MockRawPlcValue_GetInt8_Call {
	return &MockRawPlcValue_GetInt8_Call{Call: _e.mock.On("GetInt8")}
}

func (_c *MockRawPlcValue_GetInt8_Call) Run(run func()) *MockRawPlcValue_GetInt8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetInt8_Call) Return(_a0 int8) *MockRawPlcValue_GetInt8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetInt8_Call) RunAndReturn(run func() int8) *MockRawPlcValue_GetInt8_Call {
	_c.Call.Return(run)
	return _c
}

// GetKeys provides a mock function with given fields:
func (_m *MockRawPlcValue) GetKeys() []string {
	ret := _m.Called()

	var r0 []string
	if rf, ok := ret.Get(0).(func() []string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	return r0
}

// MockRawPlcValue_GetKeys_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetKeys'
type MockRawPlcValue_GetKeys_Call struct {
	*mock.Call
}

// GetKeys is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetKeys() *MockRawPlcValue_GetKeys_Call {
	return &MockRawPlcValue_GetKeys_Call{Call: _e.mock.On("GetKeys")}
}

func (_c *MockRawPlcValue_GetKeys_Call) Run(run func()) *MockRawPlcValue_GetKeys_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetKeys_Call) Return(_a0 []string) *MockRawPlcValue_GetKeys_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetKeys_Call) RunAndReturn(run func() []string) *MockRawPlcValue_GetKeys_Call {
	_c.Call.Return(run)
	return _c
}

// GetLength provides a mock function with given fields:
func (_m *MockRawPlcValue) GetLength() uint32 {
	ret := _m.Called()

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockRawPlcValue_GetLength_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetLength'
type MockRawPlcValue_GetLength_Call struct {
	*mock.Call
}

// GetLength is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetLength() *MockRawPlcValue_GetLength_Call {
	return &MockRawPlcValue_GetLength_Call{Call: _e.mock.On("GetLength")}
}

func (_c *MockRawPlcValue_GetLength_Call) Run(run func()) *MockRawPlcValue_GetLength_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetLength_Call) Return(_a0 uint32) *MockRawPlcValue_GetLength_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetLength_Call) RunAndReturn(run func() uint32) *MockRawPlcValue_GetLength_Call {
	_c.Call.Return(run)
	return _c
}

// GetList provides a mock function with given fields:
func (_m *MockRawPlcValue) GetList() []PlcValue {
	ret := _m.Called()

	var r0 []PlcValue
	if rf, ok := ret.Get(0).(func() []PlcValue); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]PlcValue)
		}
	}

	return r0
}

// MockRawPlcValue_GetList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetList'
type MockRawPlcValue_GetList_Call struct {
	*mock.Call
}

// GetList is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetList() *MockRawPlcValue_GetList_Call {
	return &MockRawPlcValue_GetList_Call{Call: _e.mock.On("GetList")}
}

func (_c *MockRawPlcValue_GetList_Call) Run(run func()) *MockRawPlcValue_GetList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetList_Call) Return(_a0 []PlcValue) *MockRawPlcValue_GetList_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetList_Call) RunAndReturn(run func() []PlcValue) *MockRawPlcValue_GetList_Call {
	_c.Call.Return(run)
	return _c
}

// GetPlcValueType provides a mock function with given fields:
func (_m *MockRawPlcValue) GetPlcValueType() PlcValueType {
	ret := _m.Called()

	var r0 PlcValueType
	if rf, ok := ret.Get(0).(func() PlcValueType); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(PlcValueType)
	}

	return r0
}

// MockRawPlcValue_GetPlcValueType_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPlcValueType'
type MockRawPlcValue_GetPlcValueType_Call struct {
	*mock.Call
}

// GetPlcValueType is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetPlcValueType() *MockRawPlcValue_GetPlcValueType_Call {
	return &MockRawPlcValue_GetPlcValueType_Call{Call: _e.mock.On("GetPlcValueType")}
}

func (_c *MockRawPlcValue_GetPlcValueType_Call) Run(run func()) *MockRawPlcValue_GetPlcValueType_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetPlcValueType_Call) Return(_a0 PlcValueType) *MockRawPlcValue_GetPlcValueType_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetPlcValueType_Call) RunAndReturn(run func() PlcValueType) *MockRawPlcValue_GetPlcValueType_Call {
	_c.Call.Return(run)
	return _c
}

// GetRaw provides a mock function with given fields:
func (_m *MockRawPlcValue) GetRaw() []byte {
	ret := _m.Called()

	var r0 []byte
	if rf, ok := ret.Get(0).(func() []byte); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	return r0
}

// MockRawPlcValue_GetRaw_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRaw'
type MockRawPlcValue_GetRaw_Call struct {
	*mock.Call
}

// GetRaw is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetRaw() *MockRawPlcValue_GetRaw_Call {
	return &MockRawPlcValue_GetRaw_Call{Call: _e.mock.On("GetRaw")}
}

func (_c *MockRawPlcValue_GetRaw_Call) Run(run func()) *MockRawPlcValue_GetRaw_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetRaw_Call) Return(_a0 []byte) *MockRawPlcValue_GetRaw_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetRaw_Call) RunAndReturn(run func() []byte) *MockRawPlcValue_GetRaw_Call {
	_c.Call.Return(run)
	return _c
}

// GetString provides a mock function with given fields:
func (_m *MockRawPlcValue) GetString() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockRawPlcValue_GetString_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetString'
type MockRawPlcValue_GetString_Call struct {
	*mock.Call
}

// GetString is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetString() *MockRawPlcValue_GetString_Call {
	return &MockRawPlcValue_GetString_Call{Call: _e.mock.On("GetString")}
}

func (_c *MockRawPlcValue_GetString_Call) Run(run func()) *MockRawPlcValue_GetString_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetString_Call) Return(_a0 string) *MockRawPlcValue_GetString_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetString_Call) RunAndReturn(run func() string) *MockRawPlcValue_GetString_Call {
	_c.Call.Return(run)
	return _c
}

// GetStruct provides a mock function with given fields:
func (_m *MockRawPlcValue) GetStruct() map[string]PlcValue {
	ret := _m.Called()

	var r0 map[string]PlcValue
	if rf, ok := ret.Get(0).(func() map[string]PlcValue); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]PlcValue)
		}
	}

	return r0
}

// MockRawPlcValue_GetStruct_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetStruct'
type MockRawPlcValue_GetStruct_Call struct {
	*mock.Call
}

// GetStruct is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetStruct() *MockRawPlcValue_GetStruct_Call {
	return &MockRawPlcValue_GetStruct_Call{Call: _e.mock.On("GetStruct")}
}

func (_c *MockRawPlcValue_GetStruct_Call) Run(run func()) *MockRawPlcValue_GetStruct_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetStruct_Call) Return(_a0 map[string]PlcValue) *MockRawPlcValue_GetStruct_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetStruct_Call) RunAndReturn(run func() map[string]PlcValue) *MockRawPlcValue_GetStruct_Call {
	_c.Call.Return(run)
	return _c
}

// GetTime provides a mock function with given fields:
func (_m *MockRawPlcValue) GetTime() time.Time {
	ret := _m.Called()

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockRawPlcValue_GetTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetTime'
type MockRawPlcValue_GetTime_Call struct {
	*mock.Call
}

// GetTime is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetTime() *MockRawPlcValue_GetTime_Call {
	return &MockRawPlcValue_GetTime_Call{Call: _e.mock.On("GetTime")}
}

func (_c *MockRawPlcValue_GetTime_Call) Run(run func()) *MockRawPlcValue_GetTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetTime_Call) Return(_a0 time.Time) *MockRawPlcValue_GetTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetTime_Call) RunAndReturn(run func() time.Time) *MockRawPlcValue_GetTime_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint16 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetUint16() uint16 {
	ret := _m.Called()

	var r0 uint16
	if rf, ok := ret.Get(0).(func() uint16); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint16)
	}

	return r0
}

// MockRawPlcValue_GetUint16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint16'
type MockRawPlcValue_GetUint16_Call struct {
	*mock.Call
}

// GetUint16 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetUint16() *MockRawPlcValue_GetUint16_Call {
	return &MockRawPlcValue_GetUint16_Call{Call: _e.mock.On("GetUint16")}
}

func (_c *MockRawPlcValue_GetUint16_Call) Run(run func()) *MockRawPlcValue_GetUint16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetUint16_Call) Return(_a0 uint16) *MockRawPlcValue_GetUint16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetUint16_Call) RunAndReturn(run func() uint16) *MockRawPlcValue_GetUint16_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint32 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetUint32() uint32 {
	ret := _m.Called()

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockRawPlcValue_GetUint32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint32'
type MockRawPlcValue_GetUint32_Call struct {
	*mock.Call
}

// GetUint32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetUint32() *MockRawPlcValue_GetUint32_Call {
	return &MockRawPlcValue_GetUint32_Call{Call: _e.mock.On("GetUint32")}
}

func (_c *MockRawPlcValue_GetUint32_Call) Run(run func()) *MockRawPlcValue_GetUint32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetUint32_Call) Return(_a0 uint32) *MockRawPlcValue_GetUint32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetUint32_Call) RunAndReturn(run func() uint32) *MockRawPlcValue_GetUint32_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint64 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetUint64() uint64 {
	ret := _m.Called()

	var r0 uint64
	if rf, ok := ret.Get(0).(func() uint64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint64)
	}

	return r0
}

// MockRawPlcValue_GetUint64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint64'
type MockRawPlcValue_GetUint64_Call struct {
	*mock.Call
}

// GetUint64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetUint64() *MockRawPlcValue_GetUint64_Call {
	return &MockRawPlcValue_GetUint64_Call{Call: _e.mock.On("GetUint64")}
}

func (_c *MockRawPlcValue_GetUint64_Call) Run(run func()) *MockRawPlcValue_GetUint64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetUint64_Call) Return(_a0 uint64) *MockRawPlcValue_GetUint64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetUint64_Call) RunAndReturn(run func() uint64) *MockRawPlcValue_GetUint64_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint8 provides a mock function with given fields:
func (_m *MockRawPlcValue) GetUint8() uint8 {
	ret := _m.Called()

	var r0 uint8
	if rf, ok := ret.Get(0).(func() uint8); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint8)
	}

	return r0
}

// MockRawPlcValue_GetUint8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint8'
type MockRawPlcValue_GetUint8_Call struct {
	*mock.Call
}

// GetUint8 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) GetUint8() *MockRawPlcValue_GetUint8_Call {
	return &MockRawPlcValue_GetUint8_Call{Call: _e.mock.On("GetUint8")}
}

func (_c *MockRawPlcValue_GetUint8_Call) Run(run func()) *MockRawPlcValue_GetUint8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_GetUint8_Call) Return(_a0 uint8) *MockRawPlcValue_GetUint8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetUint8_Call) RunAndReturn(run func() uint8) *MockRawPlcValue_GetUint8_Call {
	_c.Call.Return(run)
	return _c
}

// GetValue provides a mock function with given fields: key
func (_m *MockRawPlcValue) GetValue(key string) PlcValue {
	ret := _m.Called(key)

	var r0 PlcValue
	if rf, ok := ret.Get(0).(func(string) PlcValue); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(PlcValue)
		}
	}

	return r0
}

// MockRawPlcValue_GetValue_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetValue'
type MockRawPlcValue_GetValue_Call struct {
	*mock.Call
}

// GetValue is a helper method to define mock.On call
//   - key string
func (_e *MockRawPlcValue_Expecter) GetValue(key interface{}) *MockRawPlcValue_GetValue_Call {
	return &MockRawPlcValue_GetValue_Call{Call: _e.mock.On("GetValue", key)}
}

func (_c *MockRawPlcValue_GetValue_Call) Run(run func(key string)) *MockRawPlcValue_GetValue_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockRawPlcValue_GetValue_Call) Return(_a0 PlcValue) *MockRawPlcValue_GetValue_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_GetValue_Call) RunAndReturn(run func(string) PlcValue) *MockRawPlcValue_GetValue_Call {
	_c.Call.Return(run)
	return _c
}

// HasKey provides a mock function with given fields: key
func (_m *MockRawPlcValue) HasKey(key string) bool {
	ret := _m.Called(key)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(key)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_HasKey_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'HasKey'
type MockRawPlcValue_HasKey_Call struct {
	*mock.Call
}

// HasKey is a helper method to define mock.On call
//   - key string
func (_e *MockRawPlcValue_Expecter) HasKey(key interface{}) *MockRawPlcValue_HasKey_Call {
	return &MockRawPlcValue_HasKey_Call{Call: _e.mock.On("HasKey", key)}
}

func (_c *MockRawPlcValue_HasKey_Call) Run(run func(key string)) *MockRawPlcValue_HasKey_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockRawPlcValue_HasKey_Call) Return(_a0 bool) *MockRawPlcValue_HasKey_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_HasKey_Call) RunAndReturn(run func(string) bool) *MockRawPlcValue_HasKey_Call {
	_c.Call.Return(run)
	return _c
}

// IsBool provides a mock function with given fields:
func (_m *MockRawPlcValue) IsBool() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsBool_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsBool'
type MockRawPlcValue_IsBool_Call struct {
	*mock.Call
}

// IsBool is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsBool() *MockRawPlcValue_IsBool_Call {
	return &MockRawPlcValue_IsBool_Call{Call: _e.mock.On("IsBool")}
}

func (_c *MockRawPlcValue_IsBool_Call) Run(run func()) *MockRawPlcValue_IsBool_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsBool_Call) Return(_a0 bool) *MockRawPlcValue_IsBool_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsBool_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsBool_Call {
	_c.Call.Return(run)
	return _c
}

// IsByte provides a mock function with given fields:
func (_m *MockRawPlcValue) IsByte() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsByte_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsByte'
type MockRawPlcValue_IsByte_Call struct {
	*mock.Call
}

// IsByte is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsByte() *MockRawPlcValue_IsByte_Call {
	return &MockRawPlcValue_IsByte_Call{Call: _e.mock.On("IsByte")}
}

func (_c *MockRawPlcValue_IsByte_Call) Run(run func()) *MockRawPlcValue_IsByte_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsByte_Call) Return(_a0 bool) *MockRawPlcValue_IsByte_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsByte_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsByte_Call {
	_c.Call.Return(run)
	return _c
}

// IsDate provides a mock function with given fields:
func (_m *MockRawPlcValue) IsDate() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsDate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDate'
type MockRawPlcValue_IsDate_Call struct {
	*mock.Call
}

// IsDate is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsDate() *MockRawPlcValue_IsDate_Call {
	return &MockRawPlcValue_IsDate_Call{Call: _e.mock.On("IsDate")}
}

func (_c *MockRawPlcValue_IsDate_Call) Run(run func()) *MockRawPlcValue_IsDate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsDate_Call) Return(_a0 bool) *MockRawPlcValue_IsDate_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsDate_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsDate_Call {
	_c.Call.Return(run)
	return _c
}

// IsDateTime provides a mock function with given fields:
func (_m *MockRawPlcValue) IsDateTime() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsDateTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDateTime'
type MockRawPlcValue_IsDateTime_Call struct {
	*mock.Call
}

// IsDateTime is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsDateTime() *MockRawPlcValue_IsDateTime_Call {
	return &MockRawPlcValue_IsDateTime_Call{Call: _e.mock.On("IsDateTime")}
}

func (_c *MockRawPlcValue_IsDateTime_Call) Run(run func()) *MockRawPlcValue_IsDateTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsDateTime_Call) Return(_a0 bool) *MockRawPlcValue_IsDateTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsDateTime_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsDateTime_Call {
	_c.Call.Return(run)
	return _c
}

// IsDuration provides a mock function with given fields:
func (_m *MockRawPlcValue) IsDuration() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsDuration_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDuration'
type MockRawPlcValue_IsDuration_Call struct {
	*mock.Call
}

// IsDuration is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsDuration() *MockRawPlcValue_IsDuration_Call {
	return &MockRawPlcValue_IsDuration_Call{Call: _e.mock.On("IsDuration")}
}

func (_c *MockRawPlcValue_IsDuration_Call) Run(run func()) *MockRawPlcValue_IsDuration_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsDuration_Call) Return(_a0 bool) *MockRawPlcValue_IsDuration_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsDuration_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsDuration_Call {
	_c.Call.Return(run)
	return _c
}

// IsFloat32 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsFloat32() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsFloat32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsFloat32'
type MockRawPlcValue_IsFloat32_Call struct {
	*mock.Call
}

// IsFloat32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsFloat32() *MockRawPlcValue_IsFloat32_Call {
	return &MockRawPlcValue_IsFloat32_Call{Call: _e.mock.On("IsFloat32")}
}

func (_c *MockRawPlcValue_IsFloat32_Call) Run(run func()) *MockRawPlcValue_IsFloat32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsFloat32_Call) Return(_a0 bool) *MockRawPlcValue_IsFloat32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsFloat32_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsFloat32_Call {
	_c.Call.Return(run)
	return _c
}

// IsFloat64 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsFloat64() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsFloat64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsFloat64'
type MockRawPlcValue_IsFloat64_Call struct {
	*mock.Call
}

// IsFloat64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsFloat64() *MockRawPlcValue_IsFloat64_Call {
	return &MockRawPlcValue_IsFloat64_Call{Call: _e.mock.On("IsFloat64")}
}

func (_c *MockRawPlcValue_IsFloat64_Call) Run(run func()) *MockRawPlcValue_IsFloat64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsFloat64_Call) Return(_a0 bool) *MockRawPlcValue_IsFloat64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsFloat64_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsFloat64_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt16 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsInt16() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsInt16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt16'
type MockRawPlcValue_IsInt16_Call struct {
	*mock.Call
}

// IsInt16 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsInt16() *MockRawPlcValue_IsInt16_Call {
	return &MockRawPlcValue_IsInt16_Call{Call: _e.mock.On("IsInt16")}
}

func (_c *MockRawPlcValue_IsInt16_Call) Run(run func()) *MockRawPlcValue_IsInt16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsInt16_Call) Return(_a0 bool) *MockRawPlcValue_IsInt16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsInt16_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsInt16_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt32 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsInt32() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsInt32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt32'
type MockRawPlcValue_IsInt32_Call struct {
	*mock.Call
}

// IsInt32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsInt32() *MockRawPlcValue_IsInt32_Call {
	return &MockRawPlcValue_IsInt32_Call{Call: _e.mock.On("IsInt32")}
}

func (_c *MockRawPlcValue_IsInt32_Call) Run(run func()) *MockRawPlcValue_IsInt32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsInt32_Call) Return(_a0 bool) *MockRawPlcValue_IsInt32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsInt32_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsInt32_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt64 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsInt64() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsInt64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt64'
type MockRawPlcValue_IsInt64_Call struct {
	*mock.Call
}

// IsInt64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsInt64() *MockRawPlcValue_IsInt64_Call {
	return &MockRawPlcValue_IsInt64_Call{Call: _e.mock.On("IsInt64")}
}

func (_c *MockRawPlcValue_IsInt64_Call) Run(run func()) *MockRawPlcValue_IsInt64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsInt64_Call) Return(_a0 bool) *MockRawPlcValue_IsInt64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsInt64_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsInt64_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt8 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsInt8() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsInt8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt8'
type MockRawPlcValue_IsInt8_Call struct {
	*mock.Call
}

// IsInt8 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsInt8() *MockRawPlcValue_IsInt8_Call {
	return &MockRawPlcValue_IsInt8_Call{Call: _e.mock.On("IsInt8")}
}

func (_c *MockRawPlcValue_IsInt8_Call) Run(run func()) *MockRawPlcValue_IsInt8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsInt8_Call) Return(_a0 bool) *MockRawPlcValue_IsInt8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsInt8_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsInt8_Call {
	_c.Call.Return(run)
	return _c
}

// IsList provides a mock function with given fields:
func (_m *MockRawPlcValue) IsList() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsList'
type MockRawPlcValue_IsList_Call struct {
	*mock.Call
}

// IsList is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsList() *MockRawPlcValue_IsList_Call {
	return &MockRawPlcValue_IsList_Call{Call: _e.mock.On("IsList")}
}

func (_c *MockRawPlcValue_IsList_Call) Run(run func()) *MockRawPlcValue_IsList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsList_Call) Return(_a0 bool) *MockRawPlcValue_IsList_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsList_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsList_Call {
	_c.Call.Return(run)
	return _c
}

// IsNull provides a mock function with given fields:
func (_m *MockRawPlcValue) IsNull() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsNull_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsNull'
type MockRawPlcValue_IsNull_Call struct {
	*mock.Call
}

// IsNull is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsNull() *MockRawPlcValue_IsNull_Call {
	return &MockRawPlcValue_IsNull_Call{Call: _e.mock.On("IsNull")}
}

func (_c *MockRawPlcValue_IsNull_Call) Run(run func()) *MockRawPlcValue_IsNull_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsNull_Call) Return(_a0 bool) *MockRawPlcValue_IsNull_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsNull_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsNull_Call {
	_c.Call.Return(run)
	return _c
}

// IsNullable provides a mock function with given fields:
func (_m *MockRawPlcValue) IsNullable() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsNullable_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsNullable'
type MockRawPlcValue_IsNullable_Call struct {
	*mock.Call
}

// IsNullable is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsNullable() *MockRawPlcValue_IsNullable_Call {
	return &MockRawPlcValue_IsNullable_Call{Call: _e.mock.On("IsNullable")}
}

func (_c *MockRawPlcValue_IsNullable_Call) Run(run func()) *MockRawPlcValue_IsNullable_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsNullable_Call) Return(_a0 bool) *MockRawPlcValue_IsNullable_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsNullable_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsNullable_Call {
	_c.Call.Return(run)
	return _c
}

// IsRaw provides a mock function with given fields:
func (_m *MockRawPlcValue) IsRaw() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsRaw_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsRaw'
type MockRawPlcValue_IsRaw_Call struct {
	*mock.Call
}

// IsRaw is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsRaw() *MockRawPlcValue_IsRaw_Call {
	return &MockRawPlcValue_IsRaw_Call{Call: _e.mock.On("IsRaw")}
}

func (_c *MockRawPlcValue_IsRaw_Call) Run(run func()) *MockRawPlcValue_IsRaw_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsRaw_Call) Return(_a0 bool) *MockRawPlcValue_IsRaw_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsRaw_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsRaw_Call {
	_c.Call.Return(run)
	return _c
}

// IsSimple provides a mock function with given fields:
func (_m *MockRawPlcValue) IsSimple() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsSimple_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsSimple'
type MockRawPlcValue_IsSimple_Call struct {
	*mock.Call
}

// IsSimple is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsSimple() *MockRawPlcValue_IsSimple_Call {
	return &MockRawPlcValue_IsSimple_Call{Call: _e.mock.On("IsSimple")}
}

func (_c *MockRawPlcValue_IsSimple_Call) Run(run func()) *MockRawPlcValue_IsSimple_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsSimple_Call) Return(_a0 bool) *MockRawPlcValue_IsSimple_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsSimple_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsSimple_Call {
	_c.Call.Return(run)
	return _c
}

// IsString provides a mock function with given fields:
func (_m *MockRawPlcValue) IsString() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsString_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsString'
type MockRawPlcValue_IsString_Call struct {
	*mock.Call
}

// IsString is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsString() *MockRawPlcValue_IsString_Call {
	return &MockRawPlcValue_IsString_Call{Call: _e.mock.On("IsString")}
}

func (_c *MockRawPlcValue_IsString_Call) Run(run func()) *MockRawPlcValue_IsString_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsString_Call) Return(_a0 bool) *MockRawPlcValue_IsString_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsString_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsString_Call {
	_c.Call.Return(run)
	return _c
}

// IsStruct provides a mock function with given fields:
func (_m *MockRawPlcValue) IsStruct() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsStruct_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsStruct'
type MockRawPlcValue_IsStruct_Call struct {
	*mock.Call
}

// IsStruct is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsStruct() *MockRawPlcValue_IsStruct_Call {
	return &MockRawPlcValue_IsStruct_Call{Call: _e.mock.On("IsStruct")}
}

func (_c *MockRawPlcValue_IsStruct_Call) Run(run func()) *MockRawPlcValue_IsStruct_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsStruct_Call) Return(_a0 bool) *MockRawPlcValue_IsStruct_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsStruct_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsStruct_Call {
	_c.Call.Return(run)
	return _c
}

// IsTime provides a mock function with given fields:
func (_m *MockRawPlcValue) IsTime() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsTime'
type MockRawPlcValue_IsTime_Call struct {
	*mock.Call
}

// IsTime is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsTime() *MockRawPlcValue_IsTime_Call {
	return &MockRawPlcValue_IsTime_Call{Call: _e.mock.On("IsTime")}
}

func (_c *MockRawPlcValue_IsTime_Call) Run(run func()) *MockRawPlcValue_IsTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsTime_Call) Return(_a0 bool) *MockRawPlcValue_IsTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsTime_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsTime_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint16 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsUint16() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsUint16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint16'
type MockRawPlcValue_IsUint16_Call struct {
	*mock.Call
}

// IsUint16 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsUint16() *MockRawPlcValue_IsUint16_Call {
	return &MockRawPlcValue_IsUint16_Call{Call: _e.mock.On("IsUint16")}
}

func (_c *MockRawPlcValue_IsUint16_Call) Run(run func()) *MockRawPlcValue_IsUint16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsUint16_Call) Return(_a0 bool) *MockRawPlcValue_IsUint16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsUint16_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsUint16_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint32 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsUint32() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsUint32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint32'
type MockRawPlcValue_IsUint32_Call struct {
	*mock.Call
}

// IsUint32 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsUint32() *MockRawPlcValue_IsUint32_Call {
	return &MockRawPlcValue_IsUint32_Call{Call: _e.mock.On("IsUint32")}
}

func (_c *MockRawPlcValue_IsUint32_Call) Run(run func()) *MockRawPlcValue_IsUint32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsUint32_Call) Return(_a0 bool) *MockRawPlcValue_IsUint32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsUint32_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsUint32_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint64 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsUint64() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsUint64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint64'
type MockRawPlcValue_IsUint64_Call struct {
	*mock.Call
}

// IsUint64 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsUint64() *MockRawPlcValue_IsUint64_Call {
	return &MockRawPlcValue_IsUint64_Call{Call: _e.mock.On("IsUint64")}
}

func (_c *MockRawPlcValue_IsUint64_Call) Run(run func()) *MockRawPlcValue_IsUint64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsUint64_Call) Return(_a0 bool) *MockRawPlcValue_IsUint64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsUint64_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsUint64_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint8 provides a mock function with given fields:
func (_m *MockRawPlcValue) IsUint8() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_IsUint8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint8'
type MockRawPlcValue_IsUint8_Call struct {
	*mock.Call
}

// IsUint8 is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) IsUint8() *MockRawPlcValue_IsUint8_Call {
	return &MockRawPlcValue_IsUint8_Call{Call: _e.mock.On("IsUint8")}
}

func (_c *MockRawPlcValue_IsUint8_Call) Run(run func()) *MockRawPlcValue_IsUint8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_IsUint8_Call) Return(_a0 bool) *MockRawPlcValue_IsUint8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_IsUint8_Call) RunAndReturn(run func() bool) *MockRawPlcValue_IsUint8_Call {
	_c.Call.Return(run)
	return _c
}

// RawDecodeValue provides a mock function with given fields: typeName
func (_m *MockRawPlcValue) RawDecodeValue(typeName string) PlcValue {
	ret := _m.Called(typeName)

	var r0 PlcValue
	if rf, ok := ret.Get(0).(func(string) PlcValue); ok {
		r0 = rf(typeName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(PlcValue)
		}
	}

	return r0
}

// MockRawPlcValue_RawDecodeValue_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RawDecodeValue'
type MockRawPlcValue_RawDecodeValue_Call struct {
	*mock.Call
}

// RawDecodeValue is a helper method to define mock.On call
//   - typeName string
func (_e *MockRawPlcValue_Expecter) RawDecodeValue(typeName interface{}) *MockRawPlcValue_RawDecodeValue_Call {
	return &MockRawPlcValue_RawDecodeValue_Call{Call: _e.mock.On("RawDecodeValue", typeName)}
}

func (_c *MockRawPlcValue_RawDecodeValue_Call) Run(run func(typeName string)) *MockRawPlcValue_RawDecodeValue_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockRawPlcValue_RawDecodeValue_Call) Return(_a0 PlcValue) *MockRawPlcValue_RawDecodeValue_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_RawDecodeValue_Call) RunAndReturn(run func(string) PlcValue) *MockRawPlcValue_RawDecodeValue_Call {
	_c.Call.Return(run)
	return _c
}

// RawHasMore provides a mock function with given fields:
func (_m *MockRawPlcValue) RawHasMore() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockRawPlcValue_RawHasMore_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RawHasMore'
type MockRawPlcValue_RawHasMore_Call struct {
	*mock.Call
}

// RawHasMore is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) RawHasMore() *MockRawPlcValue_RawHasMore_Call {
	return &MockRawPlcValue_RawHasMore_Call{Call: _e.mock.On("RawHasMore")}
}

func (_c *MockRawPlcValue_RawHasMore_Call) Run(run func()) *MockRawPlcValue_RawHasMore_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_RawHasMore_Call) Return(_a0 bool) *MockRawPlcValue_RawHasMore_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_RawHasMore_Call) RunAndReturn(run func() bool) *MockRawPlcValue_RawHasMore_Call {
	_c.Call.Return(run)
	return _c
}

// RawReset provides a mock function with given fields:
func (_m *MockRawPlcValue) RawReset() {
	_m.Called()
}

// MockRawPlcValue_RawReset_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RawReset'
type MockRawPlcValue_RawReset_Call struct {
	*mock.Call
}

// RawReset is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) RawReset() *MockRawPlcValue_RawReset_Call {
	return &MockRawPlcValue_RawReset_Call{Call: _e.mock.On("RawReset")}
}

func (_c *MockRawPlcValue_RawReset_Call) Run(run func()) *MockRawPlcValue_RawReset_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_RawReset_Call) Return() *MockRawPlcValue_RawReset_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockRawPlcValue_RawReset_Call) RunAndReturn(run func()) *MockRawPlcValue_RawReset_Call {
	_c.Call.Return(run)
	return _c
}

// String provides a mock function with given fields:
func (_m *MockRawPlcValue) String() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockRawPlcValue_String_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'String'
type MockRawPlcValue_String_Call struct {
	*mock.Call
}

// String is a helper method to define mock.On call
func (_e *MockRawPlcValue_Expecter) String() *MockRawPlcValue_String_Call {
	return &MockRawPlcValue_String_Call{Call: _e.mock.On("String")}
}

func (_c *MockRawPlcValue_String_Call) Run(run func()) *MockRawPlcValue_String_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockRawPlcValue_String_Call) Return(_a0 string) *MockRawPlcValue_String_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockRawPlcValue_String_Call) RunAndReturn(run func() string) *MockRawPlcValue_String_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockRawPlcValue creates a new instance of MockRawPlcValue. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockRawPlcValue(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockRawPlcValue {
	mock := &MockRawPlcValue{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
