/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by "plc4xgenerator -type=IOCB"; DO NOT EDIT.

package bacnetip

import (
	"context"
	"encoding/binary"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

var _ = fmt.Printf

func (d *IOCB) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := d.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (d *IOCB) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	if err := writeBuffer.PushContext("IOCB"); err != nil {
		return err
	}

	if err := writeBuffer.WriteInt64("ioID", 64, int64(d.ioID)); err != nil {
		return err
	}
	{
		_value := fmt.Sprintf("%v", d.request)

		if err := writeBuffer.WriteString("request", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}
	{
		_value := fmt.Sprintf("%v", d.destination)

		if err := writeBuffer.WriteString("destination", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}
	{
		_value := fmt.Sprintf("%v", d.ioState)

		if err := writeBuffer.WriteString("ioState", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}
	{
		_value := fmt.Sprintf("%v", d.ioResponse)

		if err := writeBuffer.WriteString("ioResponse", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}

	if d.ioError != nil {
		_errString := d.ioError.Error()
		if err := writeBuffer.WriteString("ioError", uint32(len(_errString)*8), "UTF-8", _errString); err != nil {
			return err
		}
	}
	{
		_value := fmt.Sprintf("%v", d.ioController)

		if err := writeBuffer.WriteString("ioController", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}

	if err := writeBuffer.WriteBit("ioCompleteDone", d.ioCompleteDone); err != nil {
		return err
	}
	if err := writeBuffer.PushContext("ioQueue", utils.WithRenderAsList(true)); err != nil {
		return err
	}
	for _, elem := range d.ioQueue {
		_value := fmt.Sprintf("%v", elem)

		if err := writeBuffer.WriteString("ioQueue", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}
	if err := writeBuffer.PopContext("ioQueue", utils.WithRenderAsList(true)); err != nil {
		return err
	}

	_ioTimoutCancel_plx4gen_description := fmt.Sprintf("%d element(s)", len(d.ioTimoutCancel))
	if err := writeBuffer.WriteString("ioTimoutCancel", uint32(len(_ioTimoutCancel_plx4gen_description)*8), "UTF-8", _ioTimoutCancel_plx4gen_description); err != nil {
		return err
	}

	if err := writeBuffer.WriteInt64("priority", 64, int64(d.priority)); err != nil {
		return err
	}
	if err := writeBuffer.PopContext("IOCB"); err != nil {
		return err
	}
	return nil
}

func (d *IOCB) String() string {
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), d); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
