/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class VirtualFieldTest implements Message {

  // Properties.
  protected final short simpleField;

  public VirtualFieldTest(short simpleField) {
    super();
    this.simpleField = simpleField;
  }

  public short getSimpleField() {
    return simpleField;
  }

  public boolean getVirtualBitField() {
    return (boolean) ((getSimpleField()) == (0));
  }

  public byte getVirtualIntField() {
    return (byte) (getSimpleField());
  }

  public short getVirtualUintField() {
    return (short) (getSimpleField());
  }

  public float getVirtualFloatField() {
    return (float) (getSimpleField());
  }

  public double getVirtualDoubleField() {
    return (double) (getSimpleField());
  }

  public String getVirtualStringField() {
    return String.valueOf(getSimpleField());
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("VirtualFieldTest");

    // Simple Field (simpleField)
    writeSimpleField("simpleField", simpleField, writeUnsignedShort(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean virtualBitField = getVirtualBitField();
    writeBuffer.writeVirtual("virtualBitField", virtualBitField);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    byte virtualIntField = getVirtualIntField();
    writeBuffer.writeVirtual("virtualIntField", virtualIntField);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short virtualUintField = getVirtualUintField();
    writeBuffer.writeVirtual("virtualUintField", virtualUintField);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    float virtualFloatField = getVirtualFloatField();
    writeBuffer.writeVirtual("virtualFloatField", virtualFloatField);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    double virtualDoubleField = getVirtualDoubleField();
    writeBuffer.writeVirtual("virtualDoubleField", virtualDoubleField);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    String virtualStringField = getVirtualStringField();
    writeBuffer.writeVirtual("virtualStringField", virtualStringField);

    writeBuffer.popContext("VirtualFieldTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    VirtualFieldTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpleField)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static VirtualFieldTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static VirtualFieldTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("VirtualFieldTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpleField = readSimpleField("simpleField", readUnsignedShort(readBuffer, 8));
    boolean virtualBitField =
        readVirtualField("virtualBitField", boolean.class, (simpleField) == (0));
    byte virtualIntField = readVirtualField("virtualIntField", byte.class, simpleField);
    short virtualUintField = readVirtualField("virtualUintField", short.class, simpleField);
    float virtualFloatField = readVirtualField("virtualFloatField", float.class, simpleField);
    double virtualDoubleField = readVirtualField("virtualDoubleField", double.class, simpleField);
    String virtualStringField = readVirtualField("virtualStringField", String.class, simpleField);

    readBuffer.closeContext("VirtualFieldTest");
    // Create the instance
    VirtualFieldTest _virtualFieldTest;
    _virtualFieldTest = new VirtualFieldTest(simpleField);
    return _virtualFieldTest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof VirtualFieldTest)) {
      return false;
    }
    VirtualFieldTest that = (VirtualFieldTest) o;
    return (getSimpleField() == that.getSimpleField()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSimpleField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
