/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TypeSwitchInTypeSwitchParentTypeChild1Infant5
    extends TypeSwitchInTypeSwitchParentTypeChild1 implements Message {

  // Accessors for discriminator values.
  public Short getChildNumber() {
    return (short) 0x13;
  }

  // Properties.
  protected final short infantSomeField12;

  public TypeSwitchInTypeSwitchParentTypeChild1Infant5(
      short parentFieldHurz, short childFieldLamm, short infantSomeField12) {
    super(parentFieldHurz, childFieldLamm);
    this.infantSomeField12 = infantSomeField12;
  }

  public short getInfantSomeField12() {
    return infantSomeField12;
  }

  @Override
  protected void serializeTypeSwitchInTypeSwitchParentTypeChild1Child(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TypeSwitchInTypeSwitchParentTypeChild1Infant5");

    // Simple Field (infantSomeField12)
    writeSimpleField("infantSomeField12", infantSomeField12, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("TypeSwitchInTypeSwitchParentTypeChild1Infant5");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TypeSwitchInTypeSwitchParentTypeChild1Infant5 _value = this;

    // Simple field (infantSomeField12)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static TypeSwitchInTypeSwitchParentTypeChild1Builder
      staticParseTypeSwitchInTypeSwitchParentTypeChild1Builder(ReadBuffer readBuffer)
          throws ParseException {
    readBuffer.pullContext("TypeSwitchInTypeSwitchParentTypeChild1Infant5");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short infantSomeField12 =
        readSimpleField("infantSomeField12", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("TypeSwitchInTypeSwitchParentTypeChild1Infant5");
    // Create the instance
    return new TypeSwitchInTypeSwitchParentTypeChild1Infant5BuilderImpl(infantSomeField12);
  }

  public static class TypeSwitchInTypeSwitchParentTypeChild1Infant5BuilderImpl
      implements TypeSwitchInTypeSwitchParentTypeChild1
          .TypeSwitchInTypeSwitchParentTypeChild1Builder {
    private final short infantSomeField12;

    public TypeSwitchInTypeSwitchParentTypeChild1Infant5BuilderImpl(short infantSomeField12) {

      this.infantSomeField12 = infantSomeField12;
    }

    public TypeSwitchInTypeSwitchParentTypeChild1Infant5 build(
        short parentFieldHurz, short childFieldLamm) {
      TypeSwitchInTypeSwitchParentTypeChild1Infant5 typeSwitchInTypeSwitchParentTypeChild1Infant5 =
          new TypeSwitchInTypeSwitchParentTypeChild1Infant5(
              parentFieldHurz, childFieldLamm, infantSomeField12);
      return typeSwitchInTypeSwitchParentTypeChild1Infant5;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TypeSwitchInTypeSwitchParentTypeChild1Infant5)) {
      return false;
    }
    TypeSwitchInTypeSwitchParentTypeChild1Infant5 that =
        (TypeSwitchInTypeSwitchParentTypeChild1Infant5) o;
    return (getInfantSomeField12() == that.getInfantSomeField12()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getInfantSomeField12());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
