/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TypeSwitchInTypeSwitchParentTypeChild1Infant4
    extends TypeSwitchInTypeSwitchParentTypeChild1 implements Message {

  // Accessors for discriminator values.
  public Short getChildNumber() {
    return (short) 0x12;
  }

  // Properties.
  protected final short infantSomeField11;

  public TypeSwitchInTypeSwitchParentTypeChild1Infant4(
      short parentFieldHurz, short childFieldLamm, short infantSomeField11) {
    super(parentFieldHurz, childFieldLamm);
    this.infantSomeField11 = infantSomeField11;
  }

  public short getInfantSomeField11() {
    return infantSomeField11;
  }

  @Override
  protected void serializeTypeSwitchInTypeSwitchParentTypeChild1Child(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TypeSwitchInTypeSwitchParentTypeChild1Infant4");

    // Simple Field (infantSomeField11)
    writeSimpleField("infantSomeField11", infantSomeField11, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("TypeSwitchInTypeSwitchParentTypeChild1Infant4");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TypeSwitchInTypeSwitchParentTypeChild1Infant4 _value = this;

    // Simple field (infantSomeField11)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static TypeSwitchInTypeSwitchParentTypeChild1Builder
      staticParseTypeSwitchInTypeSwitchParentTypeChild1Builder(ReadBuffer readBuffer)
          throws ParseException {
    readBuffer.pullContext("TypeSwitchInTypeSwitchParentTypeChild1Infant4");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short infantSomeField11 =
        readSimpleField("infantSomeField11", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("TypeSwitchInTypeSwitchParentTypeChild1Infant4");
    // Create the instance
    return new TypeSwitchInTypeSwitchParentTypeChild1Infant4BuilderImpl(infantSomeField11);
  }

  public static class TypeSwitchInTypeSwitchParentTypeChild1Infant4BuilderImpl
      implements TypeSwitchInTypeSwitchParentTypeChild1
          .TypeSwitchInTypeSwitchParentTypeChild1Builder {
    private final short infantSomeField11;

    public TypeSwitchInTypeSwitchParentTypeChild1Infant4BuilderImpl(short infantSomeField11) {

      this.infantSomeField11 = infantSomeField11;
    }

    public TypeSwitchInTypeSwitchParentTypeChild1Infant4 build(
        short parentFieldHurz, short childFieldLamm) {
      TypeSwitchInTypeSwitchParentTypeChild1Infant4 typeSwitchInTypeSwitchParentTypeChild1Infant4 =
          new TypeSwitchInTypeSwitchParentTypeChild1Infant4(
              parentFieldHurz, childFieldLamm, infantSomeField11);
      return typeSwitchInTypeSwitchParentTypeChild1Infant4;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TypeSwitchInTypeSwitchParentTypeChild1Infant4)) {
      return false;
    }
    TypeSwitchInTypeSwitchParentTypeChild1Infant4 that =
        (TypeSwitchInTypeSwitchParentTypeChild1Infant4) o;
    return (getInfantSomeField11() == that.getInfantSomeField11()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getInfantSomeField11());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
