/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class TypeSwitchInTypeSwitchParentTypeChild1
    extends TypeSwitchInTypeSwitchParentType implements Message {

  // Accessors for discriminator values.
  public Short getTypeNumber() {
    return (short) 0x10;
  }
  // Abstract accessors for discriminator values.
  public abstract Short getChildNumber();

  // Properties.
  protected final short childFieldLamm;

  public TypeSwitchInTypeSwitchParentTypeChild1(short parentFieldHurz, short childFieldLamm) {
    super(parentFieldHurz);
    this.childFieldLamm = childFieldLamm;
  }

  public short getChildFieldLamm() {
    return childFieldLamm;
  }

  protected abstract void serializeTypeSwitchInTypeSwitchParentTypeChild1Child(
      WriteBuffer writeBuffer) throws SerializationException;

  @Override
  protected void serializeTypeSwitchInTypeSwitchParentTypeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TypeSwitchInTypeSwitchParentTypeChild1");

    // Discriminator Field (childNumber) (Used as input to a switch field)
    writeDiscriminatorField("childNumber", getChildNumber(), writeUnsignedShort(writeBuffer, 8));

    // Simple Field (childFieldLamm)
    writeSimpleField("childFieldLamm", childFieldLamm, writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeTypeSwitchInTypeSwitchParentTypeChild1Child(writeBuffer);

    writeBuffer.popContext("TypeSwitchInTypeSwitchParentTypeChild1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TypeSwitchInTypeSwitchParentTypeChild1 _value = this;

    // Discriminator Field (childNumber)
    lengthInBits += 8;

    // Simple field (childFieldLamm)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static TypeSwitchInTypeSwitchParentTypeBuilder
      staticParseTypeSwitchInTypeSwitchParentTypeBuilder(ReadBuffer readBuffer)
          throws ParseException {
    readBuffer.pullContext("TypeSwitchInTypeSwitchParentTypeChild1");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short childNumber = readDiscriminatorField("childNumber", readUnsignedShort(readBuffer, 8));

    short childFieldLamm = readSimpleField("childFieldLamm", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    TypeSwitchInTypeSwitchParentTypeChild1Builder builder = null;
    if (EvaluationHelper.equals(childNumber, (short) 0x11)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild1Infant3
              .staticParseTypeSwitchInTypeSwitchParentTypeChild1Builder(readBuffer);
    } else if (EvaluationHelper.equals(childNumber, (short) 0x12)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild1Infant4
              .staticParseTypeSwitchInTypeSwitchParentTypeChild1Builder(readBuffer);
    } else if (EvaluationHelper.equals(childNumber, (short) 0x13)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild1Infant5
              .staticParseTypeSwitchInTypeSwitchParentTypeChild1Builder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "childNumber="
              + childNumber
              + "]");
    }

    readBuffer.closeContext("TypeSwitchInTypeSwitchParentTypeChild1");
    // Create the instance
    return new TypeSwitchInTypeSwitchParentTypeChild1BuilderImpl(childFieldLamm, builder);
  }

  public interface TypeSwitchInTypeSwitchParentTypeChild1Builder {
    TypeSwitchInTypeSwitchParentTypeChild1 build(short parentFieldHurz, short childFieldLamm);
  }

  public static class TypeSwitchInTypeSwitchParentTypeChild1BuilderImpl
      implements TypeSwitchInTypeSwitchParentType.TypeSwitchInTypeSwitchParentTypeBuilder {
    private final short childFieldLamm;
    private final TypeSwitchInTypeSwitchParentTypeChild1Builder builder;

    public TypeSwitchInTypeSwitchParentTypeChild1BuilderImpl(
        short childFieldLamm, TypeSwitchInTypeSwitchParentTypeChild1Builder builder) {

      this.childFieldLamm = childFieldLamm;
      this.builder = builder;
    }

    public TypeSwitchInTypeSwitchParentTypeChild1 build(short parentFieldHurz) {
      return builder.build(parentFieldHurz, childFieldLamm);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TypeSwitchInTypeSwitchParentTypeChild1)) {
      return false;
    }
    TypeSwitchInTypeSwitchParentTypeChild1 that = (TypeSwitchInTypeSwitchParentTypeChild1) o;
    return (getChildFieldLamm() == that.getChildFieldLamm()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getChildFieldLamm());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
