/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class TypeSwitchInTypeSwitchParentTypeChild0
    extends TypeSwitchInTypeSwitchParentType implements Message {

  // Accessors for discriminator values.
  public Short getTypeNumber() {
    return (short) 0x00;
  }
  // Abstract accessors for discriminator values.
  public abstract Short getChildNumber();

  // Properties.
  protected final short childFieldwolf;

  public TypeSwitchInTypeSwitchParentTypeChild0(short parentFieldHurz, short childFieldwolf) {
    super(parentFieldHurz);
    this.childFieldwolf = childFieldwolf;
  }

  public short getChildFieldwolf() {
    return childFieldwolf;
  }

  protected abstract void serializeTypeSwitchInTypeSwitchParentTypeChild0Child(
      WriteBuffer writeBuffer) throws SerializationException;

  @Override
  protected void serializeTypeSwitchInTypeSwitchParentTypeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TypeSwitchInTypeSwitchParentTypeChild0");

    // Discriminator Field (childNumber) (Used as input to a switch field)
    writeDiscriminatorField("childNumber", getChildNumber(), writeUnsignedShort(writeBuffer, 8));

    // Simple Field (childFieldwolf)
    writeSimpleField("childFieldwolf", childFieldwolf, writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeTypeSwitchInTypeSwitchParentTypeChild0Child(writeBuffer);

    writeBuffer.popContext("TypeSwitchInTypeSwitchParentTypeChild0");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TypeSwitchInTypeSwitchParentTypeChild0 _value = this;

    // Discriminator Field (childNumber)
    lengthInBits += 8;

    // Simple field (childFieldwolf)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static TypeSwitchInTypeSwitchParentTypeBuilder
      staticParseTypeSwitchInTypeSwitchParentTypeBuilder(ReadBuffer readBuffer)
          throws ParseException {
    readBuffer.pullContext("TypeSwitchInTypeSwitchParentTypeChild0");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short childNumber = readDiscriminatorField("childNumber", readUnsignedShort(readBuffer, 8));

    short childFieldwolf = readSimpleField("childFieldwolf", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    TypeSwitchInTypeSwitchParentTypeChild0Builder builder = null;
    if (EvaluationHelper.equals(childNumber, (short) 0x01)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild0Infant0
              .staticParseTypeSwitchInTypeSwitchParentTypeChild0Builder(readBuffer);
    } else if (EvaluationHelper.equals(childNumber, (short) 0x02)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild0Infant1
              .staticParseTypeSwitchInTypeSwitchParentTypeChild0Builder(readBuffer);
    } else if (EvaluationHelper.equals(childNumber, (short) 0x03)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild0Infant2
              .staticParseTypeSwitchInTypeSwitchParentTypeChild0Builder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "childNumber="
              + childNumber
              + "]");
    }

    readBuffer.closeContext("TypeSwitchInTypeSwitchParentTypeChild0");
    // Create the instance
    return new TypeSwitchInTypeSwitchParentTypeChild0BuilderImpl(childFieldwolf, builder);
  }

  public interface TypeSwitchInTypeSwitchParentTypeChild0Builder {
    TypeSwitchInTypeSwitchParentTypeChild0 build(short parentFieldHurz, short childFieldwolf);
  }

  public static class TypeSwitchInTypeSwitchParentTypeChild0BuilderImpl
      implements TypeSwitchInTypeSwitchParentType.TypeSwitchInTypeSwitchParentTypeBuilder {
    private final short childFieldwolf;
    private final TypeSwitchInTypeSwitchParentTypeChild0Builder builder;

    public TypeSwitchInTypeSwitchParentTypeChild0BuilderImpl(
        short childFieldwolf, TypeSwitchInTypeSwitchParentTypeChild0Builder builder) {

      this.childFieldwolf = childFieldwolf;
      this.builder = builder;
    }

    public TypeSwitchInTypeSwitchParentTypeChild0 build(short parentFieldHurz) {
      return builder.build(parentFieldHurz, childFieldwolf);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TypeSwitchInTypeSwitchParentTypeChild0)) {
      return false;
    }
    TypeSwitchInTypeSwitchParentTypeChild0 that = (TypeSwitchInTypeSwitchParentTypeChild0) o;
    return (getChildFieldwolf() == that.getChildFieldwolf()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getChildFieldwolf());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
