/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class TypeSwitchInTypeSwitchParentType implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getTypeNumber();

  // Properties.
  protected final short parentFieldHurz;

  public TypeSwitchInTypeSwitchParentType(short parentFieldHurz) {
    super();
    this.parentFieldHurz = parentFieldHurz;
  }

  public short getParentFieldHurz() {
    return parentFieldHurz;
  }

  protected abstract void serializeTypeSwitchInTypeSwitchParentTypeChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("TypeSwitchInTypeSwitchParentType");

    // Discriminator Field (typeNumber) (Used as input to a switch field)
    writeDiscriminatorField("typeNumber", getTypeNumber(), writeUnsignedShort(writeBuffer, 8));

    // Simple Field (parentFieldHurz)
    writeSimpleField("parentFieldHurz", parentFieldHurz, writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeTypeSwitchInTypeSwitchParentTypeChild(writeBuffer);

    writeBuffer.popContext("TypeSwitchInTypeSwitchParentType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    TypeSwitchInTypeSwitchParentType _value = this;

    // Discriminator Field (typeNumber)
    lengthInBits += 8;

    // Simple field (parentFieldHurz)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static TypeSwitchInTypeSwitchParentType staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static TypeSwitchInTypeSwitchParentType staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("TypeSwitchInTypeSwitchParentType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short typeNumber = readDiscriminatorField("typeNumber", readUnsignedShort(readBuffer, 8));

    short parentFieldHurz = readSimpleField("parentFieldHurz", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    TypeSwitchInTypeSwitchParentTypeBuilder builder = null;
    if (EvaluationHelper.equals(typeNumber, (short) 0x00)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild0.staticParseTypeSwitchInTypeSwitchParentTypeBuilder(
              readBuffer);
    } else if (EvaluationHelper.equals(typeNumber, (short) 0x10)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild1.staticParseTypeSwitchInTypeSwitchParentTypeBuilder(
              readBuffer);
    } else if (EvaluationHelper.equals(typeNumber, (short) 0x20)) {
      builder =
          TypeSwitchInTypeSwitchParentTypeChild2.staticParseTypeSwitchInTypeSwitchParentTypeBuilder(
              readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "typeNumber="
              + typeNumber
              + "]");
    }

    readBuffer.closeContext("TypeSwitchInTypeSwitchParentType");
    // Create the instance
    TypeSwitchInTypeSwitchParentType _typeSwitchInTypeSwitchParentType =
        builder.build(parentFieldHurz);
    return _typeSwitchInTypeSwitchParentType;
  }

  public interface TypeSwitchInTypeSwitchParentTypeBuilder {
    TypeSwitchInTypeSwitchParentType build(short parentFieldHurz);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TypeSwitchInTypeSwitchParentType)) {
      return false;
    }
    TypeSwitchInTypeSwitchParentType that = (TypeSwitchInTypeSwitchParentType) o;
    return (getParentFieldHurz() == that.getParentFieldHurz()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getParentFieldHurz());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
