/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SimpleDiscriminatedTypeC extends SimpleDiscriminatedType implements Message {

  // Accessors for discriminator values.
  public Short getDiscr() {
    return (short) 0x02;
  }

  // Properties.
  protected final short simpC;

  public SimpleDiscriminatedTypeC(short simpC) {
    super();
    this.simpC = simpC;
  }

  public short getSimpC() {
    return simpC;
  }

  @Override
  protected void serializeSimpleDiscriminatedTypeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SimpleDiscriminatedTypeC");

    // Simple Field (simpC)
    writeSimpleField("simpC", simpC, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("SimpleDiscriminatedTypeC");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SimpleDiscriminatedTypeC _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpC)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static SimpleDiscriminatedTypeBuilder staticParseSimpleDiscriminatedTypeBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SimpleDiscriminatedTypeC");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpC = readSimpleField("simpC", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("SimpleDiscriminatedTypeC");
    // Create the instance
    return new SimpleDiscriminatedTypeCBuilderImpl(simpC);
  }

  public static class SimpleDiscriminatedTypeCBuilderImpl
      implements SimpleDiscriminatedType.SimpleDiscriminatedTypeBuilder {
    private final short simpC;

    public SimpleDiscriminatedTypeCBuilderImpl(short simpC) {
      this.simpC = simpC;
    }

    public SimpleDiscriminatedTypeC build() {
      SimpleDiscriminatedTypeC simpleDiscriminatedTypeC = new SimpleDiscriminatedTypeC(simpC);
      return simpleDiscriminatedTypeC;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SimpleDiscriminatedTypeC)) {
      return false;
    }
    SimpleDiscriminatedTypeC that = (SimpleDiscriminatedTypeC) o;
    return (getSimpC() == that.getSimpC()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSimpC());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
