/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OptionalTypeTest implements Message {

  // Properties.
  protected final short simpleField;
  protected final Short optionalField;

  public OptionalTypeTest(short simpleField, Short optionalField) {
    super();
    this.simpleField = simpleField;
    this.optionalField = optionalField;
  }

  public short getSimpleField() {
    return simpleField;
  }

  public Short getOptionalField() {
    return optionalField;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OptionalTypeTest");

    // Simple Field (simpleField)
    writeSimpleField("simpleField", simpleField, writeUnsignedShort(writeBuffer, 8));

    // Optional Field (optionalField) (Can be skipped, if the value is null)
    writeOptionalField("optionalField", optionalField, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("OptionalTypeTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    OptionalTypeTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpleField)
    lengthInBits += 8;

    // Optional Field (optionalField)
    if (optionalField != null) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static OptionalTypeTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static OptionalTypeTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("OptionalTypeTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpleField = readSimpleField("simpleField", readUnsignedShort(readBuffer, 8));

    Short optionalField =
        readOptionalField("optionalField", readUnsignedShort(readBuffer, 8), (simpleField) == (5));

    readBuffer.closeContext("OptionalTypeTest");
    // Create the instance
    OptionalTypeTest _optionalTypeTest;
    _optionalTypeTest = new OptionalTypeTest(simpleField, optionalField);
    return _optionalTypeTest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OptionalTypeTest)) {
      return false;
    }
    OptionalTypeTest that = (OptionalTypeTest) o;
    return (getSimpleField() == that.getSimpleField())
        && (getOptionalField() == that.getOptionalField())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSimpleField(), getOptionalField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
