/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ImplicitTypeTest implements Message {

  // Properties.
  protected final short simpleField;

  public ImplicitTypeTest(short simpleField) {
    super();
    this.simpleField = simpleField;
  }

  public short getSimpleField() {
    return simpleField;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ImplicitTypeTest");

    // Simple Field (simpleField)
    writeSimpleField("simpleField", simpleField, writeUnsignedShort(writeBuffer, 8));

    // Implicit Field (bitField) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    boolean bitField = (boolean) ((getSimpleField()) > (0));
    writeImplicitField("bitField", bitField, writeBoolean(writeBuffer));

    // Implicit Field (intField) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    byte intField = (byte) (getSimpleField());
    writeImplicitField("intField", intField, writeSignedByte(writeBuffer, 8));

    // Implicit Field (uintField) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    short uintField = (short) (getSimpleField());
    writeImplicitField("uintField", uintField, writeUnsignedShort(writeBuffer, 8));

    // Implicit Field (floatField) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    float floatField = (float) (getSimpleField());
    writeImplicitField("floatField", floatField, writeFloat(writeBuffer, 32));

    // Implicit Field (doubleField) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    double doubleField = (double) (getSimpleField());
    writeImplicitField("doubleField", doubleField, writeDouble(writeBuffer, 64));

    // Implicit Field (stringField) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    String stringField = (String) ((((getSimpleField()) > (0)) ? "HELLO TODDY" : "BYE TODDY"));
    writeImplicitField("stringField", stringField, writeString(writeBuffer, 8));

    writeBuffer.popContext("ImplicitTypeTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ImplicitTypeTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpleField)
    lengthInBits += 8;

    // Implicit Field (bitField)
    lengthInBits += 1;

    // Implicit Field (intField)
    lengthInBits += 8;

    // Implicit Field (uintField)
    lengthInBits += 8;

    // Implicit Field (floatField)
    lengthInBits += 32;

    // Implicit Field (doubleField)
    lengthInBits += 64;

    // Implicit Field (stringField)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ImplicitTypeTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static ImplicitTypeTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("ImplicitTypeTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpleField = readSimpleField("simpleField", readUnsignedShort(readBuffer, 8));

    boolean bitField = readImplicitField("bitField", readBoolean(readBuffer));

    byte intField = readImplicitField("intField", readSignedByte(readBuffer, 8));

    short uintField = readImplicitField("uintField", readUnsignedShort(readBuffer, 8));

    float floatField = readImplicitField("floatField", readFloat(readBuffer, 32));

    double doubleField = readImplicitField("doubleField", readDouble(readBuffer, 64));

    String stringField = readImplicitField("stringField", readString(readBuffer, 8));

    readBuffer.closeContext("ImplicitTypeTest");
    // Create the instance
    ImplicitTypeTest _implicitTypeTest;
    _implicitTypeTest = new ImplicitTypeTest(simpleField);
    return _implicitTypeTest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ImplicitTypeTest)) {
      return false;
    }
    ImplicitTypeTest that = (ImplicitTypeTest) o;
    return (getSimpleField() == that.getSimpleField()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSimpleField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
