/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EnumDiscriminatedTypeParameterMultipleA extends EnumDiscriminatedTypeParameterMultiple
    implements Message {

  // Accessors for discriminator values.
  public EnumType getDiscr1() {
    return EnumType.BOOL;
  }

  public EnumTypeInt getDiscr2() {
    return EnumTypeInt.BOOLINT;
  }

  // Properties.
  protected final short simpA;

  public EnumDiscriminatedTypeParameterMultipleA(short simpA) {
    super();
    this.simpA = simpA;
  }

  public short getSimpA() {
    return simpA;
  }

  @Override
  protected void serializeEnumDiscriminatedTypeParameterMultipleChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("EnumDiscriminatedTypeParameterMultipleA");

    // Simple Field (simpA)
    writeSimpleField("simpA", simpA, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("EnumDiscriminatedTypeParameterMultipleA");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    EnumDiscriminatedTypeParameterMultipleA _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpA)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static EnumDiscriminatedTypeParameterMultipleBuilder
      staticParseEnumDiscriminatedTypeParameterMultipleBuilder(
          ReadBuffer readBuffer, EnumType discr1, EnumTypeInt discr2) throws ParseException {
    readBuffer.pullContext("EnumDiscriminatedTypeParameterMultipleA");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpA = readSimpleField("simpA", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("EnumDiscriminatedTypeParameterMultipleA");
    // Create the instance
    return new EnumDiscriminatedTypeParameterMultipleABuilderImpl(simpA);
  }

  public static class EnumDiscriminatedTypeParameterMultipleABuilderImpl
      implements EnumDiscriminatedTypeParameterMultiple
          .EnumDiscriminatedTypeParameterMultipleBuilder {
    private final short simpA;

    public EnumDiscriminatedTypeParameterMultipleABuilderImpl(short simpA) {
      this.simpA = simpA;
    }

    public EnumDiscriminatedTypeParameterMultipleA build() {
      EnumDiscriminatedTypeParameterMultipleA enumDiscriminatedTypeParameterMultipleA =
          new EnumDiscriminatedTypeParameterMultipleA(simpA);
      return enumDiscriminatedTypeParameterMultipleA;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EnumDiscriminatedTypeParameterMultipleA)) {
      return false;
    }
    EnumDiscriminatedTypeParameterMultipleA that = (EnumDiscriminatedTypeParameterMultipleA) o;
    return (getSimpA() == that.getSimpA()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSimpA());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
