/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ConstTypeTest implements Message {

  // Constant values.
  public static final Boolean BITFIELD = true;
  public static final Byte INTFIELD = 100;
  public static final Short UINTFIELD = 100;
  public static final Float FLOATFIELD = 100.0F;
  public static final Double DOUBLEFIELD = 100.0;
  public static final String STRINGFIELD = "HELLO TODDY";

  public ConstTypeTest() {
    super();
  }

  public boolean getBitField() {
    return BITFIELD;
  }

  public byte getIntField() {
    return INTFIELD;
  }

  public short getUintField() {
    return UINTFIELD;
  }

  public float getFloatField() {
    return FLOATFIELD;
  }

  public double getDoubleField() {
    return DOUBLEFIELD;
  }

  public String getStringField() {
    return STRINGFIELD;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ConstTypeTest");

    // Const Field (bitField)
    writeConstField("bitField", BITFIELD, writeBoolean(writeBuffer));

    // Const Field (intField)
    writeConstField("intField", INTFIELD, writeSignedByte(writeBuffer, 8));

    // Const Field (uintField)
    writeConstField("uintField", UINTFIELD, writeUnsignedShort(writeBuffer, 8));

    // Const Field (floatField)
    writeConstField("floatField", FLOATFIELD, writeFloat(writeBuffer, 32));

    // Const Field (doubleField)
    writeConstField("doubleField", DOUBLEFIELD, writeDouble(writeBuffer, 64));

    // Const Field (stringField)
    writeConstField("stringField", STRINGFIELD, writeString(writeBuffer, 8));

    writeBuffer.popContext("ConstTypeTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ConstTypeTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (bitField)
    lengthInBits += 1;

    // Const Field (intField)
    lengthInBits += 8;

    // Const Field (uintField)
    lengthInBits += 8;

    // Const Field (floatField)
    lengthInBits += 32;

    // Const Field (doubleField)
    lengthInBits += 64;

    // Const Field (stringField)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ConstTypeTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static ConstTypeTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("ConstTypeTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean bitField = readConstField("bitField", readBoolean(readBuffer), ConstTypeTest.BITFIELD);

    byte intField =
        readConstField("intField", readSignedByte(readBuffer, 8), ConstTypeTest.INTFIELD);

    short uintField =
        readConstField("uintField", readUnsignedShort(readBuffer, 8), ConstTypeTest.UINTFIELD);

    float floatField =
        readConstField("floatField", readFloat(readBuffer, 32), ConstTypeTest.FLOATFIELD);

    double doubleField =
        readConstField("doubleField", readDouble(readBuffer, 64), ConstTypeTest.DOUBLEFIELD);

    String stringField =
        readConstField("stringField", readString(readBuffer, 8), ConstTypeTest.STRINGFIELD);

    readBuffer.closeContext("ConstTypeTest");
    // Create the instance
    ConstTypeTest _constTypeTest;
    _constTypeTest = new ConstTypeTest();
    return _constTypeTest;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ConstTypeTest)) {
      return false;
    }
    ConstTypeTest that = (ConstTypeTest) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
