/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class AbstractTypeTest implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final short simpleField;

  public AbstractTypeTest(short simpleField) {
    super();
    this.simpleField = simpleField;
  }

  public abstract boolean getAbstractBitField();

  public abstract byte getAbstractIntField();

  public abstract short getAbstractUintField();

  public abstract float getAbstractFloatField();

  public abstract double getAbstractDoubleField();

  public abstract String getAbstractStringField();

  public short getSimpleField() {
    return simpleField;
  }

  protected abstract void serializeAbstractTypeTestChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AbstractTypeTest");

    // Simple Field (simpleField)
    writeSimpleField("simpleField", simpleField, writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeAbstractTypeTestChild(writeBuffer);

    writeBuffer.popContext("AbstractTypeTest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AbstractTypeTest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (simpleField)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static AbstractTypeTest staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static AbstractTypeTest staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AbstractTypeTest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short simpleField = readSimpleField("simpleField", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    AbstractTypeTestBuilder builder = null;
    if (EvaluationHelper.equals(simpleField, (short) 0)) {
      builder = AbstractTypeTestSubType.staticParseAbstractTypeTestBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "simpleField="
              + simpleField
              + "]");
    }

    readBuffer.closeContext("AbstractTypeTest");
    // Create the instance
    AbstractTypeTest _abstractTypeTest = builder.build(simpleField);
    return _abstractTypeTest;
  }

  public interface AbstractTypeTestBuilder {
    AbstractTypeTest build(short simpleField);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AbstractTypeTest)) {
      return false;
    }
    AbstractTypeTest that = (AbstractTypeTest) o;
    return (getSimpleField() == that.getSimpleField()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSimpleField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
