/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Text;
using org.apache.plc4net.api.value;
using org.apache.plc4net.spi.generation;
using org.apache.plc4net.spi.model.values;

// Code generated by code-generation. DO NOT EDIT.

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public class DIBDeviceInfo
    {


        // Properties.
        public byte DescriptionType { get; }
        public KnxMedium KnxMedium { get; }
        public DeviceStatus DeviceStatus { get; }
        public KnxAddress KnxAddress { get; }
        public ProjectInstallationIdentifier ProjectInstallationIdentifier { get; }
        public byte[] KnxNetIpDeviceSerialNumber { get; }
        public IPAddress KnxNetIpDeviceMulticastAddress { get; }
        public MACAddress KnxNetIpDeviceMacAddress { get; }
        public byte[] DeviceFriendlyName { get; }

        public DIBDeviceInfo(byte descriptionType, KnxMedium knxMedium, DeviceStatus deviceStatus, KnxAddress knxAddress, ProjectInstallationIdentifier projectInstallationIdentifier, byte[] knxNetIpDeviceSerialNumber, IPAddress knxNetIpDeviceMulticastAddress, MACAddress knxNetIpDeviceMacAddress, byte[] deviceFriendlyName)
        {
            DescriptionType = descriptionType;
            KnxMedium = knxMedium;
            DeviceStatus = deviceStatus;
            KnxAddress = knxAddress;
            ProjectInstallationIdentifier = projectInstallationIdentifier;
            KnxNetIpDeviceSerialNumber = knxNetIpDeviceSerialNumber;
            KnxNetIpDeviceMulticastAddress = knxNetIpDeviceMulticastAddress;
            KnxNetIpDeviceMacAddress = knxNetIpDeviceMacAddress;
            DeviceFriendlyName = deviceFriendlyName;
        }

    }
}
