/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// CipRRData is the corresponding interface of CipRRData
type CipRRData interface {
	utils.LengthAware
	utils.Serializable
	EipPacket
	// GetExchange returns Exchange (property field)
	GetExchange() CipExchange
}

// CipRRDataExactly can be used when we want exactly this type and not a type which fulfills CipRRData.
// This is useful for switch cases.
type CipRRDataExactly interface {
	CipRRData
	isCipRRData() bool
}

// _CipRRData is the data-structure of this message
type _CipRRData struct {
	*_EipPacket
	Exchange CipExchange

	// Arguments.
	PacketLength uint16
	// Reserved Fields
	reservedField0 *uint32
	reservedField1 *uint16
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CipRRData) GetCommand() uint16 {
	return 0x006F
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CipRRData) InitializeParent(parent EipPacket, sessionHandle uint32, status uint32, senderContext []uint8, options uint32) {
	m.SessionHandle = sessionHandle
	m.Status = status
	m.SenderContext = senderContext
	m.Options = options
}

func (m *_CipRRData) GetParent() EipPacket {
	return m._EipPacket
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CipRRData) GetExchange() CipExchange {
	return m.Exchange
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCipRRData factory function for _CipRRData
func NewCipRRData(exchange CipExchange, sessionHandle uint32, status uint32, senderContext []uint8, options uint32, packetLength uint16) *_CipRRData {
	_result := &_CipRRData{
		Exchange:   exchange,
		_EipPacket: NewEipPacket(sessionHandle, status, senderContext, options),
	}
	_result._EipPacket._EipPacketChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastCipRRData(structType interface{}) CipRRData {
	if casted, ok := structType.(CipRRData); ok {
		return casted
	}
	if casted, ok := structType.(*CipRRData); ok {
		return *casted
	}
	return nil
}

func (m *_CipRRData) GetTypeName() string {
	return "CipRRData"
}

func (m *_CipRRData) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_CipRRData) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Reserved Field (reserved)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 16

	// Simple field (exchange)
	lengthInBits += m.Exchange.GetLengthInBits()

	return lengthInBits
}

func (m *_CipRRData) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func CipRRDataParse(readBuffer utils.ReadBuffer, packetLength uint16) (CipRRData, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CipRRData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CipRRData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var reservedField0 *uint32
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint32("reserved", 32)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of CipRRData")
		}
		if reserved != uint32(0x00000000) {
			Plc4xModelLog.Info().Fields(map[string]interface{}{
				"expected value": uint32(0x00000000),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	var reservedField1 *uint16
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint16("reserved", 16)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of CipRRData")
		}
		if reserved != uint16(0x0000) {
			Plc4xModelLog.Info().Fields(map[string]interface{}{
				"expected value": uint16(0x0000),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField1 = &reserved
		}
	}

	// Simple Field (exchange)
	if pullErr := readBuffer.PullContext("exchange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for exchange")
	}
	_exchange, _exchangeErr := CipExchangeParse(readBuffer, uint16(uint16(packetLength)-uint16(uint16(6))))
	if _exchangeErr != nil {
		return nil, errors.Wrap(_exchangeErr, "Error parsing 'exchange' field of CipRRData")
	}
	exchange := _exchange.(CipExchange)
	if closeErr := readBuffer.CloseContext("exchange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for exchange")
	}

	if closeErr := readBuffer.CloseContext("CipRRData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CipRRData")
	}

	// Create a partially initialized instance
	_child := &_CipRRData{
		_EipPacket:     &_EipPacket{},
		Exchange:       exchange,
		reservedField0: reservedField0,
		reservedField1: reservedField1,
	}
	_child._EipPacket._EipPacketChildRequirements = _child
	return _child, nil
}

func (m *_CipRRData) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CipRRData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CipRRData")
		}

		// Reserved Field (reserved)
		{
			var reserved uint32 = uint32(0x00000000)
			if m.reservedField0 != nil {
				Plc4xModelLog.Info().Fields(map[string]interface{}{
					"expected value": uint32(0x00000000),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField0
			}
			_err := writeBuffer.WriteUint32("reserved", 32, reserved)
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Reserved Field (reserved)
		{
			var reserved uint16 = uint16(0x0000)
			if m.reservedField1 != nil {
				Plc4xModelLog.Info().Fields(map[string]interface{}{
					"expected value": uint16(0x0000),
					"got value":      reserved,
				}).Msg("Overriding reserved field with unexpected value.")
				reserved = *m.reservedField1
			}
			_err := writeBuffer.WriteUint16("reserved", 16, reserved)
			if _err != nil {
				return errors.Wrap(_err, "Error serializing 'reserved' field")
			}
		}

		// Simple Field (exchange)
		if pushErr := writeBuffer.PushContext("exchange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for exchange")
		}
		_exchangeErr := writeBuffer.WriteSerializable(m.GetExchange())
		if popErr := writeBuffer.PopContext("exchange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for exchange")
		}
		if _exchangeErr != nil {
			return errors.Wrap(_exchangeErr, "Error serializing 'exchange' field")
		}

		if popErr := writeBuffer.PopContext("CipRRData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CipRRData")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_CipRRData) GetPacketLength() uint16 {
	return m.PacketLength
}

//
////

func (m *_CipRRData) isCipRRData() bool {
	return true
}

func (m *_CipRRData) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
