/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyCommandType is an enum
type TelephonyCommandType uint8

type ITelephonyCommandType interface {
	NumberOfArguments() uint8
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	TelephonyCommandType_EVENT TelephonyCommandType = 0x00
)

var TelephonyCommandTypeValues []TelephonyCommandType

func init() {
	_ = errors.New
	TelephonyCommandTypeValues = []TelephonyCommandType{
		TelephonyCommandType_EVENT,
	}
}

func (e TelephonyCommandType) NumberOfArguments() uint8 {
	switch e {
	case 0x00:
		{ /* '0x00' */
			return 0xFF
		}
	default:
		{
			return 0
		}
	}
}

func TelephonyCommandTypeFirstEnumForFieldNumberOfArguments(value uint8) (TelephonyCommandType, error) {
	for _, sizeValue := range TelephonyCommandTypeValues {
		if sizeValue.NumberOfArguments() == value {
			return sizeValue, nil
		}
	}
	return 0, errors.Errorf("enum for %v describing NumberOfArguments not found", value)
}
func TelephonyCommandTypeByValue(value uint8) (enum TelephonyCommandType, ok bool) {
	switch value {
	case 0x00:
		return TelephonyCommandType_EVENT, true
	}
	return 0, false
}

func TelephonyCommandTypeByName(value string) (enum TelephonyCommandType, ok bool) {
	switch value {
	case "EVENT":
		return TelephonyCommandType_EVENT, true
	}
	return 0, false
}

func TelephonyCommandTypeKnows(value uint8) bool {
	for _, typeValue := range TelephonyCommandTypeValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastTelephonyCommandType(structType interface{}) TelephonyCommandType {
	castFunc := func(typ interface{}) TelephonyCommandType {
		if sTelephonyCommandType, ok := typ.(TelephonyCommandType); ok {
			return sTelephonyCommandType
		}
		return 0
	}
	return castFunc(structType)
}

func (m TelephonyCommandType) GetLengthInBits() uint16 {
	return 4
}

func (m TelephonyCommandType) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func TelephonyCommandTypeParse(readBuffer utils.ReadBuffer) (TelephonyCommandType, error) {
	val, err := readBuffer.ReadUint8("TelephonyCommandType", 4)
	if err != nil {
		return 0, errors.Wrap(err, "error reading TelephonyCommandType")
	}
	if enum, ok := TelephonyCommandTypeByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return TelephonyCommandType(val), nil
	} else {
		return enum, nil
	}
}

func (e TelephonyCommandType) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("TelephonyCommandType", 4, uint8(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e TelephonyCommandType) PLC4XEnumName() string {
	switch e {
	case TelephonyCommandType_EVENT:
		return "EVENT"
	}
	return ""
}

func (e TelephonyCommandType) String() string {
	return e.PLC4XEnumName()
}
