/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataRoomControlSystem is the corresponding interface of SALDataRoomControlSystem
type SALDataRoomControlSystem interface {
	utils.LengthAware
	utils.Serializable
	SALData
}

// SALDataRoomControlSystemExactly can be used when we want exactly this type and not a type which fulfills SALDataRoomControlSystem.
// This is useful for switch cases.
type SALDataRoomControlSystemExactly interface {
	SALDataRoomControlSystem
	isSALDataRoomControlSystem() bool
}

// _SALDataRoomControlSystem is the data-structure of this message
type _SALDataRoomControlSystem struct {
	*_SALData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataRoomControlSystem) GetApplicationId() ApplicationId {
	return ApplicationId_ROOM_CONTROL_SYSTEM
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataRoomControlSystem) InitializeParent(parent SALData, salData SALData) {
	m.SalData = salData
}

func (m *_SALDataRoomControlSystem) GetParent() SALData {
	return m._SALData
}

// NewSALDataRoomControlSystem factory function for _SALDataRoomControlSystem
func NewSALDataRoomControlSystem(salData SALData) *_SALDataRoomControlSystem {
	_result := &_SALDataRoomControlSystem{
		_SALData: NewSALData(salData),
	}
	_result._SALData._SALDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSALDataRoomControlSystem(structType interface{}) SALDataRoomControlSystem {
	if casted, ok := structType.(SALDataRoomControlSystem); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataRoomControlSystem); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataRoomControlSystem) GetTypeName() string {
	return "SALDataRoomControlSystem"
}

func (m *_SALDataRoomControlSystem) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_SALDataRoomControlSystem) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	return lengthInBits
}

func (m *_SALDataRoomControlSystem) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func SALDataRoomControlSystemParse(readBuffer utils.ReadBuffer, applicationId ApplicationId) (SALDataRoomControlSystem, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataRoomControlSystem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataRoomControlSystem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{"ROOM_CONTROL_SYSTEM Not yet implemented"})
	}

	if closeErr := readBuffer.CloseContext("SALDataRoomControlSystem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataRoomControlSystem")
	}

	// Create a partially initialized instance
	_child := &_SALDataRoomControlSystem{
		_SALData: &_SALData{},
	}
	_child._SALData._SALDataChildRequirements = _child
	return _child, nil
}

func (m *_SALDataRoomControlSystem) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataRoomControlSystem"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataRoomControlSystem")
		}

		if popErr := writeBuffer.PopContext("SALDataRoomControlSystem"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataRoomControlSystem")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_SALDataRoomControlSystem) isSALDataRoomControlSystem() bool {
	return true
}

func (m *_SALDataRoomControlSystem) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
