/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// MediaTransportControlDataRepeatOnOff is the corresponding interface of MediaTransportControlDataRepeatOnOff
type MediaTransportControlDataRepeatOnOff interface {
	utils.LengthAware
	utils.Serializable
	MediaTransportControlData
	// GetRepeatType returns RepeatType (property field)
	GetRepeatType() byte
	// GetIsOff returns IsOff (virtual field)
	GetIsOff() bool
	// GetIsRepeatCurrent returns IsRepeatCurrent (virtual field)
	GetIsRepeatCurrent() bool
	// GetIsRepeatTracks returns IsRepeatTracks (virtual field)
	GetIsRepeatTracks() bool
}

// MediaTransportControlDataRepeatOnOffExactly can be used when we want exactly this type and not a type which fulfills MediaTransportControlDataRepeatOnOff.
// This is useful for switch cases.
type MediaTransportControlDataRepeatOnOffExactly interface {
	MediaTransportControlDataRepeatOnOff
	isMediaTransportControlDataRepeatOnOff() bool
}

// _MediaTransportControlDataRepeatOnOff is the data-structure of this message
type _MediaTransportControlDataRepeatOnOff struct {
	*_MediaTransportControlData
	RepeatType byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MediaTransportControlDataRepeatOnOff) InitializeParent(parent MediaTransportControlData, commandTypeContainer MediaTransportControlCommandTypeContainer, mediaLinkGroup byte) {
	m.CommandTypeContainer = commandTypeContainer
	m.MediaLinkGroup = mediaLinkGroup
}

func (m *_MediaTransportControlDataRepeatOnOff) GetParent() MediaTransportControlData {
	return m._MediaTransportControlData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MediaTransportControlDataRepeatOnOff) GetRepeatType() byte {
	return m.RepeatType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_MediaTransportControlDataRepeatOnOff) GetIsOff() bool {
	return bool(bool((m.GetRepeatType()) == (0x00)))
}

func (m *_MediaTransportControlDataRepeatOnOff) GetIsRepeatCurrent() bool {
	return bool(bool(bool((m.GetRepeatType()) > (0x00))) && bool(bool((m.GetRepeatType()) <= (0xFE))))
}

func (m *_MediaTransportControlDataRepeatOnOff) GetIsRepeatTracks() bool {
	return bool(bool((m.GetRepeatType()) >= (0xFE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewMediaTransportControlDataRepeatOnOff factory function for _MediaTransportControlDataRepeatOnOff
func NewMediaTransportControlDataRepeatOnOff(repeatType byte, commandTypeContainer MediaTransportControlCommandTypeContainer, mediaLinkGroup byte) *_MediaTransportControlDataRepeatOnOff {
	_result := &_MediaTransportControlDataRepeatOnOff{
		RepeatType:                 repeatType,
		_MediaTransportControlData: NewMediaTransportControlData(commandTypeContainer, mediaLinkGroup),
	}
	_result._MediaTransportControlData._MediaTransportControlDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastMediaTransportControlDataRepeatOnOff(structType interface{}) MediaTransportControlDataRepeatOnOff {
	if casted, ok := structType.(MediaTransportControlDataRepeatOnOff); ok {
		return casted
	}
	if casted, ok := structType.(*MediaTransportControlDataRepeatOnOff); ok {
		return *casted
	}
	return nil
}

func (m *_MediaTransportControlDataRepeatOnOff) GetTypeName() string {
	return "MediaTransportControlDataRepeatOnOff"
}

func (m *_MediaTransportControlDataRepeatOnOff) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_MediaTransportControlDataRepeatOnOff) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (repeatType)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_MediaTransportControlDataRepeatOnOff) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func MediaTransportControlDataRepeatOnOffParse(readBuffer utils.ReadBuffer) (MediaTransportControlDataRepeatOnOff, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MediaTransportControlDataRepeatOnOff"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MediaTransportControlDataRepeatOnOff")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (repeatType)
	_repeatType, _repeatTypeErr := readBuffer.ReadByte("repeatType")
	if _repeatTypeErr != nil {
		return nil, errors.Wrap(_repeatTypeErr, "Error parsing 'repeatType' field of MediaTransportControlDataRepeatOnOff")
	}
	repeatType := _repeatType

	// Virtual field
	_isOff := bool((repeatType) == (0x00))
	isOff := bool(_isOff)
	_ = isOff

	// Virtual field
	_isRepeatCurrent := bool(bool((repeatType) > (0x00))) && bool(bool((repeatType) <= (0xFE)))
	isRepeatCurrent := bool(_isRepeatCurrent)
	_ = isRepeatCurrent

	// Virtual field
	_isRepeatTracks := bool((repeatType) >= (0xFE))
	isRepeatTracks := bool(_isRepeatTracks)
	_ = isRepeatTracks

	if closeErr := readBuffer.CloseContext("MediaTransportControlDataRepeatOnOff"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MediaTransportControlDataRepeatOnOff")
	}

	// Create a partially initialized instance
	_child := &_MediaTransportControlDataRepeatOnOff{
		_MediaTransportControlData: &_MediaTransportControlData{},
		RepeatType:                 repeatType,
	}
	_child._MediaTransportControlData._MediaTransportControlDataChildRequirements = _child
	return _child, nil
}

func (m *_MediaTransportControlDataRepeatOnOff) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MediaTransportControlDataRepeatOnOff"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MediaTransportControlDataRepeatOnOff")
		}

		// Simple Field (repeatType)
		repeatType := byte(m.GetRepeatType())
		_repeatTypeErr := writeBuffer.WriteByte("repeatType", (repeatType))
		if _repeatTypeErr != nil {
			return errors.Wrap(_repeatTypeErr, "Error serializing 'repeatType' field")
		}
		// Virtual field
		if _isOffErr := writeBuffer.WriteVirtual("isOff", m.GetIsOff()); _isOffErr != nil {
			return errors.Wrap(_isOffErr, "Error serializing 'isOff' field")
		}
		// Virtual field
		if _isRepeatCurrentErr := writeBuffer.WriteVirtual("isRepeatCurrent", m.GetIsRepeatCurrent()); _isRepeatCurrentErr != nil {
			return errors.Wrap(_isRepeatCurrentErr, "Error serializing 'isRepeatCurrent' field")
		}
		// Virtual field
		if _isRepeatTracksErr := writeBuffer.WriteVirtual("isRepeatTracks", m.GetIsRepeatTracks()); _isRepeatTracksErr != nil {
			return errors.Wrap(_isRepeatTracksErr, "Error serializing 'isRepeatTracks' field")
		}

		if popErr := writeBuffer.PopContext("MediaTransportControlDataRepeatOnOff"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MediaTransportControlDataRepeatOnOff")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_MediaTransportControlDataRepeatOnOff) isMediaTransportControlDataRepeatOnOff() bool {
	return true
}

func (m *_MediaTransportControlDataRepeatOnOff) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
