/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// MediaTransportControlCommandTypeContainer is an enum
type MediaTransportControlCommandTypeContainer uint8

type IMediaTransportControlCommandTypeContainer interface {
	NumBytes() uint8
	CommandType() MediaTransportControlCommandType
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStop                                MediaTransportControlCommandTypeContainer = 0x01
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPlay                                MediaTransportControlCommandTypeContainer = 0x79
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPauseResume                         MediaTransportControlCommandTypeContainer = 0x0A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectCategory                      MediaTransportControlCommandTypeContainer = 0x12
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectSelection                     MediaTransportControlCommandTypeContainer = 0x1B
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectTrack                         MediaTransportControlCommandTypeContainer = 0x25
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandShuffleOnOff                        MediaTransportControlCommandTypeContainer = 0x2A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRepeatOnOff                         MediaTransportControlCommandTypeContainer = 0x32
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousCategory                MediaTransportControlCommandTypeContainer = 0x3A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousSelection               MediaTransportControlCommandTypeContainer = 0x42
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousTrack                   MediaTransportControlCommandTypeContainer = 0x4A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandFastForward                         MediaTransportControlCommandTypeContainer = 0x52
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRewind                              MediaTransportControlCommandTypeContainer = 0x5A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSourcePowerControl                  MediaTransportControlCommandTypeContainer = 0x62
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTotalTracks                         MediaTransportControlCommandTypeContainer = 0x6D
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStatusRequest                       MediaTransportControlCommandTypeContainer = 0x71
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerateCategoriesSelectionsTracks MediaTransportControlCommandTypeContainer = 0x73
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerationSize                     MediaTransportControlCommandTypeContainer = 0x74
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_0Bytes                    MediaTransportControlCommandTypeContainer = 0x80
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_1Bytes                    MediaTransportControlCommandTypeContainer = 0x81
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_2Bytes                    MediaTransportControlCommandTypeContainer = 0x82
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_3Bytes                    MediaTransportControlCommandTypeContainer = 0x83
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_4Bytes                    MediaTransportControlCommandTypeContainer = 0x84
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_5Bytes                    MediaTransportControlCommandTypeContainer = 0x85
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_6Bytes                    MediaTransportControlCommandTypeContainer = 0x86
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_7Bytes                    MediaTransportControlCommandTypeContainer = 0x87
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_8Bytes                    MediaTransportControlCommandTypeContainer = 0x88
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_9Bytes                    MediaTransportControlCommandTypeContainer = 0x89
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_10Bytes                   MediaTransportControlCommandTypeContainer = 0x8A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_11Bytes                   MediaTransportControlCommandTypeContainer = 0x8B
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_12Bytes                   MediaTransportControlCommandTypeContainer = 0x8C
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_13Bytes                   MediaTransportControlCommandTypeContainer = 0x8D
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_14Bytes                   MediaTransportControlCommandTypeContainer = 0x8E
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_15Bytes                   MediaTransportControlCommandTypeContainer = 0x8F
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_16Bytes                   MediaTransportControlCommandTypeContainer = 0x90
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_17Bytes                   MediaTransportControlCommandTypeContainer = 0x91
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_18Bytes                   MediaTransportControlCommandTypeContainer = 0x92
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_19Bytes                   MediaTransportControlCommandTypeContainer = 0x93
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_20Bytes                   MediaTransportControlCommandTypeContainer = 0x94
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_21Bytes                   MediaTransportControlCommandTypeContainer = 0x95
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_22Bytes                   MediaTransportControlCommandTypeContainer = 0x96
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_23Bytes                   MediaTransportControlCommandTypeContainer = 0x97
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_24Bytes                   MediaTransportControlCommandTypeContainer = 0x98
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_25Bytes                   MediaTransportControlCommandTypeContainer = 0x99
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_26Bytes                   MediaTransportControlCommandTypeContainer = 0x9A
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_27Bytes                   MediaTransportControlCommandTypeContainer = 0x9B
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_28Bytes                   MediaTransportControlCommandTypeContainer = 0x9C
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_29Bytes                   MediaTransportControlCommandTypeContainer = 0x9D
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_30Bytes                   MediaTransportControlCommandTypeContainer = 0x9E
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_31Bytes                   MediaTransportControlCommandTypeContainer = 0x9F
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_0Bytes                MediaTransportControlCommandTypeContainer = 0xA0
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_1Bytes                MediaTransportControlCommandTypeContainer = 0xA1
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_2Bytes                MediaTransportControlCommandTypeContainer = 0xA2
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_3Bytes                MediaTransportControlCommandTypeContainer = 0xA3
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_4Bytes                MediaTransportControlCommandTypeContainer = 0xA4
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_5Bytes                MediaTransportControlCommandTypeContainer = 0xA5
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_6Bytes                MediaTransportControlCommandTypeContainer = 0xA6
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_7Bytes                MediaTransportControlCommandTypeContainer = 0xA7
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_8Bytes                MediaTransportControlCommandTypeContainer = 0xA8
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_9Bytes                MediaTransportControlCommandTypeContainer = 0xA9
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_10Bytes               MediaTransportControlCommandTypeContainer = 0xAA
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_11Bytes               MediaTransportControlCommandTypeContainer = 0xAB
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_12Bytes               MediaTransportControlCommandTypeContainer = 0xAC
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_13Bytes               MediaTransportControlCommandTypeContainer = 0xAD
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_14Bytes               MediaTransportControlCommandTypeContainer = 0xAE
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_15Bytes               MediaTransportControlCommandTypeContainer = 0xAF
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_16Bytes               MediaTransportControlCommandTypeContainer = 0xB0
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_17Bytes               MediaTransportControlCommandTypeContainer = 0xB1
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_18Bytes               MediaTransportControlCommandTypeContainer = 0xB2
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_19Bytes               MediaTransportControlCommandTypeContainer = 0xB3
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_20Bytes               MediaTransportControlCommandTypeContainer = 0xB4
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_21Bytes               MediaTransportControlCommandTypeContainer = 0xB5
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_22Bytes               MediaTransportControlCommandTypeContainer = 0xB6
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_23Bytes               MediaTransportControlCommandTypeContainer = 0xB7
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_24Bytes               MediaTransportControlCommandTypeContainer = 0xB8
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_25Bytes               MediaTransportControlCommandTypeContainer = 0xB9
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_26Bytes               MediaTransportControlCommandTypeContainer = 0xBA
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_27Bytes               MediaTransportControlCommandTypeContainer = 0xBB
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_28Bytes               MediaTransportControlCommandTypeContainer = 0xBC
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_29Bytes               MediaTransportControlCommandTypeContainer = 0xBD
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_30Bytes               MediaTransportControlCommandTypeContainer = 0xBE
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_31Bytes               MediaTransportControlCommandTypeContainer = 0xBF
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_0Bytes                 MediaTransportControlCommandTypeContainer = 0xC0
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_1Bytes                 MediaTransportControlCommandTypeContainer = 0xC1
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_2Bytes                 MediaTransportControlCommandTypeContainer = 0xC2
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_3Bytes                 MediaTransportControlCommandTypeContainer = 0xC3
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_4Bytes                 MediaTransportControlCommandTypeContainer = 0xC4
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_5Bytes                 MediaTransportControlCommandTypeContainer = 0xC5
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_6Bytes                 MediaTransportControlCommandTypeContainer = 0xC6
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_7Bytes                 MediaTransportControlCommandTypeContainer = 0xC7
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_8Bytes                 MediaTransportControlCommandTypeContainer = 0xC8
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_9Bytes                 MediaTransportControlCommandTypeContainer = 0xC9
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_10Bytes                MediaTransportControlCommandTypeContainer = 0xCA
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_11Bytes                MediaTransportControlCommandTypeContainer = 0xCB
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_12Bytes                MediaTransportControlCommandTypeContainer = 0xCC
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_13Bytes                MediaTransportControlCommandTypeContainer = 0xCD
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_14Bytes                MediaTransportControlCommandTypeContainer = 0xCE
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_15Bytes                MediaTransportControlCommandTypeContainer = 0xCF
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_16Bytes                MediaTransportControlCommandTypeContainer = 0xD0
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_17Bytes                MediaTransportControlCommandTypeContainer = 0xD1
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_18Bytes                MediaTransportControlCommandTypeContainer = 0xD2
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_19Bytes                MediaTransportControlCommandTypeContainer = 0xD3
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_20Bytes                MediaTransportControlCommandTypeContainer = 0xD4
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_21Bytes                MediaTransportControlCommandTypeContainer = 0xD5
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_22Bytes                MediaTransportControlCommandTypeContainer = 0xD6
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_23Bytes                MediaTransportControlCommandTypeContainer = 0xD7
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_24Bytes                MediaTransportControlCommandTypeContainer = 0xD8
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_25Bytes                MediaTransportControlCommandTypeContainer = 0xD9
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_26Bytes                MediaTransportControlCommandTypeContainer = 0xDA
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_27Bytes                MediaTransportControlCommandTypeContainer = 0xDB
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_28Bytes                MediaTransportControlCommandTypeContainer = 0xDC
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_29Bytes                MediaTransportControlCommandTypeContainer = 0xDD
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_30Bytes                MediaTransportControlCommandTypeContainer = 0xDE
	MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_31Bytes                MediaTransportControlCommandTypeContainer = 0xDF
)

var MediaTransportControlCommandTypeContainerValues []MediaTransportControlCommandTypeContainer

func init() {
	_ = errors.New
	MediaTransportControlCommandTypeContainerValues = []MediaTransportControlCommandTypeContainer{
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStop,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPlay,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPauseResume,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectCategory,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectSelection,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectTrack,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandShuffleOnOff,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRepeatOnOff,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousCategory,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousSelection,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousTrack,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandFastForward,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRewind,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSourcePowerControl,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTotalTracks,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStatusRequest,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerateCategoriesSelectionsTracks,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerationSize,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_0Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_1Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_2Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_3Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_4Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_5Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_6Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_7Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_8Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_9Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_10Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_11Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_12Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_13Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_14Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_15Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_16Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_17Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_18Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_19Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_20Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_21Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_22Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_23Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_24Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_25Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_26Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_27Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_28Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_29Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_30Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_31Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_0Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_1Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_2Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_3Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_4Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_5Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_6Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_7Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_8Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_9Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_10Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_11Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_12Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_13Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_14Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_15Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_16Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_17Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_18Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_19Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_20Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_21Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_22Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_23Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_24Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_25Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_26Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_27Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_28Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_29Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_30Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_31Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_0Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_1Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_2Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_3Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_4Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_5Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_6Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_7Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_8Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_9Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_10Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_11Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_12Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_13Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_14Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_15Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_16Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_17Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_18Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_19Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_20Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_21Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_22Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_23Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_24Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_25Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_26Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_27Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_28Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_29Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_30Bytes,
		MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_31Bytes,
	}
}

func (e MediaTransportControlCommandTypeContainer) NumBytes() uint8 {
	switch e {
	case 0x01:
		{ /* '0x01' */
			return 1
		}
	case 0x0A:
		{ /* '0x0A' */
			return 2
		}
	case 0x12:
		{ /* '0x12' */
			return 2
		}
	case 0x1B:
		{ /* '0x1B' */
			return 3
		}
	case 0x25:
		{ /* '0x25' */
			return 5
		}
	case 0x2A:
		{ /* '0x2A' */
			return 2
		}
	case 0x32:
		{ /* '0x32' */
			return 2
		}
	case 0x3A:
		{ /* '0x3A' */
			return 2
		}
	case 0x42:
		{ /* '0x42' */
			return 2
		}
	case 0x4A:
		{ /* '0x4A' */
			return 2
		}
	case 0x52:
		{ /* '0x52' */
			return 2
		}
	case 0x5A:
		{ /* '0x5A' */
			return 2
		}
	case 0x62:
		{ /* '0x62' */
			return 2
		}
	case 0x6D:
		{ /* '0x6D' */
			return 5
		}
	case 0x71:
		{ /* '0x71' */
			return 1
		}
	case 0x73:
		{ /* '0x73' */
			return 3
		}
	case 0x74:
		{ /* '0x74' */
			return 4
		}
	case 0x79:
		{ /* '0x79' */
			return 1
		}
	case 0x80:
		{ /* '0x80' */
			return 0
		}
	case 0x81:
		{ /* '0x81' */
			return 1
		}
	case 0x82:
		{ /* '0x82' */
			return 2
		}
	case 0x83:
		{ /* '0x83' */
			return 3
		}
	case 0x84:
		{ /* '0x84' */
			return 4
		}
	case 0x85:
		{ /* '0x85' */
			return 5
		}
	case 0x86:
		{ /* '0x86' */
			return 6
		}
	case 0x87:
		{ /* '0x87' */
			return 7
		}
	case 0x88:
		{ /* '0x88' */
			return 8
		}
	case 0x89:
		{ /* '0x89' */
			return 9
		}
	case 0x8A:
		{ /* '0x8A' */
			return 10
		}
	case 0x8B:
		{ /* '0x8B' */
			return 11
		}
	case 0x8C:
		{ /* '0x8C' */
			return 12
		}
	case 0x8D:
		{ /* '0x8D' */
			return 13
		}
	case 0x8E:
		{ /* '0x8E' */
			return 14
		}
	case 0x8F:
		{ /* '0x8F' */
			return 15
		}
	case 0x90:
		{ /* '0x90' */
			return 16
		}
	case 0x91:
		{ /* '0x91' */
			return 17
		}
	case 0x92:
		{ /* '0x92' */
			return 18
		}
	case 0x93:
		{ /* '0x93' */
			return 19
		}
	case 0x94:
		{ /* '0x94' */
			return 20
		}
	case 0x95:
		{ /* '0x95' */
			return 21
		}
	case 0x96:
		{ /* '0x96' */
			return 22
		}
	case 0x97:
		{ /* '0x97' */
			return 23
		}
	case 0x98:
		{ /* '0x98' */
			return 24
		}
	case 0x99:
		{ /* '0x99' */
			return 25
		}
	case 0x9A:
		{ /* '0x9A' */
			return 26
		}
	case 0x9B:
		{ /* '0x9B' */
			return 27
		}
	case 0x9C:
		{ /* '0x9C' */
			return 28
		}
	case 0x9D:
		{ /* '0x9D' */
			return 29
		}
	case 0x9E:
		{ /* '0x9E' */
			return 30
		}
	case 0x9F:
		{ /* '0x9F' */
			return 31
		}
	case 0xA0:
		{ /* '0xA0' */
			return 0
		}
	case 0xA1:
		{ /* '0xA1' */
			return 1
		}
	case 0xA2:
		{ /* '0xA2' */
			return 2
		}
	case 0xA3:
		{ /* '0xA3' */
			return 3
		}
	case 0xA4:
		{ /* '0xA4' */
			return 4
		}
	case 0xA5:
		{ /* '0xA5' */
			return 5
		}
	case 0xA6:
		{ /* '0xA6' */
			return 6
		}
	case 0xA7:
		{ /* '0xA7' */
			return 7
		}
	case 0xA8:
		{ /* '0xA8' */
			return 8
		}
	case 0xA9:
		{ /* '0xA9' */
			return 9
		}
	case 0xAA:
		{ /* '0xAA' */
			return 10
		}
	case 0xAB:
		{ /* '0xAB' */
			return 11
		}
	case 0xAC:
		{ /* '0xAC' */
			return 12
		}
	case 0xAD:
		{ /* '0xAD' */
			return 13
		}
	case 0xAE:
		{ /* '0xAE' */
			return 14
		}
	case 0xAF:
		{ /* '0xAF' */
			return 15
		}
	case 0xB0:
		{ /* '0xB0' */
			return 16
		}
	case 0xB1:
		{ /* '0xB1' */
			return 17
		}
	case 0xB2:
		{ /* '0xB2' */
			return 18
		}
	case 0xB3:
		{ /* '0xB3' */
			return 19
		}
	case 0xB4:
		{ /* '0xB4' */
			return 20
		}
	case 0xB5:
		{ /* '0xB5' */
			return 21
		}
	case 0xB6:
		{ /* '0xB6' */
			return 22
		}
	case 0xB7:
		{ /* '0xB7' */
			return 23
		}
	case 0xB8:
		{ /* '0xB8' */
			return 24
		}
	case 0xB9:
		{ /* '0xB9' */
			return 25
		}
	case 0xBA:
		{ /* '0xBA' */
			return 26
		}
	case 0xBB:
		{ /* '0xBB' */
			return 27
		}
	case 0xBC:
		{ /* '0xBC' */
			return 28
		}
	case 0xBD:
		{ /* '0xBD' */
			return 29
		}
	case 0xBE:
		{ /* '0xBE' */
			return 30
		}
	case 0xBF:
		{ /* '0xBF' */
			return 31
		}
	case 0xC0:
		{ /* '0xC0' */
			return 0
		}
	case 0xC1:
		{ /* '0xC1' */
			return 1
		}
	case 0xC2:
		{ /* '0xC2' */
			return 2
		}
	case 0xC3:
		{ /* '0xC3' */
			return 3
		}
	case 0xC4:
		{ /* '0xC4' */
			return 4
		}
	case 0xC5:
		{ /* '0xC5' */
			return 5
		}
	case 0xC6:
		{ /* '0xC6' */
			return 6
		}
	case 0xC7:
		{ /* '0xC7' */
			return 7
		}
	case 0xC8:
		{ /* '0xC8' */
			return 8
		}
	case 0xC9:
		{ /* '0xC9' */
			return 9
		}
	case 0xCA:
		{ /* '0xCA' */
			return 10
		}
	case 0xCB:
		{ /* '0xCB' */
			return 11
		}
	case 0xCC:
		{ /* '0xCC' */
			return 12
		}
	case 0xCD:
		{ /* '0xCD' */
			return 13
		}
	case 0xCE:
		{ /* '0xCE' */
			return 14
		}
	case 0xCF:
		{ /* '0xCF' */
			return 15
		}
	case 0xD0:
		{ /* '0xD0' */
			return 16
		}
	case 0xD1:
		{ /* '0xD1' */
			return 17
		}
	case 0xD2:
		{ /* '0xD2' */
			return 18
		}
	case 0xD3:
		{ /* '0xD3' */
			return 19
		}
	case 0xD4:
		{ /* '0xD4' */
			return 20
		}
	case 0xD5:
		{ /* '0xD5' */
			return 21
		}
	case 0xD6:
		{ /* '0xD6' */
			return 22
		}
	case 0xD7:
		{ /* '0xD7' */
			return 23
		}
	case 0xD8:
		{ /* '0xD8' */
			return 24
		}
	case 0xD9:
		{ /* '0xD9' */
			return 25
		}
	case 0xDA:
		{ /* '0xDA' */
			return 26
		}
	case 0xDB:
		{ /* '0xDB' */
			return 27
		}
	case 0xDC:
		{ /* '0xDC' */
			return 28
		}
	case 0xDD:
		{ /* '0xDD' */
			return 29
		}
	case 0xDE:
		{ /* '0xDE' */
			return 30
		}
	case 0xDF:
		{ /* '0xDF' */
			return 31
		}
	default:
		{
			return 0
		}
	}
}

func MediaTransportControlCommandTypeContainerFirstEnumForFieldNumBytes(value uint8) (MediaTransportControlCommandTypeContainer, error) {
	for _, sizeValue := range MediaTransportControlCommandTypeContainerValues {
		if sizeValue.NumBytes() == value {
			return sizeValue, nil
		}
	}
	return 0, errors.Errorf("enum for %v describing NumBytes not found", value)
}

func (e MediaTransportControlCommandTypeContainer) CommandType() MediaTransportControlCommandType {
	switch e {
	case 0x01:
		{ /* '0x01' */
			return MediaTransportControlCommandType_STOP
		}
	case 0x0A:
		{ /* '0x0A' */
			return MediaTransportControlCommandType_PAUSE_RESUME
		}
	case 0x12:
		{ /* '0x12' */
			return MediaTransportControlCommandType_SELECT_CATEGORY
		}
	case 0x1B:
		{ /* '0x1B' */
			return MediaTransportControlCommandType_SELECT_SELECTION
		}
	case 0x25:
		{ /* '0x25' */
			return MediaTransportControlCommandType_SELECT_TRACK
		}
	case 0x2A:
		{ /* '0x2A' */
			return MediaTransportControlCommandType_SHUFFLE_ON_OFF
		}
	case 0x32:
		{ /* '0x32' */
			return MediaTransportControlCommandType_REPEAT_ON_OFF
		}
	case 0x3A:
		{ /* '0x3A' */
			return MediaTransportControlCommandType_NEXT_PREVIOUS_CATEGORY
		}
	case 0x42:
		{ /* '0x42' */
			return MediaTransportControlCommandType_NEXT_PREVIOUS_SELECTION
		}
	case 0x4A:
		{ /* '0x4A' */
			return MediaTransportControlCommandType_NEXT_PREVIOUS_TRACK
		}
	case 0x52:
		{ /* '0x52' */
			return MediaTransportControlCommandType_FAST_FORWARD
		}
	case 0x5A:
		{ /* '0x5A' */
			return MediaTransportControlCommandType_REWIND
		}
	case 0x62:
		{ /* '0x62' */
			return MediaTransportControlCommandType_SOURCE_POWER_CONTROL
		}
	case 0x6D:
		{ /* '0x6D' */
			return MediaTransportControlCommandType_TOTAL_TRACKS
		}
	case 0x71:
		{ /* '0x71' */
			return MediaTransportControlCommandType_STATUS_REQUEST
		}
	case 0x73:
		{ /* '0x73' */
			return MediaTransportControlCommandType_ENUMERATE_CATEGORIES_SELECTIONS_TRACKS
		}
	case 0x74:
		{ /* '0x74' */
			return MediaTransportControlCommandType_ENUMERATION_SIZE
		}
	case 0x79:
		{ /* '0x79' */
			return MediaTransportControlCommandType_PLAY
		}
	case 0x80:
		{ /* '0x80' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x81:
		{ /* '0x81' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x82:
		{ /* '0x82' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x83:
		{ /* '0x83' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x84:
		{ /* '0x84' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x85:
		{ /* '0x85' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x86:
		{ /* '0x86' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x87:
		{ /* '0x87' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x88:
		{ /* '0x88' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x89:
		{ /* '0x89' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8A:
		{ /* '0x8A' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8B:
		{ /* '0x8B' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8C:
		{ /* '0x8C' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8D:
		{ /* '0x8D' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8E:
		{ /* '0x8E' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x8F:
		{ /* '0x8F' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x90:
		{ /* '0x90' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x91:
		{ /* '0x91' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x92:
		{ /* '0x92' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x93:
		{ /* '0x93' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x94:
		{ /* '0x94' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x95:
		{ /* '0x95' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x96:
		{ /* '0x96' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x97:
		{ /* '0x97' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x98:
		{ /* '0x98' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x99:
		{ /* '0x99' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9A:
		{ /* '0x9A' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9B:
		{ /* '0x9B' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9C:
		{ /* '0x9C' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9D:
		{ /* '0x9D' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9E:
		{ /* '0x9E' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0x9F:
		{ /* '0x9F' */
			return MediaTransportControlCommandType_TRACK_NAME
		}
	case 0xA0:
		{ /* '0xA0' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA1:
		{ /* '0xA1' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA2:
		{ /* '0xA2' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA3:
		{ /* '0xA3' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA4:
		{ /* '0xA4' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA5:
		{ /* '0xA5' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA6:
		{ /* '0xA6' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA7:
		{ /* '0xA7' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA8:
		{ /* '0xA8' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xA9:
		{ /* '0xA9' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAA:
		{ /* '0xAA' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAB:
		{ /* '0xAB' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAC:
		{ /* '0xAC' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAD:
		{ /* '0xAD' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAE:
		{ /* '0xAE' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xAF:
		{ /* '0xAF' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB0:
		{ /* '0xB0' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB1:
		{ /* '0xB1' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB2:
		{ /* '0xB2' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB3:
		{ /* '0xB3' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB4:
		{ /* '0xB4' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB5:
		{ /* '0xB5' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB6:
		{ /* '0xB6' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB7:
		{ /* '0xB7' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB8:
		{ /* '0xB8' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xB9:
		{ /* '0xB9' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBA:
		{ /* '0xBA' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBB:
		{ /* '0xBB' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBC:
		{ /* '0xBC' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBD:
		{ /* '0xBD' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBE:
		{ /* '0xBE' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xBF:
		{ /* '0xBF' */
			return MediaTransportControlCommandType_SELECTION_NAME
		}
	case 0xC0:
		{ /* '0xC0' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC1:
		{ /* '0xC1' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC2:
		{ /* '0xC2' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC3:
		{ /* '0xC3' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC4:
		{ /* '0xC4' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC5:
		{ /* '0xC5' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC6:
		{ /* '0xC6' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC7:
		{ /* '0xC7' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC8:
		{ /* '0xC8' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xC9:
		{ /* '0xC9' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCA:
		{ /* '0xCA' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCB:
		{ /* '0xCB' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCC:
		{ /* '0xCC' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCD:
		{ /* '0xCD' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCE:
		{ /* '0xCE' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xCF:
		{ /* '0xCF' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD0:
		{ /* '0xD0' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD1:
		{ /* '0xD1' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD2:
		{ /* '0xD2' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD3:
		{ /* '0xD3' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD4:
		{ /* '0xD4' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD5:
		{ /* '0xD5' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD6:
		{ /* '0xD6' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD7:
		{ /* '0xD7' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD8:
		{ /* '0xD8' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xD9:
		{ /* '0xD9' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDA:
		{ /* '0xDA' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDB:
		{ /* '0xDB' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDC:
		{ /* '0xDC' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDD:
		{ /* '0xDD' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDE:
		{ /* '0xDE' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	case 0xDF:
		{ /* '0xDF' */
			return MediaTransportControlCommandType_CATEGORY_NAME
		}
	default:
		{
			return 0
		}
	}
}

func MediaTransportControlCommandTypeContainerFirstEnumForFieldCommandType(value MediaTransportControlCommandType) (MediaTransportControlCommandTypeContainer, error) {
	for _, sizeValue := range MediaTransportControlCommandTypeContainerValues {
		if sizeValue.CommandType() == value {
			return sizeValue, nil
		}
	}
	return 0, errors.Errorf("enum for %v describing CommandType not found", value)
}
func MediaTransportControlCommandTypeContainerByValue(value uint8) (enum MediaTransportControlCommandTypeContainer, ok bool) {
	switch value {
	case 0x01:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStop, true
	case 0x0A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPauseResume, true
	case 0x12:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectCategory, true
	case 0x1B:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectSelection, true
	case 0x25:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectTrack, true
	case 0x2A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandShuffleOnOff, true
	case 0x32:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRepeatOnOff, true
	case 0x3A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousCategory, true
	case 0x42:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousSelection, true
	case 0x4A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousTrack, true
	case 0x52:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandFastForward, true
	case 0x5A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRewind, true
	case 0x62:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSourcePowerControl, true
	case 0x6D:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTotalTracks, true
	case 0x71:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStatusRequest, true
	case 0x73:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerateCategoriesSelectionsTracks, true
	case 0x74:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerationSize, true
	case 0x79:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPlay, true
	case 0x80:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_0Bytes, true
	case 0x81:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_1Bytes, true
	case 0x82:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_2Bytes, true
	case 0x83:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_3Bytes, true
	case 0x84:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_4Bytes, true
	case 0x85:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_5Bytes, true
	case 0x86:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_6Bytes, true
	case 0x87:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_7Bytes, true
	case 0x88:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_8Bytes, true
	case 0x89:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_9Bytes, true
	case 0x8A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_10Bytes, true
	case 0x8B:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_11Bytes, true
	case 0x8C:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_12Bytes, true
	case 0x8D:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_13Bytes, true
	case 0x8E:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_14Bytes, true
	case 0x8F:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_15Bytes, true
	case 0x90:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_16Bytes, true
	case 0x91:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_17Bytes, true
	case 0x92:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_18Bytes, true
	case 0x93:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_19Bytes, true
	case 0x94:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_20Bytes, true
	case 0x95:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_21Bytes, true
	case 0x96:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_22Bytes, true
	case 0x97:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_23Bytes, true
	case 0x98:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_24Bytes, true
	case 0x99:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_25Bytes, true
	case 0x9A:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_26Bytes, true
	case 0x9B:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_27Bytes, true
	case 0x9C:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_28Bytes, true
	case 0x9D:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_29Bytes, true
	case 0x9E:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_30Bytes, true
	case 0x9F:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_31Bytes, true
	case 0xA0:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_0Bytes, true
	case 0xA1:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_1Bytes, true
	case 0xA2:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_2Bytes, true
	case 0xA3:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_3Bytes, true
	case 0xA4:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_4Bytes, true
	case 0xA5:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_5Bytes, true
	case 0xA6:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_6Bytes, true
	case 0xA7:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_7Bytes, true
	case 0xA8:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_8Bytes, true
	case 0xA9:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_9Bytes, true
	case 0xAA:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_10Bytes, true
	case 0xAB:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_11Bytes, true
	case 0xAC:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_12Bytes, true
	case 0xAD:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_13Bytes, true
	case 0xAE:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_14Bytes, true
	case 0xAF:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_15Bytes, true
	case 0xB0:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_16Bytes, true
	case 0xB1:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_17Bytes, true
	case 0xB2:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_18Bytes, true
	case 0xB3:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_19Bytes, true
	case 0xB4:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_20Bytes, true
	case 0xB5:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_21Bytes, true
	case 0xB6:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_22Bytes, true
	case 0xB7:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_23Bytes, true
	case 0xB8:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_24Bytes, true
	case 0xB9:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_25Bytes, true
	case 0xBA:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_26Bytes, true
	case 0xBB:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_27Bytes, true
	case 0xBC:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_28Bytes, true
	case 0xBD:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_29Bytes, true
	case 0xBE:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_30Bytes, true
	case 0xBF:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_31Bytes, true
	case 0xC0:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_0Bytes, true
	case 0xC1:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_1Bytes, true
	case 0xC2:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_2Bytes, true
	case 0xC3:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_3Bytes, true
	case 0xC4:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_4Bytes, true
	case 0xC5:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_5Bytes, true
	case 0xC6:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_6Bytes, true
	case 0xC7:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_7Bytes, true
	case 0xC8:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_8Bytes, true
	case 0xC9:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_9Bytes, true
	case 0xCA:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_10Bytes, true
	case 0xCB:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_11Bytes, true
	case 0xCC:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_12Bytes, true
	case 0xCD:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_13Bytes, true
	case 0xCE:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_14Bytes, true
	case 0xCF:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_15Bytes, true
	case 0xD0:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_16Bytes, true
	case 0xD1:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_17Bytes, true
	case 0xD2:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_18Bytes, true
	case 0xD3:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_19Bytes, true
	case 0xD4:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_20Bytes, true
	case 0xD5:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_21Bytes, true
	case 0xD6:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_22Bytes, true
	case 0xD7:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_23Bytes, true
	case 0xD8:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_24Bytes, true
	case 0xD9:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_25Bytes, true
	case 0xDA:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_26Bytes, true
	case 0xDB:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_27Bytes, true
	case 0xDC:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_28Bytes, true
	case 0xDD:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_29Bytes, true
	case 0xDE:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_30Bytes, true
	case 0xDF:
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_31Bytes, true
	}
	return 0, false
}

func MediaTransportControlCommandTypeContainerByName(value string) (enum MediaTransportControlCommandTypeContainer, ok bool) {
	switch value {
	case "MediaTransportControlCommandStop":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStop, true
	case "MediaTransportControlCommandPauseResume":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPauseResume, true
	case "MediaTransportControlCommandSelectCategory":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectCategory, true
	case "MediaTransportControlCommandSelectSelection":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectSelection, true
	case "MediaTransportControlCommandSelectTrack":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectTrack, true
	case "MediaTransportControlCommandShuffleOnOff":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandShuffleOnOff, true
	case "MediaTransportControlCommandRepeatOnOff":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRepeatOnOff, true
	case "MediaTransportControlCommandNextPreviousCategory":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousCategory, true
	case "MediaTransportControlCommandNextPreviousSelection":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousSelection, true
	case "MediaTransportControlCommandNextPreviousTrack":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousTrack, true
	case "MediaTransportControlCommandFastForward":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandFastForward, true
	case "MediaTransportControlCommandRewind":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRewind, true
	case "MediaTransportControlCommandSourcePowerControl":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSourcePowerControl, true
	case "MediaTransportControlCommandTotalTracks":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTotalTracks, true
	case "MediaTransportControlCommandStatusRequest":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStatusRequest, true
	case "MediaTransportControlCommandEnumerateCategoriesSelectionsTracks":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerateCategoriesSelectionsTracks, true
	case "MediaTransportControlCommandEnumerationSize":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerationSize, true
	case "MediaTransportControlCommandPlay":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPlay, true
	case "MediaTransportControlCommandTrackName_0Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_0Bytes, true
	case "MediaTransportControlCommandTrackName_1Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_1Bytes, true
	case "MediaTransportControlCommandTrackName_2Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_2Bytes, true
	case "MediaTransportControlCommandTrackName_3Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_3Bytes, true
	case "MediaTransportControlCommandTrackName_4Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_4Bytes, true
	case "MediaTransportControlCommandTrackName_5Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_5Bytes, true
	case "MediaTransportControlCommandTrackName_6Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_6Bytes, true
	case "MediaTransportControlCommandTrackName_7Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_7Bytes, true
	case "MediaTransportControlCommandTrackName_8Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_8Bytes, true
	case "MediaTransportControlCommandTrackName_9Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_9Bytes, true
	case "MediaTransportControlCommandTrackName_10Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_10Bytes, true
	case "MediaTransportControlCommandTrackName_11Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_11Bytes, true
	case "MediaTransportControlCommandTrackName_12Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_12Bytes, true
	case "MediaTransportControlCommandTrackName_13Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_13Bytes, true
	case "MediaTransportControlCommandTrackName_14Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_14Bytes, true
	case "MediaTransportControlCommandTrackName_15Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_15Bytes, true
	case "MediaTransportControlCommandTrackName_16Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_16Bytes, true
	case "MediaTransportControlCommandTrackName_17Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_17Bytes, true
	case "MediaTransportControlCommandTrackName_18Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_18Bytes, true
	case "MediaTransportControlCommandTrackName_19Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_19Bytes, true
	case "MediaTransportControlCommandTrackName_20Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_20Bytes, true
	case "MediaTransportControlCommandTrackName_21Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_21Bytes, true
	case "MediaTransportControlCommandTrackName_22Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_22Bytes, true
	case "MediaTransportControlCommandTrackName_23Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_23Bytes, true
	case "MediaTransportControlCommandTrackName_24Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_24Bytes, true
	case "MediaTransportControlCommandTrackName_25Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_25Bytes, true
	case "MediaTransportControlCommandTrackName_26Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_26Bytes, true
	case "MediaTransportControlCommandTrackName_27Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_27Bytes, true
	case "MediaTransportControlCommandTrackName_28Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_28Bytes, true
	case "MediaTransportControlCommandTrackName_29Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_29Bytes, true
	case "MediaTransportControlCommandTrackName_30Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_30Bytes, true
	case "MediaTransportControlCommandTrackName_31Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_31Bytes, true
	case "MediaTransportControlCommandSelectionName_0Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_0Bytes, true
	case "MediaTransportControlCommandSelectionName_1Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_1Bytes, true
	case "MediaTransportControlCommandSelectionName_2Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_2Bytes, true
	case "MediaTransportControlCommandSelectionName_3Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_3Bytes, true
	case "MediaTransportControlCommandSelectionName_4Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_4Bytes, true
	case "MediaTransportControlCommandSelectionName_5Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_5Bytes, true
	case "MediaTransportControlCommandSelectionName_6Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_6Bytes, true
	case "MediaTransportControlCommandSelectionName_7Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_7Bytes, true
	case "MediaTransportControlCommandSelectionName_8Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_8Bytes, true
	case "MediaTransportControlCommandSelectionName_9Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_9Bytes, true
	case "MediaTransportControlCommandSelectionName_10Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_10Bytes, true
	case "MediaTransportControlCommandSelectionName_11Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_11Bytes, true
	case "MediaTransportControlCommandSelectionName_12Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_12Bytes, true
	case "MediaTransportControlCommandSelectionName_13Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_13Bytes, true
	case "MediaTransportControlCommandSelectionName_14Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_14Bytes, true
	case "MediaTransportControlCommandSelectionName_15Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_15Bytes, true
	case "MediaTransportControlCommandSelectionName_16Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_16Bytes, true
	case "MediaTransportControlCommandSelectionName_17Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_17Bytes, true
	case "MediaTransportControlCommandSelectionName_18Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_18Bytes, true
	case "MediaTransportControlCommandSelectionName_19Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_19Bytes, true
	case "MediaTransportControlCommandSelectionName_20Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_20Bytes, true
	case "MediaTransportControlCommandSelectionName_21Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_21Bytes, true
	case "MediaTransportControlCommandSelectionName_22Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_22Bytes, true
	case "MediaTransportControlCommandSelectionName_23Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_23Bytes, true
	case "MediaTransportControlCommandSelectionName_24Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_24Bytes, true
	case "MediaTransportControlCommandSelectionName_25Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_25Bytes, true
	case "MediaTransportControlCommandSelectionName_26Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_26Bytes, true
	case "MediaTransportControlCommandSelectionName_27Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_27Bytes, true
	case "MediaTransportControlCommandSelectionName_28Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_28Bytes, true
	case "MediaTransportControlCommandSelectionName_29Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_29Bytes, true
	case "MediaTransportControlCommandSelectionName_30Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_30Bytes, true
	case "MediaTransportControlCommandSelectionName_31Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_31Bytes, true
	case "MediaTransportControlCommandCategoryName_0Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_0Bytes, true
	case "MediaTransportControlCommandCategoryName_1Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_1Bytes, true
	case "MediaTransportControlCommandCategoryName_2Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_2Bytes, true
	case "MediaTransportControlCommandCategoryName_3Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_3Bytes, true
	case "MediaTransportControlCommandCategoryName_4Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_4Bytes, true
	case "MediaTransportControlCommandCategoryName_5Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_5Bytes, true
	case "MediaTransportControlCommandCategoryName_6Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_6Bytes, true
	case "MediaTransportControlCommandCategoryName_7Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_7Bytes, true
	case "MediaTransportControlCommandCategoryName_8Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_8Bytes, true
	case "MediaTransportControlCommandCategoryName_9Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_9Bytes, true
	case "MediaTransportControlCommandCategoryName_10Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_10Bytes, true
	case "MediaTransportControlCommandCategoryName_11Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_11Bytes, true
	case "MediaTransportControlCommandCategoryName_12Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_12Bytes, true
	case "MediaTransportControlCommandCategoryName_13Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_13Bytes, true
	case "MediaTransportControlCommandCategoryName_14Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_14Bytes, true
	case "MediaTransportControlCommandCategoryName_15Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_15Bytes, true
	case "MediaTransportControlCommandCategoryName_16Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_16Bytes, true
	case "MediaTransportControlCommandCategoryName_17Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_17Bytes, true
	case "MediaTransportControlCommandCategoryName_18Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_18Bytes, true
	case "MediaTransportControlCommandCategoryName_19Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_19Bytes, true
	case "MediaTransportControlCommandCategoryName_20Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_20Bytes, true
	case "MediaTransportControlCommandCategoryName_21Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_21Bytes, true
	case "MediaTransportControlCommandCategoryName_22Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_22Bytes, true
	case "MediaTransportControlCommandCategoryName_23Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_23Bytes, true
	case "MediaTransportControlCommandCategoryName_24Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_24Bytes, true
	case "MediaTransportControlCommandCategoryName_25Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_25Bytes, true
	case "MediaTransportControlCommandCategoryName_26Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_26Bytes, true
	case "MediaTransportControlCommandCategoryName_27Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_27Bytes, true
	case "MediaTransportControlCommandCategoryName_28Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_28Bytes, true
	case "MediaTransportControlCommandCategoryName_29Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_29Bytes, true
	case "MediaTransportControlCommandCategoryName_30Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_30Bytes, true
	case "MediaTransportControlCommandCategoryName_31Bytes":
		return MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_31Bytes, true
	}
	return 0, false
}

func MediaTransportControlCommandTypeContainerKnows(value uint8) bool {
	for _, typeValue := range MediaTransportControlCommandTypeContainerValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastMediaTransportControlCommandTypeContainer(structType interface{}) MediaTransportControlCommandTypeContainer {
	castFunc := func(typ interface{}) MediaTransportControlCommandTypeContainer {
		if sMediaTransportControlCommandTypeContainer, ok := typ.(MediaTransportControlCommandTypeContainer); ok {
			return sMediaTransportControlCommandTypeContainer
		}
		return 0
	}
	return castFunc(structType)
}

func (m MediaTransportControlCommandTypeContainer) GetLengthInBits() uint16 {
	return 8
}

func (m MediaTransportControlCommandTypeContainer) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func MediaTransportControlCommandTypeContainerParse(readBuffer utils.ReadBuffer) (MediaTransportControlCommandTypeContainer, error) {
	val, err := readBuffer.ReadUint8("MediaTransportControlCommandTypeContainer", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading MediaTransportControlCommandTypeContainer")
	}
	if enum, ok := MediaTransportControlCommandTypeContainerByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return MediaTransportControlCommandTypeContainer(val), nil
	} else {
		return enum, nil
	}
}

func (e MediaTransportControlCommandTypeContainer) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("MediaTransportControlCommandTypeContainer", 8, uint8(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e MediaTransportControlCommandTypeContainer) PLC4XEnumName() string {
	switch e {
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStop:
		return "MediaTransportControlCommandStop"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPauseResume:
		return "MediaTransportControlCommandPauseResume"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectCategory:
		return "MediaTransportControlCommandSelectCategory"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectSelection:
		return "MediaTransportControlCommandSelectSelection"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectTrack:
		return "MediaTransportControlCommandSelectTrack"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandShuffleOnOff:
		return "MediaTransportControlCommandShuffleOnOff"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRepeatOnOff:
		return "MediaTransportControlCommandRepeatOnOff"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousCategory:
		return "MediaTransportControlCommandNextPreviousCategory"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousSelection:
		return "MediaTransportControlCommandNextPreviousSelection"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandNextPreviousTrack:
		return "MediaTransportControlCommandNextPreviousTrack"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandFastForward:
		return "MediaTransportControlCommandFastForward"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandRewind:
		return "MediaTransportControlCommandRewind"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSourcePowerControl:
		return "MediaTransportControlCommandSourcePowerControl"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTotalTracks:
		return "MediaTransportControlCommandTotalTracks"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandStatusRequest:
		return "MediaTransportControlCommandStatusRequest"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerateCategoriesSelectionsTracks:
		return "MediaTransportControlCommandEnumerateCategoriesSelectionsTracks"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandEnumerationSize:
		return "MediaTransportControlCommandEnumerationSize"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandPlay:
		return "MediaTransportControlCommandPlay"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_0Bytes:
		return "MediaTransportControlCommandTrackName_0Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_1Bytes:
		return "MediaTransportControlCommandTrackName_1Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_2Bytes:
		return "MediaTransportControlCommandTrackName_2Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_3Bytes:
		return "MediaTransportControlCommandTrackName_3Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_4Bytes:
		return "MediaTransportControlCommandTrackName_4Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_5Bytes:
		return "MediaTransportControlCommandTrackName_5Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_6Bytes:
		return "MediaTransportControlCommandTrackName_6Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_7Bytes:
		return "MediaTransportControlCommandTrackName_7Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_8Bytes:
		return "MediaTransportControlCommandTrackName_8Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_9Bytes:
		return "MediaTransportControlCommandTrackName_9Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_10Bytes:
		return "MediaTransportControlCommandTrackName_10Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_11Bytes:
		return "MediaTransportControlCommandTrackName_11Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_12Bytes:
		return "MediaTransportControlCommandTrackName_12Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_13Bytes:
		return "MediaTransportControlCommandTrackName_13Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_14Bytes:
		return "MediaTransportControlCommandTrackName_14Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_15Bytes:
		return "MediaTransportControlCommandTrackName_15Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_16Bytes:
		return "MediaTransportControlCommandTrackName_16Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_17Bytes:
		return "MediaTransportControlCommandTrackName_17Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_18Bytes:
		return "MediaTransportControlCommandTrackName_18Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_19Bytes:
		return "MediaTransportControlCommandTrackName_19Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_20Bytes:
		return "MediaTransportControlCommandTrackName_20Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_21Bytes:
		return "MediaTransportControlCommandTrackName_21Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_22Bytes:
		return "MediaTransportControlCommandTrackName_22Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_23Bytes:
		return "MediaTransportControlCommandTrackName_23Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_24Bytes:
		return "MediaTransportControlCommandTrackName_24Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_25Bytes:
		return "MediaTransportControlCommandTrackName_25Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_26Bytes:
		return "MediaTransportControlCommandTrackName_26Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_27Bytes:
		return "MediaTransportControlCommandTrackName_27Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_28Bytes:
		return "MediaTransportControlCommandTrackName_28Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_29Bytes:
		return "MediaTransportControlCommandTrackName_29Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_30Bytes:
		return "MediaTransportControlCommandTrackName_30Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandTrackName_31Bytes:
		return "MediaTransportControlCommandTrackName_31Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_0Bytes:
		return "MediaTransportControlCommandSelectionName_0Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_1Bytes:
		return "MediaTransportControlCommandSelectionName_1Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_2Bytes:
		return "MediaTransportControlCommandSelectionName_2Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_3Bytes:
		return "MediaTransportControlCommandSelectionName_3Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_4Bytes:
		return "MediaTransportControlCommandSelectionName_4Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_5Bytes:
		return "MediaTransportControlCommandSelectionName_5Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_6Bytes:
		return "MediaTransportControlCommandSelectionName_6Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_7Bytes:
		return "MediaTransportControlCommandSelectionName_7Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_8Bytes:
		return "MediaTransportControlCommandSelectionName_8Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_9Bytes:
		return "MediaTransportControlCommandSelectionName_9Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_10Bytes:
		return "MediaTransportControlCommandSelectionName_10Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_11Bytes:
		return "MediaTransportControlCommandSelectionName_11Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_12Bytes:
		return "MediaTransportControlCommandSelectionName_12Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_13Bytes:
		return "MediaTransportControlCommandSelectionName_13Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_14Bytes:
		return "MediaTransportControlCommandSelectionName_14Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_15Bytes:
		return "MediaTransportControlCommandSelectionName_15Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_16Bytes:
		return "MediaTransportControlCommandSelectionName_16Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_17Bytes:
		return "MediaTransportControlCommandSelectionName_17Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_18Bytes:
		return "MediaTransportControlCommandSelectionName_18Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_19Bytes:
		return "MediaTransportControlCommandSelectionName_19Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_20Bytes:
		return "MediaTransportControlCommandSelectionName_20Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_21Bytes:
		return "MediaTransportControlCommandSelectionName_21Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_22Bytes:
		return "MediaTransportControlCommandSelectionName_22Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_23Bytes:
		return "MediaTransportControlCommandSelectionName_23Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_24Bytes:
		return "MediaTransportControlCommandSelectionName_24Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_25Bytes:
		return "MediaTransportControlCommandSelectionName_25Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_26Bytes:
		return "MediaTransportControlCommandSelectionName_26Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_27Bytes:
		return "MediaTransportControlCommandSelectionName_27Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_28Bytes:
		return "MediaTransportControlCommandSelectionName_28Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_29Bytes:
		return "MediaTransportControlCommandSelectionName_29Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_30Bytes:
		return "MediaTransportControlCommandSelectionName_30Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandSelectionName_31Bytes:
		return "MediaTransportControlCommandSelectionName_31Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_0Bytes:
		return "MediaTransportControlCommandCategoryName_0Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_1Bytes:
		return "MediaTransportControlCommandCategoryName_1Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_2Bytes:
		return "MediaTransportControlCommandCategoryName_2Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_3Bytes:
		return "MediaTransportControlCommandCategoryName_3Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_4Bytes:
		return "MediaTransportControlCommandCategoryName_4Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_5Bytes:
		return "MediaTransportControlCommandCategoryName_5Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_6Bytes:
		return "MediaTransportControlCommandCategoryName_6Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_7Bytes:
		return "MediaTransportControlCommandCategoryName_7Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_8Bytes:
		return "MediaTransportControlCommandCategoryName_8Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_9Bytes:
		return "MediaTransportControlCommandCategoryName_9Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_10Bytes:
		return "MediaTransportControlCommandCategoryName_10Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_11Bytes:
		return "MediaTransportControlCommandCategoryName_11Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_12Bytes:
		return "MediaTransportControlCommandCategoryName_12Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_13Bytes:
		return "MediaTransportControlCommandCategoryName_13Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_14Bytes:
		return "MediaTransportControlCommandCategoryName_14Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_15Bytes:
		return "MediaTransportControlCommandCategoryName_15Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_16Bytes:
		return "MediaTransportControlCommandCategoryName_16Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_17Bytes:
		return "MediaTransportControlCommandCategoryName_17Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_18Bytes:
		return "MediaTransportControlCommandCategoryName_18Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_19Bytes:
		return "MediaTransportControlCommandCategoryName_19Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_20Bytes:
		return "MediaTransportControlCommandCategoryName_20Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_21Bytes:
		return "MediaTransportControlCommandCategoryName_21Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_22Bytes:
		return "MediaTransportControlCommandCategoryName_22Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_23Bytes:
		return "MediaTransportControlCommandCategoryName_23Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_24Bytes:
		return "MediaTransportControlCommandCategoryName_24Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_25Bytes:
		return "MediaTransportControlCommandCategoryName_25Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_26Bytes:
		return "MediaTransportControlCommandCategoryName_26Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_27Bytes:
		return "MediaTransportControlCommandCategoryName_27Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_28Bytes:
		return "MediaTransportControlCommandCategoryName_28Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_29Bytes:
		return "MediaTransportControlCommandCategoryName_29Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_30Bytes:
		return "MediaTransportControlCommandCategoryName_30Bytes"
	case MediaTransportControlCommandTypeContainer_MediaTransportControlCommandCategoryName_31Bytes:
		return "MediaTransportControlCommandCategoryName_31Bytes"
	}
	return ""
}

func (e MediaTransportControlCommandTypeContainer) String() string {
	return e.PLC4XEnumName()
}
