/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// ErrorReportingSystemCategoryVariant is an enum
type ErrorReportingSystemCategoryVariant uint8

type IErrorReportingSystemCategoryVariant interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	ErrorReportingSystemCategoryVariant_RESERVED_0 ErrorReportingSystemCategoryVariant = 0x0
	ErrorReportingSystemCategoryVariant_RESERVED_1 ErrorReportingSystemCategoryVariant = 0x1
	ErrorReportingSystemCategoryVariant_RESERVED_2 ErrorReportingSystemCategoryVariant = 0x2
	ErrorReportingSystemCategoryVariant_RESERVED_3 ErrorReportingSystemCategoryVariant = 0x3
)

var ErrorReportingSystemCategoryVariantValues []ErrorReportingSystemCategoryVariant

func init() {
	_ = errors.New
	ErrorReportingSystemCategoryVariantValues = []ErrorReportingSystemCategoryVariant{
		ErrorReportingSystemCategoryVariant_RESERVED_0,
		ErrorReportingSystemCategoryVariant_RESERVED_1,
		ErrorReportingSystemCategoryVariant_RESERVED_2,
		ErrorReportingSystemCategoryVariant_RESERVED_3,
	}
}

func ErrorReportingSystemCategoryVariantByValue(value uint8) (enum ErrorReportingSystemCategoryVariant, ok bool) {
	switch value {
	case 0x0:
		return ErrorReportingSystemCategoryVariant_RESERVED_0, true
	case 0x1:
		return ErrorReportingSystemCategoryVariant_RESERVED_1, true
	case 0x2:
		return ErrorReportingSystemCategoryVariant_RESERVED_2, true
	case 0x3:
		return ErrorReportingSystemCategoryVariant_RESERVED_3, true
	}
	return 0, false
}

func ErrorReportingSystemCategoryVariantByName(value string) (enum ErrorReportingSystemCategoryVariant, ok bool) {
	switch value {
	case "RESERVED_0":
		return ErrorReportingSystemCategoryVariant_RESERVED_0, true
	case "RESERVED_1":
		return ErrorReportingSystemCategoryVariant_RESERVED_1, true
	case "RESERVED_2":
		return ErrorReportingSystemCategoryVariant_RESERVED_2, true
	case "RESERVED_3":
		return ErrorReportingSystemCategoryVariant_RESERVED_3, true
	}
	return 0, false
}

func ErrorReportingSystemCategoryVariantKnows(value uint8) bool {
	for _, typeValue := range ErrorReportingSystemCategoryVariantValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastErrorReportingSystemCategoryVariant(structType interface{}) ErrorReportingSystemCategoryVariant {
	castFunc := func(typ interface{}) ErrorReportingSystemCategoryVariant {
		if sErrorReportingSystemCategoryVariant, ok := typ.(ErrorReportingSystemCategoryVariant); ok {
			return sErrorReportingSystemCategoryVariant
		}
		return 0
	}
	return castFunc(structType)
}

func (m ErrorReportingSystemCategoryVariant) GetLengthInBits() uint16 {
	return 2
}

func (m ErrorReportingSystemCategoryVariant) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func ErrorReportingSystemCategoryVariantParse(readBuffer utils.ReadBuffer) (ErrorReportingSystemCategoryVariant, error) {
	val, err := readBuffer.ReadUint8("ErrorReportingSystemCategoryVariant", 2)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ErrorReportingSystemCategoryVariant")
	}
	if enum, ok := ErrorReportingSystemCategoryVariantByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return ErrorReportingSystemCategoryVariant(val), nil
	} else {
		return enum, nil
	}
}

func (e ErrorReportingSystemCategoryVariant) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("ErrorReportingSystemCategoryVariant", 2, uint8(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ErrorReportingSystemCategoryVariant) PLC4XEnumName() string {
	switch e {
	case ErrorReportingSystemCategoryVariant_RESERVED_0:
		return "RESERVED_0"
	case ErrorReportingSystemCategoryVariant_RESERVED_1:
		return "RESERVED_1"
	case ErrorReportingSystemCategoryVariant_RESERVED_2:
		return "RESERVED_2"
	case ErrorReportingSystemCategoryVariant_RESERVED_3:
		return "RESERVED_3"
	}
	return ""
}

func (e ErrorReportingSystemCategoryVariant) String() string {
	return e.PLC4XEnumName()
}
