/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// ClockAndTimekeepingDataUpdateTime is the corresponding interface of ClockAndTimekeepingDataUpdateTime
type ClockAndTimekeepingDataUpdateTime interface {
	utils.LengthAware
	utils.Serializable
	ClockAndTimekeepingData
	// GetHours returns Hours (property field)
	GetHours() uint8
	// GetMinute returns Minute (property field)
	GetMinute() uint8
	// GetSecond returns Second (property field)
	GetSecond() uint8
	// GetDaylightSaving returns DaylightSaving (property field)
	GetDaylightSaving() byte
	// GetIsNoDaylightSavings returns IsNoDaylightSavings (virtual field)
	GetIsNoDaylightSavings() bool
	// GetIsAdvancedBy1Hour returns IsAdvancedBy1Hour (virtual field)
	GetIsAdvancedBy1Hour() bool
	// GetIsReserved returns IsReserved (virtual field)
	GetIsReserved() bool
	// GetIsUnknown returns IsUnknown (virtual field)
	GetIsUnknown() bool
}

// ClockAndTimekeepingDataUpdateTimeExactly can be used when we want exactly this type and not a type which fulfills ClockAndTimekeepingDataUpdateTime.
// This is useful for switch cases.
type ClockAndTimekeepingDataUpdateTimeExactly interface {
	ClockAndTimekeepingDataUpdateTime
	isClockAndTimekeepingDataUpdateTime() bool
}

// _ClockAndTimekeepingDataUpdateTime is the data-structure of this message
type _ClockAndTimekeepingDataUpdateTime struct {
	*_ClockAndTimekeepingData
	Hours          uint8
	Minute         uint8
	Second         uint8
	DaylightSaving byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ClockAndTimekeepingDataUpdateTime) InitializeParent(parent ClockAndTimekeepingData, commandTypeContainer ClockAndTimekeepingCommandTypeContainer, argument byte) {
	m.CommandTypeContainer = commandTypeContainer
	m.Argument = argument
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetParent() ClockAndTimekeepingData {
	return m._ClockAndTimekeepingData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ClockAndTimekeepingDataUpdateTime) GetHours() uint8 {
	return m.Hours
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetMinute() uint8 {
	return m.Minute
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetSecond() uint8 {
	return m.Second
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetDaylightSaving() byte {
	return m.DaylightSaving
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_ClockAndTimekeepingDataUpdateTime) GetIsNoDaylightSavings() bool {
	return bool(bool((m.GetDaylightSaving()) == (0x00)))
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetIsAdvancedBy1Hour() bool {
	return bool(bool((m.GetDaylightSaving()) == (0x01)))
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetIsReserved() bool {
	return bool(bool(bool((m.GetDaylightSaving()) > (0x01))) && bool(bool((m.GetDaylightSaving()) <= (0xFE))))
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetIsUnknown() bool {
	return bool(bool((m.GetDaylightSaving()) > (0xFE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewClockAndTimekeepingDataUpdateTime factory function for _ClockAndTimekeepingDataUpdateTime
func NewClockAndTimekeepingDataUpdateTime(hours uint8, minute uint8, second uint8, daylightSaving byte, commandTypeContainer ClockAndTimekeepingCommandTypeContainer, argument byte) *_ClockAndTimekeepingDataUpdateTime {
	_result := &_ClockAndTimekeepingDataUpdateTime{
		Hours:                    hours,
		Minute:                   minute,
		Second:                   second,
		DaylightSaving:           daylightSaving,
		_ClockAndTimekeepingData: NewClockAndTimekeepingData(commandTypeContainer, argument),
	}
	_result._ClockAndTimekeepingData._ClockAndTimekeepingDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastClockAndTimekeepingDataUpdateTime(structType interface{}) ClockAndTimekeepingDataUpdateTime {
	if casted, ok := structType.(ClockAndTimekeepingDataUpdateTime); ok {
		return casted
	}
	if casted, ok := structType.(*ClockAndTimekeepingDataUpdateTime); ok {
		return *casted
	}
	return nil
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetTypeName() string {
	return "ClockAndTimekeepingDataUpdateTime"
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (hours)
	lengthInBits += 8

	// Simple field (minute)
	lengthInBits += 8

	// Simple field (second)
	lengthInBits += 8

	// Simple field (daylightSaving)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_ClockAndTimekeepingDataUpdateTime) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func ClockAndTimekeepingDataUpdateTimeParse(readBuffer utils.ReadBuffer) (ClockAndTimekeepingDataUpdateTime, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ClockAndTimekeepingDataUpdateTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ClockAndTimekeepingDataUpdateTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (hours)
	_hours, _hoursErr := readBuffer.ReadUint8("hours", 8)
	if _hoursErr != nil {
		return nil, errors.Wrap(_hoursErr, "Error parsing 'hours' field of ClockAndTimekeepingDataUpdateTime")
	}
	hours := _hours

	// Simple Field (minute)
	_minute, _minuteErr := readBuffer.ReadUint8("minute", 8)
	if _minuteErr != nil {
		return nil, errors.Wrap(_minuteErr, "Error parsing 'minute' field of ClockAndTimekeepingDataUpdateTime")
	}
	minute := _minute

	// Simple Field (second)
	_second, _secondErr := readBuffer.ReadUint8("second", 8)
	if _secondErr != nil {
		return nil, errors.Wrap(_secondErr, "Error parsing 'second' field of ClockAndTimekeepingDataUpdateTime")
	}
	second := _second

	// Simple Field (daylightSaving)
	_daylightSaving, _daylightSavingErr := readBuffer.ReadByte("daylightSaving")
	if _daylightSavingErr != nil {
		return nil, errors.Wrap(_daylightSavingErr, "Error parsing 'daylightSaving' field of ClockAndTimekeepingDataUpdateTime")
	}
	daylightSaving := _daylightSaving

	// Virtual field
	_isNoDaylightSavings := bool((daylightSaving) == (0x00))
	isNoDaylightSavings := bool(_isNoDaylightSavings)
	_ = isNoDaylightSavings

	// Virtual field
	_isAdvancedBy1Hour := bool((daylightSaving) == (0x01))
	isAdvancedBy1Hour := bool(_isAdvancedBy1Hour)
	_ = isAdvancedBy1Hour

	// Virtual field
	_isReserved := bool(bool((daylightSaving) > (0x01))) && bool(bool((daylightSaving) <= (0xFE)))
	isReserved := bool(_isReserved)
	_ = isReserved

	// Virtual field
	_isUnknown := bool((daylightSaving) > (0xFE))
	isUnknown := bool(_isUnknown)
	_ = isUnknown

	if closeErr := readBuffer.CloseContext("ClockAndTimekeepingDataUpdateTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ClockAndTimekeepingDataUpdateTime")
	}

	// Create a partially initialized instance
	_child := &_ClockAndTimekeepingDataUpdateTime{
		_ClockAndTimekeepingData: &_ClockAndTimekeepingData{},
		Hours:                    hours,
		Minute:                   minute,
		Second:                   second,
		DaylightSaving:           daylightSaving,
	}
	_child._ClockAndTimekeepingData._ClockAndTimekeepingDataChildRequirements = _child
	return _child, nil
}

func (m *_ClockAndTimekeepingDataUpdateTime) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ClockAndTimekeepingDataUpdateTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ClockAndTimekeepingDataUpdateTime")
		}

		// Simple Field (hours)
		hours := uint8(m.GetHours())
		_hoursErr := writeBuffer.WriteUint8("hours", 8, (hours))
		if _hoursErr != nil {
			return errors.Wrap(_hoursErr, "Error serializing 'hours' field")
		}

		// Simple Field (minute)
		minute := uint8(m.GetMinute())
		_minuteErr := writeBuffer.WriteUint8("minute", 8, (minute))
		if _minuteErr != nil {
			return errors.Wrap(_minuteErr, "Error serializing 'minute' field")
		}

		// Simple Field (second)
		second := uint8(m.GetSecond())
		_secondErr := writeBuffer.WriteUint8("second", 8, (second))
		if _secondErr != nil {
			return errors.Wrap(_secondErr, "Error serializing 'second' field")
		}

		// Simple Field (daylightSaving)
		daylightSaving := byte(m.GetDaylightSaving())
		_daylightSavingErr := writeBuffer.WriteByte("daylightSaving", (daylightSaving))
		if _daylightSavingErr != nil {
			return errors.Wrap(_daylightSavingErr, "Error serializing 'daylightSaving' field")
		}
		// Virtual field
		if _isNoDaylightSavingsErr := writeBuffer.WriteVirtual("isNoDaylightSavings", m.GetIsNoDaylightSavings()); _isNoDaylightSavingsErr != nil {
			return errors.Wrap(_isNoDaylightSavingsErr, "Error serializing 'isNoDaylightSavings' field")
		}
		// Virtual field
		if _isAdvancedBy1HourErr := writeBuffer.WriteVirtual("isAdvancedBy1Hour", m.GetIsAdvancedBy1Hour()); _isAdvancedBy1HourErr != nil {
			return errors.Wrap(_isAdvancedBy1HourErr, "Error serializing 'isAdvancedBy1Hour' field")
		}
		// Virtual field
		if _isReservedErr := writeBuffer.WriteVirtual("isReserved", m.GetIsReserved()); _isReservedErr != nil {
			return errors.Wrap(_isReservedErr, "Error serializing 'isReserved' field")
		}
		// Virtual field
		if _isUnknownErr := writeBuffer.WriteVirtual("isUnknown", m.GetIsUnknown()); _isUnknownErr != nil {
			return errors.Wrap(_isUnknownErr, "Error serializing 'isUnknown' field")
		}

		if popErr := writeBuffer.PopContext("ClockAndTimekeepingDataUpdateTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ClockAndTimekeepingDataUpdateTime")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_ClockAndTimekeepingDataUpdateTime) isClockAndTimekeepingDataUpdateTime() bool {
	return true
}

func (m *_ClockAndTimekeepingDataUpdateTime) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
