/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// CBusPointToMultiPointCommand is the corresponding interface of CBusPointToMultiPointCommand
type CBusPointToMultiPointCommand interface {
	utils.LengthAware
	utils.Serializable
	// GetPeekedApplication returns PeekedApplication (property field)
	GetPeekedApplication() byte
}

// CBusPointToMultiPointCommandExactly can be used when we want exactly this type and not a type which fulfills CBusPointToMultiPointCommand.
// This is useful for switch cases.
type CBusPointToMultiPointCommandExactly interface {
	CBusPointToMultiPointCommand
	isCBusPointToMultiPointCommand() bool
}

// _CBusPointToMultiPointCommand is the data-structure of this message
type _CBusPointToMultiPointCommand struct {
	_CBusPointToMultiPointCommandChildRequirements
	PeekedApplication byte

	// Arguments.
	CBusOptions CBusOptions
}

type _CBusPointToMultiPointCommandChildRequirements interface {
	utils.Serializable
	GetLengthInBits() uint16
	GetLengthInBitsConditional(lastItem bool) uint16
}

type CBusPointToMultiPointCommandParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child CBusPointToMultiPointCommand, serializeChildFunction func() error) error
	GetTypeName() string
}

type CBusPointToMultiPointCommandChild interface {
	utils.Serializable
	InitializeParent(parent CBusPointToMultiPointCommand, peekedApplication byte)
	GetParent() *CBusPointToMultiPointCommand

	GetTypeName() string
	CBusPointToMultiPointCommand
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CBusPointToMultiPointCommand) GetPeekedApplication() byte {
	return m.PeekedApplication
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCBusPointToMultiPointCommand factory function for _CBusPointToMultiPointCommand
func NewCBusPointToMultiPointCommand(peekedApplication byte, cBusOptions CBusOptions) *_CBusPointToMultiPointCommand {
	return &_CBusPointToMultiPointCommand{PeekedApplication: peekedApplication, CBusOptions: cBusOptions}
}

// Deprecated: use the interface for direct cast
func CastCBusPointToMultiPointCommand(structType interface{}) CBusPointToMultiPointCommand {
	if casted, ok := structType.(CBusPointToMultiPointCommand); ok {
		return casted
	}
	if casted, ok := structType.(*CBusPointToMultiPointCommand); ok {
		return *casted
	}
	return nil
}

func (m *_CBusPointToMultiPointCommand) GetTypeName() string {
	return "CBusPointToMultiPointCommand"
}

func (m *_CBusPointToMultiPointCommand) GetParentLengthInBits() uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_CBusPointToMultiPointCommand) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func CBusPointToMultiPointCommandParse(readBuffer utils.ReadBuffer, cBusOptions CBusOptions) (CBusPointToMultiPointCommand, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusPointToMultiPointCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusPointToMultiPointCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Peek Field (peekedApplication)
	currentPos = positionAware.GetPos()
	peekedApplication, _err := readBuffer.ReadByte("peekedApplication")
	if _err != nil {
		return nil, errors.Wrap(_err, "Error parsing 'peekedApplication' field of CBusPointToMultiPointCommand")
	}

	readBuffer.Reset(currentPos)

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type CBusPointToMultiPointCommandChildSerializeRequirement interface {
		CBusPointToMultiPointCommand
		InitializeParent(CBusPointToMultiPointCommand, byte)
		GetParent() CBusPointToMultiPointCommand
	}
	var _childTemp interface{}
	var _child CBusPointToMultiPointCommandChildSerializeRequirement
	var typeSwitchError error
	switch {
	case peekedApplication == 0xFF: // CBusPointToMultiPointCommandStatus
		_childTemp, typeSwitchError = CBusPointToMultiPointCommandStatusParse(readBuffer, cBusOptions)
	case 0 == 0: // CBusPointToMultiPointCommandNormal
		_childTemp, typeSwitchError = CBusPointToMultiPointCommandNormalParse(readBuffer, cBusOptions)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [peekedApplication=%v]", peekedApplication)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of CBusPointToMultiPointCommand")
	}
	_child = _childTemp.(CBusPointToMultiPointCommandChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("CBusPointToMultiPointCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusPointToMultiPointCommand")
	}

	// Finish initializing
	_child.InitializeParent(_child, peekedApplication)
	return _child, nil
}

func (pm *_CBusPointToMultiPointCommand) SerializeParent(writeBuffer utils.WriteBuffer, child CBusPointToMultiPointCommand, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("CBusPointToMultiPointCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CBusPointToMultiPointCommand")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("CBusPointToMultiPointCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CBusPointToMultiPointCommand")
	}
	return nil
}

////
// Arguments Getter

func (m *_CBusPointToMultiPointCommand) GetCBusOptions() CBusOptions {
	return m.CBusOptions
}

//
////

func (m *_CBusPointToMultiPointCommand) isCBusPointToMultiPointCommand() bool {
	return true
}

func (m *_CBusPointToMultiPointCommand) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
