/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BridgeAddress is the corresponding interface of BridgeAddress
type BridgeAddress interface {
	utils.LengthAware
	utils.Serializable
	// GetAddress returns Address (property field)
	GetAddress() byte
}

// BridgeAddressExactly can be used when we want exactly this type and not a type which fulfills BridgeAddress.
// This is useful for switch cases.
type BridgeAddressExactly interface {
	BridgeAddress
	isBridgeAddress() bool
}

// _BridgeAddress is the data-structure of this message
type _BridgeAddress struct {
	Address byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BridgeAddress) GetAddress() byte {
	return m.Address
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBridgeAddress factory function for _BridgeAddress
func NewBridgeAddress(address byte) *_BridgeAddress {
	return &_BridgeAddress{Address: address}
}

// Deprecated: use the interface for direct cast
func CastBridgeAddress(structType interface{}) BridgeAddress {
	if casted, ok := structType.(BridgeAddress); ok {
		return casted
	}
	if casted, ok := structType.(*BridgeAddress); ok {
		return *casted
	}
	return nil
}

func (m *_BridgeAddress) GetTypeName() string {
	return "BridgeAddress"
}

func (m *_BridgeAddress) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BridgeAddress) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Simple field (address)
	lengthInBits += 8

	return lengthInBits
}

func (m *_BridgeAddress) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BridgeAddressParse(readBuffer utils.ReadBuffer) (BridgeAddress, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BridgeAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BridgeAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (address)
	_address, _addressErr := readBuffer.ReadByte("address")
	if _addressErr != nil {
		return nil, errors.Wrap(_addressErr, "Error parsing 'address' field of BridgeAddress")
	}
	address := _address

	if closeErr := readBuffer.CloseContext("BridgeAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BridgeAddress")
	}

	// Create the instance
	return &_BridgeAddress{
		Address: address,
	}, nil
}

func (m *_BridgeAddress) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("BridgeAddress"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BridgeAddress")
	}

	// Simple Field (address)
	address := byte(m.GetAddress())
	_addressErr := writeBuffer.WriteByte("address", (address))
	if _addressErr != nil {
		return errors.Wrap(_addressErr, "Error serializing 'address' field")
	}

	if popErr := writeBuffer.PopContext("BridgeAddress"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BridgeAddress")
	}
	return nil
}

func (m *_BridgeAddress) isBridgeAddress() bool {
	return true
}

func (m *_BridgeAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
