/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// ErrorCode is an enum
type ErrorCode uint16

type IErrorCode interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	ErrorCode_ABORT_APDU_TOO_LONG                     ErrorCode = 123
	ErrorCode_ABORT_APPLICATION_EXCEEDED_REPLY_TIME   ErrorCode = 124
	ErrorCode_ABORT_BUFFER_OVERFLOW                   ErrorCode = 51
	ErrorCode_ABORT_INSUFFICIENT_SECURITY             ErrorCode = 135
	ErrorCode_ABORT_INVALID_APDU_IN_THIS_STATE        ErrorCode = 52
	ErrorCode_ABORT_OTHER                             ErrorCode = 56
	ErrorCode_ABORT_OUT_OF_RESOURCES                  ErrorCode = 125
	ErrorCode_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK ErrorCode = 53
	ErrorCode_ABORT_PROPRIETARY                       ErrorCode = 55
	ErrorCode_ABORT_SECURITY_ERROR                    ErrorCode = 136
	ErrorCode_ABORT_SEGMENTATION_NOT_SUPPORTED        ErrorCode = 54
	ErrorCode_ABORT_TSM_TIMEOUT                       ErrorCode = 126
	ErrorCode_ABORT_WINDOW_SIZE_OUT_OF_RANGE          ErrorCode = 127
	ErrorCode_ACCESS_DENIED                           ErrorCode = 85
	ErrorCode_ADDRESSING_ERROR                        ErrorCode = 115
	ErrorCode_BAD_DESTINATION_ADDRESS                 ErrorCode = 86
	ErrorCode_BAD_DESTINATION_DEVICE_ID               ErrorCode = 87
	ErrorCode_BAD_SIGNATURE                           ErrorCode = 88
	ErrorCode_BAD_SOURCE_ADDRESS                      ErrorCode = 89
	ErrorCode_BAD_TIMESTAMP                           ErrorCode = 90
	ErrorCode_Busy                                    ErrorCode = 82
	ErrorCode_CANNOT_USE_KEY                          ErrorCode = 91
	ErrorCode_CANNOT_VERIFY_MESSAGE_ID                ErrorCode = 92
	ErrorCode_CHARACTER_SET_NOT_SUPPORTED             ErrorCode = 41
	ErrorCode_COMMUNICATION_DISABLED                  ErrorCode = 83
	ErrorCode_CONFIGURATION_IN_PROGRESS               ErrorCode = 2
	ErrorCode_CORRECT_KEY_REVISION                    ErrorCode = 93
	ErrorCode_COV_SUBSCRIPTION_FAILED                 ErrorCode = 43
	ErrorCode_DATATYPE_NOT_SUPPORTED                  ErrorCode = 47
	ErrorCode_DELETE_FDT_ENTRY_FAILED                 ErrorCode = 120
	ErrorCode_DESTINATION_DEVICE_ID_REQUIRED          ErrorCode = 94
	ErrorCode_DEVICE_BUSY                             ErrorCode = 3
	ErrorCode_DISTRIBUTE_BROADCAST_FAILED             ErrorCode = 121
	ErrorCode_DUPLICATE_ENTRY                         ErrorCode = 137
	ErrorCode_DUPLICATE_MESSAGE                       ErrorCode = 95
	ErrorCode_DUPLICATE_NAME                          ErrorCode = 48
	ErrorCode_DUPLICATE_OBJECT_ID                     ErrorCode = 49
	ErrorCode_DYNAMIC_CREATION_NOT_SUPPORTED          ErrorCode = 4
	ErrorCode_ENCRYPTION_NOT_CONFIGURED               ErrorCode = 96
	ErrorCode_ENCRYPTION_REQUIRED                     ErrorCode = 97
	ErrorCode_FILE_ACCESS_DENIED                      ErrorCode = 5
	ErrorCode_FILE_FULL                               ErrorCode = 128
	ErrorCode_INCONSISTENT_CONFIGURATION              ErrorCode = 129
	ErrorCode_INCONSISTENT_OBJECT_TYPE                ErrorCode = 130
	ErrorCode_INCONSISTENT_PARAMETERS                 ErrorCode = 7
	ErrorCode_INCONSISTENT_SELECTION_CRITERION        ErrorCode = 8
	ErrorCode_INCORRECT_KEY                           ErrorCode = 98
	ErrorCode_INTERNAL_ERROR                          ErrorCode = 131
	ErrorCode_INVALID_ARRAY_INDEX                     ErrorCode = 42
	ErrorCode_INVALID_CONFIGURATION_DATA              ErrorCode = 46
	ErrorCode_INVALID_DATA_TYPE                       ErrorCode = 9
	ErrorCode_D_PARAMETER_DATA_TYPE                   ErrorCode = 13
	ErrorCode_INVALID_TAG                             ErrorCode = 57
	ErrorCode_INVALID_TIMESTAMP                       ErrorCode = 14
	ErrorCode_INVALID_VALUE_IN_THIS_STATE             ErrorCode = 138
	ErrorCode_KEY_UPDATE_IN_PROGRESS                  ErrorCode = 100
	ErrorCode_LIST_ELEMENT_NOT_FOUND                  ErrorCode = 81
	ErrorCode_LOG_BUFFER_FULL                         ErrorCode = 75
	ErrorCode_LOGGED_VALUE_PURGED                     ErrorCode = 76
	ErrorCode_MALFORMED_MESSAGE                       ErrorCode = 101
	ErrorCode_MESSAGE_TOO_LONG                        ErrorCode = 113
	ErrorCode_MISSING_REQUIRED_PARAMETER              ErrorCode = 16
	ErrorCode_NETWORK_DOWN                            ErrorCode = 58
	ErrorCode_NO_ALARM_CONFIGURED                     ErrorCode = 74
	ErrorCode_NO_OBJECTS_OF_SPECIFIED_TYPE            ErrorCode = 17
	ErrorCode_NO_PROPERTY_SPECIFIED                   ErrorCode = 77
	ErrorCode_NO_SPACE_FOR_OBJECT                     ErrorCode = 18
	ErrorCode_NO_SPACE_TO_ADD_LIST_ELEMENT            ErrorCode = 19
	ErrorCode_NO_SPACE_TO_WRITE_PROPERTY              ErrorCode = 20
	ErrorCode_NO_VT_SESSIONS_AVAILABLE                ErrorCode = 21
	ErrorCode_NOT_CONFIGURED                          ErrorCode = 132
	ErrorCode_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING    ErrorCode = 78
	ErrorCode_NOT_COV_PROPERTY                        ErrorCode = 44
	ErrorCode_NOT_KEY_SERVER                          ErrorCode = 102
	ErrorCode_NOT_ROUTER_TO_DNET                      ErrorCode = 110
	ErrorCode_OBJECT_DELETION_NOT_PERMITTED           ErrorCode = 23
	ErrorCode_OBJECT_IDENTIFIER_ALREADY_EXISTS        ErrorCode = 24
	ErrorCode_OPERATIONAL_PROBLEM                     ErrorCode = 25
	ErrorCode_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED    ErrorCode = 45
	ErrorCode_OTHER                                   ErrorCode = 0
	ErrorCode_OUT_OF_MEMORY                           ErrorCode = 133
	ErrorCode_PARAMETER_OUT_OF_RANGE                  ErrorCode = 80
	ErrorCode_PASSWORD_FAILURE                        ErrorCode = 26
	ErrorCode_PROPERTY_IS_NOT_A_LIST                  ErrorCode = 22
	ErrorCode_PROPERTY_IS_NOT_AN_ARRAY                ErrorCode = 50
	ErrorCode_READ_ACCESS_DENIED                      ErrorCode = 27
	ErrorCode_READ_BDT_FAILED                         ErrorCode = 117
	ErrorCode_READ_FDT_FAILED                         ErrorCode = 119
	ErrorCode_REGISTER_FOREIGN_DEVICE_FAILED          ErrorCode = 118
	ErrorCode_REJECT_BUFFER_OVERFLOW                  ErrorCode = 59
	ErrorCode_REJECT_INCONSISTENT_PARAMETERS          ErrorCode = 60
	ErrorCode_REJECT_INVALID_PARAMETER_DATA_TYPE      ErrorCode = 61
	ErrorCode_REJECT_INVALID_TAG                      ErrorCode = 62
	ErrorCode_REJECT_MISSING_REQUIRED_PARAMETER       ErrorCode = 63
	ErrorCode_REJECT_OTHER                            ErrorCode = 69
	ErrorCode_REJECT_PARAMETER_OUT_OF_RANGE           ErrorCode = 64
	ErrorCode_REJECT_PROPRIETARY                      ErrorCode = 68
	ErrorCode_REJECT_TOO_MANY_ARGUMENTS               ErrorCode = 65
	ErrorCode_REJECT_UNDEFINED_ENUMERATION            ErrorCode = 66
	ErrorCode_REJECT_UNRECOGNIZED_SERVICE             ErrorCode = 67
	ErrorCode_ROUTER_BUSY                             ErrorCode = 111
	ErrorCode_SECURITY_ERROR                          ErrorCode = 114
	ErrorCode_SECURITY_NOT_CONFIGURED                 ErrorCode = 103
	ErrorCode_SERVICE_REQUEST_DENIED                  ErrorCode = 29
	ErrorCode_SOURCE_SECURITY_REQUIRED                ErrorCode = 104
	ErrorCode_SUCCESS                                 ErrorCode = 84
	ErrorCode_TIMEOUT                                 ErrorCode = 30
	ErrorCode_TOO_MANY_KEYS                           ErrorCode = 105
	ErrorCode_UNKNOWN_AUTHENTICATION_TYPE             ErrorCode = 106
	ErrorCode_UNKNOWN_DEVICE                          ErrorCode = 70
	ErrorCode_UNKNOWN_FILE_SIZE                       ErrorCode = 122
	ErrorCode_UNKNOWN_KEY                             ErrorCode = 107
	ErrorCode_UNKNOWN_KEY_REVISION                    ErrorCode = 108
	ErrorCode_UNKNOWN_NETWORK_MESSAGE                 ErrorCode = 112
	ErrorCode_UNKNOWN_OBJECT                          ErrorCode = 31
	ErrorCode_UNKNOWN_PROPERTY                        ErrorCode = 32
	ErrorCode_UNKNOWN_ROUTE                           ErrorCode = 71
	ErrorCode_UNKNOWN_SOURCE_MESSAGE                  ErrorCode = 109
	ErrorCode_UNKNOWN_SUBSCRIPTION                    ErrorCode = 79
	ErrorCode_UNKNOWN_VT_CLASS                        ErrorCode = 34
	ErrorCode_UNKNOWN_VT_SESSION                      ErrorCode = 35
	ErrorCode_UNSUPPORTED_OBJECT_TYPE                 ErrorCode = 36
	ErrorCode_VALUE_NOT_INITIALIZED                   ErrorCode = 72
	ErrorCode_VALUE_OUT_OF_RANGE                      ErrorCode = 37
	ErrorCode_VALUE_TOO_LONG                          ErrorCode = 134
	ErrorCode_VT_SESSION_ALREADY_CLOSED               ErrorCode = 38
	ErrorCode_VT_SESSION_TERMINATION_FAILURE          ErrorCode = 39
	ErrorCode_WRITE_ACCESS_DENIED                     ErrorCode = 40
	ErrorCode_WRITE_BDT_FAILED                        ErrorCode = 116
	ErrorCode_VENDOR_PROPRIETARY_VALUE                ErrorCode = 0xFFFF
)

var ErrorCodeValues []ErrorCode

func init() {
	_ = errors.New
	ErrorCodeValues = []ErrorCode{
		ErrorCode_ABORT_APDU_TOO_LONG,
		ErrorCode_ABORT_APPLICATION_EXCEEDED_REPLY_TIME,
		ErrorCode_ABORT_BUFFER_OVERFLOW,
		ErrorCode_ABORT_INSUFFICIENT_SECURITY,
		ErrorCode_ABORT_INVALID_APDU_IN_THIS_STATE,
		ErrorCode_ABORT_OTHER,
		ErrorCode_ABORT_OUT_OF_RESOURCES,
		ErrorCode_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK,
		ErrorCode_ABORT_PROPRIETARY,
		ErrorCode_ABORT_SECURITY_ERROR,
		ErrorCode_ABORT_SEGMENTATION_NOT_SUPPORTED,
		ErrorCode_ABORT_TSM_TIMEOUT,
		ErrorCode_ABORT_WINDOW_SIZE_OUT_OF_RANGE,
		ErrorCode_ACCESS_DENIED,
		ErrorCode_ADDRESSING_ERROR,
		ErrorCode_BAD_DESTINATION_ADDRESS,
		ErrorCode_BAD_DESTINATION_DEVICE_ID,
		ErrorCode_BAD_SIGNATURE,
		ErrorCode_BAD_SOURCE_ADDRESS,
		ErrorCode_BAD_TIMESTAMP,
		ErrorCode_Busy,
		ErrorCode_CANNOT_USE_KEY,
		ErrorCode_CANNOT_VERIFY_MESSAGE_ID,
		ErrorCode_CHARACTER_SET_NOT_SUPPORTED,
		ErrorCode_COMMUNICATION_DISABLED,
		ErrorCode_CONFIGURATION_IN_PROGRESS,
		ErrorCode_CORRECT_KEY_REVISION,
		ErrorCode_COV_SUBSCRIPTION_FAILED,
		ErrorCode_DATATYPE_NOT_SUPPORTED,
		ErrorCode_DELETE_FDT_ENTRY_FAILED,
		ErrorCode_DESTINATION_DEVICE_ID_REQUIRED,
		ErrorCode_DEVICE_BUSY,
		ErrorCode_DISTRIBUTE_BROADCAST_FAILED,
		ErrorCode_DUPLICATE_ENTRY,
		ErrorCode_DUPLICATE_MESSAGE,
		ErrorCode_DUPLICATE_NAME,
		ErrorCode_DUPLICATE_OBJECT_ID,
		ErrorCode_DYNAMIC_CREATION_NOT_SUPPORTED,
		ErrorCode_ENCRYPTION_NOT_CONFIGURED,
		ErrorCode_ENCRYPTION_REQUIRED,
		ErrorCode_FILE_ACCESS_DENIED,
		ErrorCode_FILE_FULL,
		ErrorCode_INCONSISTENT_CONFIGURATION,
		ErrorCode_INCONSISTENT_OBJECT_TYPE,
		ErrorCode_INCONSISTENT_PARAMETERS,
		ErrorCode_INCONSISTENT_SELECTION_CRITERION,
		ErrorCode_INCORRECT_KEY,
		ErrorCode_INTERNAL_ERROR,
		ErrorCode_INVALID_ARRAY_INDEX,
		ErrorCode_INVALID_CONFIGURATION_DATA,
		ErrorCode_INVALID_DATA_TYPE,
		ErrorCode_D_PARAMETER_DATA_TYPE,
		ErrorCode_INVALID_TAG,
		ErrorCode_INVALID_TIMESTAMP,
		ErrorCode_INVALID_VALUE_IN_THIS_STATE,
		ErrorCode_KEY_UPDATE_IN_PROGRESS,
		ErrorCode_LIST_ELEMENT_NOT_FOUND,
		ErrorCode_LOG_BUFFER_FULL,
		ErrorCode_LOGGED_VALUE_PURGED,
		ErrorCode_MALFORMED_MESSAGE,
		ErrorCode_MESSAGE_TOO_LONG,
		ErrorCode_MISSING_REQUIRED_PARAMETER,
		ErrorCode_NETWORK_DOWN,
		ErrorCode_NO_ALARM_CONFIGURED,
		ErrorCode_NO_OBJECTS_OF_SPECIFIED_TYPE,
		ErrorCode_NO_PROPERTY_SPECIFIED,
		ErrorCode_NO_SPACE_FOR_OBJECT,
		ErrorCode_NO_SPACE_TO_ADD_LIST_ELEMENT,
		ErrorCode_NO_SPACE_TO_WRITE_PROPERTY,
		ErrorCode_NO_VT_SESSIONS_AVAILABLE,
		ErrorCode_NOT_CONFIGURED,
		ErrorCode_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING,
		ErrorCode_NOT_COV_PROPERTY,
		ErrorCode_NOT_KEY_SERVER,
		ErrorCode_NOT_ROUTER_TO_DNET,
		ErrorCode_OBJECT_DELETION_NOT_PERMITTED,
		ErrorCode_OBJECT_IDENTIFIER_ALREADY_EXISTS,
		ErrorCode_OPERATIONAL_PROBLEM,
		ErrorCode_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED,
		ErrorCode_OTHER,
		ErrorCode_OUT_OF_MEMORY,
		ErrorCode_PARAMETER_OUT_OF_RANGE,
		ErrorCode_PASSWORD_FAILURE,
		ErrorCode_PROPERTY_IS_NOT_A_LIST,
		ErrorCode_PROPERTY_IS_NOT_AN_ARRAY,
		ErrorCode_READ_ACCESS_DENIED,
		ErrorCode_READ_BDT_FAILED,
		ErrorCode_READ_FDT_FAILED,
		ErrorCode_REGISTER_FOREIGN_DEVICE_FAILED,
		ErrorCode_REJECT_BUFFER_OVERFLOW,
		ErrorCode_REJECT_INCONSISTENT_PARAMETERS,
		ErrorCode_REJECT_INVALID_PARAMETER_DATA_TYPE,
		ErrorCode_REJECT_INVALID_TAG,
		ErrorCode_REJECT_MISSING_REQUIRED_PARAMETER,
		ErrorCode_REJECT_OTHER,
		ErrorCode_REJECT_PARAMETER_OUT_OF_RANGE,
		ErrorCode_REJECT_PROPRIETARY,
		ErrorCode_REJECT_TOO_MANY_ARGUMENTS,
		ErrorCode_REJECT_UNDEFINED_ENUMERATION,
		ErrorCode_REJECT_UNRECOGNIZED_SERVICE,
		ErrorCode_ROUTER_BUSY,
		ErrorCode_SECURITY_ERROR,
		ErrorCode_SECURITY_NOT_CONFIGURED,
		ErrorCode_SERVICE_REQUEST_DENIED,
		ErrorCode_SOURCE_SECURITY_REQUIRED,
		ErrorCode_SUCCESS,
		ErrorCode_TIMEOUT,
		ErrorCode_TOO_MANY_KEYS,
		ErrorCode_UNKNOWN_AUTHENTICATION_TYPE,
		ErrorCode_UNKNOWN_DEVICE,
		ErrorCode_UNKNOWN_FILE_SIZE,
		ErrorCode_UNKNOWN_KEY,
		ErrorCode_UNKNOWN_KEY_REVISION,
		ErrorCode_UNKNOWN_NETWORK_MESSAGE,
		ErrorCode_UNKNOWN_OBJECT,
		ErrorCode_UNKNOWN_PROPERTY,
		ErrorCode_UNKNOWN_ROUTE,
		ErrorCode_UNKNOWN_SOURCE_MESSAGE,
		ErrorCode_UNKNOWN_SUBSCRIPTION,
		ErrorCode_UNKNOWN_VT_CLASS,
		ErrorCode_UNKNOWN_VT_SESSION,
		ErrorCode_UNSUPPORTED_OBJECT_TYPE,
		ErrorCode_VALUE_NOT_INITIALIZED,
		ErrorCode_VALUE_OUT_OF_RANGE,
		ErrorCode_VALUE_TOO_LONG,
		ErrorCode_VT_SESSION_ALREADY_CLOSED,
		ErrorCode_VT_SESSION_TERMINATION_FAILURE,
		ErrorCode_WRITE_ACCESS_DENIED,
		ErrorCode_WRITE_BDT_FAILED,
		ErrorCode_VENDOR_PROPRIETARY_VALUE,
	}
}

func ErrorCodeByValue(value uint16) (enum ErrorCode, ok bool) {
	switch value {
	case 0:
		return ErrorCode_OTHER, true
	case 0xFFFF:
		return ErrorCode_VENDOR_PROPRIETARY_VALUE, true
	case 100:
		return ErrorCode_KEY_UPDATE_IN_PROGRESS, true
	case 101:
		return ErrorCode_MALFORMED_MESSAGE, true
	case 102:
		return ErrorCode_NOT_KEY_SERVER, true
	case 103:
		return ErrorCode_SECURITY_NOT_CONFIGURED, true
	case 104:
		return ErrorCode_SOURCE_SECURITY_REQUIRED, true
	case 105:
		return ErrorCode_TOO_MANY_KEYS, true
	case 106:
		return ErrorCode_UNKNOWN_AUTHENTICATION_TYPE, true
	case 107:
		return ErrorCode_UNKNOWN_KEY, true
	case 108:
		return ErrorCode_UNKNOWN_KEY_REVISION, true
	case 109:
		return ErrorCode_UNKNOWN_SOURCE_MESSAGE, true
	case 110:
		return ErrorCode_NOT_ROUTER_TO_DNET, true
	case 111:
		return ErrorCode_ROUTER_BUSY, true
	case 112:
		return ErrorCode_UNKNOWN_NETWORK_MESSAGE, true
	case 113:
		return ErrorCode_MESSAGE_TOO_LONG, true
	case 114:
		return ErrorCode_SECURITY_ERROR, true
	case 115:
		return ErrorCode_ADDRESSING_ERROR, true
	case 116:
		return ErrorCode_WRITE_BDT_FAILED, true
	case 117:
		return ErrorCode_READ_BDT_FAILED, true
	case 118:
		return ErrorCode_REGISTER_FOREIGN_DEVICE_FAILED, true
	case 119:
		return ErrorCode_READ_FDT_FAILED, true
	case 120:
		return ErrorCode_DELETE_FDT_ENTRY_FAILED, true
	case 121:
		return ErrorCode_DISTRIBUTE_BROADCAST_FAILED, true
	case 122:
		return ErrorCode_UNKNOWN_FILE_SIZE, true
	case 123:
		return ErrorCode_ABORT_APDU_TOO_LONG, true
	case 124:
		return ErrorCode_ABORT_APPLICATION_EXCEEDED_REPLY_TIME, true
	case 125:
		return ErrorCode_ABORT_OUT_OF_RESOURCES, true
	case 126:
		return ErrorCode_ABORT_TSM_TIMEOUT, true
	case 127:
		return ErrorCode_ABORT_WINDOW_SIZE_OUT_OF_RANGE, true
	case 128:
		return ErrorCode_FILE_FULL, true
	case 129:
		return ErrorCode_INCONSISTENT_CONFIGURATION, true
	case 13:
		return ErrorCode_D_PARAMETER_DATA_TYPE, true
	case 130:
		return ErrorCode_INCONSISTENT_OBJECT_TYPE, true
	case 131:
		return ErrorCode_INTERNAL_ERROR, true
	case 132:
		return ErrorCode_NOT_CONFIGURED, true
	case 133:
		return ErrorCode_OUT_OF_MEMORY, true
	case 134:
		return ErrorCode_VALUE_TOO_LONG, true
	case 135:
		return ErrorCode_ABORT_INSUFFICIENT_SECURITY, true
	case 136:
		return ErrorCode_ABORT_SECURITY_ERROR, true
	case 137:
		return ErrorCode_DUPLICATE_ENTRY, true
	case 138:
		return ErrorCode_INVALID_VALUE_IN_THIS_STATE, true
	case 14:
		return ErrorCode_INVALID_TIMESTAMP, true
	case 16:
		return ErrorCode_MISSING_REQUIRED_PARAMETER, true
	case 17:
		return ErrorCode_NO_OBJECTS_OF_SPECIFIED_TYPE, true
	case 18:
		return ErrorCode_NO_SPACE_FOR_OBJECT, true
	case 19:
		return ErrorCode_NO_SPACE_TO_ADD_LIST_ELEMENT, true
	case 2:
		return ErrorCode_CONFIGURATION_IN_PROGRESS, true
	case 20:
		return ErrorCode_NO_SPACE_TO_WRITE_PROPERTY, true
	case 21:
		return ErrorCode_NO_VT_SESSIONS_AVAILABLE, true
	case 22:
		return ErrorCode_PROPERTY_IS_NOT_A_LIST, true
	case 23:
		return ErrorCode_OBJECT_DELETION_NOT_PERMITTED, true
	case 24:
		return ErrorCode_OBJECT_IDENTIFIER_ALREADY_EXISTS, true
	case 25:
		return ErrorCode_OPERATIONAL_PROBLEM, true
	case 26:
		return ErrorCode_PASSWORD_FAILURE, true
	case 27:
		return ErrorCode_READ_ACCESS_DENIED, true
	case 29:
		return ErrorCode_SERVICE_REQUEST_DENIED, true
	case 3:
		return ErrorCode_DEVICE_BUSY, true
	case 30:
		return ErrorCode_TIMEOUT, true
	case 31:
		return ErrorCode_UNKNOWN_OBJECT, true
	case 32:
		return ErrorCode_UNKNOWN_PROPERTY, true
	case 34:
		return ErrorCode_UNKNOWN_VT_CLASS, true
	case 35:
		return ErrorCode_UNKNOWN_VT_SESSION, true
	case 36:
		return ErrorCode_UNSUPPORTED_OBJECT_TYPE, true
	case 37:
		return ErrorCode_VALUE_OUT_OF_RANGE, true
	case 38:
		return ErrorCode_VT_SESSION_ALREADY_CLOSED, true
	case 39:
		return ErrorCode_VT_SESSION_TERMINATION_FAILURE, true
	case 4:
		return ErrorCode_DYNAMIC_CREATION_NOT_SUPPORTED, true
	case 40:
		return ErrorCode_WRITE_ACCESS_DENIED, true
	case 41:
		return ErrorCode_CHARACTER_SET_NOT_SUPPORTED, true
	case 42:
		return ErrorCode_INVALID_ARRAY_INDEX, true
	case 43:
		return ErrorCode_COV_SUBSCRIPTION_FAILED, true
	case 44:
		return ErrorCode_NOT_COV_PROPERTY, true
	case 45:
		return ErrorCode_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED, true
	case 46:
		return ErrorCode_INVALID_CONFIGURATION_DATA, true
	case 47:
		return ErrorCode_DATATYPE_NOT_SUPPORTED, true
	case 48:
		return ErrorCode_DUPLICATE_NAME, true
	case 49:
		return ErrorCode_DUPLICATE_OBJECT_ID, true
	case 5:
		return ErrorCode_FILE_ACCESS_DENIED, true
	case 50:
		return ErrorCode_PROPERTY_IS_NOT_AN_ARRAY, true
	case 51:
		return ErrorCode_ABORT_BUFFER_OVERFLOW, true
	case 52:
		return ErrorCode_ABORT_INVALID_APDU_IN_THIS_STATE, true
	case 53:
		return ErrorCode_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK, true
	case 54:
		return ErrorCode_ABORT_SEGMENTATION_NOT_SUPPORTED, true
	case 55:
		return ErrorCode_ABORT_PROPRIETARY, true
	case 56:
		return ErrorCode_ABORT_OTHER, true
	case 57:
		return ErrorCode_INVALID_TAG, true
	case 58:
		return ErrorCode_NETWORK_DOWN, true
	case 59:
		return ErrorCode_REJECT_BUFFER_OVERFLOW, true
	case 60:
		return ErrorCode_REJECT_INCONSISTENT_PARAMETERS, true
	case 61:
		return ErrorCode_REJECT_INVALID_PARAMETER_DATA_TYPE, true
	case 62:
		return ErrorCode_REJECT_INVALID_TAG, true
	case 63:
		return ErrorCode_REJECT_MISSING_REQUIRED_PARAMETER, true
	case 64:
		return ErrorCode_REJECT_PARAMETER_OUT_OF_RANGE, true
	case 65:
		return ErrorCode_REJECT_TOO_MANY_ARGUMENTS, true
	case 66:
		return ErrorCode_REJECT_UNDEFINED_ENUMERATION, true
	case 67:
		return ErrorCode_REJECT_UNRECOGNIZED_SERVICE, true
	case 68:
		return ErrorCode_REJECT_PROPRIETARY, true
	case 69:
		return ErrorCode_REJECT_OTHER, true
	case 7:
		return ErrorCode_INCONSISTENT_PARAMETERS, true
	case 70:
		return ErrorCode_UNKNOWN_DEVICE, true
	case 71:
		return ErrorCode_UNKNOWN_ROUTE, true
	case 72:
		return ErrorCode_VALUE_NOT_INITIALIZED, true
	case 74:
		return ErrorCode_NO_ALARM_CONFIGURED, true
	case 75:
		return ErrorCode_LOG_BUFFER_FULL, true
	case 76:
		return ErrorCode_LOGGED_VALUE_PURGED, true
	case 77:
		return ErrorCode_NO_PROPERTY_SPECIFIED, true
	case 78:
		return ErrorCode_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING, true
	case 79:
		return ErrorCode_UNKNOWN_SUBSCRIPTION, true
	case 8:
		return ErrorCode_INCONSISTENT_SELECTION_CRITERION, true
	case 80:
		return ErrorCode_PARAMETER_OUT_OF_RANGE, true
	case 81:
		return ErrorCode_LIST_ELEMENT_NOT_FOUND, true
	case 82:
		return ErrorCode_Busy, true
	case 83:
		return ErrorCode_COMMUNICATION_DISABLED, true
	case 84:
		return ErrorCode_SUCCESS, true
	case 85:
		return ErrorCode_ACCESS_DENIED, true
	case 86:
		return ErrorCode_BAD_DESTINATION_ADDRESS, true
	case 87:
		return ErrorCode_BAD_DESTINATION_DEVICE_ID, true
	case 88:
		return ErrorCode_BAD_SIGNATURE, true
	case 89:
		return ErrorCode_BAD_SOURCE_ADDRESS, true
	case 9:
		return ErrorCode_INVALID_DATA_TYPE, true
	case 90:
		return ErrorCode_BAD_TIMESTAMP, true
	case 91:
		return ErrorCode_CANNOT_USE_KEY, true
	case 92:
		return ErrorCode_CANNOT_VERIFY_MESSAGE_ID, true
	case 93:
		return ErrorCode_CORRECT_KEY_REVISION, true
	case 94:
		return ErrorCode_DESTINATION_DEVICE_ID_REQUIRED, true
	case 95:
		return ErrorCode_DUPLICATE_MESSAGE, true
	case 96:
		return ErrorCode_ENCRYPTION_NOT_CONFIGURED, true
	case 97:
		return ErrorCode_ENCRYPTION_REQUIRED, true
	case 98:
		return ErrorCode_INCORRECT_KEY, true
	}
	return 0, false
}

func ErrorCodeByName(value string) (enum ErrorCode, ok bool) {
	switch value {
	case "OTHER":
		return ErrorCode_OTHER, true
	case "VENDOR_PROPRIETARY_VALUE":
		return ErrorCode_VENDOR_PROPRIETARY_VALUE, true
	case "KEY_UPDATE_IN_PROGRESS":
		return ErrorCode_KEY_UPDATE_IN_PROGRESS, true
	case "MALFORMED_MESSAGE":
		return ErrorCode_MALFORMED_MESSAGE, true
	case "NOT_KEY_SERVER":
		return ErrorCode_NOT_KEY_SERVER, true
	case "SECURITY_NOT_CONFIGURED":
		return ErrorCode_SECURITY_NOT_CONFIGURED, true
	case "SOURCE_SECURITY_REQUIRED":
		return ErrorCode_SOURCE_SECURITY_REQUIRED, true
	case "TOO_MANY_KEYS":
		return ErrorCode_TOO_MANY_KEYS, true
	case "UNKNOWN_AUTHENTICATION_TYPE":
		return ErrorCode_UNKNOWN_AUTHENTICATION_TYPE, true
	case "UNKNOWN_KEY":
		return ErrorCode_UNKNOWN_KEY, true
	case "UNKNOWN_KEY_REVISION":
		return ErrorCode_UNKNOWN_KEY_REVISION, true
	case "UNKNOWN_SOURCE_MESSAGE":
		return ErrorCode_UNKNOWN_SOURCE_MESSAGE, true
	case "NOT_ROUTER_TO_DNET":
		return ErrorCode_NOT_ROUTER_TO_DNET, true
	case "ROUTER_BUSY":
		return ErrorCode_ROUTER_BUSY, true
	case "UNKNOWN_NETWORK_MESSAGE":
		return ErrorCode_UNKNOWN_NETWORK_MESSAGE, true
	case "MESSAGE_TOO_LONG":
		return ErrorCode_MESSAGE_TOO_LONG, true
	case "SECURITY_ERROR":
		return ErrorCode_SECURITY_ERROR, true
	case "ADDRESSING_ERROR":
		return ErrorCode_ADDRESSING_ERROR, true
	case "WRITE_BDT_FAILED":
		return ErrorCode_WRITE_BDT_FAILED, true
	case "READ_BDT_FAILED":
		return ErrorCode_READ_BDT_FAILED, true
	case "REGISTER_FOREIGN_DEVICE_FAILED":
		return ErrorCode_REGISTER_FOREIGN_DEVICE_FAILED, true
	case "READ_FDT_FAILED":
		return ErrorCode_READ_FDT_FAILED, true
	case "DELETE_FDT_ENTRY_FAILED":
		return ErrorCode_DELETE_FDT_ENTRY_FAILED, true
	case "DISTRIBUTE_BROADCAST_FAILED":
		return ErrorCode_DISTRIBUTE_BROADCAST_FAILED, true
	case "UNKNOWN_FILE_SIZE":
		return ErrorCode_UNKNOWN_FILE_SIZE, true
	case "ABORT_APDU_TOO_LONG":
		return ErrorCode_ABORT_APDU_TOO_LONG, true
	case "ABORT_APPLICATION_EXCEEDED_REPLY_TIME":
		return ErrorCode_ABORT_APPLICATION_EXCEEDED_REPLY_TIME, true
	case "ABORT_OUT_OF_RESOURCES":
		return ErrorCode_ABORT_OUT_OF_RESOURCES, true
	case "ABORT_TSM_TIMEOUT":
		return ErrorCode_ABORT_TSM_TIMEOUT, true
	case "ABORT_WINDOW_SIZE_OUT_OF_RANGE":
		return ErrorCode_ABORT_WINDOW_SIZE_OUT_OF_RANGE, true
	case "FILE_FULL":
		return ErrorCode_FILE_FULL, true
	case "INCONSISTENT_CONFIGURATION":
		return ErrorCode_INCONSISTENT_CONFIGURATION, true
	case "D_PARAMETER_DATA_TYPE":
		return ErrorCode_D_PARAMETER_DATA_TYPE, true
	case "INCONSISTENT_OBJECT_TYPE":
		return ErrorCode_INCONSISTENT_OBJECT_TYPE, true
	case "INTERNAL_ERROR":
		return ErrorCode_INTERNAL_ERROR, true
	case "NOT_CONFIGURED":
		return ErrorCode_NOT_CONFIGURED, true
	case "OUT_OF_MEMORY":
		return ErrorCode_OUT_OF_MEMORY, true
	case "VALUE_TOO_LONG":
		return ErrorCode_VALUE_TOO_LONG, true
	case "ABORT_INSUFFICIENT_SECURITY":
		return ErrorCode_ABORT_INSUFFICIENT_SECURITY, true
	case "ABORT_SECURITY_ERROR":
		return ErrorCode_ABORT_SECURITY_ERROR, true
	case "DUPLICATE_ENTRY":
		return ErrorCode_DUPLICATE_ENTRY, true
	case "INVALID_VALUE_IN_THIS_STATE":
		return ErrorCode_INVALID_VALUE_IN_THIS_STATE, true
	case "INVALID_TIMESTAMP":
		return ErrorCode_INVALID_TIMESTAMP, true
	case "MISSING_REQUIRED_PARAMETER":
		return ErrorCode_MISSING_REQUIRED_PARAMETER, true
	case "NO_OBJECTS_OF_SPECIFIED_TYPE":
		return ErrorCode_NO_OBJECTS_OF_SPECIFIED_TYPE, true
	case "NO_SPACE_FOR_OBJECT":
		return ErrorCode_NO_SPACE_FOR_OBJECT, true
	case "NO_SPACE_TO_ADD_LIST_ELEMENT":
		return ErrorCode_NO_SPACE_TO_ADD_LIST_ELEMENT, true
	case "CONFIGURATION_IN_PROGRESS":
		return ErrorCode_CONFIGURATION_IN_PROGRESS, true
	case "NO_SPACE_TO_WRITE_PROPERTY":
		return ErrorCode_NO_SPACE_TO_WRITE_PROPERTY, true
	case "NO_VT_SESSIONS_AVAILABLE":
		return ErrorCode_NO_VT_SESSIONS_AVAILABLE, true
	case "PROPERTY_IS_NOT_A_LIST":
		return ErrorCode_PROPERTY_IS_NOT_A_LIST, true
	case "OBJECT_DELETION_NOT_PERMITTED":
		return ErrorCode_OBJECT_DELETION_NOT_PERMITTED, true
	case "OBJECT_IDENTIFIER_ALREADY_EXISTS":
		return ErrorCode_OBJECT_IDENTIFIER_ALREADY_EXISTS, true
	case "OPERATIONAL_PROBLEM":
		return ErrorCode_OPERATIONAL_PROBLEM, true
	case "PASSWORD_FAILURE":
		return ErrorCode_PASSWORD_FAILURE, true
	case "READ_ACCESS_DENIED":
		return ErrorCode_READ_ACCESS_DENIED, true
	case "SERVICE_REQUEST_DENIED":
		return ErrorCode_SERVICE_REQUEST_DENIED, true
	case "DEVICE_BUSY":
		return ErrorCode_DEVICE_BUSY, true
	case "TIMEOUT":
		return ErrorCode_TIMEOUT, true
	case "UNKNOWN_OBJECT":
		return ErrorCode_UNKNOWN_OBJECT, true
	case "UNKNOWN_PROPERTY":
		return ErrorCode_UNKNOWN_PROPERTY, true
	case "UNKNOWN_VT_CLASS":
		return ErrorCode_UNKNOWN_VT_CLASS, true
	case "UNKNOWN_VT_SESSION":
		return ErrorCode_UNKNOWN_VT_SESSION, true
	case "UNSUPPORTED_OBJECT_TYPE":
		return ErrorCode_UNSUPPORTED_OBJECT_TYPE, true
	case "VALUE_OUT_OF_RANGE":
		return ErrorCode_VALUE_OUT_OF_RANGE, true
	case "VT_SESSION_ALREADY_CLOSED":
		return ErrorCode_VT_SESSION_ALREADY_CLOSED, true
	case "VT_SESSION_TERMINATION_FAILURE":
		return ErrorCode_VT_SESSION_TERMINATION_FAILURE, true
	case "DYNAMIC_CREATION_NOT_SUPPORTED":
		return ErrorCode_DYNAMIC_CREATION_NOT_SUPPORTED, true
	case "WRITE_ACCESS_DENIED":
		return ErrorCode_WRITE_ACCESS_DENIED, true
	case "CHARACTER_SET_NOT_SUPPORTED":
		return ErrorCode_CHARACTER_SET_NOT_SUPPORTED, true
	case "INVALID_ARRAY_INDEX":
		return ErrorCode_INVALID_ARRAY_INDEX, true
	case "COV_SUBSCRIPTION_FAILED":
		return ErrorCode_COV_SUBSCRIPTION_FAILED, true
	case "NOT_COV_PROPERTY":
		return ErrorCode_NOT_COV_PROPERTY, true
	case "OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED":
		return ErrorCode_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED, true
	case "INVALID_CONFIGURATION_DATA":
		return ErrorCode_INVALID_CONFIGURATION_DATA, true
	case "DATATYPE_NOT_SUPPORTED":
		return ErrorCode_DATATYPE_NOT_SUPPORTED, true
	case "DUPLICATE_NAME":
		return ErrorCode_DUPLICATE_NAME, true
	case "DUPLICATE_OBJECT_ID":
		return ErrorCode_DUPLICATE_OBJECT_ID, true
	case "FILE_ACCESS_DENIED":
		return ErrorCode_FILE_ACCESS_DENIED, true
	case "PROPERTY_IS_NOT_AN_ARRAY":
		return ErrorCode_PROPERTY_IS_NOT_AN_ARRAY, true
	case "ABORT_BUFFER_OVERFLOW":
		return ErrorCode_ABORT_BUFFER_OVERFLOW, true
	case "ABORT_INVALID_APDU_IN_THIS_STATE":
		return ErrorCode_ABORT_INVALID_APDU_IN_THIS_STATE, true
	case "ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK":
		return ErrorCode_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK, true
	case "ABORT_SEGMENTATION_NOT_SUPPORTED":
		return ErrorCode_ABORT_SEGMENTATION_NOT_SUPPORTED, true
	case "ABORT_PROPRIETARY":
		return ErrorCode_ABORT_PROPRIETARY, true
	case "ABORT_OTHER":
		return ErrorCode_ABORT_OTHER, true
	case "INVALID_TAG":
		return ErrorCode_INVALID_TAG, true
	case "NETWORK_DOWN":
		return ErrorCode_NETWORK_DOWN, true
	case "REJECT_BUFFER_OVERFLOW":
		return ErrorCode_REJECT_BUFFER_OVERFLOW, true
	case "REJECT_INCONSISTENT_PARAMETERS":
		return ErrorCode_REJECT_INCONSISTENT_PARAMETERS, true
	case "REJECT_INVALID_PARAMETER_DATA_TYPE":
		return ErrorCode_REJECT_INVALID_PARAMETER_DATA_TYPE, true
	case "REJECT_INVALID_TAG":
		return ErrorCode_REJECT_INVALID_TAG, true
	case "REJECT_MISSING_REQUIRED_PARAMETER":
		return ErrorCode_REJECT_MISSING_REQUIRED_PARAMETER, true
	case "REJECT_PARAMETER_OUT_OF_RANGE":
		return ErrorCode_REJECT_PARAMETER_OUT_OF_RANGE, true
	case "REJECT_TOO_MANY_ARGUMENTS":
		return ErrorCode_REJECT_TOO_MANY_ARGUMENTS, true
	case "REJECT_UNDEFINED_ENUMERATION":
		return ErrorCode_REJECT_UNDEFINED_ENUMERATION, true
	case "REJECT_UNRECOGNIZED_SERVICE":
		return ErrorCode_REJECT_UNRECOGNIZED_SERVICE, true
	case "REJECT_PROPRIETARY":
		return ErrorCode_REJECT_PROPRIETARY, true
	case "REJECT_OTHER":
		return ErrorCode_REJECT_OTHER, true
	case "INCONSISTENT_PARAMETERS":
		return ErrorCode_INCONSISTENT_PARAMETERS, true
	case "UNKNOWN_DEVICE":
		return ErrorCode_UNKNOWN_DEVICE, true
	case "UNKNOWN_ROUTE":
		return ErrorCode_UNKNOWN_ROUTE, true
	case "VALUE_NOT_INITIALIZED":
		return ErrorCode_VALUE_NOT_INITIALIZED, true
	case "NO_ALARM_CONFIGURED":
		return ErrorCode_NO_ALARM_CONFIGURED, true
	case "LOG_BUFFER_FULL":
		return ErrorCode_LOG_BUFFER_FULL, true
	case "LOGGED_VALUE_PURGED":
		return ErrorCode_LOGGED_VALUE_PURGED, true
	case "NO_PROPERTY_SPECIFIED":
		return ErrorCode_NO_PROPERTY_SPECIFIED, true
	case "NOT_CONFIGURED_FOR_TRIGGERED_LOGGING":
		return ErrorCode_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING, true
	case "UNKNOWN_SUBSCRIPTION":
		return ErrorCode_UNKNOWN_SUBSCRIPTION, true
	case "INCONSISTENT_SELECTION_CRITERION":
		return ErrorCode_INCONSISTENT_SELECTION_CRITERION, true
	case "PARAMETER_OUT_OF_RANGE":
		return ErrorCode_PARAMETER_OUT_OF_RANGE, true
	case "LIST_ELEMENT_NOT_FOUND":
		return ErrorCode_LIST_ELEMENT_NOT_FOUND, true
	case "Busy":
		return ErrorCode_Busy, true
	case "COMMUNICATION_DISABLED":
		return ErrorCode_COMMUNICATION_DISABLED, true
	case "SUCCESS":
		return ErrorCode_SUCCESS, true
	case "ACCESS_DENIED":
		return ErrorCode_ACCESS_DENIED, true
	case "BAD_DESTINATION_ADDRESS":
		return ErrorCode_BAD_DESTINATION_ADDRESS, true
	case "BAD_DESTINATION_DEVICE_ID":
		return ErrorCode_BAD_DESTINATION_DEVICE_ID, true
	case "BAD_SIGNATURE":
		return ErrorCode_BAD_SIGNATURE, true
	case "BAD_SOURCE_ADDRESS":
		return ErrorCode_BAD_SOURCE_ADDRESS, true
	case "INVALID_DATA_TYPE":
		return ErrorCode_INVALID_DATA_TYPE, true
	case "BAD_TIMESTAMP":
		return ErrorCode_BAD_TIMESTAMP, true
	case "CANNOT_USE_KEY":
		return ErrorCode_CANNOT_USE_KEY, true
	case "CANNOT_VERIFY_MESSAGE_ID":
		return ErrorCode_CANNOT_VERIFY_MESSAGE_ID, true
	case "CORRECT_KEY_REVISION":
		return ErrorCode_CORRECT_KEY_REVISION, true
	case "DESTINATION_DEVICE_ID_REQUIRED":
		return ErrorCode_DESTINATION_DEVICE_ID_REQUIRED, true
	case "DUPLICATE_MESSAGE":
		return ErrorCode_DUPLICATE_MESSAGE, true
	case "ENCRYPTION_NOT_CONFIGURED":
		return ErrorCode_ENCRYPTION_NOT_CONFIGURED, true
	case "ENCRYPTION_REQUIRED":
		return ErrorCode_ENCRYPTION_REQUIRED, true
	case "INCORRECT_KEY":
		return ErrorCode_INCORRECT_KEY, true
	}
	return 0, false
}

func ErrorCodeKnows(value uint16) bool {
	for _, typeValue := range ErrorCodeValues {
		if uint16(typeValue) == value {
			return true
		}
	}
	return false
}

func CastErrorCode(structType interface{}) ErrorCode {
	castFunc := func(typ interface{}) ErrorCode {
		if sErrorCode, ok := typ.(ErrorCode); ok {
			return sErrorCode
		}
		return 0
	}
	return castFunc(structType)
}

func (m ErrorCode) GetLengthInBits() uint16 {
	return 16
}

func (m ErrorCode) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func ErrorCodeParse(readBuffer utils.ReadBuffer) (ErrorCode, error) {
	val, err := readBuffer.ReadUint16("ErrorCode", 16)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ErrorCode")
	}
	if enum, ok := ErrorCodeByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return ErrorCode(val), nil
	} else {
		return enum, nil
	}
}

func (e ErrorCode) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint16("ErrorCode", 16, uint16(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ErrorCode) PLC4XEnumName() string {
	switch e {
	case ErrorCode_OTHER:
		return "OTHER"
	case ErrorCode_VENDOR_PROPRIETARY_VALUE:
		return "VENDOR_PROPRIETARY_VALUE"
	case ErrorCode_KEY_UPDATE_IN_PROGRESS:
		return "KEY_UPDATE_IN_PROGRESS"
	case ErrorCode_MALFORMED_MESSAGE:
		return "MALFORMED_MESSAGE"
	case ErrorCode_NOT_KEY_SERVER:
		return "NOT_KEY_SERVER"
	case ErrorCode_SECURITY_NOT_CONFIGURED:
		return "SECURITY_NOT_CONFIGURED"
	case ErrorCode_SOURCE_SECURITY_REQUIRED:
		return "SOURCE_SECURITY_REQUIRED"
	case ErrorCode_TOO_MANY_KEYS:
		return "TOO_MANY_KEYS"
	case ErrorCode_UNKNOWN_AUTHENTICATION_TYPE:
		return "UNKNOWN_AUTHENTICATION_TYPE"
	case ErrorCode_UNKNOWN_KEY:
		return "UNKNOWN_KEY"
	case ErrorCode_UNKNOWN_KEY_REVISION:
		return "UNKNOWN_KEY_REVISION"
	case ErrorCode_UNKNOWN_SOURCE_MESSAGE:
		return "UNKNOWN_SOURCE_MESSAGE"
	case ErrorCode_NOT_ROUTER_TO_DNET:
		return "NOT_ROUTER_TO_DNET"
	case ErrorCode_ROUTER_BUSY:
		return "ROUTER_BUSY"
	case ErrorCode_UNKNOWN_NETWORK_MESSAGE:
		return "UNKNOWN_NETWORK_MESSAGE"
	case ErrorCode_MESSAGE_TOO_LONG:
		return "MESSAGE_TOO_LONG"
	case ErrorCode_SECURITY_ERROR:
		return "SECURITY_ERROR"
	case ErrorCode_ADDRESSING_ERROR:
		return "ADDRESSING_ERROR"
	case ErrorCode_WRITE_BDT_FAILED:
		return "WRITE_BDT_FAILED"
	case ErrorCode_READ_BDT_FAILED:
		return "READ_BDT_FAILED"
	case ErrorCode_REGISTER_FOREIGN_DEVICE_FAILED:
		return "REGISTER_FOREIGN_DEVICE_FAILED"
	case ErrorCode_READ_FDT_FAILED:
		return "READ_FDT_FAILED"
	case ErrorCode_DELETE_FDT_ENTRY_FAILED:
		return "DELETE_FDT_ENTRY_FAILED"
	case ErrorCode_DISTRIBUTE_BROADCAST_FAILED:
		return "DISTRIBUTE_BROADCAST_FAILED"
	case ErrorCode_UNKNOWN_FILE_SIZE:
		return "UNKNOWN_FILE_SIZE"
	case ErrorCode_ABORT_APDU_TOO_LONG:
		return "ABORT_APDU_TOO_LONG"
	case ErrorCode_ABORT_APPLICATION_EXCEEDED_REPLY_TIME:
		return "ABORT_APPLICATION_EXCEEDED_REPLY_TIME"
	case ErrorCode_ABORT_OUT_OF_RESOURCES:
		return "ABORT_OUT_OF_RESOURCES"
	case ErrorCode_ABORT_TSM_TIMEOUT:
		return "ABORT_TSM_TIMEOUT"
	case ErrorCode_ABORT_WINDOW_SIZE_OUT_OF_RANGE:
		return "ABORT_WINDOW_SIZE_OUT_OF_RANGE"
	case ErrorCode_FILE_FULL:
		return "FILE_FULL"
	case ErrorCode_INCONSISTENT_CONFIGURATION:
		return "INCONSISTENT_CONFIGURATION"
	case ErrorCode_D_PARAMETER_DATA_TYPE:
		return "D_PARAMETER_DATA_TYPE"
	case ErrorCode_INCONSISTENT_OBJECT_TYPE:
		return "INCONSISTENT_OBJECT_TYPE"
	case ErrorCode_INTERNAL_ERROR:
		return "INTERNAL_ERROR"
	case ErrorCode_NOT_CONFIGURED:
		return "NOT_CONFIGURED"
	case ErrorCode_OUT_OF_MEMORY:
		return "OUT_OF_MEMORY"
	case ErrorCode_VALUE_TOO_LONG:
		return "VALUE_TOO_LONG"
	case ErrorCode_ABORT_INSUFFICIENT_SECURITY:
		return "ABORT_INSUFFICIENT_SECURITY"
	case ErrorCode_ABORT_SECURITY_ERROR:
		return "ABORT_SECURITY_ERROR"
	case ErrorCode_DUPLICATE_ENTRY:
		return "DUPLICATE_ENTRY"
	case ErrorCode_INVALID_VALUE_IN_THIS_STATE:
		return "INVALID_VALUE_IN_THIS_STATE"
	case ErrorCode_INVALID_TIMESTAMP:
		return "INVALID_TIMESTAMP"
	case ErrorCode_MISSING_REQUIRED_PARAMETER:
		return "MISSING_REQUIRED_PARAMETER"
	case ErrorCode_NO_OBJECTS_OF_SPECIFIED_TYPE:
		return "NO_OBJECTS_OF_SPECIFIED_TYPE"
	case ErrorCode_NO_SPACE_FOR_OBJECT:
		return "NO_SPACE_FOR_OBJECT"
	case ErrorCode_NO_SPACE_TO_ADD_LIST_ELEMENT:
		return "NO_SPACE_TO_ADD_LIST_ELEMENT"
	case ErrorCode_CONFIGURATION_IN_PROGRESS:
		return "CONFIGURATION_IN_PROGRESS"
	case ErrorCode_NO_SPACE_TO_WRITE_PROPERTY:
		return "NO_SPACE_TO_WRITE_PROPERTY"
	case ErrorCode_NO_VT_SESSIONS_AVAILABLE:
		return "NO_VT_SESSIONS_AVAILABLE"
	case ErrorCode_PROPERTY_IS_NOT_A_LIST:
		return "PROPERTY_IS_NOT_A_LIST"
	case ErrorCode_OBJECT_DELETION_NOT_PERMITTED:
		return "OBJECT_DELETION_NOT_PERMITTED"
	case ErrorCode_OBJECT_IDENTIFIER_ALREADY_EXISTS:
		return "OBJECT_IDENTIFIER_ALREADY_EXISTS"
	case ErrorCode_OPERATIONAL_PROBLEM:
		return "OPERATIONAL_PROBLEM"
	case ErrorCode_PASSWORD_FAILURE:
		return "PASSWORD_FAILURE"
	case ErrorCode_READ_ACCESS_DENIED:
		return "READ_ACCESS_DENIED"
	case ErrorCode_SERVICE_REQUEST_DENIED:
		return "SERVICE_REQUEST_DENIED"
	case ErrorCode_DEVICE_BUSY:
		return "DEVICE_BUSY"
	case ErrorCode_TIMEOUT:
		return "TIMEOUT"
	case ErrorCode_UNKNOWN_OBJECT:
		return "UNKNOWN_OBJECT"
	case ErrorCode_UNKNOWN_PROPERTY:
		return "UNKNOWN_PROPERTY"
	case ErrorCode_UNKNOWN_VT_CLASS:
		return "UNKNOWN_VT_CLASS"
	case ErrorCode_UNKNOWN_VT_SESSION:
		return "UNKNOWN_VT_SESSION"
	case ErrorCode_UNSUPPORTED_OBJECT_TYPE:
		return "UNSUPPORTED_OBJECT_TYPE"
	case ErrorCode_VALUE_OUT_OF_RANGE:
		return "VALUE_OUT_OF_RANGE"
	case ErrorCode_VT_SESSION_ALREADY_CLOSED:
		return "VT_SESSION_ALREADY_CLOSED"
	case ErrorCode_VT_SESSION_TERMINATION_FAILURE:
		return "VT_SESSION_TERMINATION_FAILURE"
	case ErrorCode_DYNAMIC_CREATION_NOT_SUPPORTED:
		return "DYNAMIC_CREATION_NOT_SUPPORTED"
	case ErrorCode_WRITE_ACCESS_DENIED:
		return "WRITE_ACCESS_DENIED"
	case ErrorCode_CHARACTER_SET_NOT_SUPPORTED:
		return "CHARACTER_SET_NOT_SUPPORTED"
	case ErrorCode_INVALID_ARRAY_INDEX:
		return "INVALID_ARRAY_INDEX"
	case ErrorCode_COV_SUBSCRIPTION_FAILED:
		return "COV_SUBSCRIPTION_FAILED"
	case ErrorCode_NOT_COV_PROPERTY:
		return "NOT_COV_PROPERTY"
	case ErrorCode_OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED:
		return "OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED"
	case ErrorCode_INVALID_CONFIGURATION_DATA:
		return "INVALID_CONFIGURATION_DATA"
	case ErrorCode_DATATYPE_NOT_SUPPORTED:
		return "DATATYPE_NOT_SUPPORTED"
	case ErrorCode_DUPLICATE_NAME:
		return "DUPLICATE_NAME"
	case ErrorCode_DUPLICATE_OBJECT_ID:
		return "DUPLICATE_OBJECT_ID"
	case ErrorCode_FILE_ACCESS_DENIED:
		return "FILE_ACCESS_DENIED"
	case ErrorCode_PROPERTY_IS_NOT_AN_ARRAY:
		return "PROPERTY_IS_NOT_AN_ARRAY"
	case ErrorCode_ABORT_BUFFER_OVERFLOW:
		return "ABORT_BUFFER_OVERFLOW"
	case ErrorCode_ABORT_INVALID_APDU_IN_THIS_STATE:
		return "ABORT_INVALID_APDU_IN_THIS_STATE"
	case ErrorCode_ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK:
		return "ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK"
	case ErrorCode_ABORT_SEGMENTATION_NOT_SUPPORTED:
		return "ABORT_SEGMENTATION_NOT_SUPPORTED"
	case ErrorCode_ABORT_PROPRIETARY:
		return "ABORT_PROPRIETARY"
	case ErrorCode_ABORT_OTHER:
		return "ABORT_OTHER"
	case ErrorCode_INVALID_TAG:
		return "INVALID_TAG"
	case ErrorCode_NETWORK_DOWN:
		return "NETWORK_DOWN"
	case ErrorCode_REJECT_BUFFER_OVERFLOW:
		return "REJECT_BUFFER_OVERFLOW"
	case ErrorCode_REJECT_INCONSISTENT_PARAMETERS:
		return "REJECT_INCONSISTENT_PARAMETERS"
	case ErrorCode_REJECT_INVALID_PARAMETER_DATA_TYPE:
		return "REJECT_INVALID_PARAMETER_DATA_TYPE"
	case ErrorCode_REJECT_INVALID_TAG:
		return "REJECT_INVALID_TAG"
	case ErrorCode_REJECT_MISSING_REQUIRED_PARAMETER:
		return "REJECT_MISSING_REQUIRED_PARAMETER"
	case ErrorCode_REJECT_PARAMETER_OUT_OF_RANGE:
		return "REJECT_PARAMETER_OUT_OF_RANGE"
	case ErrorCode_REJECT_TOO_MANY_ARGUMENTS:
		return "REJECT_TOO_MANY_ARGUMENTS"
	case ErrorCode_REJECT_UNDEFINED_ENUMERATION:
		return "REJECT_UNDEFINED_ENUMERATION"
	case ErrorCode_REJECT_UNRECOGNIZED_SERVICE:
		return "REJECT_UNRECOGNIZED_SERVICE"
	case ErrorCode_REJECT_PROPRIETARY:
		return "REJECT_PROPRIETARY"
	case ErrorCode_REJECT_OTHER:
		return "REJECT_OTHER"
	case ErrorCode_INCONSISTENT_PARAMETERS:
		return "INCONSISTENT_PARAMETERS"
	case ErrorCode_UNKNOWN_DEVICE:
		return "UNKNOWN_DEVICE"
	case ErrorCode_UNKNOWN_ROUTE:
		return "UNKNOWN_ROUTE"
	case ErrorCode_VALUE_NOT_INITIALIZED:
		return "VALUE_NOT_INITIALIZED"
	case ErrorCode_NO_ALARM_CONFIGURED:
		return "NO_ALARM_CONFIGURED"
	case ErrorCode_LOG_BUFFER_FULL:
		return "LOG_BUFFER_FULL"
	case ErrorCode_LOGGED_VALUE_PURGED:
		return "LOGGED_VALUE_PURGED"
	case ErrorCode_NO_PROPERTY_SPECIFIED:
		return "NO_PROPERTY_SPECIFIED"
	case ErrorCode_NOT_CONFIGURED_FOR_TRIGGERED_LOGGING:
		return "NOT_CONFIGURED_FOR_TRIGGERED_LOGGING"
	case ErrorCode_UNKNOWN_SUBSCRIPTION:
		return "UNKNOWN_SUBSCRIPTION"
	case ErrorCode_INCONSISTENT_SELECTION_CRITERION:
		return "INCONSISTENT_SELECTION_CRITERION"
	case ErrorCode_PARAMETER_OUT_OF_RANGE:
		return "PARAMETER_OUT_OF_RANGE"
	case ErrorCode_LIST_ELEMENT_NOT_FOUND:
		return "LIST_ELEMENT_NOT_FOUND"
	case ErrorCode_Busy:
		return "Busy"
	case ErrorCode_COMMUNICATION_DISABLED:
		return "COMMUNICATION_DISABLED"
	case ErrorCode_SUCCESS:
		return "SUCCESS"
	case ErrorCode_ACCESS_DENIED:
		return "ACCESS_DENIED"
	case ErrorCode_BAD_DESTINATION_ADDRESS:
		return "BAD_DESTINATION_ADDRESS"
	case ErrorCode_BAD_DESTINATION_DEVICE_ID:
		return "BAD_DESTINATION_DEVICE_ID"
	case ErrorCode_BAD_SIGNATURE:
		return "BAD_SIGNATURE"
	case ErrorCode_BAD_SOURCE_ADDRESS:
		return "BAD_SOURCE_ADDRESS"
	case ErrorCode_INVALID_DATA_TYPE:
		return "INVALID_DATA_TYPE"
	case ErrorCode_BAD_TIMESTAMP:
		return "BAD_TIMESTAMP"
	case ErrorCode_CANNOT_USE_KEY:
		return "CANNOT_USE_KEY"
	case ErrorCode_CANNOT_VERIFY_MESSAGE_ID:
		return "CANNOT_VERIFY_MESSAGE_ID"
	case ErrorCode_CORRECT_KEY_REVISION:
		return "CORRECT_KEY_REVISION"
	case ErrorCode_DESTINATION_DEVICE_ID_REQUIRED:
		return "DESTINATION_DEVICE_ID_REQUIRED"
	case ErrorCode_DUPLICATE_MESSAGE:
		return "DUPLICATE_MESSAGE"
	case ErrorCode_ENCRYPTION_NOT_CONFIGURED:
		return "ENCRYPTION_NOT_CONFIGURED"
	case ErrorCode_ENCRYPTION_REQUIRED:
		return "ENCRYPTION_REQUIRED"
	case ErrorCode_INCORRECT_KEY:
		return "INCORRECT_KEY"
	}
	return ""
}

func (e ErrorCode) String() string {
	return e.PLC4XEnumName()
}
