/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAckAtomicReadFileRecord is the corresponding interface of BACnetServiceAckAtomicReadFileRecord
type BACnetServiceAckAtomicReadFileRecord interface {
	utils.LengthAware
	utils.Serializable
	BACnetServiceAckAtomicReadFileStreamOrRecord
	// GetFileStartRecord returns FileStartRecord (property field)
	GetFileStartRecord() BACnetApplicationTagSignedInteger
	// GetReturnedRecordCount returns ReturnedRecordCount (property field)
	GetReturnedRecordCount() BACnetApplicationTagUnsignedInteger
	// GetFileRecordData returns FileRecordData (property field)
	GetFileRecordData() []BACnetApplicationTagOctetString
}

// BACnetServiceAckAtomicReadFileRecordExactly can be used when we want exactly this type and not a type which fulfills BACnetServiceAckAtomicReadFileRecord.
// This is useful for switch cases.
type BACnetServiceAckAtomicReadFileRecordExactly interface {
	BACnetServiceAckAtomicReadFileRecord
	isBACnetServiceAckAtomicReadFileRecord() bool
}

// _BACnetServiceAckAtomicReadFileRecord is the data-structure of this message
type _BACnetServiceAckAtomicReadFileRecord struct {
	*_BACnetServiceAckAtomicReadFileStreamOrRecord
	FileStartRecord     BACnetApplicationTagSignedInteger
	ReturnedRecordCount BACnetApplicationTagUnsignedInteger
	FileRecordData      []BACnetApplicationTagOctetString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetServiceAckAtomicReadFileRecord) InitializeParent(parent BACnetServiceAckAtomicReadFileStreamOrRecord, peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, closingTag BACnetClosingTag) {
	m.PeekedTagHeader = peekedTagHeader
	m.OpeningTag = openingTag
	m.ClosingTag = closingTag
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetParent() BACnetServiceAckAtomicReadFileStreamOrRecord {
	return m._BACnetServiceAckAtomicReadFileStreamOrRecord
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetServiceAckAtomicReadFileRecord) GetFileStartRecord() BACnetApplicationTagSignedInteger {
	return m.FileStartRecord
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetReturnedRecordCount() BACnetApplicationTagUnsignedInteger {
	return m.ReturnedRecordCount
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetFileRecordData() []BACnetApplicationTagOctetString {
	return m.FileRecordData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetServiceAckAtomicReadFileRecord factory function for _BACnetServiceAckAtomicReadFileRecord
func NewBACnetServiceAckAtomicReadFileRecord(fileStartRecord BACnetApplicationTagSignedInteger, returnedRecordCount BACnetApplicationTagUnsignedInteger, fileRecordData []BACnetApplicationTagOctetString, peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, closingTag BACnetClosingTag) *_BACnetServiceAckAtomicReadFileRecord {
	_result := &_BACnetServiceAckAtomicReadFileRecord{
		FileStartRecord:     fileStartRecord,
		ReturnedRecordCount: returnedRecordCount,
		FileRecordData:      fileRecordData,
		_BACnetServiceAckAtomicReadFileStreamOrRecord: NewBACnetServiceAckAtomicReadFileStreamOrRecord(peekedTagHeader, openingTag, closingTag),
	}
	_result._BACnetServiceAckAtomicReadFileStreamOrRecord._BACnetServiceAckAtomicReadFileStreamOrRecordChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetServiceAckAtomicReadFileRecord(structType interface{}) BACnetServiceAckAtomicReadFileRecord {
	if casted, ok := structType.(BACnetServiceAckAtomicReadFileRecord); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAckAtomicReadFileRecord); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetTypeName() string {
	return "BACnetServiceAckAtomicReadFileRecord"
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (fileStartRecord)
	lengthInBits += m.FileStartRecord.GetLengthInBits()

	// Simple field (returnedRecordCount)
	lengthInBits += m.ReturnedRecordCount.GetLengthInBits()

	// Array field
	if len(m.FileRecordData) > 0 {
		for i, element := range m.FileRecordData {
			last := i == len(m.FileRecordData)-1
			lengthInBits += element.(interface{ GetLengthInBitsConditional(bool) uint16 }).GetLengthInBitsConditional(last)
		}
	}

	return lengthInBits
}

func (m *_BACnetServiceAckAtomicReadFileRecord) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetServiceAckAtomicReadFileRecordParse(readBuffer utils.ReadBuffer) (BACnetServiceAckAtomicReadFileRecord, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAckAtomicReadFileRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAckAtomicReadFileRecord")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (fileStartRecord)
	if pullErr := readBuffer.PullContext("fileStartRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for fileStartRecord")
	}
	_fileStartRecord, _fileStartRecordErr := BACnetApplicationTagParse(readBuffer)
	if _fileStartRecordErr != nil {
		return nil, errors.Wrap(_fileStartRecordErr, "Error parsing 'fileStartRecord' field of BACnetServiceAckAtomicReadFileRecord")
	}
	fileStartRecord := _fileStartRecord.(BACnetApplicationTagSignedInteger)
	if closeErr := readBuffer.CloseContext("fileStartRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for fileStartRecord")
	}

	// Simple Field (returnedRecordCount)
	if pullErr := readBuffer.PullContext("returnedRecordCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for returnedRecordCount")
	}
	_returnedRecordCount, _returnedRecordCountErr := BACnetApplicationTagParse(readBuffer)
	if _returnedRecordCountErr != nil {
		return nil, errors.Wrap(_returnedRecordCountErr, "Error parsing 'returnedRecordCount' field of BACnetServiceAckAtomicReadFileRecord")
	}
	returnedRecordCount := _returnedRecordCount.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("returnedRecordCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for returnedRecordCount")
	}

	// Array field (fileRecordData)
	if pullErr := readBuffer.PullContext("fileRecordData", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for fileRecordData")
	}
	// Count array
	fileRecordData := make([]BACnetApplicationTagOctetString, returnedRecordCount.GetPayload().GetActualValue())
	// This happens when the size is set conditional to 0
	if len(fileRecordData) == 0 {
		fileRecordData = nil
	}
	{
		for curItem := uint16(0); curItem < uint16(returnedRecordCount.GetPayload().GetActualValue()); curItem++ {
			_item, _err := BACnetApplicationTagParse(readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'fileRecordData' field of BACnetServiceAckAtomicReadFileRecord")
			}
			fileRecordData[curItem] = _item.(BACnetApplicationTagOctetString)
		}
	}
	if closeErr := readBuffer.CloseContext("fileRecordData", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for fileRecordData")
	}

	if closeErr := readBuffer.CloseContext("BACnetServiceAckAtomicReadFileRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAckAtomicReadFileRecord")
	}

	// Create a partially initialized instance
	_child := &_BACnetServiceAckAtomicReadFileRecord{
		_BACnetServiceAckAtomicReadFileStreamOrRecord: &_BACnetServiceAckAtomicReadFileStreamOrRecord{},
		FileStartRecord:     fileStartRecord,
		ReturnedRecordCount: returnedRecordCount,
		FileRecordData:      fileRecordData,
	}
	_child._BACnetServiceAckAtomicReadFileStreamOrRecord._BACnetServiceAckAtomicReadFileStreamOrRecordChildRequirements = _child
	return _child, nil
}

func (m *_BACnetServiceAckAtomicReadFileRecord) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetServiceAckAtomicReadFileRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetServiceAckAtomicReadFileRecord")
		}

		// Simple Field (fileStartRecord)
		if pushErr := writeBuffer.PushContext("fileStartRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for fileStartRecord")
		}
		_fileStartRecordErr := writeBuffer.WriteSerializable(m.GetFileStartRecord())
		if popErr := writeBuffer.PopContext("fileStartRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for fileStartRecord")
		}
		if _fileStartRecordErr != nil {
			return errors.Wrap(_fileStartRecordErr, "Error serializing 'fileStartRecord' field")
		}

		// Simple Field (returnedRecordCount)
		if pushErr := writeBuffer.PushContext("returnedRecordCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for returnedRecordCount")
		}
		_returnedRecordCountErr := writeBuffer.WriteSerializable(m.GetReturnedRecordCount())
		if popErr := writeBuffer.PopContext("returnedRecordCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for returnedRecordCount")
		}
		if _returnedRecordCountErr != nil {
			return errors.Wrap(_returnedRecordCountErr, "Error serializing 'returnedRecordCount' field")
		}

		// Array Field (fileRecordData)
		if pushErr := writeBuffer.PushContext("fileRecordData", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for fileRecordData")
		}
		for _, _element := range m.GetFileRecordData() {
			_elementErr := writeBuffer.WriteSerializable(_element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'fileRecordData' field")
			}
		}
		if popErr := writeBuffer.PopContext("fileRecordData", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for fileRecordData")
		}

		if popErr := writeBuffer.PopContext("BACnetServiceAckAtomicReadFileRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetServiceAckAtomicReadFileRecord")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetServiceAckAtomicReadFileRecord) isBACnetServiceAckAtomicReadFileRecord() bool {
	return true
}

func (m *_BACnetServiceAckAtomicReadFileRecord) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
