/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesDoorAlarmState is the corresponding interface of BACnetPropertyStatesDoorAlarmState
type BACnetPropertyStatesDoorAlarmState interface {
	utils.LengthAware
	utils.Serializable
	BACnetPropertyStates
	// GetDoorAlarmState returns DoorAlarmState (property field)
	GetDoorAlarmState() BACnetDoorAlarmStateTagged
}

// BACnetPropertyStatesDoorAlarmStateExactly can be used when we want exactly this type and not a type which fulfills BACnetPropertyStatesDoorAlarmState.
// This is useful for switch cases.
type BACnetPropertyStatesDoorAlarmStateExactly interface {
	BACnetPropertyStatesDoorAlarmState
	isBACnetPropertyStatesDoorAlarmState() bool
}

// _BACnetPropertyStatesDoorAlarmState is the data-structure of this message
type _BACnetPropertyStatesDoorAlarmState struct {
	*_BACnetPropertyStates
	DoorAlarmState BACnetDoorAlarmStateTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesDoorAlarmState) InitializeParent(parent BACnetPropertyStates, peekedTagHeader BACnetTagHeader) {
	m.PeekedTagHeader = peekedTagHeader
}

func (m *_BACnetPropertyStatesDoorAlarmState) GetParent() BACnetPropertyStates {
	return m._BACnetPropertyStates
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesDoorAlarmState) GetDoorAlarmState() BACnetDoorAlarmStateTagged {
	return m.DoorAlarmState
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetPropertyStatesDoorAlarmState factory function for _BACnetPropertyStatesDoorAlarmState
func NewBACnetPropertyStatesDoorAlarmState(doorAlarmState BACnetDoorAlarmStateTagged, peekedTagHeader BACnetTagHeader) *_BACnetPropertyStatesDoorAlarmState {
	_result := &_BACnetPropertyStatesDoorAlarmState{
		DoorAlarmState:        doorAlarmState,
		_BACnetPropertyStates: NewBACnetPropertyStates(peekedTagHeader),
	}
	_result._BACnetPropertyStates._BACnetPropertyStatesChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesDoorAlarmState(structType interface{}) BACnetPropertyStatesDoorAlarmState {
	if casted, ok := structType.(BACnetPropertyStatesDoorAlarmState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesDoorAlarmState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesDoorAlarmState) GetTypeName() string {
	return "BACnetPropertyStatesDoorAlarmState"
}

func (m *_BACnetPropertyStatesDoorAlarmState) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetPropertyStatesDoorAlarmState) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (doorAlarmState)
	lengthInBits += m.DoorAlarmState.GetLengthInBits()

	return lengthInBits
}

func (m *_BACnetPropertyStatesDoorAlarmState) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetPropertyStatesDoorAlarmStateParse(readBuffer utils.ReadBuffer, peekedTagNumber uint8) (BACnetPropertyStatesDoorAlarmState, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesDoorAlarmState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesDoorAlarmState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (doorAlarmState)
	if pullErr := readBuffer.PullContext("doorAlarmState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for doorAlarmState")
	}
	_doorAlarmState, _doorAlarmStateErr := BACnetDoorAlarmStateTaggedParse(readBuffer, uint8(peekedTagNumber), TagClass(TagClass_CONTEXT_SPECIFIC_TAGS))
	if _doorAlarmStateErr != nil {
		return nil, errors.Wrap(_doorAlarmStateErr, "Error parsing 'doorAlarmState' field of BACnetPropertyStatesDoorAlarmState")
	}
	doorAlarmState := _doorAlarmState.(BACnetDoorAlarmStateTagged)
	if closeErr := readBuffer.CloseContext("doorAlarmState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for doorAlarmState")
	}

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesDoorAlarmState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesDoorAlarmState")
	}

	// Create a partially initialized instance
	_child := &_BACnetPropertyStatesDoorAlarmState{
		_BACnetPropertyStates: &_BACnetPropertyStates{},
		DoorAlarmState:        doorAlarmState,
	}
	_child._BACnetPropertyStates._BACnetPropertyStatesChildRequirements = _child
	return _child, nil
}

func (m *_BACnetPropertyStatesDoorAlarmState) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesDoorAlarmState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesDoorAlarmState")
		}

		// Simple Field (doorAlarmState)
		if pushErr := writeBuffer.PushContext("doorAlarmState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for doorAlarmState")
		}
		_doorAlarmStateErr := writeBuffer.WriteSerializable(m.GetDoorAlarmState())
		if popErr := writeBuffer.PopContext("doorAlarmState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for doorAlarmState")
		}
		if _doorAlarmStateErr != nil {
			return errors.Wrap(_doorAlarmStateErr, "Error serializing 'doorAlarmState' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesDoorAlarmState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesDoorAlarmState")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesDoorAlarmState) isBACnetPropertyStatesDoorAlarmState() bool {
	return true
}

func (m *_BACnetPropertyStatesDoorAlarmState) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
