/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPolarity is an enum
type BACnetPolarity uint8

type IBACnetPolarity interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	BACnetPolarity_NORMAL  BACnetPolarity = 0
	BACnetPolarity_REVERSE BACnetPolarity = 1
)

var BACnetPolarityValues []BACnetPolarity

func init() {
	_ = errors.New
	BACnetPolarityValues = []BACnetPolarity{
		BACnetPolarity_NORMAL,
		BACnetPolarity_REVERSE,
	}
}

func BACnetPolarityByValue(value uint8) (enum BACnetPolarity, ok bool) {
	switch value {
	case 0:
		return BACnetPolarity_NORMAL, true
	case 1:
		return BACnetPolarity_REVERSE, true
	}
	return 0, false
}

func BACnetPolarityByName(value string) (enum BACnetPolarity, ok bool) {
	switch value {
	case "NORMAL":
		return BACnetPolarity_NORMAL, true
	case "REVERSE":
		return BACnetPolarity_REVERSE, true
	}
	return 0, false
}

func BACnetPolarityKnows(value uint8) bool {
	for _, typeValue := range BACnetPolarityValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetPolarity(structType interface{}) BACnetPolarity {
	castFunc := func(typ interface{}) BACnetPolarity {
		if sBACnetPolarity, ok := typ.(BACnetPolarity); ok {
			return sBACnetPolarity
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetPolarity) GetLengthInBits() uint16 {
	return 8
}

func (m BACnetPolarity) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetPolarityParse(readBuffer utils.ReadBuffer) (BACnetPolarity, error) {
	val, err := readBuffer.ReadUint8("BACnetPolarity", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetPolarity")
	}
	if enum, ok := BACnetPolarityByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return BACnetPolarity(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetPolarity) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint8("BACnetPolarity", 8, uint8(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetPolarity) PLC4XEnumName() string {
	switch e {
	case BACnetPolarity_NORMAL:
		return "NORMAL"
	case BACnetPolarity_REVERSE:
		return "REVERSE"
	}
	return ""
}

func (e BACnetPolarity) String() string {
	return e.PLC4XEnumName()
}
