/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalBinaryPV is the corresponding interface of BACnetOptionalBinaryPV
type BACnetOptionalBinaryPV interface {
	utils.LengthAware
	utils.Serializable
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
}

// BACnetOptionalBinaryPVExactly can be used when we want exactly this type and not a type which fulfills BACnetOptionalBinaryPV.
// This is useful for switch cases.
type BACnetOptionalBinaryPVExactly interface {
	BACnetOptionalBinaryPV
	isBACnetOptionalBinaryPV() bool
}

// _BACnetOptionalBinaryPV is the data-structure of this message
type _BACnetOptionalBinaryPV struct {
	_BACnetOptionalBinaryPVChildRequirements
	PeekedTagHeader BACnetTagHeader
}

type _BACnetOptionalBinaryPVChildRequirements interface {
	utils.Serializable
	GetLengthInBits() uint16
	GetLengthInBitsConditional(lastItem bool) uint16
}

type BACnetOptionalBinaryPVParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child BACnetOptionalBinaryPV, serializeChildFunction func() error) error
	GetTypeName() string
}

type BACnetOptionalBinaryPVChild interface {
	utils.Serializable
	InitializeParent(parent BACnetOptionalBinaryPV, peekedTagHeader BACnetTagHeader)
	GetParent() *BACnetOptionalBinaryPV

	GetTypeName() string
	BACnetOptionalBinaryPV
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalBinaryPV) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetOptionalBinaryPV) GetPeekedTagNumber() uint8 {
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetOptionalBinaryPV factory function for _BACnetOptionalBinaryPV
func NewBACnetOptionalBinaryPV(peekedTagHeader BACnetTagHeader) *_BACnetOptionalBinaryPV {
	return &_BACnetOptionalBinaryPV{PeekedTagHeader: peekedTagHeader}
}

// Deprecated: use the interface for direct cast
func CastBACnetOptionalBinaryPV(structType interface{}) BACnetOptionalBinaryPV {
	if casted, ok := structType.(BACnetOptionalBinaryPV); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalBinaryPV); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalBinaryPV) GetTypeName() string {
	return "BACnetOptionalBinaryPV"
}

func (m *_BACnetOptionalBinaryPV) GetParentLengthInBits() uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetOptionalBinaryPV) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetOptionalBinaryPVParse(readBuffer utils.ReadBuffer) (BACnetOptionalBinaryPV, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalBinaryPV"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalBinaryPV")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Peek Field (peekedTagHeader)
	currentPos = positionAware.GetPos()
	if pullErr := readBuffer.PullContext("peekedTagHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for peekedTagHeader")
	}
	peekedTagHeader, _ := BACnetTagHeaderParse(readBuffer)
	readBuffer.Reset(currentPos)

	// Virtual field
	_peekedTagNumber := peekedTagHeader.GetActualTagNumber()
	peekedTagNumber := uint8(_peekedTagNumber)
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type BACnetOptionalBinaryPVChildSerializeRequirement interface {
		BACnetOptionalBinaryPV
		InitializeParent(BACnetOptionalBinaryPV, BACnetTagHeader)
		GetParent() BACnetOptionalBinaryPV
	}
	var _childTemp interface{}
	var _child BACnetOptionalBinaryPVChildSerializeRequirement
	var typeSwitchError error
	switch {
	case peekedTagNumber == uint8(0): // BACnetOptionalBinaryPVNull
		_childTemp, typeSwitchError = BACnetOptionalBinaryPVNullParse(readBuffer)
	case 0 == 0: // BACnetOptionalBinaryPVValue
		_childTemp, typeSwitchError = BACnetOptionalBinaryPVValueParse(readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of BACnetOptionalBinaryPV")
	}
	_child = _childTemp.(BACnetOptionalBinaryPVChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("BACnetOptionalBinaryPV"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalBinaryPV")
	}

	// Finish initializing
	_child.InitializeParent(_child, peekedTagHeader)
	return _child, nil
}

func (pm *_BACnetOptionalBinaryPV) SerializeParent(writeBuffer utils.WriteBuffer, child BACnetOptionalBinaryPV, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("BACnetOptionalBinaryPV"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetOptionalBinaryPV")
	}
	// Virtual field
	if _peekedTagNumberErr := writeBuffer.WriteVirtual("peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetOptionalBinaryPV"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetOptionalBinaryPV")
	}
	return nil
}

func (m *_BACnetOptionalBinaryPV) isBACnetOptionalBinaryPV() bool {
	return true
}

func (m *_BACnetOptionalBinaryPV) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
