/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"io"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParametersExtendedParameters is the corresponding interface of BACnetNotificationParametersExtendedParameters
type BACnetNotificationParametersExtendedParameters interface {
	utils.LengthAware
	utils.Serializable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetNullValue returns NullValue (property field)
	GetNullValue() BACnetApplicationTagNull
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetApplicationTagUnsignedInteger
	// GetBooleanValue returns BooleanValue (property field)
	GetBooleanValue() BACnetApplicationTagBoolean
	// GetIntegerValue returns IntegerValue (property field)
	GetIntegerValue() BACnetApplicationTagSignedInteger
	// GetDoubleValue returns DoubleValue (property field)
	GetDoubleValue() BACnetApplicationTagDouble
	// GetOctetStringValue returns OctetStringValue (property field)
	GetOctetStringValue() BACnetApplicationTagOctetString
	// GetCharacterStringValue returns CharacterStringValue (property field)
	GetCharacterStringValue() BACnetApplicationTagCharacterString
	// GetBitStringValue returns BitStringValue (property field)
	GetBitStringValue() BACnetApplicationTagBitString
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// GetDateValue returns DateValue (property field)
	GetDateValue() BACnetApplicationTagDate
	// GetTimeValue returns TimeValue (property field)
	GetTimeValue() BACnetApplicationTagTime
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetApplicationTagObjectIdentifier
	// GetReference returns Reference (property field)
	GetReference() BACnetDeviceObjectPropertyReferenceEnclosed
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetIsOpeningTag returns IsOpeningTag (virtual field)
	GetIsOpeningTag() bool
	// GetIsClosingTag returns IsClosingTag (virtual field)
	GetIsClosingTag() bool
}

// BACnetNotificationParametersExtendedParametersExactly can be used when we want exactly this type and not a type which fulfills BACnetNotificationParametersExtendedParameters.
// This is useful for switch cases.
type BACnetNotificationParametersExtendedParametersExactly interface {
	BACnetNotificationParametersExtendedParameters
	isBACnetNotificationParametersExtendedParameters() bool
}

// _BACnetNotificationParametersExtendedParameters is the data-structure of this message
type _BACnetNotificationParametersExtendedParameters struct {
	OpeningTag           BACnetOpeningTag
	PeekedTagHeader      BACnetTagHeader
	NullValue            BACnetApplicationTagNull
	RealValue            BACnetApplicationTagReal
	UnsignedValue        BACnetApplicationTagUnsignedInteger
	BooleanValue         BACnetApplicationTagBoolean
	IntegerValue         BACnetApplicationTagSignedInteger
	DoubleValue          BACnetApplicationTagDouble
	OctetStringValue     BACnetApplicationTagOctetString
	CharacterStringValue BACnetApplicationTagCharacterString
	BitStringValue       BACnetApplicationTagBitString
	EnumeratedValue      BACnetApplicationTagEnumerated
	DateValue            BACnetApplicationTagDate
	TimeValue            BACnetApplicationTagTime
	ObjectIdentifier     BACnetApplicationTagObjectIdentifier
	Reference            BACnetDeviceObjectPropertyReferenceEnclosed
	ClosingTag           BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParametersExtendedParameters) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetNotificationParametersExtendedParameters) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetNotificationParametersExtendedParameters) GetNullValue() BACnetApplicationTagNull {
	return m.NullValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetUnsignedValue() BACnetApplicationTagUnsignedInteger {
	return m.UnsignedValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetBooleanValue() BACnetApplicationTagBoolean {
	return m.BooleanValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIntegerValue() BACnetApplicationTagSignedInteger {
	return m.IntegerValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetDoubleValue() BACnetApplicationTagDouble {
	return m.DoubleValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetOctetStringValue() BACnetApplicationTagOctetString {
	return m.OctetStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetCharacterStringValue() BACnetApplicationTagCharacterString {
	return m.CharacterStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetBitStringValue() BACnetApplicationTagBitString {
	return m.BitStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetDateValue() BACnetApplicationTagDate {
	return m.DateValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetTimeValue() BACnetApplicationTagTime {
	return m.TimeValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetObjectIdentifier() BACnetApplicationTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetNotificationParametersExtendedParameters) GetReference() BACnetDeviceObjectPropertyReferenceEnclosed {
	return m.Reference
}

func (m *_BACnetNotificationParametersExtendedParameters) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetNotificationParametersExtendedParameters) GetPeekedTagNumber() uint8 {
	nullValue := m.NullValue
	_ = nullValue
	realValue := m.RealValue
	_ = realValue
	unsignedValue := m.UnsignedValue
	_ = unsignedValue
	booleanValue := m.BooleanValue
	_ = booleanValue
	integerValue := m.IntegerValue
	_ = integerValue
	doubleValue := m.DoubleValue
	_ = doubleValue
	octetStringValue := m.OctetStringValue
	_ = octetStringValue
	characterStringValue := m.CharacterStringValue
	_ = characterStringValue
	bitStringValue := m.BitStringValue
	_ = bitStringValue
	enumeratedValue := m.EnumeratedValue
	_ = enumeratedValue
	dateValue := m.DateValue
	_ = dateValue
	timeValue := m.TimeValue
	_ = timeValue
	objectIdentifier := m.ObjectIdentifier
	_ = objectIdentifier
	reference := m.Reference
	_ = reference
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIsOpeningTag() bool {
	nullValue := m.NullValue
	_ = nullValue
	realValue := m.RealValue
	_ = realValue
	unsignedValue := m.UnsignedValue
	_ = unsignedValue
	booleanValue := m.BooleanValue
	_ = booleanValue
	integerValue := m.IntegerValue
	_ = integerValue
	doubleValue := m.DoubleValue
	_ = doubleValue
	octetStringValue := m.OctetStringValue
	_ = octetStringValue
	characterStringValue := m.CharacterStringValue
	_ = characterStringValue
	bitStringValue := m.BitStringValue
	_ = bitStringValue
	enumeratedValue := m.EnumeratedValue
	_ = enumeratedValue
	dateValue := m.DateValue
	_ = dateValue
	timeValue := m.TimeValue
	_ = timeValue
	objectIdentifier := m.ObjectIdentifier
	_ = objectIdentifier
	reference := m.Reference
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x6)))
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIsClosingTag() bool {
	nullValue := m.NullValue
	_ = nullValue
	realValue := m.RealValue
	_ = realValue
	unsignedValue := m.UnsignedValue
	_ = unsignedValue
	booleanValue := m.BooleanValue
	_ = booleanValue
	integerValue := m.IntegerValue
	_ = integerValue
	doubleValue := m.DoubleValue
	_ = doubleValue
	octetStringValue := m.OctetStringValue
	_ = octetStringValue
	characterStringValue := m.CharacterStringValue
	_ = characterStringValue
	bitStringValue := m.BitStringValue
	_ = bitStringValue
	enumeratedValue := m.EnumeratedValue
	_ = enumeratedValue
	dateValue := m.DateValue
	_ = dateValue
	timeValue := m.TimeValue
	_ = timeValue
	objectIdentifier := m.ObjectIdentifier
	_ = objectIdentifier
	reference := m.Reference
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x7)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetNotificationParametersExtendedParameters factory function for _BACnetNotificationParametersExtendedParameters
func NewBACnetNotificationParametersExtendedParameters(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, nullValue BACnetApplicationTagNull, realValue BACnetApplicationTagReal, unsignedValue BACnetApplicationTagUnsignedInteger, booleanValue BACnetApplicationTagBoolean, integerValue BACnetApplicationTagSignedInteger, doubleValue BACnetApplicationTagDouble, octetStringValue BACnetApplicationTagOctetString, characterStringValue BACnetApplicationTagCharacterString, bitStringValue BACnetApplicationTagBitString, enumeratedValue BACnetApplicationTagEnumerated, dateValue BACnetApplicationTagDate, timeValue BACnetApplicationTagTime, objectIdentifier BACnetApplicationTagObjectIdentifier, reference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetNotificationParametersExtendedParameters {
	return &_BACnetNotificationParametersExtendedParameters{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, NullValue: nullValue, RealValue: realValue, UnsignedValue: unsignedValue, BooleanValue: booleanValue, IntegerValue: integerValue, DoubleValue: doubleValue, OctetStringValue: octetStringValue, CharacterStringValue: characterStringValue, BitStringValue: bitStringValue, EnumeratedValue: enumeratedValue, DateValue: dateValue, TimeValue: timeValue, ObjectIdentifier: objectIdentifier, Reference: reference, ClosingTag: closingTag, TagNumber: tagNumber}
}

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParametersExtendedParameters(structType interface{}) BACnetNotificationParametersExtendedParameters {
	if casted, ok := structType.(BACnetNotificationParametersExtendedParameters); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParametersExtendedParameters); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParametersExtendedParameters) GetTypeName() string {
	return "BACnetNotificationParametersExtendedParameters"
}

func (m *_BACnetNotificationParametersExtendedParameters) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetNotificationParametersExtendedParameters) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// Optional Field (nullValue)
	if m.NullValue != nil {
		lengthInBits += m.NullValue.GetLengthInBits()
	}

	// Optional Field (realValue)
	if m.RealValue != nil {
		lengthInBits += m.RealValue.GetLengthInBits()
	}

	// Optional Field (unsignedValue)
	if m.UnsignedValue != nil {
		lengthInBits += m.UnsignedValue.GetLengthInBits()
	}

	// Optional Field (booleanValue)
	if m.BooleanValue != nil {
		lengthInBits += m.BooleanValue.GetLengthInBits()
	}

	// Optional Field (integerValue)
	if m.IntegerValue != nil {
		lengthInBits += m.IntegerValue.GetLengthInBits()
	}

	// Optional Field (doubleValue)
	if m.DoubleValue != nil {
		lengthInBits += m.DoubleValue.GetLengthInBits()
	}

	// Optional Field (octetStringValue)
	if m.OctetStringValue != nil {
		lengthInBits += m.OctetStringValue.GetLengthInBits()
	}

	// Optional Field (characterStringValue)
	if m.CharacterStringValue != nil {
		lengthInBits += m.CharacterStringValue.GetLengthInBits()
	}

	// Optional Field (bitStringValue)
	if m.BitStringValue != nil {
		lengthInBits += m.BitStringValue.GetLengthInBits()
	}

	// Optional Field (enumeratedValue)
	if m.EnumeratedValue != nil {
		lengthInBits += m.EnumeratedValue.GetLengthInBits()
	}

	// Optional Field (dateValue)
	if m.DateValue != nil {
		lengthInBits += m.DateValue.GetLengthInBits()
	}

	// Optional Field (timeValue)
	if m.TimeValue != nil {
		lengthInBits += m.TimeValue.GetLengthInBits()
	}

	// Optional Field (objectIdentifier)
	if m.ObjectIdentifier != nil {
		lengthInBits += m.ObjectIdentifier.GetLengthInBits()
	}

	// Optional Field (reference)
	if m.Reference != nil {
		lengthInBits += m.Reference.GetLengthInBits()
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits()

	return lengthInBits
}

func (m *_BACnetNotificationParametersExtendedParameters) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetNotificationParametersExtendedParametersParse(readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetNotificationParametersExtendedParameters, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParametersExtendedParameters"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParametersExtendedParameters")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (openingTag)
	if pullErr := readBuffer.PullContext("openingTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for openingTag")
	}
	_openingTag, _openingTagErr := BACnetOpeningTagParse(readBuffer, uint8(tagNumber))
	if _openingTagErr != nil {
		return nil, errors.Wrap(_openingTagErr, "Error parsing 'openingTag' field of BACnetNotificationParametersExtendedParameters")
	}
	openingTag := _openingTag.(BACnetOpeningTag)
	if closeErr := readBuffer.CloseContext("openingTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for openingTag")
	}

	// Peek Field (peekedTagHeader)
	currentPos = positionAware.GetPos()
	if pullErr := readBuffer.PullContext("peekedTagHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for peekedTagHeader")
	}
	peekedTagHeader, _ := BACnetTagHeaderParse(readBuffer)
	readBuffer.Reset(currentPos)

	// Virtual field
	_peekedTagNumber := peekedTagHeader.GetActualTagNumber()
	peekedTagNumber := uint8(_peekedTagNumber)
	_ = peekedTagNumber

	// Virtual field
	_isOpeningTag := bool((peekedTagHeader.GetLengthValueType()) == (0x6))
	isOpeningTag := bool(_isOpeningTag)
	_ = isOpeningTag

	// Virtual field
	_isClosingTag := bool((peekedTagHeader.GetLengthValueType()) == (0x7))
	isClosingTag := bool(_isClosingTag)
	_ = isClosingTag

	// Optional Field (nullValue) (Can be skipped, if a given expression evaluates to false)
	var nullValue BACnetApplicationTagNull = nil
	if bool(bool(bool((peekedTagNumber) == (0x0))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("nullValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for nullValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'nullValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			nullValue = _val.(BACnetApplicationTagNull)
			if closeErr := readBuffer.CloseContext("nullValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for nullValue")
			}
		}
	}

	// Optional Field (realValue) (Can be skipped, if a given expression evaluates to false)
	var realValue BACnetApplicationTagReal = nil
	if bool(bool(bool((peekedTagNumber) == (0x4))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("realValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for realValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'realValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			realValue = _val.(BACnetApplicationTagReal)
			if closeErr := readBuffer.CloseContext("realValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for realValue")
			}
		}
	}

	// Optional Field (unsignedValue) (Can be skipped, if a given expression evaluates to false)
	var unsignedValue BACnetApplicationTagUnsignedInteger = nil
	if bool(bool(bool((peekedTagNumber) == (0x2))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("unsignedValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for unsignedValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'unsignedValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			unsignedValue = _val.(BACnetApplicationTagUnsignedInteger)
			if closeErr := readBuffer.CloseContext("unsignedValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for unsignedValue")
			}
		}
	}

	// Optional Field (booleanValue) (Can be skipped, if a given expression evaluates to false)
	var booleanValue BACnetApplicationTagBoolean = nil
	if bool(bool(bool((peekedTagNumber) == (0x1))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("booleanValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for booleanValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'booleanValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			booleanValue = _val.(BACnetApplicationTagBoolean)
			if closeErr := readBuffer.CloseContext("booleanValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for booleanValue")
			}
		}
	}

	// Optional Field (integerValue) (Can be skipped, if a given expression evaluates to false)
	var integerValue BACnetApplicationTagSignedInteger = nil
	if bool(bool(bool((peekedTagNumber) == (0x3))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("integerValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for integerValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'integerValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			integerValue = _val.(BACnetApplicationTagSignedInteger)
			if closeErr := readBuffer.CloseContext("integerValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for integerValue")
			}
		}
	}

	// Optional Field (doubleValue) (Can be skipped, if a given expression evaluates to false)
	var doubleValue BACnetApplicationTagDouble = nil
	if bool(bool(bool((peekedTagNumber) == (0x5))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("doubleValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for doubleValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'doubleValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			doubleValue = _val.(BACnetApplicationTagDouble)
			if closeErr := readBuffer.CloseContext("doubleValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for doubleValue")
			}
		}
	}

	// Optional Field (octetStringValue) (Can be skipped, if a given expression evaluates to false)
	var octetStringValue BACnetApplicationTagOctetString = nil
	if bool(bool(bool((peekedTagNumber) == (0x6))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("octetStringValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for octetStringValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'octetStringValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			octetStringValue = _val.(BACnetApplicationTagOctetString)
			if closeErr := readBuffer.CloseContext("octetStringValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for octetStringValue")
			}
		}
	}

	// Optional Field (characterStringValue) (Can be skipped, if a given expression evaluates to false)
	var characterStringValue BACnetApplicationTagCharacterString = nil
	if bool(bool(bool((peekedTagNumber) == (0x7))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("characterStringValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for characterStringValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'characterStringValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			characterStringValue = _val.(BACnetApplicationTagCharacterString)
			if closeErr := readBuffer.CloseContext("characterStringValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for characterStringValue")
			}
		}
	}

	// Optional Field (bitStringValue) (Can be skipped, if a given expression evaluates to false)
	var bitStringValue BACnetApplicationTagBitString = nil
	if bool(bool(bool((peekedTagNumber) == (0x8))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("bitStringValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for bitStringValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'bitStringValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			bitStringValue = _val.(BACnetApplicationTagBitString)
			if closeErr := readBuffer.CloseContext("bitStringValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for bitStringValue")
			}
		}
	}

	// Optional Field (enumeratedValue) (Can be skipped, if a given expression evaluates to false)
	var enumeratedValue BACnetApplicationTagEnumerated = nil
	if bool(bool(bool((peekedTagNumber) == (0x9))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("enumeratedValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for enumeratedValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'enumeratedValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			enumeratedValue = _val.(BACnetApplicationTagEnumerated)
			if closeErr := readBuffer.CloseContext("enumeratedValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for enumeratedValue")
			}
		}
	}

	// Optional Field (dateValue) (Can be skipped, if a given expression evaluates to false)
	var dateValue BACnetApplicationTagDate = nil
	if bool(bool(bool((peekedTagNumber) == (0xA))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("dateValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for dateValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'dateValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			dateValue = _val.(BACnetApplicationTagDate)
			if closeErr := readBuffer.CloseContext("dateValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for dateValue")
			}
		}
	}

	// Optional Field (timeValue) (Can be skipped, if a given expression evaluates to false)
	var timeValue BACnetApplicationTagTime = nil
	if bool(bool(bool((peekedTagNumber) == (0xB))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("timeValue"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for timeValue")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'timeValue' field of BACnetNotificationParametersExtendedParameters")
		default:
			timeValue = _val.(BACnetApplicationTagTime)
			if closeErr := readBuffer.CloseContext("timeValue"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for timeValue")
			}
		}
	}

	// Optional Field (objectIdentifier) (Can be skipped, if a given expression evaluates to false)
	var objectIdentifier BACnetApplicationTagObjectIdentifier = nil
	if bool(bool((peekedTagNumber) == (0xC))) && bool(!(isOpeningTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("objectIdentifier"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for objectIdentifier")
		}
		_val, _err := BACnetApplicationTagParse(readBuffer)
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'objectIdentifier' field of BACnetNotificationParametersExtendedParameters")
		default:
			objectIdentifier = _val.(BACnetApplicationTagObjectIdentifier)
			if closeErr := readBuffer.CloseContext("objectIdentifier"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for objectIdentifier")
			}
		}
	}

	// Optional Field (reference) (Can be skipped, if a given expression evaluates to false)
	var reference BACnetDeviceObjectPropertyReferenceEnclosed = nil
	if bool(isOpeningTag) && bool(!(isClosingTag)) {
		currentPos = positionAware.GetPos()
		if pullErr := readBuffer.PullContext("reference"); pullErr != nil {
			return nil, errors.Wrap(pullErr, "Error pulling for reference")
		}
		_val, _err := BACnetDeviceObjectPropertyReferenceEnclosedParse(readBuffer, uint8(0))
		switch {
		case errors.Is(_err, utils.ParseAssertError{}) || errors.Is(_err, io.EOF):
			Plc4xModelLog.Debug().Err(_err).Msg("Resetting position because optional threw an error")
			readBuffer.Reset(currentPos)
		case _err != nil:
			return nil, errors.Wrap(_err, "Error parsing 'reference' field of BACnetNotificationParametersExtendedParameters")
		default:
			reference = _val.(BACnetDeviceObjectPropertyReferenceEnclosed)
			if closeErr := readBuffer.CloseContext("reference"); closeErr != nil {
				return nil, errors.Wrap(closeErr, "Error closing for reference")
			}
		}
	}

	// Simple Field (closingTag)
	if pullErr := readBuffer.PullContext("closingTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for closingTag")
	}
	_closingTag, _closingTagErr := BACnetClosingTagParse(readBuffer, uint8(tagNumber))
	if _closingTagErr != nil {
		return nil, errors.Wrap(_closingTagErr, "Error parsing 'closingTag' field of BACnetNotificationParametersExtendedParameters")
	}
	closingTag := _closingTag.(BACnetClosingTag)
	if closeErr := readBuffer.CloseContext("closingTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for closingTag")
	}

	if closeErr := readBuffer.CloseContext("BACnetNotificationParametersExtendedParameters"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParametersExtendedParameters")
	}

	// Create the instance
	return &_BACnetNotificationParametersExtendedParameters{
		TagNumber:            tagNumber,
		OpeningTag:           openingTag,
		PeekedTagHeader:      peekedTagHeader,
		NullValue:            nullValue,
		RealValue:            realValue,
		UnsignedValue:        unsignedValue,
		BooleanValue:         booleanValue,
		IntegerValue:         integerValue,
		DoubleValue:          doubleValue,
		OctetStringValue:     octetStringValue,
		CharacterStringValue: characterStringValue,
		BitStringValue:       bitStringValue,
		EnumeratedValue:      enumeratedValue,
		DateValue:            dateValue,
		TimeValue:            timeValue,
		ObjectIdentifier:     objectIdentifier,
		Reference:            reference,
		ClosingTag:           closingTag,
	}, nil
}

func (m *_BACnetNotificationParametersExtendedParameters) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("BACnetNotificationParametersExtendedParameters"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParametersExtendedParameters")
	}

	// Simple Field (openingTag)
	if pushErr := writeBuffer.PushContext("openingTag"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for openingTag")
	}
	_openingTagErr := writeBuffer.WriteSerializable(m.GetOpeningTag())
	if popErr := writeBuffer.PopContext("openingTag"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for openingTag")
	}
	if _openingTagErr != nil {
		return errors.Wrap(_openingTagErr, "Error serializing 'openingTag' field")
	}
	// Virtual field
	if _peekedTagNumberErr := writeBuffer.WriteVirtual("peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}
	// Virtual field
	if _isOpeningTagErr := writeBuffer.WriteVirtual("isOpeningTag", m.GetIsOpeningTag()); _isOpeningTagErr != nil {
		return errors.Wrap(_isOpeningTagErr, "Error serializing 'isOpeningTag' field")
	}
	// Virtual field
	if _isClosingTagErr := writeBuffer.WriteVirtual("isClosingTag", m.GetIsClosingTag()); _isClosingTagErr != nil {
		return errors.Wrap(_isClosingTagErr, "Error serializing 'isClosingTag' field")
	}

	// Optional Field (nullValue) (Can be skipped, if the value is null)
	var nullValue BACnetApplicationTagNull = nil
	if m.GetNullValue() != nil {
		if pushErr := writeBuffer.PushContext("nullValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nullValue")
		}
		nullValue = m.GetNullValue()
		_nullValueErr := writeBuffer.WriteSerializable(nullValue)
		if popErr := writeBuffer.PopContext("nullValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nullValue")
		}
		if _nullValueErr != nil {
			return errors.Wrap(_nullValueErr, "Error serializing 'nullValue' field")
		}
	}

	// Optional Field (realValue) (Can be skipped, if the value is null)
	var realValue BACnetApplicationTagReal = nil
	if m.GetRealValue() != nil {
		if pushErr := writeBuffer.PushContext("realValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for realValue")
		}
		realValue = m.GetRealValue()
		_realValueErr := writeBuffer.WriteSerializable(realValue)
		if popErr := writeBuffer.PopContext("realValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for realValue")
		}
		if _realValueErr != nil {
			return errors.Wrap(_realValueErr, "Error serializing 'realValue' field")
		}
	}

	// Optional Field (unsignedValue) (Can be skipped, if the value is null)
	var unsignedValue BACnetApplicationTagUnsignedInteger = nil
	if m.GetUnsignedValue() != nil {
		if pushErr := writeBuffer.PushContext("unsignedValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for unsignedValue")
		}
		unsignedValue = m.GetUnsignedValue()
		_unsignedValueErr := writeBuffer.WriteSerializable(unsignedValue)
		if popErr := writeBuffer.PopContext("unsignedValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for unsignedValue")
		}
		if _unsignedValueErr != nil {
			return errors.Wrap(_unsignedValueErr, "Error serializing 'unsignedValue' field")
		}
	}

	// Optional Field (booleanValue) (Can be skipped, if the value is null)
	var booleanValue BACnetApplicationTagBoolean = nil
	if m.GetBooleanValue() != nil {
		if pushErr := writeBuffer.PushContext("booleanValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for booleanValue")
		}
		booleanValue = m.GetBooleanValue()
		_booleanValueErr := writeBuffer.WriteSerializable(booleanValue)
		if popErr := writeBuffer.PopContext("booleanValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for booleanValue")
		}
		if _booleanValueErr != nil {
			return errors.Wrap(_booleanValueErr, "Error serializing 'booleanValue' field")
		}
	}

	// Optional Field (integerValue) (Can be skipped, if the value is null)
	var integerValue BACnetApplicationTagSignedInteger = nil
	if m.GetIntegerValue() != nil {
		if pushErr := writeBuffer.PushContext("integerValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for integerValue")
		}
		integerValue = m.GetIntegerValue()
		_integerValueErr := writeBuffer.WriteSerializable(integerValue)
		if popErr := writeBuffer.PopContext("integerValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for integerValue")
		}
		if _integerValueErr != nil {
			return errors.Wrap(_integerValueErr, "Error serializing 'integerValue' field")
		}
	}

	// Optional Field (doubleValue) (Can be skipped, if the value is null)
	var doubleValue BACnetApplicationTagDouble = nil
	if m.GetDoubleValue() != nil {
		if pushErr := writeBuffer.PushContext("doubleValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for doubleValue")
		}
		doubleValue = m.GetDoubleValue()
		_doubleValueErr := writeBuffer.WriteSerializable(doubleValue)
		if popErr := writeBuffer.PopContext("doubleValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for doubleValue")
		}
		if _doubleValueErr != nil {
			return errors.Wrap(_doubleValueErr, "Error serializing 'doubleValue' field")
		}
	}

	// Optional Field (octetStringValue) (Can be skipped, if the value is null)
	var octetStringValue BACnetApplicationTagOctetString = nil
	if m.GetOctetStringValue() != nil {
		if pushErr := writeBuffer.PushContext("octetStringValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for octetStringValue")
		}
		octetStringValue = m.GetOctetStringValue()
		_octetStringValueErr := writeBuffer.WriteSerializable(octetStringValue)
		if popErr := writeBuffer.PopContext("octetStringValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for octetStringValue")
		}
		if _octetStringValueErr != nil {
			return errors.Wrap(_octetStringValueErr, "Error serializing 'octetStringValue' field")
		}
	}

	// Optional Field (characterStringValue) (Can be skipped, if the value is null)
	var characterStringValue BACnetApplicationTagCharacterString = nil
	if m.GetCharacterStringValue() != nil {
		if pushErr := writeBuffer.PushContext("characterStringValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for characterStringValue")
		}
		characterStringValue = m.GetCharacterStringValue()
		_characterStringValueErr := writeBuffer.WriteSerializable(characterStringValue)
		if popErr := writeBuffer.PopContext("characterStringValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for characterStringValue")
		}
		if _characterStringValueErr != nil {
			return errors.Wrap(_characterStringValueErr, "Error serializing 'characterStringValue' field")
		}
	}

	// Optional Field (bitStringValue) (Can be skipped, if the value is null)
	var bitStringValue BACnetApplicationTagBitString = nil
	if m.GetBitStringValue() != nil {
		if pushErr := writeBuffer.PushContext("bitStringValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for bitStringValue")
		}
		bitStringValue = m.GetBitStringValue()
		_bitStringValueErr := writeBuffer.WriteSerializable(bitStringValue)
		if popErr := writeBuffer.PopContext("bitStringValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for bitStringValue")
		}
		if _bitStringValueErr != nil {
			return errors.Wrap(_bitStringValueErr, "Error serializing 'bitStringValue' field")
		}
	}

	// Optional Field (enumeratedValue) (Can be skipped, if the value is null)
	var enumeratedValue BACnetApplicationTagEnumerated = nil
	if m.GetEnumeratedValue() != nil {
		if pushErr := writeBuffer.PushContext("enumeratedValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for enumeratedValue")
		}
		enumeratedValue = m.GetEnumeratedValue()
		_enumeratedValueErr := writeBuffer.WriteSerializable(enumeratedValue)
		if popErr := writeBuffer.PopContext("enumeratedValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for enumeratedValue")
		}
		if _enumeratedValueErr != nil {
			return errors.Wrap(_enumeratedValueErr, "Error serializing 'enumeratedValue' field")
		}
	}

	// Optional Field (dateValue) (Can be skipped, if the value is null)
	var dateValue BACnetApplicationTagDate = nil
	if m.GetDateValue() != nil {
		if pushErr := writeBuffer.PushContext("dateValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for dateValue")
		}
		dateValue = m.GetDateValue()
		_dateValueErr := writeBuffer.WriteSerializable(dateValue)
		if popErr := writeBuffer.PopContext("dateValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for dateValue")
		}
		if _dateValueErr != nil {
			return errors.Wrap(_dateValueErr, "Error serializing 'dateValue' field")
		}
	}

	// Optional Field (timeValue) (Can be skipped, if the value is null)
	var timeValue BACnetApplicationTagTime = nil
	if m.GetTimeValue() != nil {
		if pushErr := writeBuffer.PushContext("timeValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for timeValue")
		}
		timeValue = m.GetTimeValue()
		_timeValueErr := writeBuffer.WriteSerializable(timeValue)
		if popErr := writeBuffer.PopContext("timeValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for timeValue")
		}
		if _timeValueErr != nil {
			return errors.Wrap(_timeValueErr, "Error serializing 'timeValue' field")
		}
	}

	// Optional Field (objectIdentifier) (Can be skipped, if the value is null)
	var objectIdentifier BACnetApplicationTagObjectIdentifier = nil
	if m.GetObjectIdentifier() != nil {
		if pushErr := writeBuffer.PushContext("objectIdentifier"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for objectIdentifier")
		}
		objectIdentifier = m.GetObjectIdentifier()
		_objectIdentifierErr := writeBuffer.WriteSerializable(objectIdentifier)
		if popErr := writeBuffer.PopContext("objectIdentifier"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for objectIdentifier")
		}
		if _objectIdentifierErr != nil {
			return errors.Wrap(_objectIdentifierErr, "Error serializing 'objectIdentifier' field")
		}
	}

	// Optional Field (reference) (Can be skipped, if the value is null)
	var reference BACnetDeviceObjectPropertyReferenceEnclosed = nil
	if m.GetReference() != nil {
		if pushErr := writeBuffer.PushContext("reference"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for reference")
		}
		reference = m.GetReference()
		_referenceErr := writeBuffer.WriteSerializable(reference)
		if popErr := writeBuffer.PopContext("reference"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for reference")
		}
		if _referenceErr != nil {
			return errors.Wrap(_referenceErr, "Error serializing 'reference' field")
		}
	}

	// Simple Field (closingTag)
	if pushErr := writeBuffer.PushContext("closingTag"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for closingTag")
	}
	_closingTagErr := writeBuffer.WriteSerializable(m.GetClosingTag())
	if popErr := writeBuffer.PopContext("closingTag"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for closingTag")
	}
	if _closingTagErr != nil {
		return errors.Wrap(_closingTagErr, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetNotificationParametersExtendedParameters"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetNotificationParametersExtendedParameters")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetNotificationParametersExtendedParameters) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetNotificationParametersExtendedParameters) isBACnetNotificationParametersExtendedParameters() bool {
	return true
}

func (m *_BACnetNotificationParametersExtendedParameters) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
