/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTrackingValue is the corresponding interface of BACnetConstructedDataTrackingValue
type BACnetConstructedDataTrackingValue interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetTrackingValue returns TrackingValue (property field)
	GetTrackingValue() BACnetLifeSafetyStateTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetLifeSafetyStateTagged
}

// BACnetConstructedDataTrackingValueExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataTrackingValue.
// This is useful for switch cases.
type BACnetConstructedDataTrackingValueExactly interface {
	BACnetConstructedDataTrackingValue
	isBACnetConstructedDataTrackingValue() bool
}

// _BACnetConstructedDataTrackingValue is the data-structure of this message
type _BACnetConstructedDataTrackingValue struct {
	*_BACnetConstructedData
	TrackingValue BACnetLifeSafetyStateTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTrackingValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataTrackingValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_TRACKING_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTrackingValue) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataTrackingValue) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataTrackingValue) GetTrackingValue() BACnetLifeSafetyStateTagged {
	return m.TrackingValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataTrackingValue) GetActualValue() BACnetLifeSafetyStateTagged {
	return CastBACnetLifeSafetyStateTagged(m.GetTrackingValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataTrackingValue factory function for _BACnetConstructedDataTrackingValue
func NewBACnetConstructedDataTrackingValue(trackingValue BACnetLifeSafetyStateTagged, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTrackingValue {
	_result := &_BACnetConstructedDataTrackingValue{
		TrackingValue:          trackingValue,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTrackingValue(structType interface{}) BACnetConstructedDataTrackingValue {
	if casted, ok := structType.(BACnetConstructedDataTrackingValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTrackingValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTrackingValue) GetTypeName() string {
	return "BACnetConstructedDataTrackingValue"
}

func (m *_BACnetConstructedDataTrackingValue) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataTrackingValue) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (trackingValue)
	lengthInBits += m.TrackingValue.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataTrackingValue) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataTrackingValueParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataTrackingValue, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTrackingValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTrackingValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (trackingValue)
	if pullErr := readBuffer.PullContext("trackingValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for trackingValue")
	}
	_trackingValue, _trackingValueErr := BACnetLifeSafetyStateTaggedParse(readBuffer, uint8(uint8(0)), TagClass(TagClass_APPLICATION_TAGS))
	if _trackingValueErr != nil {
		return nil, errors.Wrap(_trackingValueErr, "Error parsing 'trackingValue' field of BACnetConstructedDataTrackingValue")
	}
	trackingValue := _trackingValue.(BACnetLifeSafetyStateTagged)
	if closeErr := readBuffer.CloseContext("trackingValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for trackingValue")
	}

	// Virtual field
	_actualValue := trackingValue
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTrackingValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTrackingValue")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataTrackingValue{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		TrackingValue: trackingValue,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataTrackingValue) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTrackingValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTrackingValue")
		}

		// Simple Field (trackingValue)
		if pushErr := writeBuffer.PushContext("trackingValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for trackingValue")
		}
		_trackingValueErr := writeBuffer.WriteSerializable(m.GetTrackingValue())
		if popErr := writeBuffer.PopContext("trackingValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for trackingValue")
		}
		if _trackingValueErr != nil {
			return errors.Wrap(_trackingValueErr, "Error serializing 'trackingValue' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTrackingValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTrackingValue")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTrackingValue) isBACnetConstructedDataTrackingValue() bool {
	return true
}

func (m *_BACnetConstructedDataTrackingValue) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
