/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNetworkNumberQuality is the corresponding interface of BACnetConstructedDataNetworkNumberQuality
type BACnetConstructedDataNetworkNumberQuality interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetNetworkNumberQuality returns NetworkNumberQuality (property field)
	GetNetworkNumberQuality() BACnetNetworkNumberQualityTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetNetworkNumberQualityTagged
}

// BACnetConstructedDataNetworkNumberQualityExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataNetworkNumberQuality.
// This is useful for switch cases.
type BACnetConstructedDataNetworkNumberQualityExactly interface {
	BACnetConstructedDataNetworkNumberQuality
	isBACnetConstructedDataNetworkNumberQuality() bool
}

// _BACnetConstructedDataNetworkNumberQuality is the data-structure of this message
type _BACnetConstructedDataNetworkNumberQuality struct {
	*_BACnetConstructedData
	NetworkNumberQuality BACnetNetworkNumberQualityTagged
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetNetworkNumberQuality() BACnetNetworkNumberQualityTagged {
	return m.NetworkNumberQuality
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNetworkNumberQuality) GetActualValue() BACnetNetworkNumberQualityTagged {
	return CastBACnetNetworkNumberQualityTagged(m.GetNetworkNumberQuality())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataNetworkNumberQuality factory function for _BACnetConstructedDataNetworkNumberQuality
func NewBACnetConstructedDataNetworkNumberQuality(networkNumberQuality BACnetNetworkNumberQualityTagged, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNetworkNumberQuality {
	_result := &_BACnetConstructedDataNetworkNumberQuality{
		NetworkNumberQuality:   networkNumberQuality,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNetworkNumberQuality(structType interface{}) BACnetConstructedDataNetworkNumberQuality {
	if casted, ok := structType.(BACnetConstructedDataNetworkNumberQuality); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNetworkNumberQuality); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetTypeName() string {
	return "BACnetConstructedDataNetworkNumberQuality"
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (networkNumberQuality)
	lengthInBits += m.NetworkNumberQuality.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNetworkNumberQuality) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataNetworkNumberQualityParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataNetworkNumberQuality, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNetworkNumberQuality"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNetworkNumberQuality")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (networkNumberQuality)
	if pullErr := readBuffer.PullContext("networkNumberQuality"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for networkNumberQuality")
	}
	_networkNumberQuality, _networkNumberQualityErr := BACnetNetworkNumberQualityTaggedParse(readBuffer, uint8(uint8(0)), TagClass(TagClass_APPLICATION_TAGS))
	if _networkNumberQualityErr != nil {
		return nil, errors.Wrap(_networkNumberQualityErr, "Error parsing 'networkNumberQuality' field of BACnetConstructedDataNetworkNumberQuality")
	}
	networkNumberQuality := _networkNumberQuality.(BACnetNetworkNumberQualityTagged)
	if closeErr := readBuffer.CloseContext("networkNumberQuality"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for networkNumberQuality")
	}

	// Virtual field
	_actualValue := networkNumberQuality
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNetworkNumberQuality"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNetworkNumberQuality")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataNetworkNumberQuality{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		NetworkNumberQuality: networkNumberQuality,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataNetworkNumberQuality) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNetworkNumberQuality"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNetworkNumberQuality")
		}

		// Simple Field (networkNumberQuality)
		if pushErr := writeBuffer.PushContext("networkNumberQuality"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for networkNumberQuality")
		}
		_networkNumberQualityErr := writeBuffer.WriteSerializable(m.GetNetworkNumberQuality())
		if popErr := writeBuffer.PopContext("networkNumberQuality"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for networkNumberQuality")
		}
		if _networkNumberQualityErr != nil {
			return errors.Wrap(_networkNumberQualityErr, "Error serializing 'networkNumberQuality' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNetworkNumberQuality"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNetworkNumberQuality")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNetworkNumberQuality) isBACnetConstructedDataNetworkNumberQuality() bool {
	return true
}

func (m *_BACnetConstructedDataNetworkNumberQuality) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
