/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDefaultFadeTime is the corresponding interface of BACnetConstructedDataDefaultFadeTime
type BACnetConstructedDataDefaultFadeTime interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetDefaultFadeTime returns DefaultFadeTime (property field)
	GetDefaultFadeTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
}

// BACnetConstructedDataDefaultFadeTimeExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataDefaultFadeTime.
// This is useful for switch cases.
type BACnetConstructedDataDefaultFadeTimeExactly interface {
	BACnetConstructedDataDefaultFadeTime
	isBACnetConstructedDataDefaultFadeTime() bool
}

// _BACnetConstructedDataDefaultFadeTime is the data-structure of this message
type _BACnetConstructedDataDefaultFadeTime struct {
	*_BACnetConstructedData
	DefaultFadeTime BACnetApplicationTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEFAULT_FADE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetDefaultFadeTime() BACnetApplicationTagUnsignedInteger {
	return m.DefaultFadeTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	return CastBACnetApplicationTagUnsignedInteger(m.GetDefaultFadeTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataDefaultFadeTime factory function for _BACnetConstructedDataDefaultFadeTime
func NewBACnetConstructedDataDefaultFadeTime(defaultFadeTime BACnetApplicationTagUnsignedInteger, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDefaultFadeTime {
	_result := &_BACnetConstructedDataDefaultFadeTime{
		DefaultFadeTime:        defaultFadeTime,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDefaultFadeTime(structType interface{}) BACnetConstructedDataDefaultFadeTime {
	if casted, ok := structType.(BACnetConstructedDataDefaultFadeTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDefaultFadeTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetTypeName() string {
	return "BACnetConstructedDataDefaultFadeTime"
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (defaultFadeTime)
	lengthInBits += m.DefaultFadeTime.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataDefaultFadeTimeParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataDefaultFadeTime, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDefaultFadeTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDefaultFadeTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (defaultFadeTime)
	if pullErr := readBuffer.PullContext("defaultFadeTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for defaultFadeTime")
	}
	_defaultFadeTime, _defaultFadeTimeErr := BACnetApplicationTagParse(readBuffer)
	if _defaultFadeTimeErr != nil {
		return nil, errors.Wrap(_defaultFadeTimeErr, "Error parsing 'defaultFadeTime' field of BACnetConstructedDataDefaultFadeTime")
	}
	defaultFadeTime := _defaultFadeTime.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("defaultFadeTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for defaultFadeTime")
	}

	// Virtual field
	_actualValue := defaultFadeTime
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDefaultFadeTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDefaultFadeTime")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataDefaultFadeTime{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		DefaultFadeTime: defaultFadeTime,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataDefaultFadeTime) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDefaultFadeTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDefaultFadeTime")
		}

		// Simple Field (defaultFadeTime)
		if pushErr := writeBuffer.PushContext("defaultFadeTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for defaultFadeTime")
		}
		_defaultFadeTimeErr := writeBuffer.WriteSerializable(m.GetDefaultFadeTime())
		if popErr := writeBuffer.PopContext("defaultFadeTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for defaultFadeTime")
		}
		if _defaultFadeTimeErr != nil {
			return errors.Wrap(_defaultFadeTimeErr, "Error serializing 'defaultFadeTime' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDefaultFadeTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDefaultFadeTime")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDefaultFadeTime) isBACnetConstructedDataDefaultFadeTime() bool {
	return true
}

func (m *_BACnetConstructedDataDefaultFadeTime) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
