/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActualShedLevel is the corresponding interface of BACnetConstructedDataActualShedLevel
type BACnetConstructedDataActualShedLevel interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetActualShedLevel returns ActualShedLevel (property field)
	GetActualShedLevel() BACnetShedLevel
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetShedLevel
}

// BACnetConstructedDataActualShedLevelExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataActualShedLevel.
// This is useful for switch cases.
type BACnetConstructedDataActualShedLevelExactly interface {
	BACnetConstructedDataActualShedLevel
	isBACnetConstructedDataActualShedLevel() bool
}

// _BACnetConstructedDataActualShedLevel is the data-structure of this message
type _BACnetConstructedDataActualShedLevel struct {
	*_BACnetConstructedData
	ActualShedLevel BACnetShedLevel
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActualShedLevel) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActualShedLevel) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActualShedLevel) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataActualShedLevel) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActualShedLevel) GetActualShedLevel() BACnetShedLevel {
	return m.ActualShedLevel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataActualShedLevel) GetActualValue() BACnetShedLevel {
	return CastBACnetShedLevel(m.GetActualShedLevel())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataActualShedLevel factory function for _BACnetConstructedDataActualShedLevel
func NewBACnetConstructedDataActualShedLevel(actualShedLevel BACnetShedLevel, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActualShedLevel {
	_result := &_BACnetConstructedDataActualShedLevel{
		ActualShedLevel:        actualShedLevel,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActualShedLevel(structType interface{}) BACnetConstructedDataActualShedLevel {
	if casted, ok := structType.(BACnetConstructedDataActualShedLevel); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActualShedLevel); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActualShedLevel) GetTypeName() string {
	return "BACnetConstructedDataActualShedLevel"
}

func (m *_BACnetConstructedDataActualShedLevel) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataActualShedLevel) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (actualShedLevel)
	lengthInBits += m.ActualShedLevel.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataActualShedLevel) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataActualShedLevelParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataActualShedLevel, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActualShedLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActualShedLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (actualShedLevel)
	if pullErr := readBuffer.PullContext("actualShedLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for actualShedLevel")
	}
	_actualShedLevel, _actualShedLevelErr := BACnetShedLevelParse(readBuffer)
	if _actualShedLevelErr != nil {
		return nil, errors.Wrap(_actualShedLevelErr, "Error parsing 'actualShedLevel' field of BACnetConstructedDataActualShedLevel")
	}
	actualShedLevel := _actualShedLevel.(BACnetShedLevel)
	if closeErr := readBuffer.CloseContext("actualShedLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for actualShedLevel")
	}

	// Virtual field
	_actualValue := actualShedLevel
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActualShedLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActualShedLevel")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataActualShedLevel{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		ActualShedLevel: actualShedLevel,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataActualShedLevel) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActualShedLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActualShedLevel")
		}

		// Simple Field (actualShedLevel)
		if pushErr := writeBuffer.PushContext("actualShedLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for actualShedLevel")
		}
		_actualShedLevelErr := writeBuffer.WriteSerializable(m.GetActualShedLevel())
		if popErr := writeBuffer.PopContext("actualShedLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for actualShedLevel")
		}
		if _actualShedLevelErr != nil {
			return errors.Wrap(_actualShedLevelErr, "Error serializing 'actualShedLevel' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActualShedLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActualShedLevel")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActualShedLevel) isBACnetConstructedDataActualShedLevel() bool {
	return true
}

func (m *_BACnetConstructedDataActualShedLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
