/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/evaluation_helper.h>
#include <plc4c/driver_s7_static.h>

#include "date_and_time.h"

// Code generated by code-generation. DO NOT EDIT.


// Parse function.
plc4c_return_code plc4c_s7_read_write_date_and_time_parse(plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_date_and_time** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_date_and_time));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Manual Field (year)
  uint8_t year = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->year = year;

  // Manual Field (month)
  uint8_t month = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->month = month;

  // Manual Field (day)
  uint8_t day = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->day = day;

  // Manual Field (hour)
  uint8_t hour = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->hour = hour;

  // Manual Field (minutes)
  uint8_t minutes = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->minutes = minutes;

  // Manual Field (seconds)
  uint8_t seconds = (uint8_t) (plc4c_s7_read_write_bcd_to_int(readBuffer));
  (*_message)->seconds = seconds;

  // Manual Field (msec)
  uint16_t msec = (uint16_t) (plc4c_s7_read_write_s7msec_to_int(readBuffer));
  (*_message)->msec = msec;

  // Simple Field (dow)
  uint8_t dow = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 4, (uint8_t*) &dow);
  if(_res != OK) {
    return _res;
  }
  (*_message)->dow = dow;

  return OK;
}

plc4c_return_code plc4c_s7_read_write_date_and_time_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_date_and_time* _message) {
  plc4c_return_code _res = OK;

  // Manual Field (year)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->year);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (month)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->month);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (day)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->day);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (hour)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->hour);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (minutes)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->minutes);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (seconds)  {
  _res = plc4c_s7_read_write_byte_to_bcd(writeBuffer, _message->seconds);
  if(_res != OK) {
    return _res;
  }

  // Manual Field (msec)  {
  _res = plc4c_s7_read_write_int_to_s7msec(writeBuffer, _message->msec);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (dow)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 4, _message->dow);
  if(_res != OK) {
    return _res;
  }

  return OK;
}

uint16_t plc4c_s7_read_write_date_and_time_length_in_bytes(plc4c_s7_read_write_date_and_time* _message) {
  return plc4c_s7_read_write_date_and_time_length_in_bits(_message) / 8;
}

uint16_t plc4c_s7_read_write_date_and_time_length_in_bits(plc4c_s7_read_write_date_and_time* _message) {
  uint16_t lengthInBits = 0;

  // Manual Field (year)
  lengthInBits += 8;

  // Manual Field (month)
  lengthInBits += 8;

  // Manual Field (day)
  lengthInBits += 8;

  // Manual Field (hour)
  lengthInBits += 8;

  // Manual Field (minutes)
  lengthInBits += 8;

  // Manual Field (seconds)
  lengthInBits += 8;

  // Manual Field (msec)
  lengthInBits += 12;

  // Simple field (dow)
  lengthInBits += 4;

  return lengthInBits;
}

