/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_S7_READ_WRITE_COTP_PACKET_H_
#define PLC4C_S7_READ_WRITE_COTP_PACKET_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "s7_message.h"
#include "cotp_parameter.h"
#include "cotp_protocol_class.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_s7_read_write_cotp_packet_discriminator {
  uint8_t tpduCode;
};
typedef struct plc4c_s7_read_write_cotp_packet_discriminator plc4c_s7_read_write_cotp_packet_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_s7_read_write_cotp_packet_type {
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_data = 0,
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_connection_request = 1,
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_connection_response = 2,
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_disconnect_request = 3,
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_disconnect_response = 4,
  plc4c_s7_read_write_cotp_packet_type_plc4c_s7_read_write_cotp_packet_tpdu_error = 5};
typedef enum plc4c_s7_read_write_cotp_packet_type plc4c_s7_read_write_cotp_packet_type;

// Function to get the discriminator values for a given type.
plc4c_s7_read_write_cotp_packet_discriminator plc4c_s7_read_write_cotp_packet_get_discriminator(plc4c_s7_read_write_cotp_packet_type type);

struct plc4c_s7_read_write_cotp_packet {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_s7_read_write_cotp_packet_type _type;
  /* Properties */
  union {
    struct { /* COTPPacketData */
      bool cotp_packet_data_eot : 1;
      uint8_t cotp_packet_data_tpdu_ref : 7;
    };
    struct { /* COTPPacketConnectionRequest */
      uint16_t cotp_packet_connection_request_destination_reference;
      uint16_t cotp_packet_connection_request_source_reference;
      plc4c_s7_read_write_cotp_protocol_class cotp_packet_connection_request_protocol_class;
    };
    struct { /* COTPPacketConnectionResponse */
      uint16_t cotp_packet_connection_response_destination_reference;
      uint16_t cotp_packet_connection_response_source_reference;
      plc4c_s7_read_write_cotp_protocol_class cotp_packet_connection_response_protocol_class;
    };
    struct { /* COTPPacketDisconnectRequest */
      uint16_t cotp_packet_disconnect_request_destination_reference;
      uint16_t cotp_packet_disconnect_request_source_reference;
      plc4c_s7_read_write_cotp_protocol_class cotp_packet_disconnect_request_protocol_class;
    };
    struct { /* COTPPacketDisconnectResponse */
      uint16_t cotp_packet_disconnect_response_destination_reference;
      uint16_t cotp_packet_disconnect_response_source_reference;
    };
    struct { /* COTPPacketTpduError */
      uint16_t cotp_packet_tpdu_error_destination_reference;
      uint8_t cotp_packet_tpdu_error_reject_cause;
    };
  };
  plc4c_list* parameters;
  plc4c_s7_read_write_s7_message* payload;
};
typedef struct plc4c_s7_read_write_cotp_packet plc4c_s7_read_write_cotp_packet;

// Create an empty NULL-struct
plc4c_s7_read_write_cotp_packet plc4c_s7_read_write_cotp_packet_null();

plc4c_return_code plc4c_s7_read_write_cotp_packet_parse(plc4c_spi_read_buffer* readBuffer, uint16_t cotpLen, plc4c_s7_read_write_cotp_packet** message);

plc4c_return_code plc4c_s7_read_write_cotp_packet_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_cotp_packet* message);

uint16_t plc4c_s7_read_write_cotp_packet_length_in_bytes(plc4c_s7_read_write_cotp_packet* message);

uint16_t plc4c_s7_read_write_cotp_packet_length_in_bits(plc4c_s7_read_write_cotp_packet* message);

#endif  // PLC4C_S7_READ_WRITE_COTP_PACKET_H_
