/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotEquals;


public class AggregationResultSetTest {

  private JsonNode _mockJsonObject;

  private AggregationResultSet _aggregationResultSetUnderTest;

  @BeforeMethod
  public void setUp()
      throws Exception {
    String jsonString = "{\"function\":\"testFunction\", \"value\":\"123\"}";
    _mockJsonObject = JsonUtils.stringToJsonNode(jsonString);
    _aggregationResultSetUnderTest = new AggregationResultSet(_mockJsonObject);
  }

  @Test
  public void testGetRowCount() {
    // Run the test
    final int result = _aggregationResultSetUnderTest.getRowCount();

    // Verify the results
    assertEquals(1, result);
  }

  @Test
  public void testGetColumnCount() {
    // Run the test
    final int result = _aggregationResultSetUnderTest.getColumnCount();

    // Verify the results
    assertEquals(1, result);
  }

  @Test
  public void testGetColumnName() {
    // Run the test
    final String result = _aggregationResultSetUnderTest.getColumnName(0);

    // Verify the results
    assertEquals("testFunction", result);
  }

  @Test(expectedExceptions = IllegalArgumentException.class)
  public void testGetStringForNonZeroRow() {
    // Run the test
    _aggregationResultSetUnderTest.getString(1, 0);
  }

  @Test(expectedExceptions = IllegalArgumentException.class)
  public void testGetStringForNonZeroColumn() {
    // Run the test
    _aggregationResultSetUnderTest.getString(0, 1);
  }

  @Test
  public void testGetString() {
    // Run the test
    final String result = _aggregationResultSetUnderTest.getString(0, 0);

    // Verify the results
    assertEquals("123", result);
  }

  @Test
  public void testGetGroupKeyLength() {
    // Run the test
    final int result = _aggregationResultSetUnderTest.getGroupKeyLength();

    // Verify the results
    assertEquals(0, result);
  }

  @Test(expectedExceptions = AssertionError.class)
  public void testGetGroupKeyColumnName() {
    _aggregationResultSetUnderTest.getGroupKeyColumnName(0);
  }

  @Test(expectedExceptions = AssertionError.class)
  public void testGetGroupKeyString() {
    _aggregationResultSetUnderTest.getGroupKeyString(0, 0);
  }

  @Test
  public void testToString() {
    // Run the test
    final String result = _aggregationResultSetUnderTest.toString();

    // Verify the results
    assertNotEquals("", result);
  }
}
