/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompaction;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class UpsertCompactionTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactionTaskGenerator.class);
    private static final String DEFAULT_BUFFER_PERIOD = "7d";
    private static final double DEFAULT_INVALID_RECORDS_THRESHOLD_PERCENT = 0.0;
    private static final long DEFAULT_INVALID_RECORDS_THRESHOLD_COUNT = 0L;

    public String getTaskType() {
        return "UpsertCompactionTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "UpsertCompactionTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            List<String> validDocIdUrls;
            BiMap serverToEndpoints;
            if (!UpsertCompactionTaskGenerator.validate(tableConfig)) continue;
            String tableNameWithType = tableConfig.getTableName();
            LOGGER.info("Start generating task configs for table: {}", (Object)tableNameWithType);
            Map taskConfigs = tableConfig.getTaskConfig().getConfigsForTaskType(taskType);
            List<SegmentZKMetadata> completedSegments = this.getCompletedSegments(tableNameWithType, taskConfigs);
            if (completedSegments.isEmpty()) {
                LOGGER.info("No completed segments were eligible for compaction for table: {}", (Object)tableNameWithType);
                continue;
            }
            PinotHelixResourceManager pinotHelixResourceManager = this._clusterInfoAccessor.getPinotHelixResourceManager();
            Map serverToSegments = pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType);
            try {
                serverToEndpoints = pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
            }
            catch (InvalidConfigException e) {
                throw new RuntimeException(e);
            }
            Map<String, SegmentZKMetadata> completedSegmentsMap = completedSegments.stream().collect(Collectors.toMap(SegmentZKMetadata::getSegmentName, Function.identity()));
            try {
                validDocIdUrls = UpsertCompactionTaskGenerator.getValidDocIdMetadataUrls(serverToSegments, (BiMap<String, String>)serverToEndpoints, tableNameWithType, completedSegmentsMap.keySet());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._clusterInfoAccessor.getExecutor(), (HttpClientConnectionManager)this._clusterInfoAccessor.getConnectionManager(), serverToEndpoints.inverse());
            CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(validDocIdUrls, tableNameWithType, false, 3000);
            SegmentSelectionResult segmentSelectionResult = UpsertCompactionTaskGenerator.processValidDocIdMetadata(taskConfigs, completedSegmentsMap, serviceResponse._httpResponses.entrySet());
            if (!segmentSelectionResult.getSegmentsForDeletion().isEmpty()) {
                pinotHelixResourceManager.deleteSegments(tableNameWithType, segmentSelectionResult.getSegmentsForDeletion(), "0d");
                LOGGER.info("Deleted segments containing only invalid records for table: {}", (Object)tableNameWithType);
            }
            int numTasks = 0;
            int maxTasks = UpsertCompactionTaskGenerator.getMaxTasks(taskType, tableNameWithType, taskConfigs);
            for (SegmentZKMetadata segment : segmentSelectionResult.getSegmentsForCompaction()) {
                if (numTasks == maxTasks) break;
                HashMap<String, Object> configs = new HashMap<String, Object>();
                configs.put("tableName", tableNameWithType);
                configs.put("segmentName", segment.getSegmentName());
                configs.put("downloadURL", segment.getDownloadUrl());
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("crc", String.valueOf(segment.getCrc()));
                pinotTaskConfigs.add(new PinotTaskConfig("UpsertCompactionTask", configs));
                ++numTasks;
            }
            LOGGER.info("Finished generating {} tasks configs for table: {}", (Object)numTasks, (Object)tableNameWithType);
        }
        return pinotTaskConfigs;
    }

    @VisibleForTesting
    public static SegmentSelectionResult processValidDocIdMetadata(Map<String, String> taskConfigs, Map<String, SegmentZKMetadata> completedSegmentsMap, Set<Map.Entry<String, String>> responseSet) {
        double invalidRecordsThresholdPercent = Double.parseDouble(taskConfigs.getOrDefault("invalidRecordsThresholdPercent", String.valueOf(0.0)));
        long invalidRecordsThresholdCount = Long.parseLong(taskConfigs.getOrDefault("invalidRecordsThresholdCount", String.valueOf(0L)));
        ArrayList<SegmentZKMetadata> segmentsForCompaction = new ArrayList<SegmentZKMetadata>();
        ArrayList<String> segmentsForDeletion = new ArrayList<String>();
        for (Map.Entry<String, String> streamResponse : responseSet) {
            JsonNode allValidDocIdMetadata;
            try {
                allValidDocIdMetadata = JsonUtils.stringToJsonNode((String)streamResponse.getValue());
            }
            catch (IOException e) {
                LOGGER.error("Unable to parse validDocIdMetadata response for: {}", (Object)streamResponse.getKey());
                continue;
            }
            Iterator iterator = allValidDocIdMetadata.elements();
            while (iterator.hasNext()) {
                JsonNode validDocIdMetadata = (JsonNode)iterator.next();
                long totalInvalidDocs = validDocIdMetadata.get("totalInvalidDocs").asLong();
                String segmentName = validDocIdMetadata.get("segmentName").asText();
                SegmentZKMetadata segment = completedSegmentsMap.get(segmentName);
                long totalDocs = validDocIdMetadata.get("totalDocs").asLong();
                double invalidRecordPercent = (double)totalInvalidDocs / (double)totalDocs * 100.0;
                if (totalInvalidDocs == totalDocs) {
                    segmentsForDeletion.add(segment.getSegmentName());
                    continue;
                }
                if (!(invalidRecordPercent > invalidRecordsThresholdPercent) || totalInvalidDocs <= invalidRecordsThresholdCount) continue;
                segmentsForCompaction.add(segment);
            }
        }
        return new SegmentSelectionResult(segmentsForCompaction, segmentsForDeletion);
    }

    @VisibleForTesting
    public static List<String> getValidDocIdMetadataUrls(Map<String, List<String>> serverToSegments, BiMap<String, String> serverToEndpoints, String tableNameWithType, Set<String> completedSegments) throws URISyntaxException {
        HashSet<String> remainingSegments = new HashSet<String>(completedSegments);
        ArrayList<String> urls = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : serverToSegments.entrySet()) {
            if (remainingSegments.isEmpty()) break;
            String server = entry.getKey();
            List<String> segmentNames = entry.getValue();
            URIBuilder uriBuilder = new URIBuilder((String)serverToEndpoints.get((Object)server)).setPath(String.format("/tables/%s/validDocIdMetadata", tableNameWithType));
            int completedSegmentCountPerServer = 0;
            for (String segmentName : segmentNames) {
                if (!remainingSegments.remove(segmentName)) continue;
                ++completedSegmentCountPerServer;
                uriBuilder.addParameter("segmentNames", segmentName);
            }
            if (completedSegmentCountPerServer <= 0) continue;
            urls.add(uriBuilder.toString());
        }
        return urls;
    }

    private List<SegmentZKMetadata> getCompletedSegments(String tableNameWithType, Map<String, String> taskConfigs) {
        ArrayList<SegmentZKMetadata> completedSegments = new ArrayList<SegmentZKMetadata>();
        String bufferPeriod = taskConfigs.getOrDefault("bufferTimePeriod", DEFAULT_BUFFER_PERIOD);
        long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferPeriod);
        List allSegments = this._clusterInfoAccessor.getSegmentsZKMetadata(tableNameWithType);
        for (SegmentZKMetadata segment : allSegments) {
            CommonConstants.Segment.Realtime.Status status = segment.getStatus();
            if (!status.isCompleted() || segment.getEndTimeMs() > System.currentTimeMillis() - bufferMs) continue;
            completedSegments.add(segment);
        }
        return completedSegments;
    }

    @VisibleForTesting
    public static int getMaxTasks(String taskType, String tableNameWithType, Map<String, String> taskConfigs) {
        int maxTasks = Integer.MAX_VALUE;
        String tableMaxNumTasksConfig = taskConfigs.get("tableMaxNumTasks");
        if (tableMaxNumTasksConfig != null) {
            try {
                maxTasks = Integer.parseInt(tableMaxNumTasksConfig);
            }
            catch (Exception e) {
                LOGGER.warn("MaxNumTasks have been wrongly set for table : {}, and task {}", (Object)tableNameWithType, (Object)taskType);
            }
        }
        return maxTasks;
    }

    @VisibleForTesting
    static boolean validate(TableConfig tableConfig) {
        String taskType = "UpsertCompactionTask";
        String tableNameWithType = tableConfig.getTableName();
        if (tableConfig.getTableType() == TableType.OFFLINE) {
            LOGGER.warn("Skip generation task: {} for table: {}, offline table is not supported", (Object)taskType, (Object)tableNameWithType);
            return false;
        }
        if (!tableConfig.isUpsertEnabled()) {
            LOGGER.warn("Skip generation task: {} for table: {}, table without upsert enabled is not supported", (Object)taskType, (Object)tableNameWithType);
            return false;
        }
        return true;
    }

    public static class SegmentSelectionResult {
        private List<SegmentZKMetadata> _segmentsForCompaction;
        private List<String> _segmentsForDeletion;

        SegmentSelectionResult(List<SegmentZKMetadata> segmentsForCompaction, List<String> segmentsForDeletion) {
            this._segmentsForCompaction = segmentsForCompaction;
            this._segmentsForDeletion = segmentsForDeletion;
        }

        public List<SegmentZKMetadata> getSegmentsForCompaction() {
            return this._segmentsForCompaction;
        }

        public List<String> getSegmentsForDeletion() {
            return this._segmentsForDeletion;
        }
    }
}

