/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertCompactionTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactionTaskExecutor.class);
    private static HelixManager _helixManager = MINION_CONTEXT.getHelixManager();
    private static HelixAdmin _clusterManagementTool = _helixManager.getClusterManagmentTool();
    private static String _clusterName = _helixManager.getClusterName();

    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Compacting segment: " + indexDir));
        Map configs = pinotTaskConfig.getConfigs();
        String segmentName = (String)configs.get("segmentName");
        String taskType = pinotTaskConfig.getTaskType();
        LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)configs);
        long startMillis = System.currentTimeMillis();
        String tableNameWithType = (String)configs.get("tableName");
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        ImmutableRoaringBitmap validDocIds = UpsertCompactionTaskExecutor.getValidDocIds(tableNameWithType, configs);
        if (validDocIds.isEmpty()) {
            LOGGER.info("validDocIds is empty, skip the task. Table: {}, segment: {}", (Object)tableNameWithType, (Object)segmentName);
            if (indexDir.exists() && !FileUtils.deleteQuietly((File)indexDir)) {
                LOGGER.warn("Failed to delete input segment: {}", (Object)indexDir.getAbsolutePath());
            }
            if (!FileUtils.deleteQuietly((File)workingDir)) {
                LOGGER.warn("Failed to delete working directory: {}", (Object)workingDir.getAbsolutePath());
            }
            return new SegmentConversionResult.Builder().setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        }
        SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
        try (CompactedRecordReader compactedRecordReader = new CompactedRecordReader(indexDir, validDocIds);){
            SegmentGeneratorConfig config = UpsertCompactionTaskExecutor.getSegmentGeneratorConfig(workingDir, tableConfig, segmentMetadata, segmentName);
            SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
            driver.init(config, (RecordReader)compactedRecordReader);
            driver.build();
        }
        File compactedSegmentFile = new File(workingDir, segmentName);
        SegmentConversionResult result = new SegmentConversionResult.Builder().setFile(compactedSegmentFile).setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        long endMillis = System.currentTimeMillis();
        LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, configs, endMillis - startMillis});
        return result;
    }

    private static SegmentGeneratorConfig getSegmentGeneratorConfig(File workingDir, TableConfig tableConfig, SegmentMetadataImpl segmentMetadata, String segmentName) {
        SegmentGeneratorConfig config = new SegmentGeneratorConfig(tableConfig, segmentMetadata.getSchema());
        config.setOutDir(workingDir.getPath());
        config.setSegmentName(segmentName);
        config.setCreationTime(String.valueOf(segmentMetadata.getIndexCreationTime()));
        if (segmentMetadata.getTimeInterval() != null) {
            config.setTimeColumnName(tableConfig.getValidationConfig().getTimeColumnName());
            config.setStartTime(Long.toString(segmentMetadata.getStartTime()));
            config.setEndTime(Long.toString(segmentMetadata.getEndTime()));
            config.setSegmentTimeUnit(segmentMetadata.getTimeUnit());
        }
        return config;
    }

    private static ImmutableRoaringBitmap getValidDocIds(String tableNameWithType, Map<String, String> configs) throws URISyntaxException {
        String segmentName = configs.get("segmentName");
        String server = UpsertCompactionTaskExecutor.getServer(segmentName, tableNameWithType);
        InstanceConfig instanceConfig = _clusterManagementTool.getInstanceConfig(_clusterName, server);
        String endpoint = InstanceUtils.getServerAdminEndpoint((InstanceConfig)instanceConfig);
        String url = new URIBuilder(endpoint).setPath(String.format("/segments/%s/%s/validDocIds", tableNameWithType, segmentName)).toString();
        Response response = (Response)ClientBuilder.newClient().target(url).request().get(Response.class);
        Preconditions.checkState((response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"Unable to retrieve validDocIds from %s", (Object)url);
        byte[] snapshot = (byte[])response.readEntity(byte[].class);
        ImmutableRoaringBitmap validDocIds = new ImmutableRoaringBitmap(ByteBuffer.wrap(snapshot));
        return validDocIds;
    }

    @VisibleForTesting
    public static String getServer(String segmentName, String tableNameWithType) {
        ExternalView externalView = _clusterManagementTool.getResourceExternalView(_clusterName, tableNameWithType);
        if (externalView == null) {
            throw new IllegalStateException("External view does not exist for table: " + tableNameWithType);
        }
        Map instanceStateMap = externalView.getStateMap(segmentName);
        if (instanceStateMap == null) {
            throw new IllegalStateException("Failed to find segment: " + segmentName);
        }
        for (Map.Entry entry : instanceStateMap.entrySet()) {
            if (!((String)entry.getValue()).equals("ONLINE")) continue;
            return (String)entry.getKey();
        }
        throw new IllegalStateException("Failed to find ONLINE server for segment: " + segmentName);
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("UpsertCompactionTask.time", String.valueOf(System.currentTimeMillis())));
    }

    private class CompactedRecordReader
    implements RecordReader {
        private final PinotSegmentRecordReader _pinotSegmentRecordReader;
        private final PeekableIntIterator _validDocIdsIterator;
        GenericRow _nextRow = new GenericRow();
        boolean _nextRowReturned = true;

        CompactedRecordReader(File indexDir, ImmutableRoaringBitmap validDocIds) {
            this._pinotSegmentRecordReader = new PinotSegmentRecordReader();
            this._pinotSegmentRecordReader.init(indexDir, null, null);
            this._validDocIdsIterator = validDocIds.getIntIterator();
        }

        public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
        }

        public boolean hasNext() {
            if (!this._validDocIdsIterator.hasNext() && this._nextRowReturned) {
                return false;
            }
            if (!this._nextRowReturned) {
                return true;
            }
            if (this._validDocIdsIterator.hasNext()) {
                int docId = this._validDocIdsIterator.next();
                this._nextRow.clear();
                this._pinotSegmentRecordReader.getRecord(docId, this._nextRow);
                this._nextRowReturned = false;
                return true;
            }
            return false;
        }

        public GenericRow next() {
            return this.next(new GenericRow());
        }

        public GenericRow next(GenericRow reuse) {
            Preconditions.checkState((!this._nextRowReturned ? 1 : 0) != 0);
            reuse.init(this._nextRow);
            this._nextRowReturned = true;
            return reuse;
        }

        public void rewind() {
            this._pinotSegmentRecordReader.rewind();
            this._nextRowReturned = true;
        }

        public void close() throws IOException {
            this._pinotSegmentRecordReader.close();
        }
    }
}

