/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.realtimetoofflinesegments;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.common.minion.RealtimeToOfflineSegmentsTaskMetadata;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorFramework;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.minion.executor.MinionTaskZkMetadataManager;
import org.apache.pinot.plugin.minion.tasks.BaseMultipleSegmentsConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MergeTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeToOfflineSegmentsTaskExecutor
extends BaseMultipleSegmentsConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeToOfflineSegmentsTaskExecutor.class);
    private final MinionTaskZkMetadataManager _minionTaskZkMetadataManager;
    private int _expectedVersion = Integer.MIN_VALUE;

    public RealtimeToOfflineSegmentsTaskExecutor(MinionTaskZkMetadataManager minionTaskZkMetadataManager, MinionConf minionConf) {
        super(minionConf);
        this._minionTaskZkMetadataManager = minionTaskZkMetadataManager;
    }

    @Override
    public void preProcess(PinotTaskConfig pinotTaskConfig) {
        Map configs = pinotTaskConfig.getConfigs();
        String realtimeTableName = (String)configs.get("tableName");
        ZNRecord realtimeToOfflineSegmentsTaskZNRecord = this._minionTaskZkMetadataManager.getTaskMetadataZNRecord(realtimeTableName, "RealtimeToOfflineSegmentsTask");
        Preconditions.checkState((realtimeToOfflineSegmentsTaskZNRecord != null ? 1 : 0) != 0, (String)"RealtimeToOfflineSegmentsTaskMetadata ZNRecord for table: %s should not be null. Exiting task.", (Object)realtimeTableName);
        RealtimeToOfflineSegmentsTaskMetadata realtimeToOfflineSegmentsTaskMetadata = RealtimeToOfflineSegmentsTaskMetadata.fromZNRecord((ZNRecord)realtimeToOfflineSegmentsTaskZNRecord);
        long windowStartMs = Long.parseLong((String)configs.get("windowStartMs"));
        Preconditions.checkState((realtimeToOfflineSegmentsTaskMetadata.getWatermarkMs() <= windowStartMs ? 1 : 0) != 0, (String)"watermarkMs in RealtimeToOfflineSegmentsTask metadata: %s shouldn't be larger than windowStartMs: %d in task configs for table: %s. ZNode may have been modified by another task", (Object)realtimeToOfflineSegmentsTaskMetadata.getWatermarkMs(), (Object)windowStartMs, (Object)realtimeTableName);
        this._expectedVersion = realtimeToOfflineSegmentsTaskZNRecord.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SegmentConversionResult> convert(PinotTaskConfig pinotTaskConfig, List<File> segmentDirs, File workingDir) throws Exception {
        List outputSegmentDirs;
        String legacyMergeTypeStr;
        int numInputSegments = segmentDirs.size();
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Converting segments: " + numInputSegments));
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)configs);
        long startMillis = System.currentTimeMillis();
        String realtimeTableName = (String)configs.get("tableName");
        String rawTableName = TableNameBuilder.extractRawTableName((String)realtimeTableName);
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(rawTableName);
        TableConfig tableConfig = this.getTableConfig(offlineTableName);
        Schema schema = this.getSchema(offlineTableName);
        SegmentProcessorConfig.Builder segmentProcessorConfigBuilder = new SegmentProcessorConfig.Builder().setTableConfig(tableConfig).setSchema(schema);
        segmentProcessorConfigBuilder.setTimeHandlerConfig(MergeTaskUtils.getTimeHandlerConfig(tableConfig, schema, configs));
        segmentProcessorConfigBuilder.setPartitionerConfigs(MergeTaskUtils.getPartitionerConfigs(tableConfig, schema, configs));
        MergeType mergeType = MergeTaskUtils.getMergeType(configs);
        if (mergeType == null && (legacyMergeTypeStr = (String)configs.get("collectorType")) != null) {
            mergeType = MergeType.valueOf((String)legacyMergeTypeStr.toUpperCase());
        }
        segmentProcessorConfigBuilder.setMergeType(mergeType);
        segmentProcessorConfigBuilder.setAggregationTypes(MergeTaskUtils.getAggregationTypes(configs));
        segmentProcessorConfigBuilder.setSegmentConfig(MergeTaskUtils.getSegmentConfig(configs));
        segmentProcessorConfigBuilder.setProgressObserver(p -> this._eventObserver.notifyProgress(this._pinotTaskConfig, p));
        SegmentProcessorConfig segmentProcessorConfig = segmentProcessorConfigBuilder.build();
        ArrayList<RecordReader> recordReaders = new ArrayList<RecordReader>(numInputSegments);
        int count = 1;
        for (File file : segmentDirs) {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Creating RecordReader for: %s (%d out of %d)", file, count++, numInputSegments));
            RecordReader recordReader = new PinotSegmentRecordReader();
            recordReader.init(file, null, null, true);
            recordReaders.add(recordReader);
        }
        try {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)"Generating segments");
            outputSegmentDirs = new SegmentProcessorFramework(recordReaders, segmentProcessorConfig, workingDir).process();
        }
        finally {
            for (RecordReader recordReader : recordReaders) {
                recordReader.close();
            }
        }
        long l = System.currentTimeMillis();
        LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, configs, l - startMillis});
        ArrayList<SegmentConversionResult> results = new ArrayList<SegmentConversionResult>();
        for (File outputSegmentDir : outputSegmentDirs) {
            String outputSegmentName = outputSegmentDir.getName();
            results.add(new SegmentConversionResult.Builder().setFile(outputSegmentDir).setSegmentName(outputSegmentName).setTableNameWithType(offlineTableName).build());
        }
        return results;
    }

    @Override
    public void postProcess(PinotTaskConfig pinotTaskConfig) {
        Map configs = pinotTaskConfig.getConfigs();
        String realtimeTableName = (String)configs.get("tableName");
        long waterMarkMs = Long.parseLong((String)configs.get("windowEndMs"));
        RealtimeToOfflineSegmentsTaskMetadata newMinionMetadata = new RealtimeToOfflineSegmentsTaskMetadata(realtimeTableName, waterMarkMs);
        this._minionTaskZkMetadataManager.setTaskMetadataZNRecord((BaseTaskMetadata)newMinionMetadata, "RealtimeToOfflineSegmentsTask", this._expectedVersion);
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.emptyMap());
    }
}

