/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.purge;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class PurgeTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PurgeTaskGenerator.class);

    public String getTaskType() {
        return "PurgeTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        LOGGER.info("Start generating PurgeTask");
        String taskType = "PurgeTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            Object segmentZKMetadata22;
            int tableMaxNumTasks;
            String tableName = tableConfig.getTableName();
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            if (tableTaskConfig == null) {
                LOGGER.warn("Failed to find task config for table: {}", (Object)tableName);
                continue;
            }
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType("PurgeTask");
            Preconditions.checkNotNull((Object)taskConfigs, (String)"Task config shouldn't be null for Table: {}", (Object)tableName);
            String deltaTimePeriod = taskConfigs.getOrDefault("lastPurgeTimeThresholdPeriod", "14d");
            long purgeDeltaMs = TimeUtils.convertPeriodToMillis((String)deltaTimePeriod);
            LOGGER.info("Start generating task configs for table: {} for task: {}", (Object)tableName, (Object)taskType);
            String tableMaxNumTasksConfig = (String)taskConfigs.get("tableMaxNumTasks");
            if (tableMaxNumTasksConfig != null) {
                try {
                    tableMaxNumTasks = Integer.parseInt(tableMaxNumTasksConfig);
                }
                catch (Exception e) {
                    tableMaxNumTasks = Integer.MAX_VALUE;
                    LOGGER.warn("MaxNumTasks have been wrongly set for table : {}, and task {}", (Object)tableName, (Object)taskType);
                }
            } else {
                tableMaxNumTasks = Integer.MAX_VALUE;
            }
            List<Object> segmentsZKMetadata = new ArrayList();
            if (tableConfig.getTableType() == TableType.REALTIME) {
                List segmentsZKMetadataAll = this._clusterInfoAccessor.getSegmentsZKMetadata(tableName);
                for (Object segmentZKMetadata22 : segmentsZKMetadataAll) {
                    CommonConstants.Segment.Realtime.Status status = segmentZKMetadata22.getStatus();
                    if (!status.isCompleted()) continue;
                    segmentsZKMetadata.add(segmentZKMetadata22);
                }
            } else {
                segmentsZKMetadata = this._clusterInfoAccessor.getSegmentsZKMetadata(tableName);
            }
            ArrayList<SegmentZKMetadata> purgedSegmentsZKMetadata = new ArrayList<SegmentZKMetadata>();
            ArrayList<SegmentZKMetadata> notpurgedSegmentsZKMetadata = new ArrayList<SegmentZKMetadata>();
            segmentZKMetadata22 = segmentsZKMetadata.iterator();
            while (segmentZKMetadata22.hasNext()) {
                SegmentZKMetadata segmentMetadata = (SegmentZKMetadata)segmentZKMetadata22.next();
                if (segmentMetadata.getCustomMap() != null && segmentMetadata.getCustomMap().containsKey("PurgeTask.time")) {
                    purgedSegmentsZKMetadata.add(segmentMetadata);
                    continue;
                }
                notpurgedSegmentsZKMetadata.add(segmentMetadata);
            }
            Collections.sort(purgedSegmentsZKMetadata, Comparator.comparing(segmentZKMetadata -> (String)segmentZKMetadata.getCustomMap().get("PurgeTask.time"), Comparator.nullsFirst(Comparator.naturalOrder())));
            notpurgedSegmentsZKMetadata.addAll(purgedSegmentsZKMetadata);
            int tableNumTasks = 0;
            Set runningSegments = TaskGeneratorUtils.getRunningSegments((String)"PurgeTask", (ClusterInfoAccessor)this._clusterInfoAccessor);
            for (SegmentZKMetadata segmentZKMetadata3 : notpurgedSegmentsZKMetadata) {
                HashMap<String, Object> configs = new HashMap<String, Object>();
                String segmentName = segmentZKMetadata3.getSegmentName();
                Long tsLastPurge = segmentZKMetadata3.getCustomMap() != null ? Long.valueOf((String)segmentZKMetadata3.getCustomMap().get("PurgeTask.time")) : Long.valueOf(0L);
                if (runningSegments.contains(new Segment(tableName, segmentName)) || tsLastPurge != null && System.currentTimeMillis() - tsLastPurge < purgeDeltaMs) continue;
                if (tableNumTasks == tableMaxNumTasks) break;
                configs.put("tableName", tableName);
                configs.put("segmentName", segmentName);
                configs.put("downloadURL", segmentZKMetadata3.getDownloadUrl());
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("crc", String.valueOf(segmentZKMetadata3.getCrc()));
                pinotTaskConfigs.add(new PinotTaskConfig(taskType, configs));
                ++tableNumTasks;
            }
            LOGGER.info("Finished generating {} tasks configs for table: {} for task: {}", new Object[]{tableNumTasks, tableName, taskType});
        }
        return pinotTaskConfigs;
    }
}

