/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.restlet.resources.EndReplaceSegmentsRequest;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.RoundRobinURIProvider;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.minion.MinionContext;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.spi.utils.retry.ExponentialBackoffRetryPolicy;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentConversionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentConversionUtils.class);
    private static final int DEFAULT_MAX_NUM_ATTEMPTS = 5;
    private static final long DEFAULT_INITIAL_RETRY_DELAY_MS = 1000L;
    private static final double DEFAULT_RETRY_SCALE_FACTOR = 2.0;

    private SegmentConversionUtils() {
    }

    public static Set<String> getSegmentNamesForTable(String tableNameWithType, long startTimestamp, long endTimestamp, boolean excludeOverlapping, URI controllerBaseURI, @Nullable AuthProvider authProvider) throws Exception {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        SSLContext sslContext = MinionContext.getInstance().getSSLContext();
        try (FileUploadDownloadClient fileUploadDownloadClient = new FileUploadDownloadClient(sslContext);){
            List allSegmentNameList;
            Map tableTypeToSegmentNames = fileUploadDownloadClient.getSegments(controllerBaseURI, rawTableName, tableType, true, startTimestamp, endTimestamp, excludeOverlapping, authProvider);
            if (tableTypeToSegmentNames != null && !tableTypeToSegmentNames.isEmpty() && !CollectionUtils.isEmpty((Collection)(allSegmentNameList = (List)tableTypeToSegmentNames.get(tableType.toString())))) {
                HashSet<String> hashSet = new HashSet<String>(allSegmentNameList);
                return hashSet;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
    }

    public static Set<String> getSegmentNamesForTable(String tableNameWithType, URI controllerBaseURI, @Nullable AuthProvider authProvider) throws Exception {
        return SegmentConversionUtils.getSegmentNamesForTable(tableNameWithType, Long.MIN_VALUE, Long.MAX_VALUE, false, controllerBaseURI, authProvider);
    }

    public static void uploadSegment(Map<String, String> configs, List<Header> httpHeaders, List<NameValuePair> parameters, String tableNameWithType, String segmentName, String uploadURL, File fileToUpload) throws Exception {
        RoundRobinURIProvider uriProvider = new RoundRobinURIProvider(new URI(uploadURL));
        String maxNumAttemptsConfigStr = configs.get("maxNumAttempts");
        int maxNumAttemptsFromConfig = maxNumAttemptsConfigStr != null ? Integer.parseInt(maxNumAttemptsConfigStr) : 5;
        int maxNumAttempts = Math.max(maxNumAttemptsFromConfig, uriProvider.numAddresses());
        LOGGER.info("Retry uploading for {} times. Max num attempts from pinot minion config: {}, number of IP addresses for upload URI: {}", new Object[]{maxNumAttempts, maxNumAttemptsFromConfig, uriProvider.numAddresses()});
        String initialRetryDelayMsConfig = configs.get("initialRetryDelayMs");
        long initialRetryDelayMs = initialRetryDelayMsConfig != null ? Long.parseLong(initialRetryDelayMsConfig) : 1000L;
        String retryScaleFactorConfig = configs.get("retryScaleFactor");
        double retryScaleFactor = retryScaleFactorConfig != null ? Double.parseDouble(retryScaleFactorConfig) : 2.0;
        ExponentialBackoffRetryPolicy retryPolicy = RetryPolicies.exponentialBackoffRetryPolicy((int)maxNumAttempts, (long)initialRetryDelayMs, (double)retryScaleFactor);
        SSLContext sslContext = MinionContext.getInstance().getSSLContext();
        try (FileUploadDownloadClient fileUploadDownloadClient = new FileUploadDownloadClient(sslContext);){
            retryPolicy.attempt(() -> {
                URI uri = uriProvider.next();
                String hostName = new URI(uploadURL).getHost();
                int hostPort = new URI(uploadURL).getPort();
                if (!InetAddresses.isInetAddress((String)hostName)) {
                    httpHeaders.add((Header)new BasicHeader("Host", hostName + ":" + hostPort));
                }
                try {
                    SimpleHttpResponse response = fileUploadDownloadClient.uploadSegment(uri, segmentName, fileToUpload, httpHeaders, parameters, 600000);
                    LOGGER.info("Got response {}: {} while uploading table: {}, segment: {} with uploadURL: {}", new Object[]{response.getStatusCode(), response.getResponse(), tableNameWithType, segmentName, uploadURL});
                    return true;
                }
                catch (HttpErrorStatusException e) {
                    int statusCode = e.getStatusCode();
                    if (statusCode == 409 || statusCode == 404 || statusCode >= 500) {
                        LOGGER.warn("Caught temporary exception while uploading segment: {}, will retry", (Object)segmentName, (Object)e);
                        return false;
                    }
                    LOGGER.error("Caught permanent exception while uploading segment: {}, won't retry", (Object)segmentName, (Object)e);
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.warn("Caught temporary exception while uploading segment: {}, will retry", (Object)segmentName, (Object)e);
                    return false;
                }
            });
        }
    }

    public static String startSegmentReplace(String tableNameWithType, String uploadURL, StartReplaceSegmentsRequest startReplaceSegmentsRequest, @Nullable AuthProvider authProvider) throws Exception {
        return SegmentConversionUtils.startSegmentReplace(tableNameWithType, uploadURL, startReplaceSegmentsRequest, authProvider, true);
    }

    public static String startSegmentReplace(String tableNameWithType, String uploadURL, StartReplaceSegmentsRequest startReplaceSegmentsRequest, @Nullable AuthProvider authProvider, boolean forceCleanup) throws Exception {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        SSLContext sslContext = MinionContext.getInstance().getSSLContext();
        try (FileUploadDownloadClient fileUploadDownloadClient = new FileUploadDownloadClient(sslContext);){
            URI uri = FileUploadDownloadClient.getStartReplaceSegmentsURI((URI)new URI(uploadURL), (String)rawTableName, (String)tableType.name(), (boolean)forceCleanup);
            SimpleHttpResponse response = fileUploadDownloadClient.startReplaceSegments(uri, startReplaceSegmentsRequest, authProvider);
            String responseString = response.getResponse();
            LOGGER.info("Got response {}: {} while sending start replace segment request for table: {}, uploadURL: {}, request: {}", new Object[]{response.getStatusCode(), responseString, tableNameWithType, uploadURL, startReplaceSegmentsRequest});
            String string = JsonUtils.stringToJsonNode((String)responseString).get("segmentLineageEntryId").asText();
            return string;
        }
    }

    public static void endSegmentReplace(String tableNameWithType, String uploadURL, String segmentLineageEntryId, int socketTimeoutMs, @Nullable AuthProvider authProvider) throws Exception {
        SegmentConversionUtils.endSegmentReplace(tableNameWithType, uploadURL, null, segmentLineageEntryId, socketTimeoutMs, authProvider);
    }

    public static void endSegmentReplace(String tableNameWithType, String uploadURL, @Nullable EndReplaceSegmentsRequest endReplaceSegmentsRequest, String segmentLineageEntryId, int socketTimeoutMs, @Nullable AuthProvider authProvider) throws Exception {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        SSLContext sslContext = MinionContext.getInstance().getSSLContext();
        try (FileUploadDownloadClient fileUploadDownloadClient = new FileUploadDownloadClient(sslContext);){
            URI uri = FileUploadDownloadClient.getEndReplaceSegmentsURI((URI)new URI(uploadURL), (String)rawTableName, (String)tableType.name(), (String)segmentLineageEntryId);
            SimpleHttpResponse response = fileUploadDownloadClient.endReplaceSegments(uri, socketTimeoutMs, endReplaceSegmentsRequest, authProvider);
            LOGGER.info("Got response {}: {} while sending end replace segment request for table: {}, uploadURL: {}, request: {}", new Object[]{response.getStatusCode(), response.getResponse(), tableNameWithType, uploadURL, endReplaceSegmentsRequest});
        }
    }
}

