/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionTaskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinionTaskUtils.class);

    private MinionTaskUtils() {
    }

    public static PinotFS getInputPinotFS(Map<String, String> taskConfigs, URI fileURI) throws Exception {
        String fileURIScheme = fileURI.getScheme();
        if (fileURIScheme == null) {
            return new LocalPinotFS();
        }
        String fsClass = taskConfigs.get("input.fs.className");
        if (fsClass != null) {
            PinotFS pinotFS = (PinotFS)PluginManager.get().createInstance(fsClass);
            PinotConfiguration fsProps = IngestionConfigUtils.getInputFsProps(taskConfigs);
            pinotFS.init(fsProps);
            return pinotFS;
        }
        return PinotFSFactory.create((String)fileURIScheme);
    }

    public static PinotFS getOutputPinotFS(Map<String, String> taskConfigs, URI fileURI) throws Exception {
        String fileURIScheme;
        String string = fileURIScheme = fileURI == null ? null : fileURI.getScheme();
        if (fileURIScheme == null) {
            return new LocalPinotFS();
        }
        String fsClass = taskConfigs.get("output.fs.className");
        if (fsClass != null) {
            PinotFS pinotFS = (PinotFS)PluginManager.get().createInstance(fsClass);
            PinotConfiguration fsProps = IngestionConfigUtils.getOutputFsProps(taskConfigs);
            pinotFS.init(fsProps);
            return pinotFS;
        }
        return PinotFSFactory.create((String)fileURIScheme);
    }

    public static Map<String, String> getPushTaskConfig(String tableName, Map<String, String> taskConfigs, ClusterInfoAccessor clusterInfoAccessor) {
        try {
            String pushMode = IngestionConfigUtils.getPushMode(taskConfigs);
            HashMap<String, String> singleFileGenerationTaskConfig = new HashMap<String, String>(taskConfigs);
            if (pushMode == null || pushMode.toUpperCase().contentEquals(BatchConfigProperties.SegmentPushType.TAR.toString())) {
                singleFileGenerationTaskConfig.put("push.mode", BatchConfigProperties.SegmentPushType.TAR.toString());
            } else {
                URI outputDirURI = URI.create(clusterInfoAccessor.getDataDir() + "/" + tableName);
                String outputDirURIScheme = outputDirURI.getScheme();
                if (!MinionTaskUtils.isLocalOutputDir(outputDirURIScheme)) {
                    singleFileGenerationTaskConfig.put("output.segment.dir.uri", outputDirURI.toString());
                    if (pushMode.toUpperCase().contentEquals(BatchConfigProperties.SegmentPushType.URI.toString())) {
                        LOGGER.warn("URI push type is not supported in this task. Switching to METADATA push");
                        pushMode = BatchConfigProperties.SegmentPushType.METADATA.toString();
                    }
                    singleFileGenerationTaskConfig.put("push.mode", pushMode);
                } else {
                    LOGGER.warn("segment upload with METADATA push is not supported with local output dir: {}. Switching to TAR push.", (Object)outputDirURI);
                    singleFileGenerationTaskConfig.put("push.mode", BatchConfigProperties.SegmentPushType.TAR.toString());
                }
            }
            singleFileGenerationTaskConfig.put("push.controllerUri", clusterInfoAccessor.getVipUrl());
            return singleFileGenerationTaskConfig;
        }
        catch (Exception e) {
            return taskConfigs;
        }
    }

    public static boolean isLocalOutputDir(String outputDirURIScheme) {
        return outputDirURIScheme == null || outputDirURIScheme.startsWith("file");
    }

    public static PinotFS getLocalPinotFs() {
        return new LocalPinotFS();
    }
}

