/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.base.Preconditions;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.MinionContext;
import org.apache.pinot.minion.executor.PinotTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public abstract class BaseTaskExecutor
implements PinotTaskExecutor {
    protected static final MinionContext MINION_CONTEXT = MinionContext.getInstance();
    protected boolean _cancelled = false;

    public void cancel() {
        this._cancelled = true;
    }

    protected abstract SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig var1, SegmentConversionResult var2);

    protected TableConfig getTableConfig(String tableNameWithType) {
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)tableNameWithType);
        return tableConfig;
    }

    protected Schema getSchema(String tableName) {
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableName);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)tableName);
        return schema;
    }

    protected long getSegmentCrc(String tableNameWithType, String segmentName) {
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableNameWithType, (String)segmentName);
        return segmentZKMetadata == null ? -1L : segmentZKMetadata.getCrc();
    }
}

