/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.minion.event.MinionEventObserver;
import org.apache.pinot.minion.event.MinionEventObservers;
import org.apache.pinot.minion.exception.TaskCancelledException;
import org.apache.pinot.plugin.minion.tasks.BaseTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionUtils;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.TableSpec;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMultipleSegmentsConversionExecutor
extends BaseTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMultipleSegmentsConversionExecutor.class);
    private static final String CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID = "lineageEntryId";
    private static final int DEFUALT_PUSH_ATTEMPTS = 5;
    private static final int DEFAULT_PUSH_PARALLELISM = 1;
    private static final long DEFAULT_PUSH_RETRY_INTERVAL_MILLIS = 1000L;
    protected MinionConf _minionConf;
    protected PinotTaskConfig _pinotTaskConfig;
    protected MinionEventObserver _eventObserver;

    public BaseMultipleSegmentsConversionExecutor(MinionConf minionConf) {
        this._minionConf = minionConf;
    }

    protected abstract List<SegmentConversionResult> convert(PinotTaskConfig var1, List<File> var2, File var3) throws Exception;

    protected void preProcess(PinotTaskConfig pinotTaskConfig) throws Exception {
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String inputSegmentNames = (String)configs.get("segmentName");
        String uploadURL = (String)configs.get("uploadURL");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
        Set<String> segmentNamesForTable = SegmentConversionUtils.getSegmentNamesForTable(tableNameWithType, FileUploadDownloadClient.extractBaseURI((URI)new URI(uploadURL)), authProvider);
        HashSet<String> nonExistingSegmentNames = new HashSet<String>(Arrays.asList(inputSegmentNames.split(",")));
        nonExistingSegmentNames.removeAll(segmentNamesForTable);
        if (!CollectionUtils.isEmpty(nonExistingSegmentNames)) {
            throw new RuntimeException(String.format("table: %s does have the following segments to process: %s", tableNameWithType, nonExistingSegmentNames));
        }
    }

    protected void postProcess(PinotTaskConfig pinotTaskConfig) throws Exception {
    }

    protected void preUploadSegments(SegmentUploadContext context) throws Exception {
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Prepare to upload segments: " + context.getSegmentConversionResults().size()));
        if (context.isReplaceSegmentsEnabled()) {
            List segmentsFrom = Arrays.stream(StringUtils.split((String)context.getInputSegmentNames(), (String)",")).map(String::trim).collect(Collectors.toList());
            List segmentsTo = context.getSegmentConversionResults().stream().map(SegmentConversionResult::getSegmentName).collect(Collectors.toList());
            String lineageEntryId = SegmentConversionUtils.startSegmentReplace(context.getTableNameWithType(), context.getUploadURL(), new StartReplaceSegmentsRequest(segmentsFrom, segmentsTo), context.getAuthProvider());
            context.setCustomContext(CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID, lineageEntryId);
        }
    }

    protected void postUploadSegments(SegmentUploadContext context) throws Exception {
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Finishing uploading segments: " + context.getSegmentConversionResults().size()));
        if (context.isReplaceSegmentsEnabled()) {
            String lineageEntryId = (String)context.getCustomContext(CUSTOM_SEGMENT_UPLOAD_CONTEXT_LINEAGE_ENTRY_ID);
            SegmentConversionUtils.endSegmentReplace(context.getTableNameWithType(), context.getUploadURL(), lineageEntryId, this._minionConf.getEndReplaceSegmentsTimeoutMs(), context.getAuthProvider());
        }
    }

    @VisibleForTesting
    public void setMinionEventObserver(MinionEventObserver observer) {
        this._eventObserver = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SegmentConversionResult> executeTask(PinotTaskConfig pinotTaskConfig) throws Exception {
        this.preProcess(pinotTaskConfig);
        this._pinotTaskConfig = pinotTaskConfig;
        this._eventObserver = MinionEventObservers.getInstance().getMinionEventObserver(pinotTaskConfig.getTaskId());
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String inputSegmentNames = (String)configs.get("segmentName");
        String uploadURL = (String)configs.get("uploadURL");
        String downloadURLString = (String)configs.get("downloadURL");
        String[] downloadURLs = downloadURLString.split(",");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
        LOGGER.info("Start executing {} on table: {}, input segments: {} with downloadURLs: {}, uploadURL: {}", new Object[]{taskType, tableNameWithType, inputSegmentNames, downloadURLString, uploadURL});
        File tempDataDir = new File(new File(MINION_CONTEXT.getDataDir(), taskType), "tmp-" + UUID.randomUUID());
        Preconditions.checkState((boolean)tempDataDir.mkdirs());
        String crypterName = this.getTableConfig(tableNameWithType).getValidationConfig().getCrypterClassName();
        try {
            ArrayList<File> inputSegmentDirs = new ArrayList<File>();
            for (int i = 0; i < downloadURLs.length; ++i) {
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Downloading segment from: %s (%d out of %d)", downloadURLs[i], i + 1, downloadURLs.length));
                File tarredSegmentFile = new File(tempDataDir, "tarredSegmentFile_" + i);
                LOGGER.info("Downloading segment from {} to {}", (Object)downloadURLs[i], (Object)tarredSegmentFile.getAbsolutePath());
                SegmentFetcherFactory.fetchAndDecryptSegmentToLocal((String)downloadURLs[i], (File)tarredSegmentFile, (String)crypterName);
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Decompressing segment from: %s (%d out of %d)", downloadURLs[i], i + 1, downloadURLs.length));
                File segmentDir = new File(tempDataDir, "segmentDir_" + i);
                File indexDir = (File)TarGzCompressionUtils.untar((File)tarredSegmentFile, (File)segmentDir).get(0);
                inputSegmentDirs.add(indexDir);
                if (FileUtils.deleteQuietly((File)tarredSegmentFile)) continue;
                LOGGER.warn("Failed to delete tarred input segment: {}", (Object)tarredSegmentFile.getAbsolutePath());
            }
            File workingDir = new File(tempDataDir, "workingDir");
            Preconditions.checkState((boolean)workingDir.mkdir());
            List<SegmentConversionResult> segmentConversionResults = this.convert(pinotTaskConfig, inputSegmentDirs, workingDir);
            File convertedTarredSegmentDir = new File(tempDataDir, "convertedTarredSegmentDir");
            Preconditions.checkState((boolean)convertedTarredSegmentDir.mkdir());
            int numOutputSegments = segmentConversionResults.size();
            ArrayList<File> tarredSegmentFiles = new ArrayList<File>(numOutputSegments);
            int count = 1;
            for (SegmentConversionResult segmentConversionResult : segmentConversionResults) {
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Compressing segment: %s (%d out of %d)", segmentConversionResult.getSegmentName(), count++, numOutputSegments));
                File convertedSegmentDir = segmentConversionResult.getFile();
                File convertedSegmentTarFile = new File(convertedTarredSegmentDir, segmentConversionResult.getSegmentName() + ".tar.gz");
                TarGzCompressionUtils.createTarGzFile((File)convertedSegmentDir, (File)convertedSegmentTarFile);
                tarredSegmentFiles.add(convertedSegmentTarFile);
                if (FileUtils.deleteQuietly((File)convertedSegmentDir)) continue;
                LOGGER.warn("Failed to delete converted segment: {}", (Object)convertedSegmentDir.getAbsolutePath());
            }
            for (File inputSegmentDir : inputSegmentDirs) {
                if (!inputSegmentDir.exists() || FileUtils.deleteQuietly((File)inputSegmentDir)) continue;
                LOGGER.warn("Failed to delete input segment: {}", (Object)inputSegmentDir.getAbsolutePath());
            }
            if (this._cancelled) {
                LOGGER.info("{} on table: {}, segments: {} got cancelled", new Object[]{taskType, tableNameWithType, inputSegmentNames});
                throw new TaskCancelledException(taskType + " on table: " + tableNameWithType + ", segments: " + inputSegmentNames + " got cancelled");
            }
            SegmentUploadContext segmentUploadContext = new SegmentUploadContext(pinotTaskConfig, segmentConversionResults);
            this.preUploadSegments(segmentUploadContext);
            for (int i = 0; i < numOutputSegments; ++i) {
                URI outputSegmentTarURI;
                File convertedTarredSegmentFile = (File)tarredSegmentFiles.get(i);
                SegmentConversionResult segmentConversionResult = segmentConversionResults.get(i);
                String resultSegmentName = segmentConversionResult.getSegmentName();
                this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Uploading segment: %s (%d out of %d)", resultSegmentName, i + 1, numOutputSegments));
                SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = this.getSegmentZKMetadataCustomMapModifier(pinotTaskConfig, segmentConversionResult);
                BasicHeader segmentZKMetadataCustomMapModifierHeader = new BasicHeader("Pinot-SegmentZKMetadataCustomMapModifier", segmentZKMetadataCustomMapModifier.toJsonString());
                String pushMode = configs.getOrDefault("push.mode", BatchConfigProperties.SegmentPushType.TAR.name());
                if (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase()) != BatchConfigProperties.SegmentPushType.TAR) {
                    outputSegmentTarURI = this.moveSegmentToOutputPinotFS(configs, convertedTarredSegmentFile);
                    LOGGER.info("Moved generated segment from [{}] to location: [{}]", (Object)convertedTarredSegmentFile, (Object)outputSegmentTarURI);
                } else {
                    outputSegmentTarURI = convertedTarredSegmentFile.toURI();
                }
                ArrayList<Header> httpHeaders = new ArrayList<Header>();
                httpHeaders.add((Header)segmentZKMetadataCustomMapModifierHeader);
                httpHeaders.addAll(AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider));
                BasicNameValuePair enableParallelPushProtectionParameter = new BasicNameValuePair("enableParallelPushProtection", "true");
                BasicNameValuePair tableNameParameter = new BasicNameValuePair("tableName", TableNameBuilder.extractRawTableName((String)tableNameWithType));
                BasicNameValuePair tableTypeParameter = new BasicNameValuePair("tableType", TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType).toString());
                if ("RealtimeToOfflineSegmentsTask".equals(taskType)) {
                    tableTypeParameter = new BasicNameValuePair("tableType", TableType.OFFLINE.toString());
                }
                List<NameValuePair> parameters = Arrays.asList(enableParallelPushProtectionParameter, tableNameParameter, tableTypeParameter);
                this.pushSegment(tableNameParameter.getValue(), configs, outputSegmentTarURI, httpHeaders, parameters, segmentConversionResult);
                if (FileUtils.deleteQuietly((File)convertedTarredSegmentFile)) continue;
                LOGGER.warn("Failed to delete tarred converted segment: {}", (Object)convertedTarredSegmentFile.getAbsolutePath());
            }
            this.postUploadSegments(segmentUploadContext);
            String outputSegmentNames = segmentConversionResults.stream().map(SegmentConversionResult::getSegmentName).collect(Collectors.joining(","));
            this.postProcess(pinotTaskConfig);
            LOGGER.info("Done executing {} on table: {}, input segments: {}, output segments: {}", new Object[]{taskType, tableNameWithType, inputSegmentNames, outputSegmentNames});
            List<SegmentConversionResult> list = segmentConversionResults;
            return list;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDataDir);
        }
    }

    private void pushSegment(String tableName, Map<String, String> taskConfigs, URI outputSegmentTarURI, List<Header> headers, List<NameValuePair> parameters, SegmentConversionResult segmentConversionResult) throws Exception {
        String pushMode = taskConfigs.getOrDefault("push.mode", BatchConfigProperties.SegmentPushType.TAR.name());
        LOGGER.info("Trying to push Pinot segment with push mode {} from {}", (Object)pushMode, (Object)outputSegmentTarURI);
        PushJobSpec pushJobSpec = new PushJobSpec();
        pushJobSpec.setPushAttempts(5);
        pushJobSpec.setPushParallelism(1);
        pushJobSpec.setPushRetryIntervalMillis(1000L);
        pushJobSpec.setSegmentUriPrefix(taskConfigs.get("push.segmentUriPrefix"));
        pushJobSpec.setSegmentUriSuffix(taskConfigs.get("push.segmentUriSuffix"));
        SegmentGenerationJobSpec spec = this.generatePushJobSpec(tableName, taskConfigs, pushJobSpec);
        switch (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase())) {
            case TAR: {
                File tarFile = new File(outputSegmentTarURI);
                String segmentName = segmentConversionResult.getSegmentName();
                String tableNameWithType = segmentConversionResult.getTableNameWithType();
                String uploadURL = taskConfigs.get("uploadURL");
                SegmentConversionUtils.uploadSegment(taskConfigs, headers, parameters, tableNameWithType, segmentName, uploadURL, tarFile);
                break;
            }
            case METADATA: {
                if (taskConfigs.containsKey("output.segment.dir.uri")) {
                    URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
                    try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
                        Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputSegmentDirURI, (PushJobSpec)pushJobSpec, (String[])new String[]{outputSegmentTarURI.toString()});
                        SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)spec, (PinotFS)outputFileFS, (Map)segmentUriToTarPathMap, headers, parameters);
                        break;
                    }
                }
                throw new RuntimeException("Output dir URI missing for metadata push");
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized push mode - " + pushMode);
            }
        }
    }

    private SegmentGenerationJobSpec generatePushJobSpec(String tableName, Map<String, String> taskConfigs, PushJobSpec pushJobSpec) {
        TableSpec tableSpec = new TableSpec();
        tableSpec.setTableName(tableName);
        PinotClusterSpec pinotClusterSpec = new PinotClusterSpec();
        pinotClusterSpec.setControllerURI(taskConfigs.get("push.controllerUri"));
        PinotClusterSpec[] pinotClusterSpecs = new PinotClusterSpec[]{pinotClusterSpec};
        SegmentGenerationJobSpec spec = new SegmentGenerationJobSpec();
        spec.setPushJobSpec(pushJobSpec);
        spec.setTableSpec(tableSpec);
        spec.setPinotClusterSpecs(pinotClusterSpecs);
        spec.setAuthToken(taskConfigs.get("authToken"));
        return spec;
    }

    private URI moveSegmentToOutputPinotFS(Map<String, String> taskConfigs, File localSegmentTarFile) throws Exception {
        URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
            URI outputSegmentTarURI = URI.create(outputSegmentDirURI + localSegmentTarFile.getName());
            if (!Boolean.parseBoolean(taskConfigs.get("overwriteOutput")) && outputFileFS.exists(outputSegmentTarURI)) {
                throw new RuntimeException(String.format("Output file: %s already exists. Set 'overwriteOutput' to true to ignore this error", outputSegmentTarURI));
            }
            outputFileFS.copyFromLocalFile(localSegmentTarFile, outputSegmentTarURI);
            URI uRI = outputSegmentTarURI;
            return uRI;
        }
    }

    protected static class SegmentUploadContext {
        private final PinotTaskConfig _pinotTaskConfig;
        private final List<SegmentConversionResult> _segmentConversionResults;
        private final String _tableNameWithType;
        private final String _uploadURL;
        private final AuthProvider _authProvider;
        private final String _inputSegmentNames;
        private final boolean _replaceSegmentsEnabled;
        private final Map<String, Object> _customMap;

        public SegmentUploadContext(PinotTaskConfig pinotTaskConfig, List<SegmentConversionResult> segmentConversionResults) {
            this._pinotTaskConfig = pinotTaskConfig;
            this._segmentConversionResults = segmentConversionResults;
            Map configs = pinotTaskConfig.getConfigs();
            this._tableNameWithType = (String)configs.get("tableName");
            this._uploadURL = (String)configs.get("uploadURL");
            this._authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
            this._inputSegmentNames = (String)configs.get("segmentName");
            String replaceSegmentsString = (String)configs.get("enableReplaceSegments");
            this._replaceSegmentsEnabled = Boolean.parseBoolean(replaceSegmentsString);
            this._customMap = new HashMap<String, Object>();
        }

        public PinotTaskConfig getPinotTaskConfig() {
            return this._pinotTaskConfig;
        }

        public List<SegmentConversionResult> getSegmentConversionResults() {
            return this._segmentConversionResults;
        }

        public String getTableNameWithType() {
            return this._tableNameWithType;
        }

        public String getUploadURL() {
            return this._uploadURL;
        }

        public AuthProvider getAuthProvider() {
            return this._authProvider;
        }

        public String getInputSegmentNames() {
            return this._inputSegmentNames;
        }

        public boolean isReplaceSegmentsEnabled() {
            return this._replaceSegmentsEnabled;
        }

        public Object getCustomContext(String key) {
            return this._customMap.get(key);
        }

        public void setCustomContext(String key, Object value) {
            this._customMap.put(key, value);
        }
    }
}

