/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.utils;

import java.util.concurrent.ThreadLocalRandom;

public class ExponentialBackoff {
    private final int multiplier;
    private final double expMax;
    private final long initialInterval;
    private final double jitter;

    public ExponentialBackoff(long initialInterval, int multiplier, long maxInterval, double jitter) {
        this.initialInterval = initialInterval;
        this.multiplier = multiplier;
        this.jitter = jitter;
        this.expMax = maxInterval > initialInterval ? Math.log((double)maxInterval / (double)Math.max(initialInterval, 1L)) / Math.log(multiplier) : 0.0;
    }

    public long backoff(long attempts) {
        if (this.expMax == 0.0) {
            return this.initialInterval;
        }
        double exp = Math.min((double)attempts, this.expMax);
        double term = (double)this.initialInterval * Math.pow(this.multiplier, exp);
        double randomFactor = ThreadLocalRandom.current().nextDouble(1.0 - this.jitter, 1.0 + this.jitter);
        return (long)(randomFactor * term);
    }
}

